<?php

namespace App\Jobs;

use App\Jobs\Job;
use DB;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Bus\SelfHandling;
use Illuminate\Contracts\Queue\ShouldQueue;

class GoodsFlow extends Job implements SelfHandling, ShouldQueue
{
    /**
     * Create a new job instance.
     *
     * @param $sn transport表的sn
     * @param $codes 本次出入库的产品码
     * @param $find_adm 操作人
     * @param $type 操作类型: transIn(入库)transOut(出库)
     *
     */
    public function __construct($sn, $codes, $type = '', $find_adm='')
    {
        $this->sn = $sn;
        $this->codes = $codes;
        $this->type = $type;
        $this->find_adm = $find_adm;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $sn = $this->sn;
        $codes = $this->codes;
        $type = $this->type;
        $find_adm = $this->find_adm;

        $code_list = array();
        $total_integral = 0;
        foreach($codes as $code) {
            if(strpos($code,'G') === 0) {
                $sql = "SELECT id from trace_relation_code WHERE code='{$code}'";
                $relation_code = DB::select($sql);
                if(!$relation_code OR count($relation_code) < 1) {
                    continue;
                }
                //关联码
                $sql = "SELECT max(group_id),goods_id,max(goods_name),max(goods_code),max(code),validity_period,production_date,count(*) as num
                        FROM trace_2019_code 
                        WHERE relation_chain like '%,{$relation_code[0]['id']},%'
                        GROUP BY goods_id,validity_period,production_date";
                $find_code = DB::select($sql);
                if(count($find_code) > 0) {
                    $code_list = array_merge($code_list, $find_code);
                }
            }else {
                $sql = "SELECT group_id,goods_id,goods_name,goods_code,code,validity_period,production_date,1 as num
                        FROM trace_2019_code 
                        WHERE code='{$code}' LIMIT 1";
                $find_code = DB::select($sql);
                if(count($find_code) == 1) {
                    $code_list = array_merge($code_list, $find_code);
                }
            }
        }
        //todo 去重
        DB::beginTransaction();
        $transport = DB::table('transport')->where('sn', $sn)->first();
        $channel_id_to = $transport['channel_id_to'];
        $channel_id_from = $transport['channel_id_from'];
        $company_id = $transport['company_id'];

        //入库
        if($type='in') {
            $channel_id = $channel_id_to;//操作人当前渠道id
            $channel_parent = $channel_id_from;//上级渠道id
            $operator = 1;//数量操作符+

        //出库
        }else{
            $channel_id = $channel_id_from;//操作人当前渠道id
            $channel_row = DB::table('channels')->where('chan_id',$channel_id)->first();
            $channel_parent = intval($channel_row['chan_parent_id']);//上级渠道id
            $operator = -1;//数量操作符-
        }
        try {
            foreach ($code_list as $v) {
                //查询条件
                $where_ext = "goof_cid={$company_id} AND goof_chan_id={$channel_id} AND goof_gid={$v['goods_id']}";

                $sql = "SELECT * 
                        FROM trace_goods_flow 
                        WHERE {$where_ext}";
                $v_row = DB::row($sql);
                $goof_num = $operator*$v['num'];
                if(!$v_row) {
                    //insert
                    $fid = DB::table('goods_flow')->insertGetId([
                        'goof_cid'=>$company_id,
                        'goof_chan_id'=>$channel_id,
                        'goof_parent_chan_id'=>$channel_parent,
                        'goof_gid'=>$v['goods_id'],
                        'goo_name'=>$v['goods_name'],
                        'goo_number'=>$v['goods_code'],
                        'goof_sum'=>$v['num']
                    ]);
                }else {
                    //update
                    DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_num} WHERE $where_ext");
                    $fid = $v_row['goof_id'];
                }
                //更新trace_goods_flow_info
                $sql = "SELECT * 
                        FROM trace_goods_flow_info 
                        WHERE gofi_gid={$v['goods_id']} 
                        AND gofi_validity_period={$v['validity_period']} 
                        AND gofi_production_date={$v['production_date']}";
                $info_row = DB::row($sql);
                if(!$info_row) {
                    //insert
                    DB::table('goods_flow')->insert([
                        'goof_id'=>$fid,
                        'gofi_gid'=>$v['goods_id'],
                        'gofi_validity_period'=>$v['validity_period'],
                        'gofi_production_date'=>$v['production_date'],
                        'gofi_expired_date'=>date('Y-m-d',strtotime($v['production_date'])+3600*24*$v['validity_period']),
                        'gofi_sum'=>$v['num'],
                    ]);
                }else{
                    //update
                    DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_num} WHERE goof_id={$info_row['goof_id']}");
                }
            }
        }catch (Exception $e) {
            DB::rollback();
            return false;
        }
        DB::commit();
    }
}
