<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::post('code', 'Lore\RegisterController@telCode');  //注册--短信验证码
Route::post('register', 'Lore\RegisterController@register');  //注册
Route::post('forget_pas', 'Lore\RegisterController@forget_pas');  //忘记密码
// token路由
Route::any('tokens','Lore\RegisterController@tokens');
// 登录路由
Route::any('api/login','LoginController@login');
Route::any('adds','Lore\RegisterController@adds');
Route::any('adds2','Lore\RegisterController@adds2');
Route::any('adds3','Lore\RegisterController@adds3');
// PDA登录路由
Route::post('pda/login','Pda\LoginPdaController@login');
Route::group(['middleware'=>['pdaLogin']], function() {
    //PDA修改个人密码
    Route::post('pda/editpwd','Pda\LoginPdaController@editpwd');
    //PDA个人信息
    Route::post('pda/personal','Pda\LoginPdaController@personal');
    //PDA生成关联码
    Route::post('pda/relationcode/create','Pda\RelationCodeController@create');
    //PDA扫描产品码或关联码
    Route::post('pda/scan','Pda\PackageController@scan');
    //PDA关联码列表内部的东西
    Route::post('pda/scan/list','Pda\PackageController@scanlist');
    //PDA组合(小箱装入大箱)
    Route::post('pda/compose','Pda\PackageController@compose');
    //PDA拆分(小箱从大箱里拿出)
    Route::post('pda/divide','Pda\PackageController@divide');
    //PDA入库
    Route::post('pda/transport/in','Pda\TransportController@transIn');
    //PDA出库
    Route::post('pda/transport/out','Pda\TransportController@transOut');
    //渠道选择列表
    Route::post('pda/channel/list','Pda\TransportController@channelList');
    //系统日志
    Route::post('pda/log','Pda\LogController@logList');
    Route::post('pda/log/detail','Pda\LogController@logDetail');
});
//pc--零整关联 不需要权限控制
Route::group(['prefix'=>'zero','middleware'=>['islogin']],function(){
    //扫描产品码或关联码
    Route::post('Package/scan','Zero\PackageController@scan');
    //关联码列表内部的东西
    Route::post('Package/scanlist','Zero\PackageController@scanlist');
    Route::post('Log/logDetail','Zero\LogController@logDetail');
});
//pc--零整关联 需要权限控制
Route::group(['prefix'=>'zero','middleware'=>['islogin','hasrole']],function(){
    //生成关联码
    Route::post('relationcode/create','Zero\RelationCodeController@create');
    //关联码列表
    Route::post('relationcode/index','Zero\RelationCodeController@index');
    //编辑
    Route::post('relationcode/edit','Zero\RelationCodeController@edit');
    //关联码开启查询
    Route::post('relationcode/open','Zero\RelationCodeController@open');
    //关联码关闭查询
    Route::post('relationcode/close','Zero\RelationCodeController@close');
    //打印
    Route::post('relationcode/prints','Zero\RelationCodeController@prints');
    //申请下载
    Route::post('relationcode/derivation','Zero\RelationCodeController@derivation');
    //组合(小箱装大箱)
    Route::post('Package/compose','Zero\PackageController@compose');
    //拆分(小箱从大箱里拿出)
    Route::post('Package/divide','Zero\PackageController@divide');
    //操作记录
    Route::post('Log/logList','Zero\LogController@logList');
});

// 公众号web页面接口
// 客户的
Route::any('web/logins','MobileWeb\Homepage\HomepageController@login');//登录
Route::post('web/registers','MobileWeb\Homepage\HomepageController@register');//注册
Route::post('web/sendVerifyCodes','MobileWeb\Homepage\HomepageController@sendVerifyCode');//获取验证码
Route::post('web/getChannelss','MobileWeb\Homepage\HomepageController@getChannels');//获取渠道商信息
Route::any('web/getCustomerInfo','MobileWeb\Homepage\HomepageController@getCustomerInfo');//获取code
Route::any('web/getCustomerInfos','MobileWeb\Homepage\HomepageController@getCustomerInfos');//获取openid
Route::any('web/getTokens','MobileWeb\Homepage\HomepageController@getTokens');//获取token值和userid

// 总管理
Route::any('web/login','MobileWeb\Homepage\MyHomepageController@login');//登录
Route::post('web/register','MobileWeb\Homepage\MyHomepageController@register');//注册
Route::post('web/sendVerifyCode','MobileWeb\Homepage\MyHomepageController@sendVerifyCode');//获取验证码
Route::post('web/getChannels','MobileWeb\Homepage\MyHomepageController@getChannels');//获取渠道商信息
Route::any('web/getUserInfo','MobileWeb\Homepage\MyHomepageController@getUserInfo');//获取code
Route::any('web/getUserInfos','MobileWeb\Homepage\MyHomepageController@getUserInfos');//获取openid
Route::any('web/getToken','MobileWeb\Homepage\MyHomepageController@getToken');//获取token值和userid

// web端接口，验证api_token
Route::group(['middleware'=>['webLogin']],function(){
    // 客户的
    Route::post('web/getJSSDKs','MobileWeb\Homepage\HomepageController@getJSSDK');//获取getAccessToken
    Route::post('web/integralRecords','MobileWeb\Homepage\HomepageController@integralRecord');//积分记录
    Route::post('web/integralExchanges','MobileWeb\Homepage\HomepageController@integralExchange');//积分兑换
    Route::post('web/scanCodes','MobileWeb\Homepage\HomepageController@scanCode');//扫一扫，扫码获取产品信息
    Route::post('web/subWarrantyInfos','MobileWeb\Homepage\HomepageController@subWarrantyInfo');//扫一扫，提交质保信息
    Route::post('web/getIntegrals','MobileWeb\Homepage\HomepageController@getIntegral');//获取积分值
    Route::post('web/forItemss','MobileWeb\Homepage\HomepageController@forItems');   //兑换物品
    Route::post('web/reduceIntegrals','MobileWeb\Homepage\HomepageController@reduceIntegral');   //兑换物品
    Route::post('web/techIndexs','MobileWeb\Homepage\HomepageController@techIndex');   //获取技师列表
    Route::post('web/imageforms','MobileWeb\Homepage\HomepageController@imageform');   //获取上传图片路径
    Route::post('web/quits','MobileWeb\Homepage\HomepageController@quit');   //退出

    // 总管理
    Route::post('web/getJSSDK','MobileWeb\Homepage\MyHomepageController@getJSSDK');//获取getAccessToken
    Route::post('web/integralRecord','MobileWeb\Homepage\MyHomepageController@integralRecord');//积分记录
    Route::post('web/integralExchange','MobileWeb\Homepage\MyHomepageController@integralExchange');//积分兑换
    Route::post('web/scanCode','MobileWeb\Homepage\MyHomepageController@scanCode');//扫一扫，扫码获取产品信息
    Route::post('web/subWarrantyInfo','MobileWeb\Homepage\MyHomepageController@subWarrantyInfo');//扫一扫，提交质保信息
    Route::post('web/getIntegral','MobileWeb\Homepage\MyHomepageController@getIntegral');//获取积分值
    Route::post('web/forItems','MobileWeb\Homepage\MyHomepageController@forItems');   //兑换物品
    Route::post('web/reduceIntegral','MobileWeb\Homepage\MyHomepageController@reduceIntegral');   //兑换物品
    Route::post('web/techIndex','MobileWeb\Homepage\MyHomepageController@techIndex');   //获取技师列表
    Route::post('web/imageform','MobileWeb\Homepage\MyHomepageController@imageform');   //获取上传图片路径
    Route::post('web/quit','MobileWeb\Homepage\MyHomepageController@quit');   //退出
});

Route::group(['middleware'=>['islogin']],function(){
    Route::post('order/remark_list',"Order\OrderController@remark_list");    //订单备注列表
    Route::post('companyInfo', 'Lore\RegisterController@companyInfo');      //企业资料补充
    Route::post('startTheTrial', 'Lore\RegisterController@startTheTrial');  //申请试用
    Route::post('setMeal', 'Lore\RegisterController@setMeal');              //缴费
    Route::post('return_url', 'Lore\RegisterController@return_url');  //支付

    // 消息中心
    Route::post('messageCenter','Order\PiecemealController@messageCenter');
    Route::post('show','Order\PiecemealController@show'); //详情

    //首页
    // Route::post('api/index/home',"Order\PiecemealController@homestatis");  //首页概括
    Route::post('api/index/home',"Index\HomeController@index");  //首页概括

    // 获取左侧导航列表
    Route::post('api/login/navigation',"LoginController@navigation");       //左侧列表
    // 获取用户信息
    Route::post('api/userinfo','LoginController@userinfo');
    // 用户退出
	Route::post('api/loginout','LoginController@loginout');
    // 发码管理路由
    Route::post('CodeManage/goodscode',['uses'=>'CodeManageController@goodscode']);//搜索商品
    Route::post('CodeManage/goodsdata',['uses'=>'CodeManageController@goodsdata']);//返回5条商品信息

    Route::post('InfoModify/search_environment',['uses'=>'InfoModifyController@search_environment']);//搜索环境信息
    Route::post('InfoModify/search_camera',['uses'=>'InfoModifyController@search_camera']);//搜索摄像头

    // 分类管理路由
    Route::post('GooClassifi/class_list',['uses'=>'GooClassifiController@class_list']);//分类添加

    // 商品管理 -- 商品列表
    Route::post('Goods/imageform','GoodsController@imageform');       //商品列表上傳圖片 ==
    Route::post('Goods/videoform','GoodsController@videoform');       //商品列表上傳視頻 ==
    Route::post('Goods/delimageform','GoodsController@delimageform'); //商品列表删除图片
    Route::post('Goods/delvideoform','GoodsController@delvideoform'); //商品列表删除视频

    // 商品管理 -- 导航列表
    Route::post("api/navigation/formwork_info","NavigationController@formwork_info");  //查询信息

    // 系统管理-->个人中心
    Route::post('api/admin/oldpwd','AdminController@oldpwd');             //原密码 ==
    Route::post('api/admin/newpwd','AdminController@newpwd');             //新密码 ==
    Route::post('api/admin/companyedit','AdminController@companyedit');   //公司资料修改
    Route::post('api/admin/editlogo','AdminController@editlogo');         //logo修改
    Route::post('api/admin/personaledit','AdminController@personaledit'); //修改个人信息
    Route::post('api/admin/get_roleinfo','AdminController@get_roleinfo'); //获取角色列表
    Route::post('api/admin/agoTel','AdminController@agoTel');             //更改电话--原有电话
    Route::post('api/admin/newTel','AdminController@newTel');             //更改电话--新手机号
    Route::post('api/admin/order','AdminController@order');               //交易记录
    Route::post('api/admin/invoice','AdminController@invoice');           //索要发票
    Route::post('api/admin/checkingdata','AdminController@checkingdata'); //查看资料
    Route::post('api/admin/editInvoice','AdminController@editInvoice');   //修改资料
    Route::post('api/admin/viewinvoice','AdminController@viewinvoice');   //查看发票

    // 系统管理-->角色模块
    Route::post('api/role/addaction','RoleController@addaction');       //添加角色权限执行列表页
    Route::post('api/role/editaction','RoleController@editaction');     //编辑角色权限执行列表页

    // 溯源管理-->信息列表
    Route::post('api/formwork/imageform','FormworkController@imageform');               //溯源列表上傳圖片 ==
    Route::post('api/formwork/videoform','FormworkController@videoform');               //溯源列表上傳視頻 ==
    Route::post('api/formwork/doeditformwork','FormworkController@doeditformwork');     //溯源列表修改页
    Route::post('api/formwork/delimageform','FormworkController@delimageform');         //溯源列表删除图片
    Route::post('api/formwork/delvideoform','FormworkController@delvideoform');         //溯源列表删除视频

    // 溯源管理-->信息维护
    Route::post('InfoModify/imageform','InfoModifyController@imageform');               //溯源信息上传图片
    Route::post('InfoModify/delimageform','InfoModifyController@delimageform');         //溯源列表删除图片

    // 仓库管理-->云仓页面
    Route::post("api/ware/classgoods","Ware\StorageController@classgoods");       //更改商品分类  获取商品信息
    Route::post('api/ware/editclassadd','Ware\StorageController@editclassadd');   //存储商品设置--缓存
    Route::post("api/ware/waregoodsave","Ware\StorageController@waregoodsave");   //提交存储商品设置
    //出入库-->记录详情;
    Route::post('api/ware/lisdetails',"Ware\OrdermanageController@lisdetails");  //历史信息
    Route::post('api/ware/adddetails',"Ware\OrdermanageController@adddetails");  //入库详情
    Route::post('api/ware/outdetails',"Ware\OrdermanageController@outdetails");  //出库详情
    Route::post('api/ware/confirmout',"Ware\OrdermanageController@confirmout");   //提交出库单确认
    Route::post('api/ware/submisout',"Ware\OrdermanageController@submisout");     //提交出库单
    Route::post('api/ware/submiadd',"Ware\OrdermanageController@submiadd");       //提交入库单
    Route::post('api/ware/confirmadd',"Ware\OrdermanageController@confirmadd");   //确认入库单

    // 溯源管理 -- 模板列表
    Route::post('api/template/labelist','TemplateController@labelist');         //获取标签列表--用于添加
    Route::post('api/template/imageform','TemplateController@imageform');       //溯源列表上傳圖片 ==
    Route::post('api/template/videoform','TemplateController@videoform');       //溯源列表上傳視頻 ==
    Route::post('api/template/doedittem','TemplateController@doedittem');       //溯源列表修改页
    Route::post('api/template/delimageform','TemplateController@delimageform'); //溯源列表删除图片
    Route::post('api/template/delvideoform','TemplateController@delvideoform'); //溯源列表删除视频

    // 溯源管理 -- 信息列表
    Route::post('api/formwork/labelist','FormworkController@labelist');         //获取标签列表--用于添加

    //防窜防伪  -- 经销区管理
    Route::post("DistributionArea/regioncache","DistributionAreaController@regioncache");//缓存数据
    Route::post("DistributionArea/delcache","DistributionAreaController@delcache");//删除缓存数据

    //防伪预警设置
    Route::post('anticounter/judge','AnticounterController@judge');

    Route::post('ChannelsList/getLabel','Channels\ChannelsListController@getLabel');//获取渠道标签
    Route::post('Technician/getChannels','Channels\TechnicianController@getChannels');//获取渠道商信息

    Route::post('api/goods/imageforms','GoodsController@imageforms'); //溯源列表删除视频

    Route::post('CodeManage/scan',['uses'=>'CodeManageController@scan']);//扫一扫

    // 商品管理-->导航列表
    Route::post('api/navigation/imageform','NavigationController@imageform');        //导航列表上传图片
    Route::post('api/navigation/delimageform','NavigationController@delimageform');  //导航列表删除图片
    Route::post('api/navigation/addformwork','NavigationController@addformwork'); //添加溯源信息
    Route::post('api/navigation/handleformwork','NavigationController@handleformwork'); //编辑溯源信息

    // 库存管理路由
    Route::post('ware/sysNum','Ware\OrdermanageController@sysNum');//生成系统编号
    Route::post('ware/count','Ware\OrdermanageController@count');//出入库管理--出库单/入库单--存库数量
    Route::post('ware/comData','Ware\OrdermanageController@comData');//出入库管理--新增出库单--搜索前五条商品
    Route::post('ware/comGood','Ware\OrdermanageController@comGood');//出入库管理--新增出库单--搜索商品
    Route::post('ware/goodsdata','Ware\OrdermanageController@goodsdata');//出入库管理--新增入库单--搜索前五条商品
    Route::post('ware/goodscode','Ware\OrdermanageController@goodscode');//出入库管理--新增入库单--搜索商品
    Route::post('ware/scan','Ware\OrdermanageController@scan'); //PC扫描产品码或关联码
    Route::post('ware/scan/list','Ware\OrdermanageController@scanlist'); //PC关联码列表内部的东西
    Route::post('ware/getGoodsInfos','Ware\OrdermanageController@getGoodsInfos'); //扫码出库获取商品信息
    // 渠道商出入库获取信息
    Route::post('ware/channelList',"Ware\OrdermanageController@channelList");
    Route::post('ware/outRefer','Ware\OrdermanageController@outRefer');   //出库提交
    Route::post('ware/inRefer','Ware\OrdermanageController@inRefer');   //入库提交
    Route::post('ware/outPick','Ware\OrdermanageController@outPick');   //出库捡出
    Route::post('ware/inPick','Ware\OrdermanageController@inPick');   //入库捡出
});

//pc--仓库管理 需要权限控制
Route::group(['prefix'=>'ware','middleware'=>['islogin','hasrole']],function(){
//Route::group(['prefix'=>'ware','middleware'=>['islogin']],function(){
    //商品出入库获取信息
    Route::any('getgoods',"Ware\OrdermanageController@getgoods");       //获取商品农资信息
    // pc--我的仓库 -- 入库
    Route::any('entryList',"Ware\OrdermanageController@entryList"); //入库单列表
    Route::any('new_entry',"Ware\OrdermanageController@new_entry"); //新增入库单
    Route::any('delete',"Ware\OrdermanageController@delete"); //删除入库单
    Route::any('export_list',"Ware\OrdermanageController@export_list"); //导出入库单
    Route::any('lookEntry',"Ware\OrdermanageController@lookEntry"); //查看入库单信息
    Route::post('transport/in','Ware\OrdermanageController@transIn');   //扫码入库
    Route::post('akeytreasury','Ware\OrdermanageController@akeytreasury');   //一键入库
    Route::post('editEntryform','Ware\OrdermanageController@editEntryform');   //编辑入库单

    //我的仓库 -- 出库
    Route::any('deliverList',"Ware\OrdermanageController@deliverList"); //出库单列表
    Route::any('new_delivery_order',"Ware\OrdermanageController@new_delivery_order"); //新增出库单
    Route::any('deliverDel',"Ware\OrdermanageController@deliverDel"); //删除出库单
    Route::any('derive',"Ware\OrdermanageController@derive"); //导出出库单
    Route::any('outboundDetails',"Ware\OrdermanageController@outboundDetails"); //出库详情
    Route::post('transport/out','Ware\OrdermanageController@transOut');    //扫码出库
    Route::post('akeyoutbound','Ware\OrdermanageController@akeyoutbound');   //一键出库
    Route::post('editOutboundlist','Ware\OrdermanageController@editOutboundlist');   //编辑出库单


    //渠道云仓
    Route::post('Channel_YunCang',"Ware\ChannelYunCangController@Channel_YunCang"); //列表
    //云仓商品
    Route::post("YunCang_goods","Ware\YunCangGoodsController@YunCang_goods"); //库位列表

});

// 控制登陆和权限
Route::group(['middleware'=>['islogin','hasrole']],function(){
    // 兑换物品
    Route::post('ForItem/index','Integral\ForItemController@index');//积分记录列表
    Route::post('ForItem/add','Integral\ForItemController@add');    //新增
    Route::post('ForItem/edit','Integral\ForItemController@edit');    //编辑
    Route::post('ForItem/putaway','Integral\ForItemController@putaway');    //上架
    Route::post('ForItem/soldout','Integral\ForItemController@soldout');    //下架
    Route::post('ForItem/delete','Integral\ForItemController@delete');    //删除
    
    Route::post('bigdata/overaplaning','StatisicController@overaplaning');  //数据大屏
 
    // 分类管理路由
    Route::post('GooClassifi/addgc',['uses'=>'GooClassifiController@addgc']);//分类添加
    Route::post('GooClassifi/editgc',['uses'=>'GooClassifiController@editgc']);//分类编辑
    Route::post('GooClassifi/delgc',['uses'=>'GooClassifiController@delgc']);//分类删除
    Route::post('GooClassifi/open_state',['uses'=>'GooClassifiController@open_state']);//分类开启
    Route::post('GooClassifi/stop_state',['uses'=>'GooClassifiController@stop_state']);//分类关闭
    Route::post('GooClassifi/index',['uses'=>'GooClassifiController@index']);//分类列表

    // 行业管理路由
    Route::post('Industry/addins','IndustryController@addins');//添加
    Route::post('Industry/editins','IndustryController@editins');//编辑
    Route::post('Industry/enable','IndustryController@enable');//启用
    Route::post('Industry/disable','IndustryController@disable');//停用
    Route::post('Industry/index','IndustryController@index');//列表
    
    // 商品管理路由
    Route::post('Goods/index','GoodsController@index');//商品列表
    Route::post('Goods/addgo',['uses'=>'GoodsController@addgo']);//商品添加
    Route::post('Goods/editgo',['uses'=>'GoodsController@editgo']);//商品编辑
    Route::post('Goods/delgo',['uses'=>'GoodsController@delgo']);//商品删除
    Route::post('Goods/open_state',['uses'=>'GoodsController@open_state']);//商品开启
    Route::post('Goods/stop_state',['uses'=>'GoodsController@stop_state']);//商品关闭
    Route::post('Goods/exports',['uses'=>'GoodsController@exports']);//商品导出
    Route::post('Goods/import',['uses'=>'GoodsController@import']);//商品导入
    Route::post('Goods/duplication',['uses'=>'GoodsController@duplication']);//商品复制
    Route::post('Goods/editindex',['uses'=>'GoodsController@editindex']);//商品复制

    // 创建溯源码
    Route::post('Cretecode/index',['uses'=>'CretecodeController@index']);//发码

    // 发码管理路由
    Route::post('CodeManage/index',['uses'=>'CodeManageController@index']);//发码列表
    Route::post('CodeManage/editgco',['uses'=>'CodeManageController@editgco']);//编辑
    Route::post('CodeManage/publish',['uses'=>'CodeManageController@publish']);//开启发布
    Route::post('CodeManage/padlock',['uses'=>'CodeManageController@padlock']);//关闭发布
    Route::post('CodeManage/download',['uses'=>'CodeManageController@download']);//发码列表-下载
    Route::post('CodeManage/derivation',['uses'=>'CodeManageController@derivation']);//申请下载
    Route::post('CodeManage/prints',['uses'=>'CodeManageController@prints']);//打印

    // 溯源管理-信息维护路由
    Route::post('InfoModify/index',['uses'=>'InfoModifyController@index']);//信息维护页面
    Route::post('InfoModify/modify',['uses'=>'InfoModifyController@modify']);//信息维护提交

    Route::post('InfoModify/del','InfoModifyController@del');//清除溯源信息
    Route::post('InfoModify/searchtime','InfoModifyController@searchtime');//按时间查找
    Route::post("InfoModify/handleformwork","InfoModifyController@handleformwork"); //保存溯源信息
    
    // 环境管理
    // 环境列表(更改为设备列表)
    Route::post('Environment/index',['uses'=>'EnvironmentController@index']);//环境列表
    Route::post('Environment/adden',['uses'=>'EnvironmentController@adden']);//添加环境检测
    Route::post('Environment/editen',['uses'=>'EnvironmentController@editen']);//编辑环境检测
    Route::post('Environment/open_state',['uses'=>'EnvironmentController@open_state']);//环境检测启用
    Route::post('Environment/stop_state',['uses'=>'EnvironmentController@stop_state']);//环境检测停用
    Route::post('Environment/delen',['uses'=>'EnvironmentController@delen']);//环境检测删除
    Route::post('Environment/configen',['uses'=>'EnvironmentController@configen']);//环境检测配置
    Route::post('Environment/device_data',['uses'=>'EnvironmentController@device_data']);//环境列表，设备数据
    // Route::post('Environment/getDevice',['uses'=>'EnvironmentController@getDevice']);//获取环境设备数据，自动获取数据

    // 环境管理
    // 设备列表
    Route::post('Equipment/index',['uses'=>'EquipmentController@index']);//设备列表
    Route::post('Equipment/addeq',['uses'=>'EquipmentController@addeq']);//添加摄像头
    Route::post('Equipment/editeq',['uses'=>'EquipmentController@editeq']);//编辑摄像头
    Route::post('Equipment/open_state',['uses'=>'EquipmentController@open_state']);//设备启用
    Route::post('Equipment/stop_state',['uses'=>'EquipmentController@stop_state']);//设备停用
    Route::post('Equipment/deleq',['uses'=>'EquipmentController@deleq']);//设备删除
    Route::post('Equipment/look',['uses'=>'EquipmentController@look']);//设备查看

    // 查询日志
    Route::post('api/coperationa','CoperationaController@index');
    // 账号列表
    Route::post('api/admin/index','AdminController@index');             //账号列表页
    Route::post('api/admin/addadmin','AdminController@addadmin');       //添加账号
    Route::post('api/admin/editadmin','AdminController@editadmin');     //修改账号
    Route::post('api/admin/startstase','AdminController@startstase');   //开启账号权限
    Route::post('api/admin/shopstase','AdminController@shopstase');     //停用账号权限
    Route::post('api/admin/resetpwd','AdminController@resetpwd');       //重置账号密码
    // 个人中心
    Route::post('api/admin/personal','AdminController@personal');       //个人中心页面

    // 角色列表
    Route::post('api/role/roleindex','RoleController@roleindex');       //角色列表页
    Route::post('api/role/startstase','RoleController@startstase');     //启用角色列表页
    Route::post('api/role/shopstase','RoleController@shopstase');       //启用角色列表页
    Route::post('api/role/addrole','RoleController@addrole');           //添加角色权限列表页
    Route::post('api/role/editrole','RoleController@editrole');         //编辑角色权限列表页
    // 溯源列表页面
    Route::post('api/formwork/indexformwork','FormworkController@indexformwork');   //溯源列表页
    Route::post('api/formwork/addformwork','FormworkController@addformwork');       //溯源列表添加页
    Route::post('api/formwork/editformwork','FormworkController@editformwork');     //溯源列表修改页
    Route::post('api/formwork/copyform','FormworkController@copyform');             //溯源列表复制
    Route::post('api/formwork/shopstase','FormworkController@shopstase');           //溯源列表停用
    Route::post('api/formwork/startstase','FormworkController@startstase');         //溯源列表启用
    Route::post('api/formwork/delform','FormworkController@delform');               //溯源列表删除

    // 客户列表
    Route::post('api/company/index','CompanyController@index');                     //客户列表 
    Route::post('api/company/addcompany','CompanyController@addcompany');           //客户添加接口
    Route::post('api/company/getcompanyedit','CompanyController@getcompanyedit');   //客户编辑接口
    Route::post('api/company/startcompany','CompanyController@startcompany');       //客户启用接口
    Route::post('api/company/stopcompany','CompanyController@stopcompany');         //客户停用接口
    Route::post('api/company/disable','CompanyController@disable');                 //客户禁用接口
    Route::post('api/company/login','CompanyController@login');                     //一键登录
    Route::post('api/company/docompanyedit','CompanyController@docompanyedit');     //执行修改公司名称

    //渠道管理
    // 渠道列表
    Route::post('ChannelsList/index','Channels\ChannelsListController@index');             //渠道列表
    Route::post('ChannelsList/add','Channels\ChannelsListController@add');       //渠道商新增
    Route::post('ChannelsList/edit','Channels\ChannelsListController@edit');     //渠道商编辑
    Route::post('ChannelsList/start','Channels\ChannelsListController@start');   //渠道商启用
    Route::post('ChannelsList/stop','Channels\ChannelsListController@stop');     //渠道商停用
    Route::post('ChannelsList/resetPassword','Channels\ChannelsListController@resetPassword');//渠道重置密码
    Route::post('ChannelsList/addIntegral','Channels\ChannelsListController@addIntegral');//加积分
    Route::post('ChannelsList/reduceIntegral','Channels\ChannelsListController@reduceIntegral');//积分兑换

    // 技师列表
    Route::post('Technician/index','Channels\TechnicianController@index');             //技师列表
    Route::post('Technician/add','Channels\TechnicianController@add');       //技师新增
    Route::post('Technician/edit','Channels\TechnicianController@edit');     //技师编辑
    Route::post('Technician/start','Channels\TechnicianController@start');   //技师启用
    Route::post('Technician/stop','Channels\TechnicianController@stop');     //技师停用
    Route::post('Technician/addIntegral','Channels\TechnicianController@addIntegral');//加积分
    Route::post('Technician/reduceIntegral','Channels\TechnicianController@reduceIntegral');//积分兑换
    Route::post('Technician/pass','Channels\TechnicianController@pass');//通过
    Route::post('Technician/reject','Channels\TechnicianController@reject');//驳回

    // 渠道标签
    Route::post('ChannelsLabel/index','Channels\ChannelsLabelController@index');    //渠道标签列表
    Route::post('ChannelsLabel/add','Channels\ChannelsLabelController@add');       //渠道标签新增
    Route::post('ChannelsLabel/edit','Channels\ChannelsLabelController@edit');     //渠道标签编辑
    Route::post('ChannelsLabel/start','Channels\ChannelsLabelController@start');   //渠道标签启用
    Route::post('ChannelsLabel/stop','Channels\ChannelsLabelController@stop');     //渠道标签停用
    Route::post('ChannelsLabel/delete','Channels\ChannelsLabelController@delete');       //渠道标签删除

    // 积分管理
    // 积分记录
    Route::post('IntegralRecord/index','Integral\IntegralRecordController@index');//积分记录列表

    // 兑换公告
    Route::post('ExchangeNotice/index','Integral\ExchangeNoticeController@index');//兑换公告列表
    Route::post('ExchangeNotice/edit','Integral\ExchangeNoticeController@edit');//兑换公告编辑

    // 质保管理
    // 质保列表
    Route::post('WarrantyList/index','Warranty\WarrantyListController@index');//质保列表
    Route::post('WarrantyList/info','Warranty\WarrantyListController@info');//查看详情
    Route::post('WarrantyList/pass','Warranty\WarrantyListController@pass');//通过
    Route::post('WarrantyList/reject','Warranty\WarrantyListController@reject');//驳回

    // 表单设置
    Route::post('WarrantyTable/index','Warranty\WarrantyTableController@index');//技师表单设置列表
    Route::post('WarrantyTable/edit','Warranty\WarrantyTableController@edit');//技师表单设置编辑
    Route::post('WarrantyTable/open','Warranty\WarrantyTableController@open');//技师表单设置开启
    Route::post('WarrantyTable/close','Warranty\WarrantyTableController@close');//技师表单设置关闭

    Route::post('WarrantyTables/indexs','Warranty\WarrantyTablesController@indexs');//消费者表单设置列表
    Route::post('WarrantyTables/edits','Warranty\WarrantyTablesController@edits');//消费者表单设置编辑
    Route::post('WarrantyTables/open','Warranty\WarrantyTablesController@open');//消费者表单设置编辑
    Route::post('WarrantyTables/close','Warranty\WarrantyTablesController@close');//消费者表单设置编辑

    // 预警管理
    // 过期预警
    Route::post('WarningList/index','Warning\WarningListController@index');//过期预警列表


    // 仓库管理
    // 我的仓库 
    Route::post('WarehouseList/index','Warehouse\WarehouseListController@index');//我的仓库列表
    // 出入库记录
    Route::post('OutEnterRecord/index','Warehouse\OutEnterRecordController@index');//出入库记录列表
    Route::post('OutEnterRecord/info','Warehouse\OutEnterRecordController@info');//查看详情
    Route::post('OutEnterRecord/export','Warehouse\OutEnterRecordController@export');//导出
    Route::post('OutEnterRecord/view','Warehouse\OutEnterRecordController@view');//导出

    // 导航列表
    Route::post('api/navigation/index','NavigationController@index');            //获取导航列表
    Route::post('api/navigation/addnaviga','NavigationController@addnaviga');    //添加导航
    Route::post('api/navigation/editnaviga','NavigationController@editnaviga');  //修改导航
    Route::post('api/navigation/delnaviga','NavigationController@delnaviga');    //删除导航
    Route::post("api/navigation/startnav","NavigationController@startnav");      //启用导航
    Route::post("api/navigation/stopnav","NavigationController@stopnav");        //停用导航
    Route::post("api/navigation/copynav","NavigationController@copynav");        //复制导航
    // 溯源管理 -- 标签列表
    Route::post('Tag/index',['uses'=>'TagController@index']);//标签列表
    Route::post('Tag/addtag',['uses'=>'TagController@addtag']);   //新增
    Route::post('Tag/edittag',['uses'=>'TagController@edittag']); //编辑
    Route::post('Tag/deltag',['uses'=>'TagController@deltag']);   //删除
    Route::post('Tag/enable',['uses'=>'TagController@enable']);//启用
    Route::post('Tag/disable',['uses'=>'TagController@disable']);//停用

    // 溯源管理 -- 模板列表
    Route::post('Template/index',['uses'=>'TemplateController@index']);     //模板列表
    Route::post('Template/addtem',['uses'=>'TemplateController@addtem']);   //新增
    Route::post('Template/edittem',['uses'=>'TemplateController@edittem']); //编辑
    Route::post('Template/deltem',['uses'=>'TemplateController@deltem']);   //删除
    Route::post('Template/enable',['uses'=>'TemplateController@enable']);   //启用
    Route::post('Template/disable',['uses'=>'TemplateController@disable']); //停用
    Route::post('Template/copytem',['uses'=>'TemplateController@copytem']); //复制

    //防窜防伪  -- 经销区管理
    Route::post("DistributionArea/index","DistributionAreaController@index");       //列表
    Route::post("DistributionArea/adddis","DistributionAreaController@adddis");     //添加
    Route::post("DistributionArea/editdis","DistributionAreaController@editdis");   //编辑
    Route::post("DistributionArea/enable","DistributionAreaController@enable");     //启用
    Route::post("DistributionArea/disable","DistributionAreaController@disable");   //停用
    Route::post("DistributionArea/deldis","DistributionAreaController@deldis");     //删除

    //防窜预警 --ok
    Route::post("RegionManage/earlylist","Prevention\PreWarningController@earlylist"); //防窜预警列表  ok
    Route::post("RegionManage/handlearly","Prevention\PreWarningController@handlearly"); //处理防窜预警  ok
    Route::post("RegionManage/editearly","Prevention\PreWarningController@editearly");  //编辑防窜预警  ok

    //防伪管理     -- ok
    Route::post('anticounter/antiset','AnticounterController@antiset');        //防伪预警设置
    Route::post('anticounter/editantiset','AnticounterController@editantiset');//防伪预警提交
    Route::post('anticounter/antilist','AnticounterController@antilist');      //防伪预警列表
    Route::post('anticounter/antihandle','AnticounterController@antihandle');  //防伪预警处理
    Route::post('anticounter/editanti','AnticounterController@editanti');      //防伪预警编辑
    Route::post('anticounter/openQuery','AnticounterController@openQuery');    //开启查询
    Route::post('anticounter/closeQuery','AnticounterController@closeQuery');  //关闭查询

    // 公告管理
    Route::post('notice/index','NoticeController@index');              //列表
    Route::post('notice/addNotice','NoticeController@addNotice');      //添加
    Route::post('notice/editNotice','NoticeController@editNotice');    //编辑
    Route::post('notice/delNotice','NoticeController@delNotice');      //删除

    // 兑换记录
    Route::post('AutiRecord/index','Integral\AutiRecordController@index');//兑换物品记录列表
    Route::post('AutiRecord/pass','Integral\AutiRecordController@pass');//通过
    Route::post('AutiRecord/reject','Integral\AutiRecordController@reject');//驳回
});
// 发码管理-发码列表-生成下载文件
Route::any('Derivation/index',['uses'=>'DerivationController@index']);
Route::any('Environment/getDevice',['uses'=>'EnvironmentController@getDevice']);//获取环境设备数据，自动获取数据
Route::any('CodeManage/singleCodeLink',['uses'=>'CodeManageController@singleCodeLink']);//单个码链接

// 终端页面接口
Route::post('Look/getGoodsInfo',['uses'=>'LookController@getGoodsInfo']);               //获取商品信息接口
Route::post('Look/Goodsdata/{type?}',['uses'=>'LookController@Goodsdata']);                     //获取商品数据接口
Route::post('Look/getEnvironmentInfo/{type?}',['uses'=>'LookController@getEnvironmentInfo']);   //获取环境信息接口
Route::post('Look/getTraceabilityInfo/{type?}',['uses'=>'LookController@getTraceabilityInfo']); //获取溯源信息接口
Route::post('Look/getSourceInfo/{type?}',['uses'=>'LookController@getSourceInfo']);             //获取溯源信息接口
Route::post('Look/preventforge/{type?}','LookController@preventforge');                         //防伪查询信息接口
Route::post('Look/warranty/{type?}','LookController@warranty');                                 //质保查询信息接口
Route::post('Look/warrantys','LookController@warrantys');                               //消费者查看质保单信息
Route::post('Look/subwarranty','LookController@subwarranty');                           //消费者提交质保单信息
Route::post('Look/GetInfo','LookController@GetInfo');                           //入口文件
Route::post('Look/for_navigation','LookController@for_navigation');                   //获取导航信息
Route::post('Look/getWarehouse/{type?}','LookController@getWarehouse');                   //获取出入库渠道商信息

Route::group(['middleware'=>['islogin']],function(){
    //一键发码
    Route::post("akeycode/index","AkeycodeController@index");                   //一键发码获取商品信息
    Route::post("akeycode/goods_info","AkeycodeController@goods_info");         //选择分类获取商品信息
    Route::post("akeycode/addcode","AkeycodeController@addcode");               //发码

    Route::post("akeycode/addgo","AkeycodeController@addgo");               //添加商品
    Route::post("akeycode/editgo","AkeycodeController@editgo");               //编辑商品
    Route::post('akeycode/imageform','AkeycodeController@imageform');       //上传图片
    Route::post('akeycode/delimageform','AkeycodeController@delimageform'); //删除图片
    Route::post('akeycode/addformwork','AkeycodeController@addformwork'); //添加溯源信息
    Route::post('akeycode/handleformwork','AkeycodeController@handleformwork'); //编辑溯源信息
    Route::post('akeycode/gettrainfo','AkeycodeController@gettrainfo'); //获取溯源信息

    Route::post('akeycode/navigation_info','AkeycodeController@navigation_info'); //获取导航信息
    Route::post('akeycode/add_nav','AkeycodeController@add_nav'); //修改导航信息项
    Route::post('akeycode/edit_nav','AkeycodeController@edit_nav'); //修改导航信息项
    Route::post("akeycode/formwork_info","AkeycodeController@formwork_info");   //获取右侧信息
});
