<?php
namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use App\Http\Models\Coperationa;
class WareModel extends Model
{

	private $state=[1=>'启用',2=>'停用',3=>'删除'];
	//展示仓库列表；
	public function getWarelist($data=[],$cid){
		
		// 库名   最大  最小   省份  城市  区县 详细地址 库类 库状态  数量排序  1 从大到小  2 从下到大
		$Db=DB::table('repertory')->where('rep_state','!=',3)->where(['rep_cid'=>$cid]);
		if(!empty($data['ware_name'])){
			$Db=$Db->where('rep_name','like',"%".$data['ware_name']."%");
		}
		if(!empty($data['ware_max']) || $data['ware_max']===0){
			$Db=$Db->where('rep_good_number','<=',$data['ware_max']);
		}
		if(!empty($data['ware_min']) || $data['ware_min']===0){
			$Db=$Db->where('rep_good_number','>=',$data['ware_min']);
		}
		if(!empty($data['province'])){			
			$Db=$Db->where(['rep_province'=>$data['province']]);			
		}
		if(!empty($data['city'])){
			$Db=$Db->where(['rep_city'=>$data['city']]);
		}
		if(!empty($data['county'])){
			$Db=$Db->where(['rep_county'=>$data['county']]);
		}
		if(!empty($data['address'])){
			$Db=$Db->where('rep_address','like',"%".$data['address']."%");
		}
		if(!empty($data['is_ok'])){
			$Db=$Db->where(['is_ok'=>$data['is_ok']]);
		}
		if(!empty($data['ware_state'])){
			$Db=$Db->where(['rep_state'=>$data['ware_state']]);
		}
		if(!empty($data['ware_class'])){
			$Db=$Db->where(['rep_type'=>$data['ware_class']]);
		}
		if(!empty($data['order'])){
			$order= $data['order']==1 ?"desc":"asc";
			$Db=$Db->orderBy('rep_good_number',$order);
		}else{
			$Db=$Db->orderBy('rep_id','desc');
		}

		if(empty($data['page_size'])){
			$data['page_size']=10;
		}
		if(empty($data['page'])){
			$data['page']=1;
		}
		$count1=$Db->count();
		$page_count=(int)ceil($count1/$data['page_size']);
		$limit=($data['page']-1)*$data['page_size'];
		$list=$Db->limit($data['page_size'])->offset($limit)->get();

		foreach($list as $k=>$v)
		{
			$num=DB::table('out_order')
					->where('ware_id','=',$v['rep_id'])
					->where('war_out_state','=',1)
					->where('del_state','=',1)
					->count();

			$num1=DB::table('receipt_order')
					->where('ware_id','=',$v['rep_id'])
					->where('rec_state','=',1)
					->where('del_state','=',1)
					->count();
			$count = $num+$num1;
			$list[$k]['tip_num'] = $count;
		}
		return ['page'=>$data['page'],'page_count'=>$count1,'page_size'=>$data['page_size'],'page_number'=>$page_count,'list'=>$list];
	}
	/**
	 * 修改云仓状态
	 * @param  [type] $ware_id 仓库id
	 * @param  [type] $state   操作类型
	 * @param  [type] $adm_cid 公司id
	 * @param  [type] $page    分页 数组
	 * @return [type]          [description]
	 */
	public function updateWare($ware_id,$state,$user){
		if(!is_array($ware_id)){
			$str=$ware_id;
			unset($ware_id);
			$ware_id[]=$str;
		}
		//没有仓库
		foreach ($ware_id as $key => $value){
				if(!CommenModel::wareCheck($value,$user['adm_cid'])){
				return ['code'=>500,'msg'=>'失败','data'=>'公司没有该仓库'];
			}
		}
		try{
			DB::beginTransaction();
			if($state==2 || $state==3){
				//判断出库单
				$res=Db::table('out_order')->whereIn('ware_id',$ware_id)->where(['war_out_state'=>1,'del_state'=>1])->get();
				if($res) throw new Exception("仓库".$this->state[$state]."失败,有出库单未完成");

				$res2=Db::table('receipt_order')->whereIn('ware_id',$ware_id)->where(['rec_state'=>1,'del_state'=>1])->get();
				if($res2) throw new Exception("仓库".$this->state[$state]."失败,有入库单未完成");
				
			}
			$data=Db::table('repertory')->whereIn('rep_id',$ware_id)->select('rep_name','rep_good_number','cultiv_id')->get();
			$goods_num=array_sum(array_column($data,'rep_good_number'));
			if($state==3 && $goods_num>0){
				throw new Exception("仓库商品数量不为0。无法删除");
			}

			// 将耕地表和农田仓库表的数据删除
			$cultiv_id=array_unique(array_column($data,'cultiv_id'));
			rsort($cultiv_id);
			$res2=true;
			//删除判断 农田仓库表的id 不能为空
			if($state==3 && !empty($cultiv_id)){

				//查询耕地仓库的数据;
				$cultiv_data=Db::table('cultivation')
				->where('cul_state','!=',3)
				->whereIn('cul_id',$cultiv_id)
				->select('cul_id','reg_id','cul_acreage')->get();
				if(!empty($cultiv_data)){
					foreach ($cultiv_data as $key => $val){
						$res2=Db::table('massif_region')->where(['reg_id'=>$val['reg_id']])->increment('reg_surplus',$val['cul_acreage']);
						if(!$res2)throw new Exception('删除仓库失败。');
					}

					$res2=Db::table('cultivation')->whereIn('cul_id',$cultiv_id)->update(['cul_state'=>3]);
				}
				
			}

			$res=Db::table('repertory')->where(['rep_cid'=>$user['adm_cid']])->whereIn('rep_id',$ware_id)->update(['rep_state'=>$state]);

			if(!$res || !$res2) throw new Exception("仓库".$this->state[$state]."失败");
			$ware_name=array_column($data,'rep_name');

			$ware_name=implode(',',$ware_name);
			$str=$this->state[$state];
			//1 启用  2 停用  3.删除
			if($state==1){
				$content="启用仓库:".$ware_name;
			}elseif($state==2){
				$content="停用仓库:".$ware_name;
			}elseif($state==3){
				$content="删除仓库:".$ware_name;
			}
			//写入操作日志表里
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="我的云仓-->仓库状态更改";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");
			DB::commit();
			//判断是否是删除，是就返回数据；
			return ['code'=>200,'msg'=>'成功',"data"=>$this->state[$state].'操作成功'];
		}catch(Exception $e){
			DB::rollBack(); 
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}	
	}
/**
 * 添加或修改  仓库
 * @param [type] $array 值
 * @param [type] $state 修改或添加  
 * @param [type] $user  登陆人信息
 */
	public function Waremodify($array,$state,$user){
		try{
			DB::beginTransaction();
			$data['rep_province']=$array['province'];
			$data['rep_city']=$array['city'];
			$data['rep_county']=$array['county'];

			$data['rep_address']=$array['address'];

			$data['rep_name']=$array['ware_name'];

			$data['is_ok']=$array['is_ok'];

			$data['rep_type']=$array['state'];

			$data['rep_cid']=$user['adm_cid'];
			$data['rep_addname']=$user['admin_id'];
			$data['rep_sort']= 1;
			$half=Db::table("repertory")->where('rep_state','!=',3)->where(['rep_cid'=>$user['adm_cid']]);
			if($state==1){
				$data['rep_subtime']=date("Y-m-d H:i:s");
				$warename=$half->where(['rep_name'=>$data['rep_name']])->first();
				
				if($warename) throw new Exception('公司已存在这个仓库,仓库名重复');

				$res=Db::table('repertory')->insert($data);
				$ware_str="添加";
				if(!$res) throw new Exception('添加仓库失败');
			}elseif($state==2){
				$ware_id=$array['ware_id'];
				$data['rep_subtime']=date("Y-m-d H:i:s");
				$res=$half->where(['rep_id'=>$ware_id])->select('rep_name','cultiv_id')->first();
				$res5=Db::table('repertory')->where('rep_state','!=',3)->where(['rep_cid'=>$user['adm_cid']])->where(['rep_name'=>$data['rep_name']])->where('rep_id','!=',$ware_id)->select('rep_name')->first();
				if(!empty($res5)){
					throw new Exception("仓库名称不可重复");
				}
				if($res){
					$res2=true;
					//如果名称更换，并且有关联id则更改 农田表数据
					if(!empty($res['cultiv_id'])){
						$res2=Db::table('cultivation')->where('cul_id',$res['cultiv_id'])->update(['cul_name'=>$data['rep_name'],'cul_ware_type'=>$data['rep_type'],'update_time'=>date('Y-m-d H:i:s',time())]);
					}
					$return_res=$half->where(['rep_id'=>$ware_id])->update($data);
					$ware_str="更新";
					if(!$return_res || !$res2) throw new Exception('修改失败');
				}else{
					throw new Exception('未找到仓库');
				}
			}
			// 写入操作日志表里
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="我的云仓";//模块
			$content=$ware_str."仓库：.".$data['rep_name']; 
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$ware_str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");
			
			DB::commit();
			if($state==1){
				return ['code'=>200,'msg'=>'成功','data'=>'仓库添加成功'];
			}else{
				return ['code'=>200,'msg'=>'成功','data'=>'仓库修改成功'];
			}
			
		}catch(Exception $e){
			DB::rollBack(); 
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}
	
}