<?php
namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Cache;
use \Exception;
use App\Http\Models\Coperationa;
class StorageModel extends Model
{
	private $state=[1=>'正常',2=>'停用',3=>'删除'];
		/**
	 * 获取仓库商品列表
	 * @param  [type] $ware_id 仓库id
	 * @param  [type] $where   条件
	 * @param  [type] $rep_cid 公司id
	 * @return [type]          [description]
	 */
	//获取 仓库的商品列表
	public function getGoodslist($ware_id,$where,$rep_cid){
		//判断是否自己有这个库
		if(!CommenModel::wareCheck($ware_id,$rep_cid)){
			return ['code'=>500,'msg'=>'失败','data'=>'公司旗下没有这个仓库'];
		}

		$Db=DB::table('warehouse as ware')->where(['war_rid'=>$ware_id])->where('war_goods_state','!=',3)->join('goods','goods.goo_id','=','ware.war_goodsid')->where(['goo_cid'=>$rep_cid]);

		if(!empty($where['goods_name'])){
			$Db=$Db->where('goods.goo_name','like',"%".$where['goods_name']."%");
		}
		if(!empty($where['barcoding'])){
			$Db=$Db->where('goods.goo_number','like',"%".$where['barcoding']."%");
		}
		if(!empty($where['goods_state'])){
			$Db=$Db->where(['ware.war_goods_state'=>$where['goods_state']]);
		}
		if(!empty($where['goods_max']) || $where['goods_max']===0){
			$Db=$Db->where('ware.war_stock_count','<',$where['goods_max']);
		}
		if(!empty($where['goods_min']) || $where['goods_min']===0){
			$Db=$Db->where('ware.war_stock_count','>',$where['goods_min']);
		}
		if(!empty($where['order'])){
			$order= $where['order']==1 ?"desc":"asc";
			$Db=$Db->orderBy('ware.war_stock_count',$order);
		}else{
			$Db=$Db->orderBy('ware.war_id','desc');
		}
		if(empty($where['page_size'])){
			$where['page_size']=10;
		}
		if(empty($where['page'])){
			$where['page']=1;
		}

		$count=$Db->count();
		$page_count=(int)ceil($count/$where['page_size']);
		$limit=($where['page']-1)*$where['page_size'];

		$data=$Db->select('war_id as goods_id','war_stock_count as number','war_goods_state as state','goo_name as goods_name','goo_number as goods_num')->limit($where['page_size'])->offset($limit)->get();
		foreach ($data as $key => $value) {
			$data[$key]['input_type']=1;
		}
		return ['code'=>200,'msg'=>'成功','data'=>['page'=>(int)$where['page'],'page_count'=>(int)$page_count,'page_size'=>(int)$where['page_size'],'page_number'=>(int)$count,'ware_id'=>$ware_id,'list'=>$data]];
	}
/**
 * 修改库房商品 状态    停用 或 启用
 * @param  [type] $ware_id  仓库id
 * @param  [type] $goods_id 商品id
 * @param  [type] $state    修改值
 * @param  [type] $user     用户参数
 * @return [type]           
 */
	public function goodEidt_state($ware_id,$goods_id,$state,$user){
		try{
			DB::beginTransaction();
			//判断是否有该仓库
			if(!CommenModel::wareCheck($ware_id,$user['adm_cid'])) throw new Exception("公司旗下没有这个仓库");
			if(!is_array($goods_id)){
				$str=$goods_id;
				unset($goods_id);
				$goods_id[]=$str;
			}
			$goods_name=Db::table('warehouse')->where(['war_rid'=>$ware_id])->whereIn('war_id',$goods_id)->select('war_id')->get();
			// return $goods_name;die;
			if(empty($goods_name)) throw new Exception("仓库中没有该商品");

			$str=implode(',',array_column($goods_name,'war_id'));
			$res=Db::table('warehouse')->where(['war_rid'=>$ware_id])->whereIn('war_id',$goods_id)->update(['war_goods_state'=>$state]);
			if(!$res) throw new Exception("修改商品状态失败");

			//写入操作日志表里
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="我的云仓";//模块
			$str='更改状态';
			$action="将商品".implode(',',$goods_id)."  --".$str."状态更改为".$this->state[$state];
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$action);
			if(!$res) throw new Exception("写入操作日志表失败");

			DB::commit();
			return ['code'=>200,'msg'=>'成功','data'=>'修改商品状态成功'];
		}catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}

	/**
	 * 盘库  修改商品库存
	 * @param [type] $data 
	 * @param [type] $user  用户信息
	 */
	public function IncrbyStock($data,$user){
		if(!CommenModel::wareCheck($data['ware_id'],$user['adm_cid'])) throw new Exception("公司旗下没有这个仓库");
			$number=Db::table('warehouse')->where(['war_id'=>$data['good_id']])->select('war_stock_count as number')->pluck('number');
			if($data['number']==$number){
				return ['code'=>200,'msg'=>'失败','data'=>'没有修改数据'];
			}
			
		// try{
			DB::beginTransaction();
			//判断是否有该仓库

			$disparity=$data['number']-$number;
			if($disparity<0){
				$sum_number=Db::table('repertory')->where(['rep_id'=>$data['ware_id']])->select('rep_good_number')->first()['rep_good_number'];
				if(($sum_number+$disparity) <0 ) throw new Exception("商品总库存不足");
			}
			//修改仓库  总库存
			$res=Db::table('repertory')->where(['rep_id'=>$data['ware_id']])->increment("rep_good_number",$disparity);
			if(!$res) throw new Exception("修改仓库商品数量失败");

			//修改某个商品库存
			$res=Db::table('warehouse')->where(['war_id'=>$data['good_id']])->increment("war_stock_count",$disparity);
			//获取商品名称
			$goo_name=DB::table('warehouse as w')
						->leftjoin('goods', 'goods.goo_id', '=', 'w.war_goodsid')
						->where('w.war_id','=',$data['good_id'])
						->select('goods.goo_name')
						->first();

			if(!$res) throw new Exception("修改商品数量失败");

			//写入操作日志表里
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="我的云仓->云仓管理->盘库";//模块
			// $action="将".$str."状态更改为".$this->type[$state]; //操作东西  如 ：   删除:上海仓库,上海仓库
			// $res= Log::read($user['admin_name'],$action);
			// if($res) throw new Exception("写入操作日志表失败");
			$str='盘库';
			$content="修改商品 :".$goo_name['goo_name'].",库存为".$data['number'];
			//写入操作日志表里

			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");

			// $e->getMessage()
			DB::commit();
			return ['code'=>200,'msg'=>'成功','data'=>'修改库成功'];
		// }catch(Exception $e){
		// 	DB::rollBack();
		// 	return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		// }
	}

	//获取分类下商品 ,并且自己没有的商品   公司id   仓库id  分类id
	public function getClassgoods($cdm_id,$ware_id,$token,$class=null){
		if(!CommenModel::wareCheck($ware_id,$cdm_id)) return ['code'=>false,'data'=>'公司旗下没有这个仓库'];

		$state=1;
		$type=$class;
		if(empty($class)){
			//没有传递class下  所有分类
			$state=2;
			$class=Db::table('goo_classifi')->where(['cla_cid'=>$cdm_id,'cla_stase'=>1])->orderBy('cla_id','asc')->select('cla_id')->pluck('cla_id');
		}else{
			//有传递class
			$existence=Db::table('goo_classifi')->where(['cla_cid'=>$cdm_id,'cla_stase'=>1,'cla_id'=>$class])->select('cla_id')->first();
			if(!$existence) return ['code'=>false,'data'=>'没有这个分类'];
		}

		$left=Db::table('goods')->where(['goo_classifi'=>$class,'goo_sta'=>1,'del_type'=>1])->select('goo_id as goods_id','goo_name as goods_name','goo_number as number')->get();
		
		//获取缓存中的仓库id 
		$arr=CommenModel::setChache($token,1);

		if(empty($arr) && empty($type)){

			$have=Db::table('warehouse')->where(['war_rid'=>$ware_id])->where('war_goods_state','!=',3)->select('war_goodsid as goods_id')->get();
			//获取仓库存在的商品id
			$data=array_column($have,"goods_id");
			$have2=Db::table('warehouse')->where(['war_rid'=>$ware_id])->where('war_goods_state','!=',3)->where('war_stock_count','>',0)->select('war_goodsid as goods_id')->get();
			$data2=array_column($have2,"goods_id");

			CommenModel::setChache($token,2,$data,0,$data2);
			$data=CommenModel::setChache($token,1);	
		}else{
			$data=$arr;
		}
		foreach ($left as $key => $value){
			$left[$key]['count']=0;

			if(!empty($data) && in_array($value['goods_id'],$data)){
				$left[$key]['type']=2;
			}else{
				$left[$key]['type']=1;
			}

		}
		if($state==1){
			return ['code'=>true,'left'=>$left];
		}
		// $left=json_decode(json_encode($left),true);
		
		$class_data=Db::table('goo_classifi')->where(['cla_cid'=>$cdm_id,'cla_stase'=>1])->orderBy('cla_id','asc')->select('cla_id as class_id','cla_name as class_name')->get();
		return ['code'=>true,'left'=>$left,'class'=>$class_data];
	}

	/**
	 * 提交 修改仓库 商品
	 * @param [type] $ware_id  仓库id
	 * @param [type] $goods_id 商品id
	 * @param [type] $user     用户信息
	 */
	public function StoraGoodsave($ware_id,$goods_id,$user){
		try{
			DB::beginTransaction();	
			if(!CommenModel::wareCheck($ware_id,$user['adm_cid'])) throw new Exception("公司旗下没有这个仓库");
			//获取所有的仓库商品信息
			$all_goods_id=Db::table('warehouse')->where(['war_rid'=>$ware_id])->where('war_goods_state','!=','3')->select('war_goodsid as goods_id')->get();

			//仓库里有商品    对商品进行处理    判断， 比对， 删除多余  ，入库
			// $all_goods_id=json_decode(json_encode($all_goods_id),true);
			
			if($all_goods_id){
				$all_goods=array_column($all_goods_id,'goods_id');

				//计算交集
				$arr_insert=array_intersect($goods_id,$all_goods);

				//得出删除的数据
				$del_goods_id=array_diff($all_goods,$arr_insert);

				//得出添加的数据
				$goods_id=array_diff($goods_id,$arr_insert);

				//判斷添加的商品  商品表中是否存在；
				$check_goods=Db::table('goods')->whereIn('goo_id',$goods_id)->select('goo_id')->get();
				$check_goods=json_decode(json_encode($check_goods),true);
				if(count($check_goods) != count($goods_id)) throw new Exception("商品表不存在添加的商品数据");

				if(!empty($del_goods_id)){
					//根据删除的商品id来判断是否有订单 存在未完成的状态，如果有则 则无法删除;
					//判断出库单
					$order_data=Db::table('out_order')->where(['ware_id'=>$ware_id,'war_out_state'=>1,'del_state'=>1])->select('war_out_id as order_id')->get();
					if(!empty($order_data)){
						$order_id=array_column($order_data,'order_id');
						//订单id
						$data=Db::table('warehouse_goods')->where('warg_type','!=',2)->where(['warg_state'=>1])->whereIn('warg_wid',$order_id)->select('warg_goodsid as goods_id')->get();
						$order_data_id=array_column($data,'goods_id');
						if(array_intersect($order_data_id,$del_goods_id)) throw new Exception("存在未完成的出库单,无法更改商品设置");

					}

					//判断入库单
					$order_data=Db::table('receipt_order')->where(['ware_id'=>$ware_id,'rec_state'=>1,'del_state'=>1])->select('rec_id as order_id')->get();
					if(!empty($order_data)){
						$order_id=array_column($order_data,'order_id');
						//订单id
						$data=Db::table('warehouse_goods')->where(['warg_state'=>1,'warg_type'=>2])->whereIn('warg_wid',$order_id)->select('warg_goodsid as goods_id')->get();
						$order_data_id=array_column($data,'goods_id');
						if(array_intersect($order_data_id,$del_goods_id)) throw new Exception("存在未完成的入库单,无法更改商品设置");
					}

					$res=Db::table('warehouse')->where(['war_rid'=>$ware_id])->whereIn('war_goodsid',$del_goods_id)->update(['war_goods_state'=>3]);
					if(!$res) throw new Exception("存储商品设置失败");
				}
			}
			
			$arr=[];
			foreach ($goods_id as $key => $value) {
				$arr[$key]['war_cid']=$user['adm_cid'];
				$arr[$key]['war_rid']=$ware_id;
				$arr[$key]['war_userid']=$user['admin_id'];
				$arr[$key]['war_goodsid']=$value;
				$arr[$key]['war_stock_count']=0;
				$arr[$key]['war_subtime']=date('Y-m-d H:i:s',time());
			}

			if(!empty($arr)){
				$res=Db::table("warehouse")->insert($arr);
				if(!$res) throw new Exception("存储商品设置失败");
			}
			// 添加数据
			
			
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="我的云仓->存储商品设置";//模块
			// $action="将".$str."状态更改为".$this->type[$state]; //操作东西  如 ：   删除:上海仓库,上海仓库
			// $res= Log::read($user['admin_name'],$action);
			// if($res) throw new Exception("写入操作日志表失败");
			$str='更改';
			$content="修改仓库内商品";
			//写入操作日志表里
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");
			DB::commit();
			return ['code'=>200,'msg'=>'成功','data'=>'更改仓库商品成功'];
		}catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];

		}
		
	}

	//获取仓库内的商品 
	public function getWare_goodslist($ware_id,$user){
		if(!CommenModel::wareCheck($ware_id,$user['adm_cid'])){
			return ['code'=>false];
		}

		$have=Db::table('warehouse as ware')->where(['war_rid'=>$ware_id])->where('war_goods_state','!=',3)->join('goods as goods','goods.goo_id','=','ware.war_goodsid')->select('goods.goo_id as goods_id','goo_name as goods_name','goo_number as number','war_stock_count as count')->get();
		// $have=json_decode(json_encode($have),true);
		foreach ($have as $key => $value){
			if($have[$key]['count']>0){
				$have[$key]['type']=2;
			}else{
				$have[$key]['type']=1;
			}
			# code...
		}
		return ['code'=>true,'data'=>$have];
	}
}