<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use App\Http\Models\Coperationa;
class StatisicModel extends Model
{
	private $page_size=10;

    /**
     * 数据大屏统计
     * @param [type] $user 用户
     * @param [type] $type 1 第一页    2 第二页
     * @param [type] $page 页面数据   equ_page设备页码   reg_page 基地运营情况页码
     */
    public function Big_Data_Count($user,$type,$page){

    	if($type==1){
    		$res_data=[2=>'software',3=>'service',4=>'system'];

    		$year=date("Y");
    		//统计第一页数据；
    		//统计 访问端  网络  操作系统  软件
    		
    		$data=[];
    		//访问端查询量
			$phone_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>3])->selectRaw("sum(stal_total) as value,stal_city as name")->orderBy('stal_total','desc')->groupBy('stal_city')->get();
			$data['terminal']=$phone_count;

    		foreach ($res_data as $key => $value) {
    			$data[$value]=Db::table('overall_plan')->where(['ovp_time'=>$year,'ovp_cid'=>$user['adm_cid'],'ovp_type'=>$key])->selectRaw("ovp_name as name,sum(ovp_num) as value")->groupBy('ovp_name')->orderBy('value','desc')->get();
    		}

    		//统计商品发码量
    		$goods=Db::table('goods_code')->where(['gco_year'=>$year,'gco_cid'=>$user['adm_cid']])->groupBy('goods_id')->join('goods','goo_id','=','goods_id')->selectRaw("sum(gco_num) as value,goo_name as name")->orderBy('value','desc')->get();
    		$data['goods_send']=$goods;
    		$data['goods_sends']=array_slice($goods,0,10);

    		//二维码发码量   统计的是导入的二维码数量
    		$sql="SELECT sum(gro_num) as value,concat(date_format(gro_time,'%m'),'月') as name FROM trace_group where gro_cid={$user['adm_cid']} and date_format(gro_time,'%Y') = {$year} group by date_format(gro_time,'%m') order by gro_time asc";
    		$group=Db::select($sql);
    		
    		$data['send_code']=$group;

    		//获取所有城市和省份的名称
    		$city=[];

    		//城市查询量
			$city_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>1])->selectRaw("sum(stal_total) as value,stal_city as name")->orderBy('stal_total','desc')->groupBy('stal_city')->get();
			$data['city_count']=$city_count;

			if(!empty($city_count)){
				$city=array_column($city_count,'name');
				$data['city']=$city;
			}else{
				$data['city']=[];
			}

			//商品查询量
			$goods_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2])->selectRaw("sum(stal_total) as value,goo_name as name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->orderBy('value','desc')->groupBy('stal_goo_id')->get();
			$data['goods_count']=$goods_count;
			$data['goods_counts']=array_slice($goods_count,0,10);

    		//商品分类查询量
    		$class_data=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2])->selectRaw("sum(stal_total) as value,cla_name as name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->join('goo_classifi','goo_classifi','=','cla_id')->groupBy('cla_id')->orderBy('value','desc')->get();
    		$data['class_count']=$class_data;
    		$data['class_counts']=array_slice($class_data,0,10);


    		//区域防窜
    		$region_data=Db::table('region_early')->where(['com_id'=>$user['adm_cid']])->whereRaw("date_format(add_time,'%Y') = {$year}")->join('region','region.id','=','region_early.region_id')->selectRaw("group_name as name,trace_region_early.region_id")->groupBy('region_early.region_id')->get();

    		$no_region=Db::table('region_early')->where(['com_id'=>$user['adm_cid'],'type'=>1])->whereRaw("date_format(add_time,'%Y') = {$year}")->selectRaw("count(region_id) as val,region_id")->groupBy('region_id')->get();
    		$no_region=array_column($no_region,null,'region_id');

    		$region=Db::table('region_early')->where(['com_id'=>$user['adm_cid'],'type'=>2])->whereRaw("date_format(add_time,'%Y') = {$year}")->selectRaw("count(region_id) as val,region_id")->groupBy('region_id')->get();
    		$region=array_column($region,null,'region_id');
    		foreach ($region_data as $key => $value) {
    			$region_data[$key]['sum']=0;
    			if(empty($no_region[$value['region_id']])){
    				$region_data[$key]['no_flee']=0;
    			}else{
    				$region_data[$key]['no_flee']=$no_region[$value['region_id']]['val'];
    				$region_data[$key]['sum']+=$no_region[$value['region_id']]['val'];
    			}
    			if(empty($region[$value['region_id']])){
    				$region_data[$key]['flee']=0;
    			}else{
    				$region_data[$key]['flee']=$region[$value['region_id']]['val'];
    				$region_data[$key]['sum']+=$region[$value['region_id']]['val'];
    			}
    			unset($region_data[$key]['region_id']);
    		}

    		$data['region_data']=$region_data;
    		
    		//防窜预警
    		$prevention_data=Db::table('region_early')->where(['com_id'=>$user['adm_cid'],'type'=>2])->whereRaw("date_format(add_time,'%Y') = {$year} and city != ''")->selectRaw("count(city) as value,city as name")->groupBy('city')->get();
    		if(!empty($prevention_data)){
    			$num=array_sum(array_column($prevention_data,'value'));
    			$no_num=Db::table('region_early')->where(['com_id'=>$user['adm_cid']])->whereRaw("date_format(add_time,'%Y') = {$year} and type != 2")->count();
    			// $num_bl=sprintf("%.2f",$num/($num+$no_num)*100);
    			// $no_num_bl=sprintf("%.2f",$no_num/($num+$no_num)*100);
    			$data['prop_region']=[
    				['name'=>'窜货','value'=>$num],
    				['name'=>'未窜货','value'=>$no_num]
    			];

    		}else{
    			$data['prop_region']=[];
    		}
    		// $preven=array_column($prevention_data);
    		
    		$data['prevention_data']=$prevention_data;
    		$city=array_merge($city,array_column($prevention_data,'name'));

    		//防伪预警
    		$total=Db::table('info_total')->where(['total_cid'=>$user['adm_cid']])->whereRaw("date_format(create_at,'%Y') = {$year}")->selectRaw("count(total_city) as value,total_city as name")->groupBy('total_city')->get();
    		foreach ($total as $key => $value){
    			if(empty($value['name'])){
    				unset($total[$key]);
    			}
    		}
    		sort($total);
    		$data['anti_counter']=$total;
    		$city=array_merge($city,array_column($total,'name'));
    		$data['city']=array_unique($city);
    		$arr=[];
			foreach ($data['city'] as $key => $value){
				if($value=="" || empty($value) || $value=='未知' || $value=='city'){

				}else{
					$arr[]=$value;
				}
			}
			$data['city']=$arr;
    		return ['code'=>'200','msg'=>'success','data'=>$data];
    	}elseif($type==2){

    		$data=[];
    		//统计的是今年的数据;
    		$year=date("Y");
    		
    		//统计基地的分布
    		//统计基地运营情况
    		//统计设备的分布
    		$res_data=$this->Equ_Data($user,$page['equ_page']);

    		$data['equ_data']=$res_data['data']['data'];
    		$data['equ_page']=$res_data['data']['page'];
    		//统计商品分类的产量
    		$class_data=Db::table('production')->where(['pro_cid'=>$user['adm_cid'],'pro_del'=>1,'pro_quarantine'=>4,'pro_state'=>3])->whereRaw("date_format(end_time,'%Y') = {$year}")->groupBy('class_id')->selectRaw("SUM(sla_number) as value,cla_name as name")->join('goo_classifi','cla_id','=','class_id')->orderBy('value','desc')->get();

    		$data['class_yield']=$class_data;

    		//高产基地排行
    		$region=Db::table('massif_region')->where(['reg_cid'=>$user['adm_cid'],'reg_parent_id'=>0])->where('reg_state','!=',3)->join('farmland','farmland.far_id','=','massif_region.far_id')->leftjoin('herdsman','herdsman.her_id','=','farmland.her_id')->select("her_name","reg_name",'reg_id')->get();
    		$new_region = array();
    		array_walk($region, function($value, $key) use (&$new_region ){
			    $new_region[$key]['name'] = $value['her_name'];
			    $new_region[$key]['reg_name'] = $value['reg_name'];
			    $new_region[$key]['reg_id'] = $value['reg_id'];
			});
    		$reg_id=array_column($new_region,'reg_id');
    		$production=Db::table('production')->where(['pro_del'=>1,'pro_quarantine'=>4,'pro_state'=>3])->whereIn('reg_id',$reg_id)->whereRaw("date_format(end_time,'%Y') = {$year}")->groupBy('reg_id')->selectRaw("SUM(sla_number) as value,reg_id")->orderBy('value','desc')->get();
    		$pro_data=array_column($production,'value','reg_id');
    		$reg_data=[];
    		foreach ($new_region as $key => $value) {
    			if(!empty($pro_data[$value['reg_id']])){
    				$value['value']=$pro_data[$value['reg_id']];
    				$reg_data[]=$value;
    			}
    		}
    		$last_names = array_column($reg_data,'value');
			array_multisort($last_names,SORT_DESC,$reg_data);
			$data['high_yield']=$reg_data;

			//统计基地分布情况
			//主要统计每个省份有几个负责人，每个负责人负责几个基地，有多少设备；
			$data_prover=Db::table('massif_region')
			->where('reg_parent_id',0)
			->where('reg_state','!=',3)
			->join('farmland','massif_region.far_id','=','farmland.far_id')
			->join('herdsman','herdsman.her_id','=','farmland.her_id')
			->leftjoin('equipment',function($join){
				$join->on('farmland.far_id','=','equipment.equ_far_id')
				->where('equipment.equ_state','!=',3);
			})
			->selectRaw("far_prover,her_name,count(equ_far_id) as equ_count,trace_farmland.her_id")
			->groupBy('massif_region.far_id')
			->get();
			$prover=[];
			foreach ($data_prover as $key => $val){
				// $temp['prover_name']
				$prover[$val['far_prover']][]=$val;
			}
			$data_prover=[];
			$i=0;
			foreach ($prover as $key => $val) {
				$temp=$val;
				$herdsman=[];
				foreach ($temp as $k => $v) {
					$herdsman[$v['her_id']]['herdsman_name']=$v['her_name'];
					$herdsman[$v['her_id']]['land_count']=empty($herdsman[$v['her_id']]['land_count'])?1:++$herdsman[$v['her_id']]['land_count'];

					$herdsman[$v['her_id']]['equ_count']=empty($herdsman[$v['her_id']]['equ_count'])?$v['equ_count']:$herdsman[$v['her_id']]['equ_count']+$v['equ_count'];
				}
				sort($herdsman);
				$data_prover[$i]['prover']=$key;
				$prover[]=$key;
				$data_prover[$i]['data']=$herdsman;
				$i++;
			}
			$data['distr_prover']=$data_prover;

			$data['distr_city']=array_column($data_prover,'prover');

			//统计每个区域的天气和牧场状态;
			$weather=$this->base_operate($user,1);

			//统计未使用的牧场数量  和使用中的牧场数量
			$cultiv_use=DB::table('cultivation')->where('cul_state','!=',3)->where(['state'=>2])->count();
			$cultiv_Nouser=DB::table('cultivation')->where('cul_state','!=',3)->where(['state'=>1])->count();
			if($cultiv_use==0 && $cultiv_Nouser==0){
				$data['cultiv_count']=[];
			}else{
				$data['cultiv_count']=[['name'=>'使用中','value'=>$cultiv_use],['name'=>'未使用','value'=>$cultiv_Nouser]];
			}
			$data['weather']=$weather['data']['data'];
			$data['weather_page']=$weather['data']['page'];

    		return ['code'=>'200','msg'=>'success','data'=>$data];
    	}else{


    		$data=[];
    		//统计的是今年的数据;
    		$year=date("Y");
    		// 大统计
    		//统计 全国的基地数 牧场数量  其中空闲多少  使用中多少
    		//今年  养殖中多少   待质检   病亡多少     已合格多少
    		//基地数量
    		$statist['base_num']=Db::table('farmland')->where('far_state','!=',3)->where('far_cid',$user['adm_cid'])->count();
    		//牧场数量
    		$statist['enc_num']=Db::table('cultivation')->where('cul_state','!=',3)->where(['cul_cid'=>$user['adm_cid']])->count();  
    		//使用中
    		$statist['use_num']=Db::table('cultivation')->where('cul_state','!=',3)->where(['cul_cid'=>$user['adm_cid'],'state'=>2])->count(); 
    		//未使用数量;
    		$statist['not_used']=$statist['enc_num']-$statist['use_num']; 

    		//养殖数量
    		$breed_num=Db::table('production')->where('pro_cid',$user['adm_cid'])->where(function($query){
    			$query->where("pro_state",">",1);
    		})->selectRaw("sum(breed_number) as breed,sum(die_number) as die")->first();
    		if(!empty($breed_num)){
    			$statist['breed_num']=$breed_num['breed']-$breed_num['die'];
    		}else{
    			$statist['breed_num']=0;
    		}
			$statist['breed_nums']=$this->hand_data($statist['breed_num']);
    		//质检数量
    		$quality_num=Db::table('production')->where('pro_cid',$user['adm_cid'])->where("pro_quarantine",3)->selectRaw("sum(breed_number) as breed,sum(die_number) as die")->first();
    		if(!empty($quality_num)){
    			$statist['quality_num']=$quality_num['breed']-$quality_num['die'];
    		}else{
    			$statist['quality_num']=0;
    		}
			$statist['quality_nums']=$this->hand_data($statist['quality_num']);
    		//病亡数量
    		$statist['die_num']=Db::table('death_record')->where('dea_cid',$user['adm_cid'])->whereRaw("date_format(dea_addtime,'%Y') = {$year}")->sum('dea_number');
    		$statist['die_nums']=$this->hand_data($statist['die_num']);
			//合格数量率
    		$qu_data=Db::table('production')->where('pro_cid',$user['adm_cid'])->where("pro_quarantine",4)->selectRaw("sum(sla_number) as sla_number,sum(die_number) as die")->first();
    		if(!empty($qu_data)){
    			$sum=$qu_data['sla_number']+$qu_data['die'];
    			// sprintf('%.1f',$int/10000);
    			$statist['qualified']=sprintf('%.1f',($qu_data['sla_number']/$sum)*100)."%";
    		}else{
    			$statist['qualified']="100%";
    		}
			$data['statist']=$statist;

    		//新运营统计   统计每种分类有多少个牧场养殖。
    		//统计  统计依据 根据 分类id 查询已经开始养殖的,和没有检疫成功的养殖批次。
    		$operate=Db::table("production")
    		->where(['pro_del'=>1,'pro_cid'=>$user['adm_cid'],'pro_state'=>2])
    		->join('goo_classifi','production.class_id','=','goo_classifi.cla_id')
    		->selectRaw("sum(breed_number) as breed_sum,sum(die_number) as die_number,count(cul_id) as count,cla_name as name")->orderBy('breed_sum','asc')->groupBy('class_id')->get();
    		$data['new_operate']=$operate;


    		//新基地的前十生产   1 结束时间是 今年   
    		//统计已完成的数量  
    		$pro_ok=Db::table('production')->where(['pro_del'=>1,'pro_cid'=>$user['adm_cid'],'pro_state'=>3])->join('massif_region','production.reg_id','=','massif_region.reg_id')->join('farmland','massif_region.far_id','=','farmland.far_id')->whereRaw("date_format(end_time,'%Y') = {$year}")->groupBy('reg_id')->selectRaw("SUM(sla_number) as complete,trace_massif_region.reg_id,far_name")->get();
    		if(!empty($pro_ok)){
    			$ok_regid=array_column($pro_ok,'reg_id');
    			$pro_ok=array_column($pro_ok,null,'reg_id');
    		}else{
    			$ok_regid=[];
    			$pro_ok=[];
    		}
    		//统计养殖中的数量
    		$pro_breed=Db::table('production')->where(['pro_del'=>1,'pro_cid'=>$user['adm_cid'],'pro_state'=>2])->join('massif_region','production.reg_id','=','massif_region.reg_id')->join('farmland','massif_region.far_id','=','farmland.far_id')->groupBy('reg_id')->selectRaw("SUM(breed_number) as breed,trace_massif_region.reg_id,far_name")->get();
    		if(!empty($pro_breed)){
    			$breed_regid=array_column($pro_breed,'reg_id');
    			$pro_breed=array_column($pro_breed,null,'reg_id');
    		}else{
    			$breed_regid=[];
    			$pro_breed=[];
    		}
    		$reg_id=array_unique(array_merge($breed_regid,$ok_regid));
    		$high_yield=[];
    		foreach ($reg_id as $key => $val) {
    			$temp=['breed_num'=>0,'far_name'=>'','complete'=>0,'total'=>0];
    			//如果有养殖数据
    			if(!empty($pro_breed[$val])){
    				$temp['breed_num']=$pro_breed[$val]['breed'];
    				$temp['far_name']=$pro_breed[$val]['far_name'];
    				$temp['total']=$pro_breed[$val]['breed'];
    			}
    			//如果有完成养殖数据
    			if(!empty($pro_ok[$val])){
    				$temp['complete']=$pro_ok[$val]['complete'];
    				$temp['far_name']=$pro_ok[$val]['far_name'];
    				$temp['total']+=$pro_ok[$val]['complete'];
    			}
    			$high_yield[]=$temp;
    		}
    		if(!empty($high_yield)){
    			$last_names = array_column($high_yield,'total');
				array_multisort($last_names,SORT_DESC,$high_yield);
				$high_yield=array_chunk($high_yield,10)[0];
    		}
			$data['high_yield']=$high_yield;

			//统计 高产高品质 圈舍排行榜top10  求检疫合格的数据。
			$enclosure=Db::table('production')->where(['pro_quarantine'=>4,'pro_cid'=>$user['adm_cid']])->join('enclosure','cultiv_id','=','cul_id')->selectRaw("sum(sla_number) as complete,sum(die_number) as die_num,enc_name")->groupBy('cul_id')->orderBy('complete','desc')->limit(10)->get();
			foreach ($enclosure as $key => $val) {
				$sum=$val['complete']+$val['die_num'];
				$enclosure[$key]['prop']=sprintf('%.2f',($val['die_num']/$sum)*100);
			}
			$data['enclosure']=$enclosure;

    		//统计每个区域的天气和牧场状态;
			$weather=$this->base_operate($user,$page['reg_page']);
			$data['weather']=$weather['data']['data'];
			$data['weather_page']=$weather['data']['page'];
			
			//统计基地分布情况
			//主要统计每个省份有几个负责人，每个负责人负责几个基地，有多少设备；
			$data_prover=Db::table('massif_region')
			->where('reg_parent_id',0)
			->where('reg_state','!=',3)
			->join('farmland','massif_region.far_id','=','farmland.far_id')
			->join('herdsman','herdsman.her_id','=','farmland.her_id')
			->leftjoin('equipment',function($join){
				$join->on('farmland.far_id','=','equipment.equ_far_id')
				->where('equipment.equ_state','!=',3);
			})
			->selectRaw("far_prover,her_name,count(equ_far_id) as equ_count,trace_farmland.her_id")
			->groupBy('massif_region.far_id')
			->get();
			$prover=[];
			foreach ($data_prover as $key => $val){
				// $temp['prover_name']
				$prover[$val['far_prover']][]=$val;
			}
			$data_prover=[];
			$i=0;
			foreach ($prover as $key => $val) {
				$temp=$val;
				$herdsman=[];
				foreach ($temp as $k => $v) {
					$herdsman[$v['her_id']]['herdsman_name']=$v['her_name'];
					$herdsman[$v['her_id']]['land_count']=empty($herdsman[$v['her_id']]['land_count'])?1:++$herdsman[$v['her_id']]['land_count'];

					$herdsman[$v['her_id']]['equ_count']=empty($herdsman[$v['her_id']]['equ_count'])?$v['equ_count']:$herdsman[$v['her_id']]['equ_count']+$v['equ_count'];
				}
				sort($herdsman);
				$data_prover[$i]['prover']=$key;
				$prover[]=$key;
				$data_prover[$i]['data']=$herdsman;
				$i++;
			}
			$data['distr_prover']=$data_prover;

			$data['distr_city']=array_column($data_prover,'prover');
    		
    		return ['code'=>'200','msg'=>'success','data'=>$data];
    	}
    }


    //获取天气数据
   	public function base_operate($user,$page){
   		//获取最后天气数据的 分组编号
   		$weather_num=Db::table('weather')->orderBy('wea_id','desc')->pluck('group_num');

   		//获取区域的数据
		$Db=Db::table('massif_region')
		->where(['reg_parent_id'=>0,'reg_cid'=>$user['adm_cid']])->where('reg_state','!=',3)
		->leftjoin('equipment',function($join){
			$join->on('equ_regid','=','massif_region.reg_id')
			->where('equ_state','!=',3);
		})
		->groupBy('reg_id')
		->leftjoin('weather',function($join) use ($weather_num){
			$join->on('reg_id','=','region_id')->where('group_num','=',$weather_num);
		});
		$count=count($Db->select('reg_id')->get());
		// dd($Db->get());
		$limit=($page-1)*4;
		$Db=$Db->limit(4)->offset($limit);
		$weather=$Db->select('reg_id','far_id','reg_name','reg_image','acreage','temp','wd','wdforce','humidity','prcp','equ_url')->get();

		$page_count=(int)ceil($count/4);

		//获取农田id
		$far_id=array_column($weather,'far_id');
		//更加农田id 查询耕地的数据
		$cultivation=DB::table('cultivation')->whereIn('far_id',$far_id)->where('cul_state','!=',3)->join('enclosure','cultiv_id','=','cul_id')->select('cul_id','far_id','state','enc_breed')->get();

		$state=[];
		//循环统计  每个农田下的 牧场数量  养殖数量，使用数量和未使用数量
		foreach ($cultivation as $key => $value){
			$state[$value['far_id']]['count']=empty($state[$value['far_id']]['count'])?1:$state[$value['far_id']]['count']+1;
			$state[$value['far_id']]['breed_count']=empty($state[$value['far_id']]['breed_count'])?$value['enc_breed']:$state[$value['far_id']]['breed_count']+$value['enc_breed'];
			if($value['state']==1){
				//未使用
				$state[$value['far_id']]['stop_count']=empty($state[$value['far_id']]['stop_count'])?1:$state[$value['far_id']]['stop_count']+1;
				$state[$value['far_id']]['use_count']=empty($state[$value['far_id']]['use_count'])?0:$state[$value['far_id']]['use_count'];
			}else{
				// 使用
				$state[$value['far_id']]['use_count']=empty($state[$value['far_id']]['use_count'])?1:$state[$value['far_id']]['use_count']+1;
				$state[$value['far_id']]['stop_count']=empty($state[$value['far_id']]['stop_count'])?0:$state[$value['far_id']]['stop_count'];
			}
		}
		//把统计的数据放到数组中
		foreach ($weather as $key => $value) {
			$weather[$key]['count']=empty($state[$value['far_id']]['count'])?0:$state[$value['far_id']]['count'];
			$weather[$key]['breed_count']=empty($state[$value['far_id']]['breed_count'])?0:$state[$value['far_id']]['breed_count'];
			$weather[$key]['stop_count']=empty($state[$value['far_id']]['stop_count'])?0:$state[$value['far_id']]['stop_count'];
			$weather[$key]['use_count']=empty($state[$value['far_id']]['use_count'])?0:$state[$value['far_id']]['use_count'];
		}
		$page=['count'=>$count,'page'=>$page,'page_size'=>4,'page_count'=>$page_count];
		return ['code'=>200,'msg'=>'error','data'=>['data'=>$weather,'page'=>$page]];
   	}

	//处理数据
    public function hand_data($int){
    	if($int>10000){
    		$temp=sprintf('%.1f',$int/10000);
    		$temp=trim($temp,'.0');
    		return $temp."万";
    		// return $int/10000
    	}else{
    		return $int;
    	}

    }

    /**
     * 请求设备数据
     * @param [type] $user 用户
     * @param [type] $page 页码
     */
    public function Equ_Data($user,$page){
    	$Db=DB::table('massif_region')->where('reg_state','!=',3)->where('reg_parent_id',0)->where(['reg_cid'=>$user['adm_cid']])->select("reg_name as name","reg_image as image",'reg_id');

    	// $Db=Db::table('equipment')->where(['equ_cid'=>$user['adm_cid']])->where('equ_state','!=',3)->selectRaw("count(equ_regid) as number,reg_name as name,reg_image as image")->groupBy('equ_regid')->join('massif_region','reg_id','=','equ_regid');
    	$count=$Db->count();
		$page_count=(int)ceil($count/12);
		$limit=($page-1)*12;
		$Db=$Db->limit(12)->offset($limit);
		$data=$Db->get();
		$reg_id=array_column($data,'reg_id');
		//获取摄像头数据
		$equipment=Db::table('equipment')->where('equ_state','!=',3)->whereIn('equ_regid',$reg_id)->groupBy('equ_regid')->selectRaw("count(equ_regid) as number,equ_regid")->get();
		$equip=array_column($equipment,'number','equ_regid');

		foreach ($data as $key => $value) {
			if(empty($equip[$value['reg_id']])){
				$data[$key]['number']=0;
			}else{
				$data[$key]['number']=$equip[$value['reg_id']];
			}
			unset($data[$key]['reg_id']);
		}

		$page=['count'=>$count,'page'=>$page,'page_size'=>12,'page_count'=>$page_count];
		return ['code'=>200,'msg'=>'error','data'=>['data'=>$data,'page'=>$page]];
    }
}