<?php
namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use Excel;
use App\Http\Models\Coperationa;

class OrdermanageModel extends Model
{
	private $type=[1=>'订单出库',2=>'出库单',3=>'入库单'];
	private $order_state=[1=>'已出库',2=>'已入库',3=>'强制入库',4=>'作废'];
	private $warning="入库异常：";
	private $warning_out="出库异常：";
	private $max=500;
	//获取 出库单列表
	public function getOutlist($where,$user,$export=2){
		//没有仓库
		if(!CommenModel::wareCheck($where['ware_id'],$user['adm_cid'])){
			return ['code'=>500,'msg'=>'失败','data'=>'公司没有该仓库'];
		}
		// 操作人  最大数 最小数  数量排序  时间排序
		$Db=DB::table('out_order as order')->where(['war_out_cid'=>$user['adm_cid'],'war_out_state'=>1,'ware_id'=>$where['ware_id'],'order.del_state'=>1])->leftjoin('wl','order.war_out_logistics','=','wl.wl_id')->join('admin','order.war_out_user','=','admin.adm_id');

		if(!empty($where['name'])){
			$Db=$Db->where('adm_name','like',"%".$where['name']."%");
		}

		if(!empty($where['time_end'])){
			$time=date('Y-m-d H:i:s',strtotime($where['time_end']));
			$Db=$Db->where('war_out_createtime','<=',$time);
		}
		if(!empty($where['order'])){
			$Db=$Db->where('war_out_order','like','%'.$where['order'].'%');
		}

		if(!empty($where['time_start'])){
			$time=date('Y-m-d H:i:s',strtotime($where['time_start']));
			$Db=$Db->where('war_out_createtime','>=',$time);
		}
		if(!empty($where['number_max']) || $where['number_max']===0){
			$Db=$Db->where('war_out_count','<=',$where['number_max']);
		}

		if(!empty($where['number_min']) || $where['number_min']===0){
			$Db=$Db->where('war_out_count','>=',$where['number_min']);
		}

		if(!empty($where['order_number'])){
			$order= $where['order_number']==1 ?"desc":"asc";
			$Db=$Db->orderBy('war_out_count',$order);
		}

		if(!empty($where['order_time'])){
			$order= $where['order_time']==1 ?"desc":"asc";
			$Db=$Db->orderBy('war_out_createtime',$order);
		}
		if(empty($where['order_time']) && empty($where['order_time'])){
			$Db=$Db->orderBy('war_out_id','desc');
		}
		if(empty($where['page_size'])){
			$where['page_size']=10;
		}
		if(empty($where['page'])){
			$where['page']=1;
		}
		$count=$Db->count();
		$page_count=(int)ceil($count/$where['page_size']);
		$limit=($where['page']-1)*$where['page_size'];

		//如果导出excel 则不分页展示
		if($export !== 1){
			$Db=$Db->limit($where['page_size'])->offset($limit);
		}else{
			$Db=$Db->limit($this->max);
		}
		$data=$Db->join('repertory','order.war_out_shipper','=','repertory.rep_id')->select('war_out_id as order_id','war_out_order as rec_order','war_out_count as number','repertory.rep_name as send_user','war_out_receiving as get_user','adm_name as user','war_out_createtime as create_time','war_out_remarks as note','wl_department','wl_courier','wl_type','wl_courier','wl_user','wl_tel','wl_license','war_type')->get();
		// return $data;
		// $data=json_decode(json_encode($data),true);
		foreach ($data as $key => $val) {
			//更改物流信息
			if($val['wl_type']==1 ){
				$data[$key]['wl']=$val['wl_department']."；快递单号:".$val['wl_courier'];
			}elseif($val['wl_type']==3 || $val['wl_type']==2){
				$data[$key]['wl']=$val['wl_department']." 负责人:".$val['wl_user'].";  联系电话:".$val['wl_tel'].";  车牌信息：".$val['wl_license'];
			}else{
				$data[$key]['wl']='';
			}
			//1 订单   2 出库
			$data[$key]['war_type']=$val['war_type'];
			// $data=json_decode(json_encode($data),true);
			unset($data[$key]['wl_type']);
			unset($data[$key]['wl_department']);
			unset($data[$key]['wl_courier']);
			unset($data[$key]['wl_tel']);
			unset($data[$key]['wl_license']);
			unset($data[$key]['wl_user']);

			// 获取订单信息
			if($val['war_type']==1){
				//获取关联表数据 然后获取 客户表数据
				$res_arr=$this->Get_order_information($val['order_id']);
				// return $res_arr;
				$data[$key]['get_user']=$res_arr['oru_user_name'];
				$data[$key]['get_tel']=$res_arr['oru_user_tel'];
				$data[$key]['get_address']=$res_arr['oru_province'].$res_arr['oru_city'].$res_arr['oru_county'].$res_arr['oru_address'];
			}else{
				$data[$key]['get_tel']='';
				$data[$key]['get_address']='';
			}

		}
		if($export===1){
			//导出excel
			return $this->Into_Out_Excel($data,2);
			die;
		}
		$ware=Db::table('repertory')->where(['rep_id'=>$where['ware_id']])->select('rep_id as rep_id','rep_name as ware_name')->first();
		$count_order=$this->ware_order($where['ware_id']);
		// $ware=json_decode(json_encode($ware),true);
		return ['code'=>200,'msg'=>'success','data'=>['page'=>(int)$where['page'],'page_count'=>(int)$page_count,'page_size'=>(int)$where['page_size'],'page_number'=>(int)$count,'ware_order'=>$count_order,'ware_id'=>$where['ware_id'],'ware_name'=>$ware['ware_name'],'list'=>$data]];
	}

	//获取入库单列表
	public function getEnterlist($where,$user,$export=2){
		//没有仓库
		if(!CommenModel::wareCheck($where['ware_id'],$user['adm_cid'])){
			return ['code'=>500,'msg'=>'失败','data'=>'公司没有该仓库'];
		}
		// 操作人  最大数 最小数  数量排序  时间排序
		$Db=DB::table('receipt_order as order')->where(['rec_cid'=>$user['adm_cid'],'rec_state'=>1,'ware_id'=>$where['ware_id'],'del_state'=>1])->join('admin','order.rec_user','=','admin.adm_id');

		if(!empty($where['name'])){
			$Db=$Db->where('adm_name','like',"%".$where['name']."%");
		}
		if(!empty($where['time_end'])){
			$time=date('Y-m-d H:i:s',strtotime($where['time_end']));
			$Db=$Db->where('rec_createtime','<=',$time);
		}
		if(!empty($where['time_start'])){
			$time=date('Y-m-d H:i:s',strtotime($where['time_start']));
			$Db=$Db->where('rec_createtime','>=',$time);
		}
		if(!empty($where['order'])){
			$Db=$Db->where('rec_order','like','%'.$where['order'].'%');
		}

		if(!empty($where['number_max']) || $where['number_max']===0){
			$Db=$Db->where('rec_count','<=',$where['number_max']);
		}
		if(!empty($where['number_min']) || $where['number_max']===0){
			$Db=$Db->where('rec_count','>=',$where['number_min']);
		}

		if(!empty($where['order_number'])){
			$order= $where['order_number']==1 ?"desc":"asc";
			$Db=$Db->orderBy('rec_count',$order);
		}
		if(!empty($where['order_time'])){
			$order= $where['order_time']==1 ?"desc":"asc";
			$Db=$Db->orderBy('rec_createtime',$order);
		}

		if(empty($where['order_number']) && empty($where['order_time'])){
			$Db=$Db->orderBy('rec_id','desc');
		}

		if(empty($where['page_size'])){
			$where['page_size']=10;
		}
		if(empty($where['page'])){
			$where['page']=1;
		}

		$count=$Db->count();
		$page_count=(int)ceil($count/$where['page_size']);
		$limit=($where['page']-1)*$where['page_size'];

		//如果导出excel 则不分页展示
		if($export !== 1){
			$Db=$Db->limit($where['page_size'])->offset($limit);
		}else{
			$Db=$Db->limit($this->max);
		}
		$data=$Db->select('rec_id as order_id','rec_order','rec_count as number','rec_shipper as send_user','rec_receiving as get_user','adm_name as user','rec_createtime as create_time','rec_remarks as note','rec_wl as wl')->get();
		foreach ($data as $key => $val) {
			//返回订单类型
			$data[$key]['war_type']=3;
			//因为订单  添加两个模拟数据
			$data[$key]['get_tel']='';
			$data[$key]['get_address']='';
			# code...
		}
		if($export===1){
			//导出excel
			return $this->Into_Out_Excel($data,3);
			die;
		}
		$ware=Db::table('repertory')->where(['rep_id'=>$where['ware_id']])->select('rep_id as rep_id','rep_name as ware_name')->first();
		$count_order=$this->ware_order($where['ware_id']);
		return ['code'=>200,'msg'=>'success','data'=>['page'=>(int)$where['page'],'page_count'=>(int)$page_count,'page_size'=>(int)$where['page_size'],'page_number'=>(int)$count,'ware_order'=>$count_order,'ware_id'=>$where['ware_id'],'ware_name'=>$ware['ware_name'],'list'=>$data]];
		
	}
	/**
	 * 出库表，入库表  导入excel
	 * @param [type] $data 数据
	 * @param [type] $type 3入库   2出库  1 记录
	 *               $state  给出入库记录准备的;
	 */
	public function Into_Out_Excel($data,$type=1,$state=1){
		$str=[1=>'出入库记录',2=>'出库单',3=>'入库单'];
		
		return Excel::create($str[$type].'数据导出', function($excel) use ($data,$type,$str,$state){
            $excel->sheet($str[$type].'数据导出', function($sheet) use ($data,$type,$str,$state)
            {	
            	$state_type=[1=>"已出库",2=>"已入库",3=>"强制入库",4=>"作废"];
            	$type=[1=>'订单',2=>'出库单',3=>'入库单'];
            	$sheet->setWidth(array('A'=>24,'B'=>12,'C'=>8,'D'=>20,'E'=>8,'F'=>24,'G'=>10,'H'=>10,'I'=>20,'J'=>20))->setFontSize(12);
                $sheet->cell('A1','系统单号');
                $sheet->cell('B1','类型');
                $sheet->cell('C1','数量');
                $sheet->cell('D1','发货方');
                $sheet->cell('E1','收货方');
                $sheet->cell('F1','物流信息');
                $sheet->cell('G1','操作人');
                $sheet->cell('H1','状态');
                $sheet->cell('I1','操作时间');
                $sheet->cell('J1','备注');
                if($state===2){
                	$sheet->cell('K1','归属仓库');
                }
                if (!empty($data)){
                    foreach ($data as $key => $value) {
                        $i= $key+2;
                        $sheet->cell('A'.$i, $value['rec_order']);
                        $sheet->cell('B'.$i,$type[$value['war_type']]);
                        $sheet->cell('C'.$i, $value['number']);
                        $sheet->cell('D'.$i, $value['send_user']);
                        $sheet->cell('E'.$i, $value['get_user'].$value['get_tel'].$value['get_address']);
                        $sheet->cell('F'.$i,empty($value['wl'])?"暂无":$value['wl']);
                        $sheet->cell('G'.$i, $value['user']);
                        if($state===2){
		                	$sheet->cell('H'.$i,$state_type[$value['war_type']]);
		                }else{
		                	$sheet->cell('H'.$i,$type==3?"待入库":"待出库");
		                }

                        $sheet->cell('I'.$i,$value['create_time']);
                        $sheet->cell('J'.$i,empty($value['note'])?"暂无":$value['note']);

                        if($state===2){
		                	$sheet->cell('K'.$i,$value['ware_name']);
		                }
		                unset($data[$key]);
		                unset($value);
                    }
                }
            });
        })->download('xls');

	}

	//获取 出库单未处理，和入库单未处理的 所有总数
	public function ware_order($ware_id){
		$out_count=Db::table('out_order')->where(['war_out_state'=>1,'ware_id'=>$ware_id,'del_state'=>1])->count();
		$into_count=Db::table('receipt_order')->where(['rec_state'=>1,'ware_id'=>$ware_id,'del_state'=>1])->count();
		return ['out_count'=>$out_count,'into_count'=>$into_count];
	}
	//获取 出入库表单记录列表
	public function getLoglist($where,$user,$state=1,$export=2){
		if(!empty($where['ware_id'])){
			$Db=DB::table('sheet_log')->where(['sheet_cid'=>$user['adm_cid'],'ware_id'=>$where['ware_id']]);
		}else{
			$Db=DB::table('sheet_log')->where(['sheet_cid'=>$user['adm_cid']]);
		}

		//出入库记录  多两个判断
		if($state==2){
			$Db=$Db->join('repertory as ware','sheet_log.ware_id','=','ware.rep_id');
			if(!empty($where['type'])){
				$Db=$Db->where('sheet_type',$where['type']);
			}
			if(!empty($where['state'])){
				if((int)$where['state']==1){
					$Db=$Db->where(['sheet_state'=>2]);
				}elseif((int)$where['state']==2){
					$Db=$Db->where(['sheet_state'=>1]);
				}else{
					$Db=$Db->where(['sheet_state'=>$where['state']]);
				}
			}
		}

		if(!empty($where['order'])){
			$Db=$Db->where('sheet_order','like',"%".$where['order']."%");
		}

		// 操作人  最大数 最小数  数量排序  时间排序
		if(!empty($where['name'])){
			$Db=$Db->where('sheet_user','like',"%".$where['name']."%");
		}
		if(!empty($where['time_end'])){
			$time=date('Y-m-d H:i:s',strtotime($where['time_end']));
			$Db=$Db->where('sheet_createtime','<=',$time);
		}
		if(!empty($where['time_start'])){
			$time=date('Y-m-d H:i:s',strtotime($where['time_start']));
			$Db=$Db->where('sheet_createtime','>=',$time);
		}

		if(!empty($where['number_max']) || $where['number_max']===0){
			$Db=$Db->where('sheet_count','<=',$where['number_max']);
		}
		if(!empty($where['number_min']) || $where['number_min']===0){
			$Db=$Db->where('sheet_count','>=',$where['number_min']);
		}

		if(!empty($where['order_number'])){
			$order= $where['order_number']==1 ?"desc":"asc";
			$Db=$Db->orderBy('sheet_count',$order);
		}

		if(!empty($where['order_time'])){
			$order= $where['order_time']==1 ?"desc":"asc";
			$Db=$Db->orderBy('sheet_createtime',$order);
		}
		if(empty($where['order_number']) && empty($where['order_time'])){
			$Db=$Db->orderBy('sheet_id','desc');
		}

		if(empty($where['page_size'])){
			$where['page_size']=10;
		}
		if(empty($where['page'])){
			$where['page']=1;
		}
		$Db=$Db->join('repertory','sheet_log.ware_id','=','repertory.rep_id')->where('repertory.rep_state','=',1);
		$count=$Db->count();
		$page_count=(int)ceil($count/$where['page_size']);
		$limit=($where['page']-1)*$where['page_size'];

		//如果导出excel 则不分页展示
		if($export !== 1){

			$Db=$Db->limit($where['page_size'])->offset($limit);
		}else{
			$Db=$Db->limit($this->max);
		}

		if($state==2){
			$data=$Db->selectRaw('sheet_id,(case sheet_type when 1 then sheet_id else order_id end) as order_id,sheet_order as rec_order,sheet_count as number,trace_ware.rep_name as ware_name,sheet_shipper as send_user,sheet_receiving as get_user,sheet_user as user,sheet_createtime as create_time,sheet_remarks as note,sheet_state as state,sheet_type as war_type,sheet_logistics as wl')->get();
		}else{

			$data=$Db->select('sheet_id as sheet_id','order_id as order_id','sheet_order as rec_order','sheet_count as number','sheet_shipper as send_user','sheet_receiving as get_user','sheet_user as user','sheet_createtime as create_time','sheet_remarks as note','sheet_state as state','sheet_type as war_type','sheet_logistics as wl')->get();
		}

		foreach ($data as $key => $val){

			if($val['state']==1 && $val['war_type']==1){
				//获取关联表数据 然后获取 客户表数据
				$res_arr=$this->Get_order_information($val['order_id']);
				// return $res_arr;
				$data[$key]['get_user']=$res_arr['oru_user_name'];
				$data[$key]['get_tel']=$res_arr['oru_user_tel'];
				$data[$key]['get_address']=$res_arr['oru_province'].$res_arr['oru_city'].$res_arr['oru_county'].$res_arr['oru_address'];
			}else{
				$data[$key]['get_tel']='';
				$data[$key]['get_address']='';
			}
		}
		if($export===1){
			//导出excel
			return $this->Into_Out_Excel($data,1,$state);
			die;
		}

		if($state==2){
			$wareList=Db::table('repertory')->where(['rep_state'=>1])->select('rep_id as ware_id','rep_name as ware_name')->get();
			return ['code'=>200,'msg'=>'success','data'=>['page'=>(int)$where['page'],'page_count'=>(int)$page_count,'page_size'=>(int)$where['page_size'],'page_number'=>(int)$count,'ware_list'=>$wareList,'list'=>$data]];

		}else{
			$ware=Db::table('repertory')->where(['rep_id'=>$where['ware_id']])->select('rep_id as rep_id','rep_name as ware_name')->first();
			return ['code'=>200,'msg'=>'success','data'=>['page'=>(int)$where['page'],'page_count'=>(int)$page_count,'page_size'=>(int)$where['page_size'],'page_number'=>(int)$count,'ware_id'=>$where['ware_id'],'ware_name'=>$ware['ware_name'],'list'=>$data]];
		}	
	}
//////填写出库，入库单  请求
	public function getWare_data($ware_id,$user,$state=1){
		if(!CommenModel::wareCheck($ware_id,$user['adm_cid'])){
			return ['code'=>500,'msg'=>'失败','data'=>'公司没有该仓库'];
		}

		$ware=Db::table('repertory')->where(['rep_id'=>$ware_id])->select('rep_name as ware_name','rep_id as ware_id')->first();
		$goods=Db::table('warehouse as ware')->where(['war_rid'=>$ware_id,'war_cid'=>$user['adm_cid'],'war_goods_state'=>1])->join('goods as goods','ware.war_goodsid','=','goods.goo_id')->select('goo_id as goods_id','goo_name as name','ware.war_stock_count as goods_number')->get();
		foreach ($goods as $key => $value){
			$goods[$key]['count']=0;
			# code...
		}
		if($state==1){
			$order_number="RK".$ware_id.$user['adm_cid'].'0'.$user['admin_id'].date("YmdHis").rand(1000,9999);
		}elseif($state==2){
			$order_number="CK".$ware_id.$user['adm_cid'].'0'.$user['admin_id'].date("YmdHis").rand(1000,9999);
		}
		$users['user_id']=$user['admin_id'];
		$users['user_name']=$user['admin_name'];
		$users['user_tel']=$user['user_tel'];
		if($state==2){
			return ['code'=>200,'msg'=>'success','data'=>['order_number'=>$order_number,'user'=>$users,'ware'=>$ware,'goods'=>$goods]];
		}else{
			return ['code'=>200,'msg'=>'success','data'=>['order_number'=>$order_number,'user'=>$users,'ware'=>$ware,'goods'=>$goods]];
		}
	}

	//出库单，入库， 出入库记录    详情
	public function getlisdetails($user,$state,$order_id){
		// 2入库   3出库
		
		//历史详情
		if($state==1){

			//1订单出库  2 出库单  3，入库单
			$data=Db::table('sheet_log')->where(['sheet_id'=>$order_id,'sheet_cid'=>$user['adm_cid']])->select('sheet_type','order_id')->first();
			if(empty($data)){
				return ['code'=>500,'msg'=>'失败','data'=>'没有该出入库记录'];
			}
			// $order_id=$data['order_id'];
			// $sheet_type=$data['sheet_type'];

			$order_id=$data['order_id'];
			$sheet_type=$data['sheet_type'];
			if($sheet_type==1 || $sheet_type==2){
				//出库
				$state=3;
			}else{
				//入库
				$state=2;
			}
		}

		if($state==2){
			$res=$this->getOrderInto($order_id,$user,2);
		}elseif($state==3){
			$res=$this->getOrderout($order_id,$user,2);
		}
		if($res['code']==200){
			if($state==2){
				return ['code'=>200,'msg'=>'success','data'=>['type'=>1,'order'=>$res['data']]];
			}else{
				return ['code'=>200,'msg'=>'success','data'=>['type'=>2,'order'=>$res['data']]];
			}
		}else{
			return $res;
		}
	}


	//提交出库单  
	public function submitOrder_out($data,$user,$goods,$logistics,$state=1){
		try{
			if($state==1){
				//提交 出库单  
				if(!CommenModel::wareCheck($data['ware_id'],$user['adm_cid'])) throw new Exception("公司没有该仓库");

			}else{
				$ware_id=Db::table('out_order')->where(['war_out_id'=>$data['war_out_id'],'del_state'=>1,'war_out_state'=>1])->pluck('ware_id');

				if(empty($ware_id)) throw new Exception("没有该出库单,或已经出库了");

				if(!CommenModel::wareCheck($ware_id,$user['adm_cid'])) throw new Exception("公司没有该仓库");
				
			}
			//写入出入库记录表
			DB::beginTransaction();
			//将数量为0的商品删除 
			foreach ($goods['goods_number'] as $key => $val) {
				if(empty($val) || $val < 0 ){
					unset($goods['goods_number'][$key]);
					unset($goods['goods_id'][$key]);
				}
			}

			if(empty($goods['goods_number'])) throw new Exception("确认出库单商品数量不能全部为0,谢谢");

			$goods_id_a=array_unique($goods['goods_id']);

			if($state==1){
				//判断收货方信息
				if(empty($data['war_out_receiving'])) throw new Exception('缺少收货方信息');

				$goods_data_b=Db::table('warehouse')->where(['war_cid'=>$user['adm_cid'],'war_rid'=>$data['ware_id'],'war_goods_state'=>1])->whereIn('war_goodsid',$goods_id_a)->select('war_goodsid')->get();

			}else{
				$goods_data_b=Db::table('warehouse')->where(['war_cid'=>$user['adm_cid'],'war_rid'=>$ware_id,'war_goods_state'=>1])->whereIn('war_goodsid',$goods_id_a)->where('war_goods_state','!=',3)->select('war_goodsid')->get();
				// return $goods_data_b;
			}
			$order_out_form=2;
			if(count($goods_id_a) != count($goods_data_b)) throw new Exception("存在不属于这个仓库的商品");
			if($state==2){
				//判断是否是订单，判断是否锁定，更改添加物流表  更改活动日志表  更改添加出入库记录表 
				//更改订单 状态
				$out_order=Db::table('out_order')->where(['war_out_id'=>$data['war_out_id'],'del_state'=>1,'war_out_state'=>1])->first();
				if(empty($out_order)) throw new Exception("订单不存在");

				//判断 是否 是订单 判断是否锁定
				
				if($out_order['war_type']==1){
					//删除收货方
					$data['war_out_receiving']=' ';

					$order_arr=Db::table('order_ware_relation as owr')->where(['del_state'=>1,'order_out_id'=>$data['war_out_id']])->join('order_form','owr.order_id','=','order_form.ord_id')->select('order_form.order_state','order_form.ord_id as order_id')->first();
					if(empty($order_arr)) throw new Exception("是否误删数据了,没有订单相关数据");
					if($order_arr['order_state']>30) throw new Exception("订单被锁定,无法做任何操作");
					if($order_arr['order_state']==11) throw new Exception("订单已被删除,无法做任何操作");
					if($order_arr['order_state']==10) throw new Exception("订单已完成,无法做任何操作");
					if($order_arr['order_state']==1) throw new Exception("请先分单");

					//等于1 是订单出库
					$order_out_form=1;

					//添加订单信息表
					$order_log['admin_user']=$user['admin_id'];
					$order_log['order_id']=$order_arr['order_id'];
					$order_log['details']='出库';
					$time=date('Y-m-d H:i:s');
					$order_log['create_time']=$time;
					$res1=Db::table('order_log')->insert($order_log);
					if(!$res1) throw new Exception("添加订单信息表错误");

					$res_order=Db::table('order_form')->where(['ord_id'=>$order_arr['order_id']])->update(['order_state'=>5]);
					if($res_order !=1 && $res_order !=0 ) throw new Exception("更改订单状态失败");

					//更改订单关联表状态
					$order_ware['owt_time']=$time;
					$order_ware['owt_state']=2;
					$res2=Db::table('order_ware_relation')->where(['order_id'=>$order_arr['order_id'],'del_state'=>1,'order_out_id'=>$data['war_out_id']])->update($order_ware);
					if(!$res2) throw new Exception("修改订单状态失败");
				}

				//判断商品的数量
				$get_receipt2=Db::table('warehouse_goods')->where('warg_type','!=',2)->where(['warg_wid'=>$data['war_out_id']])->select('warg_goodsid as goods_id','wari_real_quantity as goods_number')->get();
				$check_array2=array_column($get_receipt2,'goods_number','goods_id');

				$stop_array2=[];
				foreach ($goods['goods_number'] as $key => $value){
					$stop_array2[$key]['goods_number']=$value;
					$stop_array2[$key]['goods_id']=$goods['goods_id'][$key];
				}
				$arr_data2=array_column($stop_array2,'goods_number','goods_id');
				$count111=array_sum($arr_data2);
				$count222=array_sum($check_array2);
				if($count111 != $count222 || count($get_receipt2) != count($goods['goods_number'])){
					if(!empty($data['war_out_remarks'])){
						if(substr($data['war_out_remarks'],0,strlen($this->warning_out)) != strlen($this->warning_out)){
							$data['war_out_remarks']=$this->warning_out.$data['war_out_remarks'];
						}
					}else{
						throw new Exception("出库失败，非正常出库请必填备注。");
					}
				}else{
					//与之前比较出库数量;
					foreach ($check_array2 as $key => $value){
						if(empty($arr_data2[$key]) || $value != $arr_data2[$key]){
							if(!empty($data['war_out_remarks'])){
								$data['war_out_remarks']=$this->warning_out.$data['war_out_remarks'];
							}else{
								throw new Exception("出库失败，非正常出库请必填备注.");
							}
						}
					}
				}

				$arr_data2=array_column($stop_array2,'goods_number','goods_id');
				$goods_id=array_column($stop_array2,'goods_id');

				$ware_data=Db::table('warehouse')->where(['war_rid'=>$ware_id,'war_goods_state'=>1])->whereIn('war_goodsid',$goods_id)->select('war_goodsid as goods_id','war_stock_count as goods_number')->get();
				if(count($ware_data) != count($goods_id)) throw new Exception("商品信息不正确,多提交了不属于本仓库的商品");
				$goods_check_b=array_column($ware_data,'goods_number','goods_id');

				foreach ($arr_data2 as $key => $value) {

					if($arr_data2[$key] > $goods_check_b[$key]) throw new Exception("无法出库,超出仓库内的库存了");

					$res=Db::table('warehouse')->where(['war_rid'=>$ware_id,'war_goodsid'=>$key,'war_goods_state'=>1])->decrement('war_stock_count',$arr_data2[$key]);

					if(!$res) throw new Exception("更新仓库商品数量失败");

				}

				//判断是出库单还是订单,
				
				//删除 出库商品表数据
				$res2=Db::table('warehouse_goods')->where(['warg_type'=>1,'warg_wid'=>$data['war_out_id']])->delete();
				$res1=Db::table('warehouse_goods')->where(['warg_type'=>3,'warg_wid'=>$data['war_out_id']])->delete();
				if(!$res1 && !$res2) throw new Exception("更新商品表失败");
				//寻找对象
			}
			if($state==1){
				//获取仓库名
				$data['war_out_shipper']=$data['ware_id'];
				//获取查询单号，判断是否重复提交
				$res_order_number_s=Db::table('out_order')->where(['war_out_order'=>$data['war_out_order']])->first();
				if($res_order_number_s) throw new Exception("请不要重复提交,出库单号重复");


			}elseif($state==2){
				$data['war_out_id'];//出库单id 
				$wl_id=Db::table('out_order')->where(['war_out_id'=>$data['war_out_id'],'del_state'=>1])->select('war_out_logistics as wl_id')->first()['wl_id'];
				if(!empty($wl_id)){
					$res2=Db::table('wl')->where(['wl_id'=>$wl_id])->delete();
					if(!$res2) throw new Exception("更新物流表失败");
				}

				//删除物流信息,  

			}
			if(!empty($logistics['wl_type'])){
				if(!empty($logistics['wl_license']) && is_array($logistics['wl_license'])){
					$logistics['wl_license']=implode(',',$logistics['wl_license']);
				}
				if(!empty($logistics['wl_courier']) && is_array($logistics['wl_courier'])){
					$logistics['wl_courier']=implode(',',$logistics['wl_courier']);
				}
				$logistics['wl_state']=1;
				if($state==2){
					if($order_out_form==1){
						$logistics['wl_state']=2;
					 	$logistics['order_id']=$order_arr['order_id'];
					}

				}
				$res=Db::table('wl')->insertGetId($logistics);
				if(!$res) throw new Exception("添加物流表失败");
				$data['war_out_logistics']=$res;
			}

			$data['war_out_count']=$count=array_sum($goods['goods_number']);
			//更新出库单
			if($state==1){
				//出库单 id
				$order_id=Db::table('out_order')->insertGetId($data);
				if(!$order_id) throw new Exception("添加出库单失败");
			}else{
				$order_id=$data['war_out_id'];
				unset($data['war_out_id']);
				$res=Db::table('out_order')->where(['war_out_id'=>$order_id])->update($data);
				if(!$res) throw new Exception("确认出库单失败");

				//更新仓库总数量
				//判断总库存
				$sum_number=Db::table('repertory')->where(['rep_id'=>$ware_id])->select('rep_good_number')->first()['rep_good_number'];
				if($sum_number < $count) throw new Exception("您的商品总数量不足");
				$res2=Db::table('repertory')->where(['rep_id'=>$ware_id])->decrement('rep_good_number',$count);
				if(!$res2) throw new Exception("更新商品总数量失败");
				//更改
				//

				$sheet_log=Db::table('out_order as order')->join('admin','admin.adm_id','=','order.war_out_user')->where(['war_out_id'=>$order_id])->join('repertory','order.war_out_shipper','=','repertory.rep_id')->select('war_out_cid as sheet_cid','ware_id','war_out_order as sheet_order','war_out_count as sheet_count','adm_name as sheet_user','repertory.rep_name as sheet_shipper','war_out_receiving as sheet_receiving','war_out_id as order_id','submit_time as sheet_createtime','war_out_remarks as sheet_remarks')->first();

				if(empty($logistics['wl_type'])){
					unset($logistics['wl_type']);
				}else{

					if($logistics['wl_type']==1){
						$sheet_log['sheet_logistics']="运输方:".$logistics['wl_department']."; 快递单号:".$logistics['wl_courier'];

					}elseif($logistics['wl_type']==3 || $logistics['wl_type']==2){

						$sheet_log['sheet_logistics']="运输方:".$logistics['wl_department']."; 负责人:".$logistics['wl_user'].'; 联系电话:'.$logistics['wl_tel']."; 车牌号:".$logistics['wl_license'];
					}

				}
				if($order_out_form==1){
					//订单
					$sheet_log['sheet_type']=1;
				}else{
					//出库单
					$sheet_log['sheet_type']=2;
				}
				$sheet_log['sheet_state']=1;
				$res3=Db::table('sheet_log')->insert($sheet_log);
				if(!$res3) throw new Exception("写入记录表失败");
			}
			$arr=[];
			// goods_number
			foreach ($goods['goods_id'] as $key => $value){
				if(!empty($goods['goods_number'][$key])){
					$arr[$key]['warg_wid']=$order_id;

					$arr[$key]['warg_state']=$state;

					//判断是出库 还是订单； 1 订单   2 出库单
					if($order_out_form==1){
						$arr[$key]['warg_type']=3;
					}else{
						$arr[$key]['warg_type']=1;
					}
					// if()
					
					$arr[$key]['warg_goodsid']=$value;
					$arr[$key]['wari_real_quantity']=$goods['goods_number'][$key];
				}
				
			}
			$res2=Db::table('warehouse_goods')->insert($arr);
			if(!$res2) throw new Exception("添加商品库存失败");

			if($state==1){
				//填写出库单
				$str='添加出库单';
				$content="填写出库单,出库单号为 ".$data['war_out_order'];
			}else{
				$order_number=Db::table('out_order')->where(['war_out_id'=>$order_id])->select('war_out_order')->first()['war_out_order'];
				//确认出库单
				$str='确认出库单';

				$content="确认出库单并出库,出库单 为:".$order_number;
			}

		// 写入操作日志表里
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="我的云仓->出入库管理";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");
			DB::commit();
			if($state==1){
				return ['code'=>200,'msg'=>'success','data'=>'添加出库单成功'];
			}else{
				return ['code'=>200,'msg'=>'success','data'=>'确认出库成功'];
			}

		}catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}
	
	/**
	 * //提交 入库单 
	 * @param  [type] $data  入库单信息
	 * @param  [type] $user  用户信息
	 * @param  [type] $goods 商品信息
	 * @return [type]       
	 */
	public function submitOrder_add($data,$user,$goods,$state=1){
		//校验仓库是否正常， 和仓库是否正常接单
		try{
			if($state==1){
				if(!CommenModel::wareCheck($data['ware_id'],$user['adm_cid'])) throw new Exception("公司没有该仓库");
				
			}else{
				$ware_id=Db::table('receipt_order')->where(['rec_id'=>$data['rec_id'],'rec_state'=>1,'del_state'=>1])->pluck('ware_id');

				if(empty($ware_id)) throw new Exception("没有该入库单,或已经入库了");

				if(!CommenModel::wareCheck($ware_id,$user['adm_cid'])) throw new Exception("公司没有该仓库");
			}
		
			DB::beginTransaction();
			//将数量为0的商品删除
			foreach ($goods['goods_number'] as $key => $val) {
				if(empty($val) || $val < 0 ){
					unset($goods['goods_number'][$key]);
					unset($goods['goods_id'][$key]);
				}
			}
			if(empty($goods['goods_number'])) throw new Exception("入库单的商品不能都为空");
			///////////校验仓库内是否存在提交的商品
			$goods_id_a=array_unique($goods['goods_id']);

			if($state==1){
				$goods_data_b=Db::table('warehouse')->where(['war_cid'=>$user['adm_cid'],'war_rid'=>$data['ware_id']])->whereIn('war_goodsid',$goods_id_a)->select('war_goodsid')->get();
			}else{
				$goods_data_b=Db::table('warehouse')->where(['war_cid'=>$user['adm_cid'],'war_rid'=>$ware_id])->whereIn('war_goodsid',$goods_id_a)->select('war_goodsid')->get();
			}
			if(count($goods_id_a) != count($goods_data_b)) throw new Exception("添加不存在属于这个仓库的商品");

			// return $data;die;
			//获取收获方   仓库名
			$data['rec_count']=$count=array_sum($goods['goods_number']);
			if($state==1){
				$data['rec_receiving']=Db::table('repertory')->where(['rep_id'=>$data['ware_id']])->select('rep_name')->first()['rep_name'];
				$order_id=Db::table('receipt_order')->insertGetId($data);
				if(!$order_id) throw new Exception("添加入库单失败");
			}else{
				$get_receipt=Db::table('warehouse_goods')->where(['warg_type'=>2,'warg_wid'=>$data['rec_id']])->select('warg_goodsid as goods_id','wari_real_quantity as goods_number')->get();
				$check_array=array_column($get_receipt,'goods_number','goods_id');

				$stop_array=[];
				foreach ($goods['goods_number'] as $key => $value){
					$stop_array[$key]['goods_number']=$value;
					$stop_array[$key]['goods_id']=$goods['goods_id'][$key];
					//ware_id
				}
				$arr_data=array_column($stop_array,'goods_number','goods_id');
				if(array_sum($arr_data) != array_sum($check_array)){
					if(!empty($data['rec_remarks'])){
						if(substr($data['rec_remarks'],0,strlen($this->warning)) !=strlen($this->warning)){
							$data['rec_remarks']=$this->warning.$data['rec_remarks'];
							$data['rec_state']=3;
						}
					}else{
						throw new Exception("入库失败，非正常入库请必填备注。");
					}
				}else{
					//与之前比较入库数量;
					foreach ($check_array as $key => $value){
						if($value != $arr_data[$key]){
							if(!empty($data['rec_remarks'])){
								if(substr($data['rec_remarks'],0,strlen($this->warning)) !=strlen($this->warning)){
									$data['rec_remarks']=$this->warning.$data['rec_remarks'];
									$data['rec_state']=3;
								}
							}else{
								throw new Exception("入库失败，非正常入库请必填备注。");
							}
						}
					}
				}

				//删除 之前的 商品数据;
				$res66=Db::table('warehouse_goods')->where(['warg_type'=>2,'warg_wid'=>$data['rec_id']])->first();
				if(!empty($res66)){
					$res=Db::table('warehouse_goods')->where(['warg_type'=>2,'warg_wid'=>$data['rec_id']])->delete();
					if(!$res) throw new Exception("确认入库单失败");
				}
				$order_id=$data['rec_id'];
				unset($data['rec_id']);
				//更改入库单信息；
				$res=Db::table('receipt_order')->where(['rec_id'=>$order_id])->update($data);
				if(!$res) throw new Exception("确认入库单失败。");
			}
		//入库单 id
		$arr=[];
		// goods_number
		foreach ($goods['goods_id'] as $key => $value) {

				$arr[$key]['warg_wid']=$order_id;
				$arr[$key]['warg_state']=$state;
				$arr[$key]['warg_type']=2;
				$arr[$key]['warg_goodsid']=$value;
				$arr[$key]['wari_real_quantity']=$goods['goods_number'][$key];

		}
		$res2=Db::table('warehouse_goods')->insert($arr);
		if(!$res2) throw new Exception("添加商品库存失败");
			if($state==2){

				foreach ($goods['goods_id'] as $key => $value) {
					$goods_id=$value;
					$goods_number=$goods['goods_number'][$key];
					if($goods_number>0){
						$res=Db::table('warehouse')->where(['war_rid'=>$ware_id,'war_goodsid'=>$goods_id])->increment('war_stock_count',$goods_number);
						if(!$res) throw new Exception("更新仓库商品数量失败");
					}
				}

				//更新仓库的总数量
				$res=Db::table('repertory')->where(['rep_id'=>$ware_id])->increment('rep_good_number',$count);
				if(!$res) throw new Exception("更新仓库总数量失败");
				//写入 出入库记录
				$log=Db::table('receipt_order as order')->where(['rec_id'=>$order_id])->join('admin','admin.adm_id','=','order.rec_user')->select('rec_cid as sheet_cid','ware_id','rec_order as sheet_order','rec_count as sheet_count','adm_name as sheet_user','rec_shipper as sheet_shipper','rec_receiving as sheet_receiving','rec_remarks as sheet_remarks','rec_id as order_id','rec_time as sheet_createtime')->first();

				$log_data=json_decode(json_encode($log),true);
				$log_data['sheet_type']=3;
				// if($state==2){
				$log_data['sheet_state']=$data['rec_state'];
				// }
				// elseif($state==3){
				// 	$log_data['sheet_state']=3;
				// }

				$res=Db::table('sheet_log')->insert($log_data);
				if(!$res) throw new Exception("写入出入库记录失败");
			}

			//写入操作日志
			if($state==1){
				//填写出库单
				$str='添加入库单';
				$rec_order=Db::table('receipt_order')->where(['rec_id'=>$order_id])->first()['rec_order'];
				$content="我的云仓--出入库管理-- 填写入库单 入库单id 为   ".$order_id;
			}else{
				//确认出库单
				$str='确认入库单';
				$rec_order=Db::table('receipt_order')->where(['rec_id'=>$order_id])->first()['rec_order'];
				$content="我的云仓--出入库管理-- 确认入库单 入库单编号为".$rec_order;
			}

		// 写入操作日志表里
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="我的云仓--出入库管理";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");

			DB::commit();
			if($state==1){
				return ['code'=>200,'msg'=>'success','data'=>'添加入库单成功'];
			}else{
				return ['code'=>200,'msg'=>'success','data'=>'确认入库成功'];
			}
		}catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}


	//确认 出库单   请求页面
	public function getOrderout($order_id,$user,$state=1){
		$res=Db::table('out_order as order')->where(['war_out_cid'=>$user['adm_cid'],'war_out_id'=>$order_id,'del_state'=>1])->join('admin as user','user.adm_id','=','order.war_out_user')->join('repertory','order.war_out_shipper','=','repertory.rep_id')->leftjoin('wl','order.war_out_logistics','=','wl.wl_id')->select('war_out_id as order_id','repertory.rep_name as send_ware','war_type as type','war_out_order as order_number','adm_name as user_name','war_out_count as count','adm_mobile as user_tel','war_type as type','wl_type','wl_department','wl_courier','wl_user','wl_tel','wl_license','war_out_remarks as remarks','war_out_receiving as get_ware')->first();
		if(!$res){
			return ['code'=>500,'msg'=>'失败','data'=>'没有该出库.'];
		}

		$wl=null;
		//对物流信息进行更改
		if(!empty($res['wl_type'])){
			$wl['wl_type']=$res['wl_type'];
			$wl['wl_department']=$res['wl_department'];
			if($wl['wl_type']==1){
				$arr=explode(',',$res['wl_courier']);
				$data=[];
				foreach ($arr as $key => $value){
					$data[]['value']=$value;
				}
				$wl['wl_courier']=$data;
				$wl['wl_user']='';
				$wl['wl_tel']='';
				$wl['wl_license']=[];
				$wl['wl_content']="运输方:".$res['wl_department']."; 快递单号:".$res['wl_courier'];
			}elseif($wl['wl_type']==3 || $wl['wl_type']==2){
				$wl['wl_user']=$res['wl_user'];
				$wl['wl_tel']=$res['wl_tel'];
				$arr=explode(',',$res['wl_license']);
				$data=[];
				foreach ($arr as $key => $value){
					$data[]['value']=$value;
				}
				$wl['wl_license']=$data;
				$wl['wl_courier']=[];
				$wl['wl_content']="运输方:".$res['wl_department']."; 负责人:".$res['wl_user'].'; 联系电话:'.$res['wl_tel']."; 车牌号:".$res['wl_license'];
			}
		}else{
			$res['wl_type']=1;
			$wl['wl_department']="";
			$wl['wl_courier']=[];
			$wl['wl_user']='';
			$wl['wl_tel']='';
			$wl['wl_license']=[];
			$wl['wl_content']="";
		}
		//获取商品信息；
		$goods=$this->getGoodsWare($order_id,1,$state);

		//出库单信息 填写
		$ware['order_id']=$res['order_id'];
		$ware['type']=$this->type[$res['type']];
		$ware['order_type']=2;
		$ware['send_ware']=$res['send_ware'];
		$ware['order_number']=$res['order_number'];
		$ware['user_name']=$res['user_name'];
		$ware['user_tel']=$res['user_tel'];
		$ware['count']=$res['count'];
		$ware['remarks']=$res['remarks'];
		$ware['get_ware']=$res['get_ware'];
		$ware['get_tel']='';
		$ware['get_address']='';
		//模拟平台数据
		$jd=['shop_name'=>"",'jd_order'=>""];

		//判断订单
		if($res['type']==1){
			$ware['order_type']=1;
			//获取订单id
			$order_id=Db::table('order_ware_relation as owr')->where(['order_out_id'=>$res['order_id']])->join('order_form','owr.order_id','=','order_form.ord_id')->select('order_form.ord_id as order_id')->pluck('order_id');

			//获取平台信息
			$plat=Db::table('order_form')->where(['ord_id'=>$order_id])->join('platform','order_form.plat_id','=','platform.plat_id')->select('platform.plat_name as shop_name','order_form.plat_number as jd_order')->first();

			if(!empty($plat)){
				$jd=$plat;
			}
			// return $order_id;
			$order_user=Db::table('order_user')->where(['order_id'=>$order_id])->orderBy('oru_id','desc')->first();
			//获取客户信息
			$ware['get_ware']=$order_user['oru_user_name'];
			$ware['get_tel']=$order_user['oru_user_tel'];
			$ware['get_address']=$order_user['oru_province'].$order_user['oru_city'].$order_user['oru_county'].$order_user['oru_address'];
		}

		$data=[
			'type'=>2,
			'jd_order'=>$jd,
			'ware'=>$ware,      //订单的信息
			'goods'=>$goods,   //  商品信息
			'wl'=>$wl          //物流信息
		];
		unset($res);

		return ['code'=>200,'msg'=>'success','data'=>$data];
	}

	//确认  入库单请求页面     1 正常的确认页面   2 详情页面
	public function getOrderInto($order_id,$user,$state=1){
		$res=Db::table('receipt_order as order')->where(['rec_cid'=>$user['adm_cid'],'rec_id'=>$order_id])->join('admin as user','user.adm_id','=','order.rec_user')->select('rec_id as order_id','rec_shipper as send_ware','rec_receiving as get_ware','rec_order as order_number','adm_name as user_name','rec_count as count','adm_mobile as user_tel','rec_remarks as remarks')->first();

		if(!$res){
			return ['code'=>500,'msg'=>'失败','data'=>'您没有该入库单。'];
		}
		// $res=json_decode(json_encode($res),true);
		foreach ($res as $key => $val) {
			$res['war_type']=3;
			# code...
		}

		// return $res;
		//获取商品信息；
		$goods=$this->getGoodsWare($order_id,2,$state);
		//入库单信息 填写
		
		$ware['order_id']=$res['order_id'];
		$ware['type']='入库单';
		$ware['order_type']=3;
		$ware['send_ware']=$res['send_ware'];
		$ware['get_ware']=$res['get_ware'];
		$ware['order_number']=$res['order_number'];
		$ware['user_name']=$res['user_name'];
		$ware['user_tel']=$res['user_tel'];
		$ware['count']=$res['count'];
		$ware['remarks']=$res['remarks'];
		$wl['wl_type']=1;
			$wl['wl_department']="";
			$wl['wl_courier']=[];
			$wl['wl_user']='';
			$wl['wl_tel']='';
			$wl['wl_license']=[];
			$wl['wl_content']="";
		$data=[
			'type'=>1,
			'jd_order'=>['shop_name'=>"",'jd_order'=>""],
			'ware'=>$ware,      //入库单的信息
			'goods'=>$goods,   //  商品信息
			'wl'=>$wl
		];
		return ['code'=>200,'msg'=>'success','data'=>$data];
	}
	/**
	 * 获取出库，订单，入库，记录，表单的  商品信息        
	 * @param  [type]  $order_id    订单id
	 * @param  [type]  $order_state  1 获取出库单信息   2 获取入库单信息
	 * @param  integer $type       1 确认页面     2 详情页面;
	 * @return [type]               [description]
	 */
	public function getGoodsWare($order_id,$order_state,$type=1){
		if($order_state==1){
			//判断是否是订单;  如果是订单 那么只展示订单商品数据;
			$order_data=Db::table('out_order')->where(['war_out_id'=>$order_id])->select('ware_id','war_type')->first();
			// return $order_data;
			if($order_data['war_type']==1){
				//订单
				$goods_type=3;
			}else{
				//出库
				$goods_type=1;
			}
			$ware_id=$order_data['ware_id'];
		}else{
			//入库单
			$ware_id=Db::table('receipt_order')->where(['rec_id'=>$order_id])->pluck('ware_id');
			$goods_type=2;
		}

		$order_goods=Db::table('warehouse_goods')->where(['warg_wid'=>$order_id,'warg_type'=>$goods_type])->select('warg_goodsid as goods_id','wari_real_quantity as number')->get();

		$order_goods=json_decode(json_encode($order_goods),true);
		$order=array_column($order_goods,'number','goods_id');

		//获取订单中的商品id
		$order_goods_id=array_column($order_goods,'goods_id');

		if($goods_type==3 || $type==2){  //type ==2  只获取自己的信息;
			//订单只需要查询 自己的商品即可
			$merge_id=$order_goods_id;
		}elseif($goods_type==2 || $goods_type==1){
			//出库单，入库单需要 查询所有的商品
			
			//获取仓库中的商品id
			$ware_goods=Db::table('warehouse')->where(['war_goods_state'=>1,'war_rid'=>$ware_id])->select('war_goodsid as goods_id')->get();
			$ware_goods_id=array_column($ware_goods,'goods_id');
			// 合并
			$merge_id=array_unique(array_merge($ware_goods_id,$order_goods_id));

		}

		// return $merge_id;
		$data=Db::table('warehouse')->where(['war_rid'=>$ware_id])->whereIn('goo_id',$merge_id)->join('goods','goods.goo_id','=','warehouse.war_goodsid')->where('war_goods_state','!=',3)->select('goods.goo_id as goods_id','goods.goo_name as goods_name','war_stock_count as goods_number')->get();
		$data=json_decode(json_encode($data),true);

		foreach ($data as $key => $value){
			$data[$key]['count']=empty($order[$value['goods_id']])?0:$order[$value['goods_id']];
			$data[$key]['number']=empty($order[$value['goods_id']])?0:$order[$value['goods_id']];
		}
		$last_names = array_column($data,'count');
		array_multisort($last_names,SORT_DESC,$data);
		return $data;
	}

		/**
	 * //获取 订单信息   //获取用户的地址
	 * @param [type] $order_id 出库单id
 array:8 [
  "oru_id" => 11
  "oru_user_name" => "孔圣寅3"
  "oru_user_tel" => "13232353232"
  "oru_province" => "黑龙江"
  "oru_city" => "铁岭"
  "oru_county" => "大兴县"
  "oru_address" => "莫某某4474号"
  "order_id" => 19
]
	 */
	public function Get_order_information($order_id){
		$order_arr=Db::table('order_ware_relation')->where(['del_state'=>1,'order_out_id'=>$order_id])->select('order_id')->first();
		//一般都是有数据的， 因为 分单的时候就会写入关联表，否则就分单失败
		if(!empty($order_arr)){
			$address=Db::table('order_user')->where(['order_id'=>$order_arr['order_id']])->orderBy('oru_id','desc')->first();
			return $address;
		}else{
			$arr=["oru_user_name" => "","oru_user_tel" => "","oru_province" => "","oru_city" => "","oru_county" => "","oru_address" => ""];
			return $arr;
		}
	}
}