<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class Coperationa extends Model
{

	/**
	 * 添加日志
	 * @param [type] $userid  用户id
	 * @param [type] $ip      操作ip
	 * @param [type] $model   操作模块
	 * @param [type] $type    操作类型
	 * @param [type] $content 操作内容
	 */
	public static  function add($userid,$ip,$model,$type,$content)
	{
		$find_adm = DB::table('admin')
			->where('adm_id',$userid)
			->select('adm_cid','adm_chan_id','adm_name','adm_type')
			->first();
		$time = date('Y-m-d H:i:s');
		$data = [
			$find_adm['adm_cid'], 
			$userid, 
			$find_adm['adm_name'], 
			$ip, 
			$model, 
			$type, 
			$content, 
			$time,
			$find_adm['adm_type'],
			$find_adm['adm_chan_id']
		];
		$bool = DB::insert('insert into trace_coperationa (`cop_cid`, `cop_adminid`, `cop_admin`, `cop_ip`, `cop_mode`, `cop_type`, `cop_content`, `cop_createtime`,`cop_types`,`cop_channelid`) values(?,?,?,?,?,?,?,?,?,?)',$data);
		return $bool;
	}

	/**
	 * [addTechnician 技师添加操作日志]
	 * @param [type] $userid  [用户id]
	 * @param [type] $ip      [操作ip]
	 * @param [type] $model   [操作模块]
	 * @param [type] $type    [操作类型]
	 * @param [type] $content [操作内容]
	 */
	public static  function addTechnician($userid,$ip,$model,$type,$content)
	{
		$find_data = DB::table('technician')
			->where('tech_id',$userid)
			->select('tech_cid','tech_chan_id','tech_name')
			->first();

		$data['cop_cid'] = $find_data['tech_cid'];
		$data['cop_types'] = 4;//1总管理3注册4技师账号
		$data['cop_adminid'] = $userid;
		$data['cop_admin'] = $find_data['tech_name'];
		$data['cop_ip'] = $ip;
		$data['cop_mode'] = $model;
		$data['cop_type'] = $type;
		$data['cop_content'] = $content;
		$bool = DB::table('coperationa')->insert($data);
		return $bool;
	}

	// 获取用户信息
	public static function getUserInfo($api_token)
	{
		$ahead_token = Crypt::decrypt($api_token);
		$find_adm = DB::table('login_temporary as lt')
            ->leftJoin('admin', 'lt.adm_id', '=', 'admin.adm_id')
           	->where('lt.api_token','=',$ahead_token)
			->select('admin.adm_id','admin.adm_cid','admin.adm_chan_id','admin.adm_chan_type','admin.adm_name','admin.adm_leave','admin.adm_acc','admin.adm_mobile','admin.adm_pre','admin.adm_stase','admin.adm_type','admin.adm_module', 'admin.adm_chan_id')
			->orderBy('tem_id','desc')
           	->first();
		return $find_adm;
	}

}
