<?php
namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Exception;
class CommenModel extends Model
{
    //获取地名
    public function Placename($id=110000){
    	return Db::table('china')->where(['id'=>$id])->select('name')->first()['name'];
    }

    /**
     * [uploadBase64Img 上传base64图片]
     * @param  [type] $stream [base64数据]
     * @param  [type] $url    路径 存放哪一个文件夹下
     * @param  string $folder [文件夹]
     * @return [type]         [上传成功返回图片路径，失败返回false]
     */
    static function uploadBase64Img($stream,$url='image',$public_s='storage')
    {

        if(strlen($stream)<200){
            if($public_s !='storage' && strpos($stream,$public_s)){
                return strstr($stream,$public_s);
            }
            //如果 里面出现 storage代表是链接 则，返回连接路径；
            if(!empty(strpos($stream,'storage')) || strpos($stream,'storage') == 0){
                return strstr($stream,'storage');
            }
        }

        if(stristr($stream,'data:image')){
            $stream  = $stream;
        }else{
            $stream="data:image/png;base64,".$stream;
        }

        //获取扩展名和文件名
        if (preg_match('/(?<=\/)[^\/]+(?=\;)/', $stream, $pregR)) $streamFileType = '.' . $pregR[0];

        $streamFileRand = time() . rand(11,99);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        // $pathName = "/public/image/" ;
        if($public_s=='storage'){
            $pathName = storage_path()."/".$url."/";//获取上传图片路径
        }else{
            $pathName = public_path()."/".$url."/";//获取上传图片路径
        }
        
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName,0775,true);
            chmod($pathName,0775);
        }
        $streamFilename = $pathName . $streamFileRand . $streamFileType;//上传到服务器图片路径

        //处理base64文本，用正则把第一个base64,之前的部分砍掉
        preg_match('/(?<=base64,)[\S|\s]+/', $stream, $streamForW);
        if (file_put_contents($streamFilename, base64_decode($streamForW[0])) === false) {
            throw new Exception("上传文件失败");
        } else {
            // 返回路径
            $filePath = $public_s."/".$url."/". $streamFileRand . $streamFileType;
            return $filePath;
        }
    }
    
    /**
     *  //校验该公司有没有 这个仓库
     * @param  [type] $ware_id 仓库id
     * @param  [type] $c_id    公司id
     * @return [type]          false没有  true 有
     */
    static function wareCheck($ware_id,$c_id){
    	$data=Db::table('repertory')->where('rep_state','!=',3)->where(['rep_cid'=>$c_id,'rep_id'=>$ware_id])->select('rep_name')->get();
    	if($data){
    		return true;
    	}else{
    		return false;
    	}
    }
    //获取用户信息
    static function getUserToken($token=null){
        if(empty($token)){
            return false;
        }else{
            $adm_id=Db::table('login_temporary')->where(['api_token'=>$token])->select('adm_id')->first()['adm_id'];
            if(!empty($adm_id)){
                $token=Db::table('admin')
                    ->where(['adm_id'=>$adm_id])
                    ->first(['adm_name as admin_name','adm_id as admin_id','adm_cid','adm_mobile as user_tel','adm_acc as admin_acc','adm_type','adm_chan_id','adm_chan_type','adm_leave','adm_pre','adm_stase','adm_module']);
                $token=json_decode(json_encode($token),true);
                return $token;
            }else{
                return false;
            }
        }
    }
    //循环校验数据   参数必须是一维数组；
    static function check_preg($data,$check_preg){
        if(is_array($data)){
            foreach ($data as $key => $val) {
                if(!preg_match($check_preg,$val)){
                     return false;
                }
            }
            return true;
        }else{
            if(!preg_match($check_preg,$data)){
                    return false;
            }else{
                return true;
            }
        }
        

    }

    //校验输入的时间字符串是否合格
    static function checkInput_time($data){
        if(is_array($data)){
            foreach ($data as $key => $value) {
                $str=date("Y-m-d H:i:s",strtotime($value));
                if($str==$value){
                    return true;
                }else{
                    return false;
                }
            }
        }else{
            $str=date("Y-m-d H:i:s",strtotime($data));
            if($str==$data){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 缓存存储数据库
     * @param [type]  $token   数据
     * @param [type]  $type  1获取，  2，创建  3.更改或添加某个商品id  4.删除所有;   5.删除某个   
     * @param integer $type  [description]         
     */                                  //商品可以移除id //商品id //存在商品数量不为0的商品id
    static function setChache($token,$type=1,$arr='',$goods_id=1,$goods=[]){
        $goods_data=Db::table('temporary_goods_id')->where(['token'=>$token])->select('goods_id','temporary_goods_id as tem_goods_id')->first();
        $res=$goods_data['goods_id'];
        if($type==1){
            //获取
            if(empty($res)){
                return null;
            }else{
                return json_decode($res,true);
            }
        }elseif($type==2){
            if(!empty($res)){
                Db::table('temporary_goods_id')->where(['token'=>$token])->delete();
            }
            $data['token']=$token;
            $data['goods_id']=json_encode($arr,JSON_UNESCAPED_UNICODE);
            $data['temporary_goods_id']=json_encode($goods,JSON_UNESCAPED_UNICODE);
            $res=Db::table('temporary_goods_id')->insert($data);
            return $res;
        }elseif($type==3){
            if(empty($res)){
                return null;
            }
            $res2=json_decode($res,true);
            if(!in_array($goods_id,$res2)){
                $res2[]=$goods_id;
                $data=$res2;
                return Db::table('temporary_goods_id')->where(['token'=>$token])->update(['goods_id'=>json_encode($data,JSON_UNESCAPED_UNICODE)]);
            }
        }elseif($type==4){
            if(!empty($res)){
                return Db::table('temporary_goods_id')->where(['token'=>$token])->delete();
            }else{
                return false;
            }
        }elseif($type==5){
            if(!empty($res)){
                $tem=json_decode($goods_data['tem_goods_id'],true);
                if(!in_array($goods_id,$tem)){
                    $data=array_values(array_diff(json_decode($res,true),[0=>$goods_id]));
                    return Db::table('temporary_goods_id')->where(['token'=>$token])->update(['goods_id'=>json_encode($data,JSON_UNESCAPED_UNICODE)]);
                }else{
                    return false;
                }
            }else{
                return false;
            }
        }
    }


//校验数据；  
//1.只校验是否是 整数或数字字符串，然后返回 true 或者false;
//2.去除数组，或字符串中的空格;
    static function checkData_dc($data,$state=1){
        if($state==1){
            if(is_array($data)){
                foreach ($data as $key => $val) {
                    if(is_array($val)){
                        foreach ($val as $k => $v){
                            if(!is_numeric($v) || $v<0){
                                return false;
                            }
                        }
                    }else{
                        if(!is_numeric($val) || $val<0){
                            return false;
                        }
                    }
                }
                return true;
            }else{
                if(!is_numeric($data) || $data<0){
                    return false;
                }else{
                    return true;
                }
            }
        }elseif($state==2){
            if(is_array($data)){

                foreach ($data as $key => $val){

                    if(is_array($val)){
                        foreach ($val as $k => $v){
                            if(is_array($v)){
                                foreach ($v as $k_s => $v_s) {
                                    $data[$key][$val][$k_s]=strip_tags(preg_replace('# #','',$v_s));
                                }
                            }else{
                                $data[$key][$k]=strip_tags(preg_replace('# #','',$v));
                            }
                            
                        }
                    }else{
                        $data[$key]=strip_tags(preg_replace('# #','',$val));
                    }
                }
            }else{
                $data=strip_tags(preg_replace('# #','',$data));
            }
            return $data;
        }
    }
}