<?php
namespace App\Http\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Schema;
use \Exception;
use Excel;
use App\Http\Models\Coperationa;
class CodeManageModel extends Model
{
	/**
	 * 下载
	 * @param [type] $gro_id id
	 * @param [type] $user   用户
	 * @param [type] $type   1 申请下载   2 下载
	 */
	public function Down_Code($gro_id,$user,$type){
		try{
			Db::beginTransaction();
			//判断是否有这个发码数据
			$group=Db::table('group')->where(['gro_id'=>$gro_id,'gro_cid'=>$user['adm_cid']])->select('gro_number','gro_codeid','gro_id','gro_derid','gro_num','gro_pnumber')->first();
			if(empty($group)){
				throw new Exception("没有找到这个发码批次");
			}

			if($group['gro_derid']==1){

				if($type==1){
					throw new Exception("已申请下载");
				}else{
					throw new Exception("定时任务正在进行,请稍后下载");
				}
			}
			if($type==1){
				if($group['gro_derid']>0 && $group['gro_derid']!=2){
					throw new Exception("已申请下载");
				}
				
				if($group['gro_derid']==2){
					$res2=Db::table('group')->where('gro_id',$gro_id)->update(['gro_derid'=>1,'gro_update_time'=>date('Y-m-d H:i:s')]);
					if(!$res2){
						throw new Exception("更改发码表状态失败");
					}
					$res3=Db::table('derivation')->where(['der_content'=>$group['gro_number']])->update(['der_sta'=>1]);

					if(!$res3){
						throw new Exception("更改发码表状态失败");
					}
				}else{
					// 获取分组信息
					$find_group = DB::table('group')
						->where('gro_number', $group['gro_number'])
						->select('gro_id','gro_gid','gro_codeid','gro_pnumber')
						->first();
					if (!empty($find_group['gro_gid'])) {
						// 获取分组商品信息
						$find_goods = DB::table('goods')
								->where('del_type', 1)
								->where('goo_id', $find_group['gro_gid'])
								->select('goo_name','goo_number')
								->first();
					}else{
						$find_goods['goo_name'] = '';
						$find_goods['goo_number'] = '';
					}
					$der = DB::table('derivation')
							->where('der_sta',1)
							->selectRaw('der_id,der_table,der_gname,der_gnumber,der_content,der_cid,der_aid')
							->first();

					// select der_id,der_table,der_gname,der_gnumber,der_content,der_cid,der_aid from trace_derivation where der_sta=1
					//写入导出记录表
					$der_data=[
						'der_type' => 2,
						'der_gid'  =>$find_group['gro_gid'],
						'der_gname' => $find_goods['goo_name'],
						'der_gnumber' => $find_goods['goo_number'],
						'der_numbers'=>$group['gro_num'],
						'der_content'=>$group['gro_number'],
						'der_number'=>$group['gro_pnumber'],
						// 'der_url'=>'storage/crontab/'.$group['gro_number'].".xls",
						'der_url'=>'storage/crontab/'.$der['der_gname'].$der['der_content'].".xls",
						'der_cid'=>$user['adm_cid'],
						'der_table'=>$group['gro_codeid'],
						'der_aid'=>$user['admin_id'],
						'der_time'=>date('Y-m-d H:i:s')
					];

					$res=Db::table('derivation')->insert($der_data);
					if(!$res){
						throw new Exception("添加定时任务表失败");
					}
					$res2=Db::table('group')->where('gro_id',$gro_id)->update(['gro_derid'=>1,'gro_update_time'=>date('Y-m-d H:i:s')]);
					if(!$res2){
						throw new Exception("更改发码表状态失败");
					}
				}
				// 写入操作日志表里
				$content='申请下载发码批次。发码批次为'.$group['gro_number'];
				$ip=$_SERVER['REMOTE_ADDR'];
				$mk="发码管理->申请下载";//模块
				$res=Coperationa::add($user['admin_id'],$ip,$mk,'申请下载',$content);
				if(!$res) throw new Exception("写入操作日志表失败");
				Db::commit();
	    		return ['code'=>200,'msg'=>'success','data'=>'申请成功'];
			}else{
				$sql="UPDATE trace_group set gro_derid=4,down_num=down_num+1 where gro_id=".$gro_id;
				$res2=Db::update($sql);
				if(!$res2){
					throw new Exception("添加下载次数失败");
				}
				//获取文件路径
				$data=Db::table('derivation')->where(['der_content'=>$group['gro_number']])->select('der_url')->orderBy('der_id','desc')->first();
				if(empty($data)){
					throw new Exception("获取下载路径失败");
				}
				// 写入操作日志表里
				$content='下载发码批次。发码批次为'.$group['gro_number'];
				$ip=$_SERVER['REMOTE_ADDR'];
				$mk="发码管理->下载";//模块
				$res=Coperationa::add($user['admin_id'],$ip,$mk,'下载',$content);
				if(!$res) throw new Exception("写入操作日志表失败");
				Db::commit();
				return ['code'=>200,'msg'=>'success','data'=>$data['der_url']];
			}
		}catch(Exception $e){
			Db::rollback();
    		return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
		}
	}



}