<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Crypt;
use DB;

class PdaLogin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $api_token = $request['api_token'];
        if(!$api_token) {
            return response()->json(['code'=> 300, 'msg'=>'error', 'data'=>'']);
        }
        $api_token = Crypt::decrypt($api_token);
        $api_token = explode(',', $api_token);
        $admin_id =$api_token[0];
        $token = $api_token[1];
        $find_adm = DB::table('admin')->where('adm_id', $admin_id)->select('adm_id','adm_cid','adm_chan_id','adm_name','adm_mobile','adm_pas','adm_mobile')->first();

        if($token != sha1($find_adm['adm_mobile'].$find_adm['adm_pas'].date('Ymd'))) {
            return response()->json(['code'=> 300, 'msg'=>'error', 'data'=>'']);
        }
        $request['_admin_id'] = $admin_id;
        $request['_company_id'] = $find_adm['adm_cid'];
        $request['_channel_id'] = $find_adm['adm_chan_id'];
        $request['_admin_name'] = $find_adm['adm_name'];
        return $next($request);
    }
}
