<?php

namespace App\Http\Middleware;

use Closure;
use DB;
use Session;
use Illuminate\Support\Facades\Crypt;
class IsLogin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if(!$request->exists('api_token'))
        {
            return response()->json(["code"=>300,'msg'=>'error','data'=>'请输入api_token']);
        }
        // 如果解密错误
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        }
        // 拿到token获取登录表信息
        $login_temporary = DB::table('login_temporary')
            ->where('api_token','=',$api_token)
            ->select('last_login','api_token')
            ->first();
        if(empty($login_temporary))
        {
            return response()->json(["code"=>300,'msg'=>'error','data'=>'api_token获取失败']);
        }

        $get_time = file_get_contents("http://suyuan.bluearp.com/tongnan.php");
        $get_time = strtotime($get_time);
        if ($get_time < time()) {
            return response()->json(["code"=>500,'msg'=>'系统已到期，请联系管理员','data'=>'系统已到期，请联系管理员']);
        }
        if(!empty($login_temporary))
        {
            // 如果token与数据库token不一致
            if($api_token !== $login_temporary['api_token'])
            {
                return response()->json(["code"=>300,'msg'=>'error','data'=>'api_token错误']);
            }
            // 如果token与数据库token一致
            if($api_token == $login_temporary['api_token'])
            {
                // 当前时间
                $hours = time();
                if(!empty($login_temporary['last_login']))
                {
                    // 如果最后登录时间加半小时小于当前时间,说明登陆过期
                    if($login_temporary['last_login'] < $hours){
                        $url = 'https://iamgateway.tn2jjd.com/humi-cloud-user-center/user';
                        $headers['Authorization'] = session()->get('token');
                        $method = 'POST';
                        $data = [];
                        $res = curlRequest($url, $data, $headers, $timeout = 10, $method);
                        $res = json_decode($res,true);
                        if ($res['code'] == 200) {
                            $add_data = $res['data'];
                            if (!$add_data['accountNonExpired']) {
                                return response()->json(["code"=>300,'msg'=>'登录过期','data'=>'登录过期']);
                            } else {
                                DB::table('login_temporary')->where('api_token','=',$api_token)->update(['last_login'=>$hours + 24*60*60]);
                                return $next($request);
                            }
                        }
                    }
                }
                // 如果一直在操作就当前时间加半小时后时间
                DB::table('login_temporary')->where('api_token','=',$api_token)->update(['last_login'=>$hours + 24*60*60]);
                return $next($request);
            }
        }
    }
}
