<?php

namespace App\Http\Controllers\Zero;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Session;
use DB;
use App\Http\Models\Coperationa;
use App\Http\Models\RelationCodeModel;
use AuthenticatesUsers;
use App\Http\Controllers\Verify\VerifyCodeController;
use App\Http\Controllers\Verify\Zero\VerifyRelationcodeController;

//关联码
class RelationCodeController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    public function __construct() {
        DB::connection()->enableQueryLog(); // 开启查询日志

    }
    //发码
    public function create(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRelationcodeController;
        $error_message = $verify_data->creatValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $company_id = $find_adm['adm_cid'];
        $channel_id = $find_adm['adm_chan_id'];
        if(!$company_id) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'公司信息不完整']);
        }
        //该箱码最大装载量
        $max_num = intval($request->input('max_num'));
        $max_num = max(1, $max_num);

        /*//获取最大的关联码
        $max_code = RelationCodeModel::getMaxCode($company_id);
        if(is_array($max_code) AND $max_code['code']) {
            $code_serial = substr($max_code['code'],10,-3);
            $code_serial = sprintf('%06d',$code_serial+1);
        }else {
            $code_serial = sprintf('%06d',1);
        }

        //关联码生成规则：G+企业ID(5位)+年月(4位)+顺序码(6位)+验证码(3位)
        $relation_code = 'G';
        $relation_code .= sprintf('%05d',$company_id).date('ym').$code_serial;
        //生成校验位
        $verify_code = VerifyCodeController::generateVerify($relation_code, 3);
        if(!$verify_code) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
        }else {
            $relation_code .= $verify_code;
        }*/
        // 查找综合码表信息
        $find_goods_code = DB::table('goods_code')
            ->where('gco_cid',$company_id)
            ->first(['gco_id','gco_back']);
        if($find_goods_code){
            $isadd = "1";
            $code = $find_goods_code['gco_back'];
        }else{
            $isadd = "0";
            $code = "0";
        }
        //拆分为一万一组
        if($request['codes_num'] > 10000){
            $nums = $request['codes_num'] / 10000;
            $n = '1';
            while($n < $nums){
                $array[] = 10000;
                $n = n + 1;
            }
            $num = $request['codes_num'] -10000 * count($array);
            if($num > '0'){
                $array[] = $num;
            }
        }else{
            $array[] = $request['codes_num'];
        }
        // 批次号
        $batch_number = time() . str_pad($find_adm['adm_cid'], 6, '0', STR_PAD_LEFT) . str_pad(rand(0, 999), 3, '0', STR_PAD_LEFT);
        $time = date('Y-m-d H:i:s');
        DB::beginTransaction(); //开启事务
        $grores = DB::table('batch')->insert([
            'bat_cid'   =>  $find_adm['adm_cid'],
            'bat_aid'   =>  $find_adm['adm_id'],
            'bat_chanid'   =>  $channel_id,
            'bat_number'    =>  $batch_number,
            'bat_nums'  =>$request['codes_num'],
            'bat_time'  =>  $time,
            'remark'    => $request['remark'] ? $request['remark'] : '',
            'bat_release'   =>  1
        ]);
        if($grores){
            foreach($array as $key => $value) {
                $sql = "INSERT INTO trace_relation_code (code,max_num,company_id,channel_id,add_time,state,up_code,chain_code,batch_number,codes_num) VALUES ";
                $j = "0";
                while($j < $value){
                    $find_goods_code['gco_back'] = $find_goods_code['gco_back'] + 1;
                    //获取最大的关联码
                    $max_code = RelationCodeModel::getMaxCode($company_id);
                    if(is_array($max_code) AND $max_code['code']) {
                        $code_serial = sprintf('%06d',$find_goods_code['gco_back']);
                    }else {
                        $code_serial = sprintf('%06d',$find_goods_code['gco_back']);
                    }
                    //关联码生成规则：G+企业ID(5位)+年月(4位)+顺序码(6位)+验证码(3位)
                    $relation_code = 'G';
                    $relation_code .= sprintf('%05d',$company_id).date('ym').$code_serial;
                    //生成校验位
                    $verify_code = VerifyCodeController::generateVerify($relation_code, 3);
                    if(!$verify_code) {
                        return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
                    }else {
                        $relation_code .= $verify_code;
                    }
                    $j = $j + '1';
                    $code = $code + 1;
                    $sql = $sql . "('".$relation_code."','".$max_num."','".$company_id."','".$channel_id."','".$time."',1,0,'','".$batch_number."','".$request['codes_num']."'),";
                }
                $sql = trim($sql,",") . ";";
                $grores = DB::insert($sql);
                unset($sql);
            }
            if ($isadd == "1") {
                $all_code_res = DB::update('UPDATE `trace_goods_code` SET `gco_back`=? WHERE (`gco_id`=?) ',[$code,$find_goods_code['gco_id']]);
            } else {
                $all_code_res = DB::insert('INSERT INTO `trace_goods_code` (`gco_cid`, `gco_back`, `gco_year`,`gco_month`, `gco_user`) values(?,?,?,?)',[$company_id,$request['codes_num'],date('Y'),date('m'),$find_adm['adm_id']]);
            }
            if($grores && $all_code_res){
                DB::commit();
                $url = config('app.url').'/sy.php?code='.$relation_code.'&';
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $relation_code]);
            }else{
                DB::rollBack();
                return response()->json(['code'=> 500,'msg'=>'error','data'=>'写入数据库失败']);
            }
        }else{
            DB::rollBack();
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'发码失败']);
        }
    }

    //关联码列表
    public function index(Request $request){
        // 验证数据
        $verify_data = new VerifyRelationcodeController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        if(!$request->exists('bat_time_range0') || !$request->exists('bat_time_range1')){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $data = $request->all();
        $list = DB::table('batch as a')
            ->where('bat_cid',$find_adm['adm_cid'])
            ->where('bat_chanid',$find_adm['adm_chan_id'])
            ->where(function($query) use($data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($data['bat_time_range0'] && $data['bat_time_range1'])){
                    $query->whereBetween('bat_time',[$data['bat_time_range0'],$data['bat_time_range1']]);
                }else{
                    // 如果选择开始时间
                    if (!empty($data['bat_time_range0'])){
                        $query->where('bat_time','>=',$data['bat_time_range0']);
                    }else{
                        // 如果选择结束时间
                        if (!empty($data['bat_time_range1'])) {
                            $query->where('bat_time','<=',$data['bat_time_range1']);
                        }
                    }
                }
            })
            ->where(function($query) use($data) {
                if (!empty($data['remark'] )) {
                    $query->where('remark', 'like' , '%'.$data['remark'].'%' );
                }
            })
            ->select('bat_number','remark','bat_nums','down_num','bat_release','bat_time','bat_stase')
            ->paginate($this->show_count);
        $listData['code'] = 200;
        $listData['current_page'] = $list->currentPage();
        $listData['total'] = $list->total();
        $listData['last_page'] = $list->lastPage();
        $listData['current_number'] = $this->show_count;
        $listData['data'] = $list->items();
        $listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        if($listData['data']){
            foreach ($listData['data'] as $k => $v) {
                $listData['data'][$k]['max_num'] = DB::table('relation_code')->where('batch_number',$v['bat_number'])->value('max_num');
            }
        }
        return response()->json($listData);
    }

    // 编辑
    public function edit(Request $request)
    {
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 验证数据
        $verify_data = new VerifyRelationcodeController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        $num = DB::table('batch')->where('id',$request['id'])->value('bat_number');
        $res = DB::table('batch')->where('id',$request['id'])->update(['remark'=>$request['remark']]);
        if ($res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'关联码列表','编辑','编辑渠道商：'.$num.'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑失败']);
        }
    }

    // 开启查询
    public function open(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRelationcodeController;
        $error_message = $verify_data->openValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        $find = DB::table('batch')->whereIn('id', $request['id'])->get(['bat_number']);
        foreach($find as $key=>$value){
            $num[] = $value['bat_number'];
        }
        $res = DB::table('batch')
            ->whereIn('id',$request['id'])
            ->update(['bat_release' => 1]);
        if($res){
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'关联码列表','开启','开启('.implode(',', $num).')关联码成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'开启成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'当前码号已开启']);
        }
    }

    // 关闭查询
    public function close(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRelationcodeController;
        $error_message = $verify_data->openValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        $find = DB::table('batch')->whereIn('id', $request['id'])->get(['bat_number']);
        foreach($find as $key=>$value){
            $num[] = $value['bat_number'];
        }
        $res = DB::table('batch')
            ->whereIn('id',$request['id'])
            ->update(['bat_release' => 2]);
        if($res){
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'关联码列表','关闭','关闭('.implode(',', $num).')关联码成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'关闭成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'当前码号已关闭']);
        }
    }

    //打印
    public function prints(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        if ($request['type'] == '1'){
            $res = DB::table('batch')->where('id',$request['id'])->first(['bat_number','bat_nums','print_num']);
            $res['alreadyused'] = $res['bat_nums'] - $res['print_num'];
            return response()->json(['code'=>200,'msg'=>'success','data'=>$res]);
        }elseif($request['type'] == '2'){
            $res = DB::table('relation_code')->where('batch_number',$request['group_num'])->get(['id','code']);
            $num = count($res)-(int)$request['print_alreadyused'];
            $i = 0;
            $a = 0;
            foreach ($res as $key=>$value){
                $i++;
                if ($i>$num && $a<$request['print_num']){
                    $a++;
                    $str[] = $value['code'];
                }
            }
            foreach ($str as $k=>$v){
                $arraylist[$k]["code"]=$v;
            }
            $print_num = DB::table('batch')->where('id',$request['id'])->value('print_num');
            $print_num = $print_num + $request['print_num'];
            $result = DB::table('batch')->where('id',$request['id'])->update(['print_num'=>$print_num,'bat_stase'=>2]);
            return response()->json(['code'=>200,'msg'=>'success','data'=>$arraylist]);
        }
    }
    //下载
    public function derivation(Request $request)
    {
        // 验证数据
        if (!$request->exists('id') || !is_numeric($request->input('id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        //根据id查询关联码信息
        $find_batch = DB::table('batch')
            ->where('id',$request['id'])
            ->first(['bat_number','bat_cid']);
        $pathName = storage_path()."/app/excel/";
        // 创建文件夹
        if (!file_exists($pathName)){
            mkdir($pathName,0775,true);
            chmod($pathName,0775);
        }
        $filePath = storage_path()."/app/excel/" . $find_batch['bat_number'] . ".xls"; //路径
        $ident = "";
        // 查询出码号
        $table_code_info = DB::table('relation_code')
            ->where('company_id',$find_adm['adm_cid'])
            ->where('batch_number',$find_batch['bat_number'])
            ->get(['code as number','max_num']);
        $strexport = "二维码地址\t二维码号\t装载数量\r";
        $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
        file_put_contents($filePath, $strexport);
        unset($strexport);
        foreach ($table_code_info as $k => $val) {
            $strexport = config('app.url')."/sy.php?" . $val['number'] . $ident . "&\t" . $val['number'] . "&\t" . $val['max_num'] . "\r";
            $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
            file_put_contents($filePath, $strexport, FILE_APPEND);
            unset($strexport);
        }
        Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'关联码列表','下载','下载批次为“'.$find_batch['bat_number'].'”',1);
        return response()->json(['code'=>200,'msg'=>'success','data'=>"storage/app/excel/".$find_batch['bat_number'] . ".xls"]);
    }
}

