<?php

namespace App\Http\Controllers\Zero;

use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
use App\Http\Controllers\Controller;
use Session;
use DB;
use AuthenticatesUsers;

class LogController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    //日志列表
    public function logList(Request $request) {
        // 验证数据
        if (!$request->exists('add_time_range0')|| !$request->exists('add_time_range1') || empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $data = $request->all();
        $last_id = intval($request->input('last_id'));
        $logTable = DB::table('operate_log');
        if($last_id > 0) {
            $logTable->where('id', '<', $last_id);
        }
        $log_list = DB::table('relation_log as a')
            ->leftjoin('relation_code as b','a.relation_id','=','b.id')
            ->leftjoin('batch as c','c.bat_number','=','b.batch_number')
            ->where('a.company_id',$find_adm['adm_cid'])
            ->where('a.channel_id',$find_adm['adm_chan_id'])
            ->where(function($query) use($data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($data['add_time_range0'] && $data['add_time_range1'])){
                    $query->whereBetween('add_time',[$data['add_time_range0'],$data['add_time_range1']]);
                }else{
                    // 如果选择开始时间
                    if (!empty($data['add_time_range0'])){
                        $query->where('add_time','>=',$data['add_time_range0']);
                    }else{
                        // 如果选择结束时间
                        if (!empty($data['add_time_range1'])) {
                            $query->where('add_time','<=',$data['add_time_range1']);
                        }
                    }
                }
            })
            ->where(function($query) use($data) {
                if (!empty($data['remark'] )) {
                    $query->where('remark', 'like' , '%'.$data['remark'].'%' );
                }
            })
            ->select('a.type','a.relation_id','a.relation_code','a.goods_id','a.goods_name','a.goods_code','a.num','a.add_time','a.types','a.id','batch_number','remark')
            ->orderBy('id','desc')
            ->paginate($this->show_count);
        $listData['code'] = 200;
        $listData['current_page'] = $log_list->currentPage();
        $listData['total'] = $log_list->total();
        $listData['data'] = $log_list->items();
        $listData['last_page'] = $log_list->lastPage();
        $listData['current_number'] = $this->show_count;
        $listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        if($listData['data']){
            foreach ($listData['data'] as $k => $v) {
                // $listData['data'][$k]['batch_number'] = DB::table('relation_code as a')
                //     ->leftjoin('batch as b','b.bat_number','=','a.batch_number')
                //     ->where('a.id',$v['relation_id'])
                //     ->first(['batch_number','remark']);
                $listData['data'][$k]['admin_name'] = DB::table('operate_log')
                    ->where('obj_id',$v['relation_id'])
                    ->value('admin_name');
            }
        }
        return response()->json($listData);
    }
    public function logDetail(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $company_id = $find_adm['adm_cid'];
        $channel_id = $find_adm['adm_chan_id'];
        $log_row = DB::table('relation_log')
            ->where('company_id',$company_id)
            ->where('channel_id',$channel_id)
            ->where('id',$request['log_id'])
            ->get(['goods_name','goods_code','num']);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $log_row]);
    }
}

