<?php

namespace App\Http\Controllers\Warranty;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\Warranty\VerifyWarrantyTableController;

// 表单设置
class WarrantyTableController extends Controller
{
    // 表单列表页面显示
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWarrantyTableController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $data_info = DB::table('warranty_table')
                        ->where('wata_cid',$find_adm['adm_cid'])
                        ->select('wata_content','wata_stase')
                        ->first();

        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);
        if($data_info != null) {
            $data_info['wata_stase'] = $data_info['wata_stase'];
            $data_info['wata_content'] = json_decode($data_info['wata_content']);
            return response()->json(['code'=> 200,'msg'=>'success', 'data'=>$data_info, 'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据', 'button'=>$button]);
        }
    }

    // 编辑保存
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWarrantyTableController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        /**
         * 处理表单数据
         *  表单json数据字段说明
            {
                "key":"商品编号",//信息名称
                "value":"6922266440090",//信息内容
                "show":1,//1显示2隐藏
                "type":"1",//类型1普通文本2安装时间3联系电话4上传图片
                "required":"1",//是否必填1必填2选填
            }
         */
        foreach ($request['info_name'] as $key => $value) {
            if (empty($value) || !in_array($request['info_show'][$key], [1,2]) || !in_array($request['info_required'][$key], [1,2]) || !in_array($request['info_required'][$key], [1,2,3,4]) ) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息项存在空项']);
            }
            $table_content[$key]['key'] = $value;
            $table_content[$key]['value'] = $request['info_content'][$key];
            $table_content[$key]['show'] = $request['info_show'][$key];
            $table_content[$key]['type'] = $request['info_type'][$key];
            $table_content[$key]['required'] = $request['info_required'][$key];
        }

        $wata_id = DB::table('warranty_table')
                        ->where('wata_cid',$find_adm['adm_cid'])
                        ->select('wata_id')
                        ->first();
        $wata_data['wata_content'] = json_encode($table_content);
        $wata_data['wata_userid'] = $find_adm['adm_id'];
        $wata_data['wata_user_name'] = $find_adm['adm_name'];
        $wata_data['wata_updatetime'] = date('Y-m-d H:i:s');
        $wata_data['wata_stase'] = $request['wata_stase'];  //状态1开启2关闭
        if ($wata_id) {
            $wata_res = DB::table('warranty_table')->where('wata_id',$wata_id['wata_id'])->update($wata_data);
        }else{
            $wata_data['wata_cid'] = $find_adm['adm_cid'];
            $wata_res = DB::table('warranty_table')->insert($wata_data);
        }

        if($wata_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'表单设置','编辑', '表单编辑成功');
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'保存成功']);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'保存失败']);
        }
    }
    // 开启
    public function open(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $wata_id = DB::table('warranty_table')
                        ->where('wata_cid',$find_adm['adm_cid'])
                        ->select('wata_id')
                        ->first();
        $wata_data['watas_stase'] = 1;  //状态1开启2关闭
        if ($wata_id) {
            $watas_res = DB::table('warranty_table')->where('wata_id',$wata_id['wata_id'])->update($wata_data);
        }

        if($watas_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'表单设置','开启', '表单开启成功');
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'保存成功']);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'保存失败']);
        }
    }
    // 关闭
    public function close(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $wata_id = DB::table('warranty_table')
                        ->where('wata_cid',$find_adm['adm_cid'])
                        ->select('wata_id')
                        ->first();
        $wata_data['watas_stase'] = 2;  //状态1开启2关闭
        if ($wata_id) {
            $watas_res = DB::table('warranty_table')->where('wata_id',$wata_id['wata_id'])->update($wata_data);
        }

        if($watas_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'表单设置','开启', '表单开启成功');
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'保存成功']);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'保存失败']);
        }
    }
}
