<?php

namespace App\Http\Controllers\Warranty;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\Warranty\VerifyWarrantyListController;

// 质保列表
class WarrantyListController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 标签列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWarrantyListController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        $search_data = $request->all();
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $userinfo = DB::table('warranty as a')
            ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
            ->leftJoin('integral_record as c', 'c.warr_id', '=', 'a.warr_id')
            // ->where('a.warr_cid',$find_adm['adm_cid'])
            ->where(function($query) use($find_adm) {
                if ($find_adm['adm_chan_type'] == 0) {
                    $query->where('a.warr_cid', $find_adm['adm_cid']);
                } else {
                    $query->where('a.warr_chan_id', $find_adm['adm_chan_id']);
                }
            })
            // ->where(function($query) use($find_adm) {
            //     if ($find_adm['adm_chan_id'] > 0) {
            //         $query->where('a.warr_chan_id', $find_adm['adm_chan_id']);
            //     }
            // })
            ->where(function($query) use($search_data) {
                // 隶属渠道商
                if (!empty($search_data['chan_enterprise_name'])) {
                    $query->where('b.chan_enterprise_name', 'like' , '%'.$search_data['chan_enterprise_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['warr_tech_id'])) {
                    $query->where('a.warr_tech_id', 'like' , '%'.$search_data['warr_tech_id'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['warr_tech_name'])) {
                    $query->where('a.warr_tech_name', 'like' , '%'.$search_data['warr_tech_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['warr_number'])) {
                    $query->where('a.warr_number', 'like' , '%'.$search_data['warr_number'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['warr_content'])) {
                    $query->where('a.warr_content', 'like' , '%'.$search_data['warr_content'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['inte_audit_state'])) {
                    $query->where('c.inte_audit_state', $search_data['inte_audit_state']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('warr_addtime', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('warr_addtime', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('warr_addtime', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','c.inte_audit_state')
            ->orderBy('a.warr_id','desc')
            ->paginate($this->show_count);
        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
        $data_info['total'] = $userinfo->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $userinfo->items();                //返回数据

        if($data_info) {
            // 获取当前列表下的按钮
            $button = wherebutton($request['api_token'],$request['pri_id']);
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWarrantyListController;
        $error_message = $verify_data->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $find_data = DB::table('warranty')->where('warr_id',$request['warr_id'])->select('warr_content')->first();
        $data = json_decode($find_data['warr_content']);
        if($data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 通过
    public function pass(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWarrantyListController;
        $error_message = $verify_data->passValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 查询数据
        $find_data = DB::table('integral_record')
            ->where('warr_id', $request['warr_id'])
            ->select('inte_audit_state', 'inte_id', 'inte_userid', 'inte_user_name', 'inte_integral_number', 'inte_remain_integral')
            ->first();
        // var_dump($find_data);exit;
        if ($find_data['inte_audit_state'] != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前质保单不是待审核状态']);
        }
        
        DB::beginTransaction();
        $update_data['inte_audit_state'] = 2;//状态:1待审核2已通过3已驳回
        $update_data['inte_updatetime'] = date('Y-m-d H:i:s');
        $update_data['inte_remain_integral'] = $find_data['inte_integral_number'] + $find_data['inte_remain_integral'];
        $inte_res =  DB::table('integral_record')
            ->where('inte_id', $find_data['inte_id'])
            ->update($update_data);

        // 更改技师积分值
		if($find_data['inte_integral_number']=='0'){
            $tech_res=1;
		}else{
    		$tech_res = DB::table('technician')
                ->where('tech_id', $find_data['inte_userid'])
                ->increment('tech_integral', $find_data['inte_integral_number']);
		}
        
        if ($tech_res && $inte_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'], $request->getClientIp(), '积分记录', '通过', '('.$find_data['inte_user_name'].')获取积分成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'通过成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'通过失败']);
        }
    }

    // 驳回
    public function reject(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyWarrantyListController;
        $error_message = $verify_data->rejectValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 查询数据
        $find_data = DB::table('integral_record')
                    ->where('warr_id',$request['warr_id'])
                    ->select('inte_audit_state','inte_id','inte_userid','inte_user_name','inte_integral_number')->first();
        if ($find_data['inte_audit_state'] != 1) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'当前质保单不是待审核状态']);
        }

        $update_data['inte_audit_state'] = 3;//状态:1待审核2已通过3已驳回
        $update_data['inte_updatetime'] = date('Y-m-d H:i:s');
        $inte_res =  DB::table('integral_record')->where('inte_id',$find_data['inte_id'])->update($update_data);
        if($inte_res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'积分记录','驳回','('.$find_data['inte_user_name'].')驳回成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'驳回成功']);
        }else{
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
        }
    }

    /**
     * 质保列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-11-21
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function exports(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $search_data = $request->all();
        $list = DB::table('warranty as a')
            ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
            ->leftJoin('integral_record as c', 'c.warr_id', '=', 'a.warr_id')
            // ->where('a.warr_cid',$find_adm['adm_cid'])
            ->where(function($query) use($find_adm) {
                if ($find_adm['adm_chan_type'] == 0) {
                    $query->where('a.warr_cid', $find_adm['adm_cid']);
                } else {
                    $query->where('a.warr_chan_id', $find_adm['adm_chan_id']);
                }
            })
            // ->where(function($query) use($find_adm) {
            //     if ($find_adm['adm_chan_id'] > 0) {
            //         $query->where('a.warr_chan_id', $find_adm['adm_chan_id']);
            //     }
            // })
            ->where(function($query) use($search_data) {
                // 隶属渠道商
                if (!empty($search_data['chan_enterprise_name'])) {
                    $query->where('b.chan_enterprise_name', 'like' , '%'.$search_data['chan_enterprise_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['warr_tech_id'])) {
                    $query->where('a.warr_tech_id', 'like' , '%'.$search_data['warr_tech_id'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['warr_tech_name'])) {
                    $query->where('a.warr_tech_name', 'like' , '%'.$search_data['warr_tech_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['warr_number'])) {
                    $query->where('a.warr_number', 'like' , '%'.$search_data['warr_number'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['warr_content'])) {
                    $query->where('a.warr_content', 'like' , '%'.$search_data['warr_content'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['inte_audit_state'])) {
                    $query->where('c.inte_audit_state', $search_data['inte_audit_state']);
                }
            })
            ->where(function ($query) use ($search_data) { //创建时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('warr_addtime', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('warr_addtime', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('warr_addtime', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->select('a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','c.inte_audit_state')
            ->orderBy('a.warr_id','desc')
            ->get();
        if($list){
            $new_list = [];
            $title = ['时间','质保单号','渠道商名称','提交人','审核状态'];
            $configTitle = DB::table('warranty_table')
                ->where('wata_cid',$find_adm['adm_cid'])
                ->select('wata_content','wata_stase')
                ->first();
            $wata_content = json_decode($configTitle['wata_content'], true);
            foreach ($wata_content as $key => $value) {
                $title[] = $value['key'];
            }
            $new_list = [];
            foreach ($list as $key => $value) {
                $new_list[$key]['时间'] = $value['warr_addtime'];
                $new_list[$key]['质保单号'] = $value['warr_number'];
                $new_list[$key]['渠道商名称'] = $value['parent_enterprise_name'];
                $new_list[$key]['提交人'] = $value['warr_tech_name'];
                if ($value['inte_audit_state'] == 1) {
                    $inte_audit_state = '待审核';
                } elseif ($value['inte_audit_state'] == 2) {
                    $inte_audit_state = '已通过';
                } elseif ($value['inte_audit_state'] == 3) {
                    $inte_audit_state = '已驳回';
                } else {
                    $inte_audit_state = '无';
                }
                $new_list[$key]['审核状态'] = $inte_audit_state;
                $warr_content = json_decode($value['warr_content'], true);

                foreach ($wata_content as $k => $v) {
                    $new_list[$key][$v['key']] = '';
                    foreach ($warr_content as $key1 => $value1) {
                        if ($v['key'] == $value1['key']) {
                            if ($value1['type'] != 4) {
                                $new_list[$key][$v['key']] = $value1['value'];
                            } else {
                                $new_list[$key][$v['key']] = '';
                            }
                            continue;
                        }
                    }
                }
            }
        }
        $file_name = 'zb-'.date('YmdHis').rand(0,999);
        try{
            if(!empty($new_list)){
                \Excel::create($file_name, function($excel) use ($new_list, $title) {
                    $new_lists = $new_list[0];
                    $num=count($new_lists);
                    for ($i=0; $i < $num; $i++) {
                        if($i<26){
                            $letter[]=chr(65 + $i);
                        }else{
                            $letter[]=chr(64 + ($i / 26)) . chr(65 + $i % 26);
                        }
                    }
                    // 质保列表
                    $excel->sheet('质保列表', function($sheet) use ($new_list, $title, $letter)
                    {
                        foreach ($title as $key => $value) {
                            $sheet->cell($letter[$key].'1',$value."\t");
                            // $sheet->getColumnDimension($letter[$key])->setWidth(20);
                        }
                        $i = 1;
                        foreach ($new_list as $key => $value) {
                            $j = 0;
                            foreach ($value as $k => $v) {
                                if( $v && strpos($v,'=') === 0 ){
                                    $v = "'".$v;
                                }
                                $sheet->cell($letter[$j].($i+1), $v."\t");
                                $j++;
                            }
                            $i++;
                        }
                    });

                })->save('xls',storage_path('excel/warranty'));
                return response()->json(['code'=> 200,'msg'=>'success','data'=>"storage/excel/warranty/".$file_name.".xls"]);
            }else{
                return response()->json(['code'=> 500,'msg'=>'error']);
            }
        }catch(Exception $e){
            return $e->getMessage();
        }
    }
}
