<?php

namespace App\Http\Controllers\Warehouse;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App\Http\Models\Coperationa;

// 我的仓库
class WarehouseListController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 标签列表
    public function index(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $search_data = $request->all();

        $find_list = DB::table('goods_flow')
                    ->where('goof_cid',$find_adm['adm_cid'])
                    ->where('goof_chan_id',$find_adm['adm_chan_id'])
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['goo_name'])) {
                            $query->where('goo_name', 'like' , '%'.$search_data['goo_name'].'%' );
                        }
                    })
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['goo_number'])) {
                            $query->where('goo_number', 'like' , '%'.$search_data['goo_number'].'%' );
                        }
                    })
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['start_number'])) {
                            $query->where('goof_sum', '>=' , $search_data['start_number']);
                        }
                    })
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['end_number'])) {
                            $query->where('goof_sum', '<=' , $search_data['end_number']);
                        }
                    })
                    ->select('goo_name','goo_number','goof_sum')
                    ->orderBy('goof_id','desc')
                    ->paginate($this->show_count);

        $return_data['current_page'] = $find_list->currentPage();  //当前页面页码
        $return_data['last_page'] = $find_list->lastPage();        //表示最后一页的页码
        $return_data['total'] = $find_list->total();               //总数据个数
        $return_data['current_number'] = $this->show_count;       //一页显示多少个
        $return_data['data'] = $find_list->items();                //返回数据
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$return_data]);
    }
}
