<?php
namespace App\Http\Controllers\Ware;

use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Verify\VerifyCodeController;
use App\Http\Models\Code;
use Illuminate\Http\Response;
use Mockery\Exception;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Db;
use Illuminate\Support\Facades\Session;
use App\Http\Models\OrdermanageModel;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Crypt;
use Excel;
use AuthenticatesUsers;
use Illuminate\Contracts\Support\JsonableInterface;

use Carbon\Carbon;
use Storage;

use App\Http\Controllers\CommonController;


class YunCangGoodsController extends Controller{
	// 列表每页显示数据个数
    protected $show_count = 10;

    public function YunCang_goods(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $data = $request->all();
        $list = DB::table('goods_flow as a')
            ->leftjoin('channels as b','b.chan_id','=','a.goof_chan_id')
            ->where('goof_cid',$find_adm['adm_cid'])
            ->where('goof_chan_id',$find_adm['adm_chan_id'])
            ->where(function($query) use($data) {
                if (!empty($data['goo_name'])) {
                    $query->where('goo_name', 'like' , '%'.$data['goo_name'].'%' );
                }
            })
            ->where(function($query) use($data) {
                if (!empty($data['goo_number'])) {
                    $query->where('goo_number', 'like' , '%'.$data['goo_number'].'%' );
                }
            })
            ->where(function($query) use($data) {
                if (!empty($data['start_number'])) {
                    $query->where('goof_sum', '>=' , $data['start_number']);
                }
            })
            ->where(function($query) use($data) {
                if (!empty($data['end_number'])) {
                    $query->where('goof_sum', '<=' , $data['end_number']);
                }
            })
            ->select('goo_name','goo_number','goof_sum','chan_enterprise_name')
            ->orderBy('goof_id','desc')
            ->paginate($this->show_count);

        $return_data['current_page'] = $list->currentPage();  //当前页面页码
        $return_data['last_page'] = $list->lastPage();        //表示最后一页的页码
        $return_data['total'] = $list->total();               //总数据个数
        $return_data['current_number'] = $this->show_count;       //一页显示多少个
        $return_data['data'] = $list->items();                //返回数据
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$return_data]);
    }
}