<?php
namespace App\Http\Controllers\Ware;

use App\Jobs\Integral;
use App\Jobs\GoodsFlow;
use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
use App\Http\Models\Transport;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Verify\VerifyCodeController;
use App\Http\Models\Code;
use App\Http\Models\RelationCodeModel;
use Illuminate\Http\Response;
use Mockery\Exception;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Db;
use Illuminate\Support\Facades\Session;
use App\Http\Models\OrdermanageModel;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Crypt;
use Excel;
use AuthenticatesUsers;
use Illuminate\Contracts\Support\JsonableInterface;

use Carbon\Carbon;
use Storage;

use App\Http\Controllers\CommonController;

class OrdermanageController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 导出最大数量
    protected $max = 500;
    // 获取渠道商
    public function channelList(Request $request)
    {
        // 根据token值获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $channel_list = DB::table('channels')
            ->where('chan_cid', $find_adm['adm_cid'])
            ->where(['chan_cid'=>$find_adm['adm_cid'],'chan_state'=>1])
            ->get(['chan_id','chan_enterprise_name as title','chan_name as name','chan_phone as phone']);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $channel_list]);
    }
    // 出库单列表
    public function deliverList(Request $request)
    {
        // 验证数据
        if (!$request->exists('add_time_range0')|| !$request->exists('add_time_range1') || empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $input = $request->all();
        $list = DB::table('transport as a')
            ->leftjoin('channels as b', 'b.chan_id', '=', 'a.channel_id_to')
            ->where(function ($query) use ($input) {
                if (!empty($input['sn'])) {
                    $query->where('sn', 'like', '%'.$input['sn'].'%');
                }
            })
            ->where(function ($query) use ($input) {
                //如果选择开始时间并且选择结束时间
                if (!empty($input['add_time_range0'] && $input['add_time_range1'])) {
                    $query->whereBetween('add_time', [$input['add_time_range0'],$input['add_time_range1']]);
                } else {
                    // 如果选择开始时间
                    if (!empty($input['add_time_range0'])) {
                        $query->where('add_time', '>=', $input['add_time_range0']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($input['add_time_range1'])) {
                            $query->where('add_time', '<=', $input['add_time_range1']);
                        }
                    }
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['admin_name'])) {
                    $query->where('admin_name', 'like', '%'.$input['admin_name'].'%');
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['chan_enterprise_name'])) {
                    $query->where('channel_name_to', 'like', '%'.$input['chan_enterprise_name'].'%');
                }
            })
            ->where('company_id', $find_adm['adm_cid'])
            ->where('channel_id_from', $find_adm['adm_chan_id'])
            ->where('type', 0)
            ->where('state_from', 0)
            ->select('a.id', 'a.sn', 'a.total_num', 'channel_name_to', 'state_from', 'admin_name', 'remark', 'a.add_time', 'channel_id_to', 'a.channel_id_from')
            ->orderBy('id', 'desc')
            ->paginate($this->show_count);
        $transport_info = DB::table('transport as t')
            ->leftjoin('transport_info as ti', 'ti.transport_id', '=', 't.id')
            ->where('type', 0)
            ->where('state_from', 0)
            ->get(['goods_id']);
        $listData['current_page'] = $list->currentPage();
        $listData['total'] = $list->total();
        $listData['current_number'] = $this->show_count;
        $listData['last_page'] = $list->lastPage();
        $listData['data_info'] = $list->items();
        $listData['transport_info'] = $transport_info;
        $listData['button_data'] = wherebutton($request['api_token'], $request['pri_id']);
        if ($listData['data_info']) {
            foreach ($listData['data_info'] as $k => $v) {
                //渠道
                $channel = DB::table('channels')->where('chan_id', $v['channel_id_to'])->first(['chan_name','chan_phone','chan_address','chan_id','chan_enterprise_name']);
                $listData['data_info'][$k]['channel_id_to'] = $channel;
            }
        }
        return response()->json(['code'=>200,'data'=>'获取出库单列表','data_info'=>$listData]);
    }
    // 新增出库单--搜索商品
    public function comGood(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $data = $request->all();
        $list = DB::table('goods_flow as a')
            ->leftjoin('channels as b', 'b.chan_id', '=', 'a.goof_chan_id')
            ->where('goof_cid', $find_adm['adm_cid'])
            ->where(function ($query) use ($data) {
                $query->where('goo_name', 'like', '%'.$data['search_goods'].'%')
                    ->orWhere('goo_number', 'like', '%'.$data['search_goods'].'%');
            })
            ->orderBy('goof_id', 'desc')
            ->get(['goof_gid as goods_id','goo_name as goods_name','goo_number as goods_code','goof_sum','goof_chan_id','chan_id','chan_name','chan_enterprise_name']);
        $listData['data'] = $list;
        $listData['code'] = 200;
        return response()->json($listData);
    }
    // 新增出库单--返回商品(页面加载时调用,返回前五条数据)
    public function comData(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $list = DB::table('goods_flow')
            ->where('goof_cid', $find_adm['adm_cid'])
            ->orderBy('goof_id', 'desc')
            ->offset(0)->limit(5)
            ->get(['goof_gid as goods_id','goo_name as goods_name','goo_number as goods_code','goof_sum']);
        $listData['data'] = $list;
        $listData['code'] = 200;
        return response()->json($listData);
    }
    // 新增出库单
    public function new_delivery_order(Request $request)
    {
        // 验证数据
        if (empty($request->input('sn')) || empty($request->input('count')) ||empty($request->input('goods_info'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'所填新信息有误']);
        }
        // 根据token值获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $company_id = $find_adm['adm_cid'];	//公司id
        $channel_id_to = intval($request['channel_id']);
        if (empty($request->input('remark'))) {
            $request['remark'] = "";
        }
        //查询该单的收货方渠道
        if ($channel_id_to > 0) {
            $channel_to = DB::table('channels')
                ->where('chan_cid', $find_adm['adm_cid'])
                ->where('chan_state', 1)
                ->where('chan_id', $channel_id_to)
                ->get();
            if (count($channel_to) < 1) {
                return response()->json(['code' => 500, 'msg' => '未找到该渠道', 'data' => []]);
            } else {
                if ($channel_id_to == $find_adm['adm_chan_id']) {
                    return response()->json(['code' => 500, 'msg' => '出入库渠道不能相同', 'data' => []]);
                }
                $channel_to = current($channel_to);
            }
        }
        //查询该单的发货方渠道
        $channel_from = ['chan_id'=>0,'chan_enterprise_name'=>''];
        if ($find_adm['adm_chan_id'] > 0) {
            $channel_from = DB::table('channels')
                ->where('chan_cid', $find_adm['adm_cid'])
                ->where('chan_state', 1)
                ->where('chan_id', $find_adm['adm_chan_id'])
                ->get();
            if (count($channel_from) == 1) {
                $channel_from = current($channel_from);
            }
        }
        $goof_chan_id = $find_adm['adm_chan_id'];
        //step.1.创建出入库单(transport)
        $data['company_id'] = $company_id;	//公司id
        $data['sn'] = $request['sn'];	//系统单号
        $data['type'] = 0;	//0出库1入库
        $data['channel_id_from'] = $goof_chan_id;	//出库方
        $data['channel_id_to'] = $channel_id_to;	//入库方
        $data['channel_name_from'] = $channel_from['chan_enterprise_name'];	//出库方渠道名称
        $data['channel_name_to'] = $channel_to['chan_enterprise_name'];	//入库方渠道名称
        $data['state_from'] = 0;	//出库状态0未发货1已发货
        $data['state_to'] = 0;	//入库状态0未入库1已入库
        $data['add_time'] = date('Y-m-d H:i:s');	//添加时间
        $data['total_num'] = $request['count'];
        $data['admin_id'] = $find_adm['adm_id'];	//操作人id
        $data['admin_name'] = $find_adm['adm_name'];	//操作人姓名
        $data['remark'] = $request['remark'];	//备注
        $goods_info = json_decode($request['goods_info'], true);	//将商品详情解析为数组
        DB::beginTransaction();
        $id = DB::table('transport')->insertGetid($data);
        // 2.创建出库单详情(transport_info)
        // 将出库单id追加进去  并且  验证出库数量不得大于库存数量
        foreach ($goods_info as $key=>$value) {
            unset($value['goof_sum']);
            $value['transport_id'] = $id;
            $goods_inf[] = $value;
        }
        $goof_inf['add_time'] = date('Y-m-d H:i:s');
        $transport_info = DB::table('transport_info')->insert($goods_inf);
        if ($id && $transport_info) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '出库单', '新增出库单', '新增系统编号为"'.$data['sn'].'"出库单');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'新增出库单成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'新增出库单失败']);
        }
    }
    //编辑出库单
    public function editOutboundlist(Request $request)
    {
        // 验证数据
        if (empty($request->input('type')) || !in_array($request->input('type'), array(1,2))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token值获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if ($request['type'] == 1) {
            //出库信息
            $transport = DB::table('transport')
                ->where(['id'=>$request['id'],'type'=>0])
                ->first(['id','sn','total_num','channel_id_from','channel_name_from','remark','state_from','channel_id_to','channel_name_to']);
            //出库详细信息
            $transport_info = DB::table('transport as t')
                ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
                ->where(['t.id'=>$request['id'],'t.type'=>0])
                ->get(['goods_id','goods_name','goods_code','det_real_quantity']);
            //将出库信息以及出库详细信息组合
            foreach ($transport_info as $key=>$value) {
                $find_count = DB::table('goods_flow as a')
                    ->leftjoin('channels as b', 'b.chan_id', '=', 'a.goof_chan_id')
                    ->where('b.chan_id', $transport['channel_id_from'])
                    ->where('goof_cid', $find_adm['adm_cid'])
                    ->where('goof_gid', $value['goods_id'])
                    ->where('goo_name', $value['goods_name'])
                    ->where('goo_number', $value['goods_code'])
                    ->first(['goof_sum']);
                if (!$find_count['goof_sum']) {
                    $find_count['goof_sum'] = 0;
                }
                $value['goof_sum'] = $find_count['goof_sum'];
                $transport['transport_info'][] = $value;
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$transport]);
        }
        $company_id = $find_adm['adm_cid'];	//公司id
        $channel_id_to = intval($request['channel_id']);
        if (empty($request->input('remark'))) {
            $request['remark'] = "";
        }
        //查询该单的收货方渠道
        if ($channel_id_to > 0) {
            $channel_to = DB::table('channels')
                ->where('chan_cid', $find_adm['adm_cid'])
                ->where('chan_state', 1)
                ->where('chan_id', $channel_id_to)
                ->get();
            if (count($channel_to) < 1) {
                return response()->json(['code' => 500, 'msg' => '未找到该渠道', 'data' => []]);
            } else {
                $channel_to = current($channel_to);
            }
        }
        //查询该单的发货方渠道
        // $channel_from = ['chan_id'=>0,'chan_enterprise_name'=>''];
        // $channel_from = DB::table('channels')
        //     ->where('chan_cid', $find_adm['adm_cid'])
        //     ->where('chan_state', 1)
        //     ->where('chan_id', $find_adm['adm_channel_id'])
        //     ->get();
        // if (count($channel_from) == 1) {
        //     $channel_from = current($channel_from);
        // }
        //step.1.创建出入库单(transport)
        $data['company_id'] = $company_id;	//公司id
        $data['type'] = 0;	//0出库1入库
        // $data['channel_id_from'] = $channel_from['chan_id'];	//出库方
        $data['channel_id_to'] = $channel_id_to;	//入库方
        // $data['channel_name_from'] = $channel_from['chan_enterprise_name'];	//出库方渠道名称
        $data['channel_name_to'] = $channel_to['chan_enterprise_name'];	//入库方渠道名称
        $data['state_from'] = 0;	//出库状态0未发货1已发货
        $data['state_to'] = 0;	//入库状态0未入库1已入库
        $data['add_time'] = date('Y-m-d H:i:s');	//添加时间
        // $data['total_num'] = 0;
        $data['admin_id'] = $find_adm['adm_id'];	//操作人id
        $data['admin_name'] = $find_adm['adm_name'];	//操作人姓名
        $data['remark'] = $request['remark'];	//备注
        $goods_count = $request['count'];
        $goods_info = json_decode($request['goods_info'], true);	//将商品详情解析为数组
        DB::beginTransaction();
        // 2.创建出库单详情(transport_info)
        // 将出库单id追加进去  并且  验证出库数量不得大于库存数量
        $total_num = 0;
        foreach ($goods_info as $key=>$value) {
            $total_num += $value['det_real_quantity'];
            $transport_info = DB::table('transport_info')
                ->where('transport_id', $request['id'])
                ->where('goods_name', $value['goods_name'])
                ->where('goods_code', $value['goods_code'])
                ->where('goods_id', $value['goods_id'])
                ->update(['det_real_quantity'=>$value['det_real_quantity'],'add_time'=>date('Y-m-d H:i:s')]);
        }
        $data['total_num'] = $total_num;
        $id = DB::table('transport')->where('id', $request['id'])->update($data);
        $sn = DB::table('transport')
            ->where('id', $request['id'])
            ->value('sn');
        if ($id && $transport_info) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '出库单', '编辑出库单', '编辑系统编号为"'.$sn.'"出库单');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑出库单成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑出库单失败']);
        }
    }
    // 出库单详情
    public function outboundDetails(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['id']) || !is_numeric($request['id'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $find_list = DB::table('transport as t')
            ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
            ->where('transport_id', $request['id'])
            ->get(['channel_id_to','goods_id', 'goods_name', 'goods_code']);
        $goods_data = array();
        foreach ($find_list as $key => $value) {
            if (empty($goods_data[$value['goods_id']])) {
                $goods_data[$value['goods_id']]['num'] = 1;
                $goods_data[$value['goods_id']]['goods_name'] = $value['goods_name'];
                $goods_data[$value['goods_id']]['goods_code'] = $value['goods_code'];
            } else {
                $goods_data[$value['goods_id']]['num']++;
            }
            // 渠道
            $goods_data['channel'] = DB::table('channels')->where('chan_id', $value['channel_id_to'])->first(['chan_enterprise_name','chan_name','chan_phone','chan_address']);
        }
        return response()->json(['code'=>200,'msg'=>'success','data'=>$goods_data]);
    }
    // 导出
    public function derive(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $input = $request->all();
        $data = DB::table('transport')
            ->where(function ($query) use ($input) {
                if (!empty($input['sn'])) {
                    $query->where('sn', 'like', '%'.$input['sn'].'%');
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['start_time'])) {
                    $query->where('add_time', '>=', $input['start_time']);
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['end_time'])) {
                    $query->where('add_time', '<=', $input['end_time']);
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['admin_name'])) {
                    $query->where('admin_name', 'like', '%'.$input['admin_name'].'%');
                }
            })
            ->where(['company_id'=>$find_adm['adm_cid'],'type'=>0,'state_from'=>0])
            ->orderBy('id', 'desc')
            ->get();
        if ($data) {
            foreach ($data as $key => $value) {
                $data[$key]['channel'] = DB::table('channels')->where('chan_id', $value['channel_id_to'])->first(['chan_id','chan_enterprise_name','chan_name','chan_phone','chan_address']);
            }
        }
        $file_name = '10000-'.$find_adm['adm_id'];
        try {
            if (!empty($data)) {
                \Excel::create($file_name, function ($excel) use ($data) {
                    $excel->sheet('出库单', function ($sheet) use ($data) {
                        $sheet->cell('A1', function ($cell) {
                            $cell->setValue('系统单号');
                        });
                        $sheet->cell('B1', function ($cell) {
                            $cell->setValue('数量');
                        });
                        $sheet->cell('C1', function ($cell) {
                            $cell->setValue('收货方信息');
                        });
                        $sheet->cell('D1', function ($cell) {
                            $cell->setValue('操作人');
                        });
                        $sheet->cell('E1', function ($cell) {
                            $cell->setValue('状态');
                        });
                        $sheet->cell('F1', function ($cell) {
                            $cell->setValue('操作时间');
                        });
                        $sheet->cell('G1', function ($cell) {
                            $cell->setValue('备注');
                        });

                        foreach ($data as $key => $value) {
                            $i= $key+2;
                            $state_from = $value['state_from']==0 ? '未发货' : '已发货';
                            $sheet->cell('A'.$i, $value['sn']);     //系统单号
                            $sheet->cell('B'.$i, $value['total_num']);          //数量
                            $sheet->cell('C'.$i, $value['channel']['chan_enterprise_name'].','.$value['channel']['chan_name'].','.$value['channel']['chan_phone']); //发货方
                            $sheet->cell('D'.$i, $value['admin_name']);           //操作人
                            $sheet->cell('E'.$i, $state_from);     		//状态
                            $sheet->cell('F'.$i, $value['add_time']);  //操作时间
                            $sheet->cell('G'.$i, $value['remark']);       //备注
                        }
                    });
                })->save('xls', storage_path('excel/Statement'));
                return response()->json(['code'=> 200,'msg'=>'success','data'=>"storage/excel/Statement/".$file_name.".xls"]);
            } else {
                return response()->json(['code'=> 500,'msg'=>'error']);
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }
    }
    // 扫码出库
    public function transOut(Request $request)
    {
        //根据token值获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        if ($request['type'] == 1) {
            //入库信息
            $transport = DB::table('transport')
                ->where('id', $request['id'])
                ->first(['id','sn','total_num','channel_id_from','channel_name_from','remark','state_to']);
            //入库详细信息
            $transport_info = DB::table('transport as t')
                ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
                ->where('t.id', $request['id'])
                ->get(['goods_id','goods_name','goods_code','det_real_quantity']);
            //将入库信息以及入库详细信息组合
            foreach ($transport_info as $key=>$value) {
                $find_count = DB::table('goods_flow')
                    ->where('goof_cid', $find_adm['adm_cid'])
                    ->where('goof_gid', $request['goof_gid'])
                    ->orWhere('goo_name', $request['goof_gid'])
                    ->orWhere('goo_number', $request['goof_gid'])
                    ->first(['goof_sum']);
                if (!$find_count['goof_sum']) {
                    $find_count['goof_sum'] = 0;
                }
                $value['goof_sum'] = $find_count['goof_sum'];
                $transport['transport_info'][] = $value;
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$transport]);
        }

        $input = $request->only('codes', 'channel_id');
        $codes = trim($input['codes']);
        $channel_id_to = intval($input['channel_id']);
        if (!$codes) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' =>[]]);
        }
        $company_id = $find_adm['adm_cid'];
        $codes = $this->filterCodeData($codes);
        $codes = $codes['data'];
        //验证待组合的产品码或关联码
        $error_codes = [];
        $codes = explode(',', trim($codes, ','));
        foreach ($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if (!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            } else {
                $codes[$key] = $code_tmp;
            }
        }
        // if (count($error_codes) > 0 or count($codes) < 1) {
        //     return response()->json(['code' => 500, 'msg' => '包含错误的码', 'data' => $error_codes]);
        // }
        $channel_to['chan_enterprise_name'] = '';
        //查询该单的收货方渠道
        if ($channel_id_to > 0) {
            $channel_to = DB::table('channels')
                ->where('chan_cid', $company_id)
                ->where('chan_state', 1)
                ->where('chan_id', $channel_id_to)
                ->get();
            if (count($channel_to) < 1) {
                return response()->json(['code' => 500, 'msg' => '未找到该渠道', 'data' => []]);
            } else {
                $channel_to = current($channel_to);
            }
        }
        //查询该单的发货方渠道
        $channel_from = ['chan_id'=>0,'chan_enterprise_name'=>''];
        if ($request['_channel_id'] > 0) {
            $channel_from = DB::table('channels')
                ->where('chan_cid', $company_id)
                ->where('chan_state', 1)
                ->where('chan_id', $request['_channel_id'])
                ->get();
            if (count($channel_from) == 1) {
                $channel_from = current($channel_from);
            }
        }
        $code_list = array();
        foreach ($codes as $code) {
            if (strpos($code, 'G') === 0) {
                $sql = "SELECT id from trace_relation_code WHERE code='{$code}'";
                $relation_code = DB::select($sql);
                if (!$relation_code or count($relation_code) < 1) {
                    continue;
                }
                //关联码
                $sql = "SELECT max(group_id),goods_id,goods_name,goods_code,code,validity_period,production_date,count(*) as num
                        FROM trace_2019_code
                        WHERE relation_chain like '%,{$relation_code[0]['id']},%'
                        GROUP BY goods_id,validity_period,production_date";
                $find_code = DB::select($sql);
                if (count($find_code) > 0) {
                    $code_list = array_merge($code_list, $find_code);
                }
            } else {
                $sql = "SELECT group_id,goods_id,goods_name,goods_code,code,validity_period,production_date,1 as num
                        FROM trace_2019_code
                        WHERE code='{$code}' LIMIT 1";
                $find_code = DB::select($sql);
                if (count($find_code) == 1) {
                    $code_list = array_merge($code_list, $find_code);
                }
            }
        }
        $addtime = date('Y-m-d H:i:s');
        //step.1.创建出入库单(transport)
        if (empty($request['remark'])) {
            $request['remark'] = '';
        }
        $total_integral = 0;
        /*$ret = DB::table('transport')->insertGetId([
            'company_id' => $company_id,    //公司id
            'sn' => 'CK'.date('YmdHis').rand(1000,9999),    //系统单号
            'type' => 0,    //1入库0出库
            'channel_id_from' => $channel_from['chan_id'],    //出库方
            'channel_id_to' => $channel_id_to,    //入库方
            'channel_name_from' => $channel_from['chan_enterprise_name'],    //出库方渠道名称
            'channel_name_to' => $channel_to['chan_enterprise_name'],    //入库方渠道名称
            'state_from' => 1,    //出库状态0未发货1已发货
            'state_to' => 0,    //入库状态0未入库1已入库
            'add_time' => date('Y-m-d H:i:s'),    //添加时间
            'total_num' => 0,    //添加时间
            'admin_id' => $find_adm['adm_id'],    //操作人id
            'admin_name' => $find_adm['adm_name'],    //操作人姓名
            'remark' => $request['remark']    //备注
        ]);*/
        //step.2.创建出入库单详细(transport_info)
        $i = 0;
        $insert_array = $value_array = [];
        try {
            foreach ($code_list as $value) {
                array_push(
                    $insert_array,
                    [
                        // 'transport_id' => $ret,
                        'goods_id' => $value['goods_id'] ? $value['goods_id'] : '',
                        'goods_name' => $value['goods_name'] ? $value['goods_name'] : '',
                        'goods_code' => $value['goods_code'] ? $value['goods_code'] : '',
                        'code' => $value['code'],
                        'add_time' => $addtime,
                    ]
                );
                $value_array[] = $value['code'];
                $i += 1;
                if ($i == 100) {
                    // $ret = DB::table('transport_info')->insert($insert_array);
                    // if(!$ret) {
                    //     throw new ExceptionNew("insert failed");
                    // }

                    //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                    if ($request['type'] == 'out') {
                        //添加渠道积分
                        $sql = "SELECT sum(b.channel_integral) as integral
                            FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                            WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                        $tmp_integral = DB::select($sql);
                        if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                            $total_integral += $tmp_integral[0]['integral'];
                        }

                        $sql = "UPDATE trace_2019_code
                        SET transport_chain = CONCAT(transport_chain,',{$channel_id_to},')
                        WHERE company_id={$company_id} AND code in ('".implode('\',\'', $value_array)."')";
                        DB::update($sql);
                    }

                    $i = 0;
                    $insert_array = $value_array = [];
                }
                $operator = 1;//数量操作符-
                $operators = -1;//数量操作符-
                $sql = "SELECT *
                        FROM trace_goods_flow
                        WHERE `goof_cid` = ".$find_adm['adm_cid']."
                        AND `goof_chan_id` = ".$channel_id_to."
                        AND `goof_gid` = ".$value['goods_id'];
                $v_row = DB::select($sql);
                $goof_num = $operator*$value['num'];
                $goof_nums = $operators*$value['num'];
                if (!$v_row) {
                    //insert
                    $fid = DB::table('goods_flow')->insertGetId([
                        'goof_cid'=>$company_id,
                        'goof_chan_id'=>$channel_id_to,    //操作人当前渠道id
                        'goof_parent_chan_id'=>$channel_from['chan_id'],   //上级渠道id
                        'goof_gid'=>$value['goods_id'] ? $value['goods_id'] : '',
                        'goo_name'=>$value['goods_name'] ? $value['goods_name'] : '',
                        'goo_number'=>$value['goods_code'] ? $value['goods_code'] : '',
                        'goof_sum'=>$value['num']
                    ]);
                } else {
                    //update
                    DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_num} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$channel_id_to." AND `goof_gid`=".$value['goods_id']);
                    DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_nums} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$channel_id_to." AND `goof_gid`=".$value['goods_id']);
                    $fid = $v_row[0]['goof_id'];
                }
                //更新trace_goods_flow_info
                $sql = "SELECT *
                        FROM trace_goods_flow_info
                        WHERE gofi_gid={$value['goods_id']}";
                $info_row = DB::select($sql);
                if (!$info_row) {
                    //insert
                    DB::table('goods_flow_info')->insert([
                        'goof_id'=>$fid,
                        'gofi_gid'=>$value['goods_id'] ? $value['goods_id'] : '',
                        'gofi_validity_period'=>$value['validity_period'] ? $value['validity_period'] : '',
                        'gofi_production_date'=>$value['production_date'] ? $value['production_date'] : '',
                        'gofi_expired_date'=>date('Y-m-d', strtotime($value['production_date'])+3600*24*$value['validity_period']),
                        'gofi_sum'=>$value['num'],
                    ]);
                } else {
                    //update
                    DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_num} WHERE goof_id={$info_row[0]['goof_id']}");
                    DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_nums} WHERE goof_id={$info_row[0]['goof_id']}");
                }
                //修改库存数量
                DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_num} WHERE chan_id={$channel_id_to}");
                DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_nums} WHERE chan_id={$channel_id_to}");
            }
            if (count($insert_array) > 0) {
                /*$rets = DB::table('transport_info')->insert($insert_array);
                if(!$rets) {
                    throw new ExceptionNew("insert failed");
                }*/
                //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                if ($request['type'] == 'out') {
                    //添加渠道积分
                    $sql = "SELECT sum(b.channel_integral) as integral
                            FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                            WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                    $tmp_integral = DB::select($sql);
                    if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                        $total_integral += $tmp_integral[0]['integral'];
                    }
                    $sql = "UPDATE trace_2019_code
                        SET transport_chain = CONCAT(transport_chain,',{$channel_id_to},')
                        WHERE code in ('".implode('\',\'', $value_array)."')";
                    DB::update($sql);
                }
                foreach ($code_list as $vv) {
                    //出库商品数量及出库实际商品数量
                    // DB::table('transport_info')->where('transport_id', $ret)->where('goods_id',$vv['goods_id'])->increment('det_real_quantity',1);
                    // DB::table('transport_info')->where('transport_id', $ret)->where('goods_id',$vv['goods_id'])->update(['det_real_quantity'=>$request['total_num']]);
                    // DB::table('transport_info')->where('transport_id', $ret)->where('goods_id',$vv['goods_id'])->increment('det_real_actual',1);
                    // DB::table('transport_info')->where('transport_id', $ret)->where('goods_id',$vv['goods_id'])->update(['det_real_actual'=>$request['total_num']]);
                }
            }
        } catch (Exception $e) {
            DB::rollback();
            return false;
        }
        //添加渠道积分
        if ($total_integral > 0) {
            $sql = "SELECT chan_integral from trace_channels where chan_id={$channel_id_to} LIMIT 1";
            $channel_row = DB::select($sql);
            if (count($channel_row) == 1) {
                $sql = "UPDATE trace_channels SET chan_integral=chan_integral+{$total_integral} where chan_id={$channel_id_to} LIMIT 1";
                DB::update($sql);
                DB::table('integral_record')->insert([
                    'inte_cid' => $company_id,
                    'inte_chan_id' => $channel_id_to,
                    'inte_userid' => 0,
                    'inte_user_phone' => $find_adm['adm_mobile'],
                    'inte_user_name' => $find_adm['adm_name'],
                    'inte_state' => 1,
                    'inte_integral_number' => $total_integral,
                    'inte_content' => '出库',
                    'inte_type' => 1,
                    'inte_remain_integral' => $channel_row[0]['chan_integral']+$total_integral,
                    'inte_operation_name' => $find_adm['adm_name'],
                    'inte_operation_id' => $find_adm['adm_id'],
                    'inte_addtime' => $addtime
                ]);
            }
        }
        $total_num = count($code_list);
        // DB::table('transport')->where('id', $ret)->update(['total_num' => $total_num]);
        //三方物流
        /*if($request['wl_type'] == '1'){
            if(empty($request['wl_courier']))
            {
                return response()->json(['code'=>500,'data'=>'运输单位信息为空']);
            }
            $data['wl_department'] = $request['wl_department']; //运输单位
            $data['wl_courier'] = implode(',',$request['wl_courier']); //运输单位
            $data['wl_type'] = $request['wl_type']; //运输方式
        }elseif($request['wl_type'] == 2 || $request['wl_type'] == 3){
            $data['wl_department'] = $request['wl_department']; //运输单位
            $data['wl_user'] = $request['wl_user']; //负责人
            $data['wl_tel'] = $request['wl_tel']; //联系电话
            $data['wl_license'] = $request['wl_license']; //车牌号
            $data['wl_state'] = 1; //手动填写的出库单
            $data['wl_type'] = $request['wl_type']; //手动填写的出库单
        }
        $data['order_id'] = $ret;
        //添加物流信息
        $res = DB::table('wl')->insert($data);
        if(empty($res))
        {
            return response()->json(['code'=>500,'data'=>'运输方式添加失败']);
        }*/
        //step.3.生成操作日志
        DB::table('operate_log')->insert([
            'admin_id'=>$find_adm['adm_id'],
            'admin_name'=>$find_adm['adm_name'],
            'company_id'=>$company_id,
            'channel_id'=>$request['type'] == 'in'?$channel_id_to:$channel_from['chan_id'],
            'obj_table'=>'transport',
            // 'obj_id'=>$ret,
            'name'=> $request['type'] == 'in'?'入库':'出库',
            'add_time'=>date('Y-m-d H:i:s'),
            'total_num'=>$total_num]);
        DB::commit();
        return response()->json(['code' => 200, 'msg' => 'success!', 'data' => []]);
    }
    //扫码出库提交
    public function outRefer(Request $request)
    {
        //根据token值获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        if ($request['type'] == 1) {
            //入库信息
            $transport = DB::table('transport')
                ->where('id', $request['id'])
                ->first(['id','sn','total_num','channel_id_from','channel_name_from','remark','state_to']);
            //入库详细信息
            $transport_info = DB::table('transport as t')
                ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
                ->where('t.id', $request['id'])
                ->get(['goods_id','goods_name','goods_code','det_real_quantity']);
            //将入库信息以及入库详细信息组合
            foreach ($transport_info as $key=>$value) {
                $find_count = DB::table('goods_flow')
                    ->where('goof_cid', $find_adm['adm_cid'])
                    ->where('goof_gid', $request['goof_gid'])
                    ->orWhere('goo_name', $request['goof_gid'])
                    ->orWhere('goo_number', $request['goof_gid'])
                    ->first(['goof_sum']);
                if (!$find_count['goof_sum']) {
                    $find_count['goof_sum'] = 0;
                }
                $value['goof_sum'] = $find_count['goof_sum'];
                $transport['transport_info'][] = $value;
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$transport]);
        }

        $input = $request->only('codes', 'channel_id');
        $codes = trim($input['codes']);
        $channel_id_to = intval($input['channel_id']);
        if (!$codes) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' =>[]]);
        }
        $company_id = $find_adm['adm_cid'];
        $codes = $this->filterCodeData($codes);
        $codes = $codes['data'];
        //验证待组合的产品码或关联码
        $error_codes = [];
        $codes = explode(',', trim($codes, ','));
        foreach ($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if (!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            } else {
                $codes[$key] = $code_tmp;
            }
        }
        // if (count($error_codes) > 0 or count($codes) < 1) {
        //     return response()->json(['code' => 500, 'msg' => '包含错误的码', 'data' => $error_codes]);
        // }
        $channel_to['chan_enterprise_name'] = '';
        //查询该单的收货方渠道
        if ($channel_id_to > 0) {
            $channel_to = DB::table('channels')
                ->where('chan_cid', $company_id)
                ->where('chan_state', 1)
                ->where('chan_id', $channel_id_to)
                ->get();
            if (count($channel_to) < 1) {
                return response()->json(['code' => 500, 'msg' => '未找到该渠道', 'data' => []]);
            } else {
                $channel_to = current($channel_to);
            }
        }
        //查询该单的发货方渠道
        $channel_from = ['chan_id'=>0,'chan_enterprise_name'=>''];
        if ($request['_channel_id'] > 0) {
            $channel_from = DB::table('channels')
                ->where('chan_cid', $company_id)
                ->where('chan_state', 1)
                ->where('chan_id', $request['_channel_id'])
                ->get();
            if (count($channel_from) == 1) {
                $channel_from = current($channel_from);
            }
        }
        $code_list = array();
        foreach ($codes as $code) {
            if (strpos($code, 'G') === 0) {
                $sql = "SELECT id from trace_relation_code WHERE code='{$code}'";
                $relation_code = DB::select($sql);
                if (!$relation_code or count($relation_code) < 1) {
                    continue;
                }
                //关联码
                $sql = "SELECT max(group_id),goods_id,goods_name,goods_code,code,validity_period,production_date,count(*) as num
                        FROM trace_2019_code
                        WHERE relation_chain like '%,{$relation_code[0]['id']},%'
                        GROUP BY goods_id,validity_period,production_date";
                $find_code = DB::select($sql);
                if (count($find_code) > 0) {
                    $code_list = array_merge($code_list, $find_code);
                }
            } else {
                $sql = "SELECT group_id,goods_id,goods_name,goods_code,code,validity_period,production_date,1 as num
                        FROM trace_2019_code
                        WHERE code='{$code}' LIMIT 1";
                $find_code = DB::select($sql);
                if (count($find_code) == 1) {
                    $code_list = array_merge($code_list, $find_code);
                }
            }
        }
        $addtime = date('Y-m-d H:i:s');
        //step.1.创建出入库单(transport)
        if (empty($request['remark'])) {
            $request['remark'] = '';
        }
        $total_integral = 0;
        $ret = DB::table('transport')->insertGetId([
            'company_id' => $company_id,    //公司id
            'sn' => 'CK'.date('YmdHis').rand(1000, 9999),    //系统单号
            'type' => 0,    //1入库0出库
            'channel_id_from' => $channel_from['chan_id'],    //出库方
            'channel_id_to' => $channel_id_to,    //入库方
            'channel_name_from' => $channel_from['chan_enterprise_name'],    //出库方渠道名称
            'channel_name_to' => $channel_to['chan_enterprise_name'],    //入库方渠道名称
            'state_from' => 1,    //出库状态0未发货1已发货
            'state_to' => 0,    //入库状态0未入库1已入库
            'add_time' => date('Y-m-d H:i:s'),    //添加时间
            'total_num' => 0,    //添加时间
            'admin_id' => $find_adm['adm_id'],    //操作人id
            'admin_name' => $find_adm['adm_name'],    //操作人姓名
            'remark' => $request['remark']    //备注
        ]);
        //step.2.创建出入库单详细(transport_info)
        $i = 0;
        $insert_array = $value_array = [];
        try {
            foreach ($code_list as $value) {
                array_push(
                    $insert_array,
                    [
                        'transport_id' => $ret,
                        'goods_id' => $value['goods_id'] ? $value['goods_id'] : '',
                        'goods_name' => $value['goods_name'] ? $value['goods_name'] : '',
                        'goods_code' => $value['goods_code'] ? $value['goods_code'] : '',
                        'code' => $value['code'],
                        'add_time' => $addtime,
                    ]
                );
                $value_array[] = $value['code'];
                if ($request['goods_id']) {
                    foreach ($insert_array as $key => $value) {
                        $insert_array[$key]['goods_id'] = $request['goods_id'] ? $request['goods_id'] : '';
                        $insert_array[$key]['goods_name'] = $request['goods_name'] ? $request['goods_name'] : '';
                        $insert_array[$key]['goods_code'] = $request['goods_code'] ? $request['goods_code'] : '';
                    }
                }
                $i += 1;
                if ($i == 100) {
                    $ret = DB::table('transport_info')->insert($insert_array);
                    if (!$ret) {
                        throw new ExceptionNew("insert failed");
                    }

                    //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                    if ($request['type'] == 'out') {
                        //添加渠道积分
                        $sql = "SELECT sum(b.channel_integral) as integral
                            FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                            WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                        $tmp_integral = DB::select($sql);
                        if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                            $total_integral += $tmp_integral[0]['integral'];
                        }

                        $sql = "UPDATE trace_2019_code
                        SET transport_chain = CONCAT(transport_chain,',{$channel_id_to},')
                        WHERE company_id={$company_id} AND code in ('".implode('\',\'', $value_array)."')";
                        DB::update($sql);
                        if ($request['goods_id']) {
                            $num = 0;
                            $whereArray = [];
                            foreach ($codes as $code) {
                                $tab_codeid = substr($code, 0, 5);    //二维码标识
                                $tab_yemo =  substr($code, 5, 4);     //年月
                                // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
                                if ($num == 0) {
                                    $table_name = $tab_codeid.$tab_yemo;
                                    $tab_tablename = DB::table('table_link')
                                        ->where('tab_codeid', $tab_codeid)
                                        ->where('tab_yemo', $tab_yemo)
                                        ->select('tab_tablenam')
                                        ->first();
                                    $codePrefix = $tab_tablename['tab_tablenam'];
                                } else {
                                    if ($table_name == $tab_codeid.$tab_yemo) {
                                    } else {
                                        $tab_tablename = DB::table('table_link')
                                            ->where('tab_codeid', $tab_codeid)
                                            ->where('tab_yemo', $tab_yemo)
                                            ->select('tab_tablenam')
                                            ->first();
                                        $codePrefix = $tab_tablename['tab_tablenam'];
                                    }
                                }
                                $num++;
                                $whereArray[$codePrefix][] = $code;
                            }
                            foreach ($whereArray as $key => $value) {
                                $code_sqls = '';//拼接更改二维码表SQL语句
                                $code_sqls = 'UPDATE `trace_2019_code` SET goods_id = '.$request['goods_id'].',goods_name="'.$request['goods_name'].'",goods_code="'.$request['goods_code'].'" WHERE `code` IN(';
                                $where_sql = '';//where条件
                                foreach ($value as $k => $val) {
                                    if ($val) {
                                        $where_sql .= "'".$val."',";
                                        $code_where[] = $val;//二维码表查询条件
                                    }
                                }
                                $where_sql = trim($where_sql, ',');
                                $code_sqls = $code_sqls.$where_sql.')';
                                DB::update($code_sqls);
                            }
                        }
                    }

                    $i = 0;
                    $insert_array = $value_array = [];
                }
                $operator = 1;//数量操作符-
                $operators = -1;//数量操作符-
                if ($request['goods_id']) {
                    $sql = "SELECT *
                        FROM trace_goods_flow
                        WHERE `goof_cid` = ".$find_adm['adm_cid']."
                        AND `goof_chan_id` = ".$channel_id_to."
                        AND `goof_gid` = ".$request['goods_id'];
                    $v_row = DB::select($sql);
                    // $goof_num = $operator*1;
                    $goof_nums = $operators*1;
                    if (!$v_row) {
                        //insert
                        $fid = DB::table('goods_flow')->insertGetId([
                            'goof_cid'=>$company_id,
                            'goof_chan_id'=>$channel_id_to,    //操作人当前渠道id
                            'goof_parent_chan_id'=>$channel_from['chan_id'],   //上级渠道id
                            'goof_gid'=>$request['goods_id'] ? $request['goods_id'] : '',
                            'goo_name'=>$request['goods_name'] ? $request['goods_name'] : '',
                            'goo_number'=>$request['goods_code'] ? $request['goods_code'] : '',
                            'goof_sum'=>1
                        ]);
                    } else {
                        if ($v_row[0]['goof_sum'] == 0) {
                            return response()->json(['code' => 500, 'msg' => '库存不足', 'data' => []]);
                        }
                        //update
                        // DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_num} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$channel_id_to." AND `goof_gid`=".$request['goods_id']);
                        DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_nums} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$channel_id_to." AND `goof_gid`=".$request['goods_id']);
                        $fid = $v_row[0]['goof_id'];
                    }
                    $sql = "SELECT *
                        FROM trace_goods_flow_info
                        WHERE gofi_gid={$request['goods_id']}";
                    $info_row = DB::select($sql);
                    if (!$info_row) {
                        //insert
                        DB::table('goods_flow_info')->insert([
                            'goof_id'=>$fid,
                            'gofi_gid'=>$request['goods_id'] ? $request['goods_id'] : '',
                            'gofi_validity_period'=>'',
                            'gofi_production_date'=>'',
                            'gofi_expired_date'=>'',
                            'gofi_sum'=>1,
                        ]);
                    } else {
                        $goods_ids = DB::table('goods')
                            ->where('goo_id', $request['goods_id'])
                            ->select('validity_period', 'warranty_day')
                            ->first();
                        foreach ($code_list as $key => $value) {
                            $production_date = $value['production_date'];
                        }
                        $gofi_expired_date = date('Y-m-d', strtotime($production_date)+3600*24*$goods_ids['validity_period']);
                        //update
                        // DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_num},gofi_validity_period={$goods_ids['validity_period']},gofi_production_date={$goods_ids['warranty_day']},gofi_expired_date={$gofi_expired_date} WHERE goof_id={$info_row[0]['goof_id']}");
                        DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_nums},gofi_validity_period={$goods_ids['validity_period']},gofi_production_date={$goods_ids['warranty_day']},gofi_expired_date={$gofi_expired_date} WHERE goof_id={$info_row[0]['goof_id']}");
                    }
                    //修改库存数量
                    // DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_num} WHERE chan_id={$channel_id_to}");
                    DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_nums} WHERE chan_id={$channel_id_to}");
                } else {
                    $sql = "SELECT *
                            FROM trace_goods_flow
                            WHERE `goof_cid` = ".$find_adm['adm_cid']."
                            AND `goof_chan_id` = ".$channel_id_to."
                            AND `goof_gid` = ".$value['goods_id'];
                    $v_row = DB::select($sql);
                    $goof_num = $operator*$value['num'];
                    $goof_nums = $operators*$value['num'];
                    if (!$v_row) {
                        //insert
                        $fid = DB::table('goods_flow')->insertGetId([
                            'goof_cid'=>$company_id,
                            'goof_chan_id'=>$channel_id_to,    //操作人当前渠道id
                            'goof_parent_chan_id'=>$channel_from['chan_id'],   //上级渠道id
                            'goof_gid'=>$value['goods_id'] ? $value['goods_id'] : '',
                            'goo_name'=>$value['goods_name'] ? $value['goods_name'] : '',
                            'goo_number'=>$value['goods_code'] ? $value['goods_code'] : '',
                            'goof_sum'=>$value['num']
                        ]);
                    } else {
                        if ($v_row[0]['goof_sum'] == 0) {
                            return response()->json(['code' => 500, 'msg' => '库存不足', 'data' => []]);
                        }
                        //update
                        // DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_num} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$channel_id_to." AND `goof_gid`=".$value['goods_id']);
                        DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_nums} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$channel_id_to." AND `goof_gid`=".$value['goods_id']);
                        $fid = $v_row[0]['goof_id'];
                    }
                    $sql = "SELECT *
                        FROM trace_goods_flow_info
                        WHERE gofi_gid={$value['goods_id']}";
                    $info_row = DB::select($sql);
                    if (!$info_row) {
                        //insert
                        DB::table('goods_flow_info')->insert([
                            'goof_id'=>$fid,
                            'gofi_gid'=>$value['goods_id'] ? $value['goods_id'] : '',
                            'gofi_validity_period'=>$value['validity_period'] ? $value['validity_period'] : '',
                            'gofi_production_date'=>$value['production_date'] ? $value['production_date'] : '',
                            'gofi_expired_date'=>date('Y-m-d', strtotime($value['production_date'])+3600*24*$value['validity_period']),
                            'gofi_sum'=>$value['num'],
                        ]);
                    } else {
                        //update
                        // DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_num} WHERE goof_id={$info_row[0]['goof_id']}");
                        DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_nums} WHERE goof_id={$info_row[0]['goof_id']}");
                    }
                    //修改库存数量
                    // DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_num} WHERE chan_id={$channel_id_to}");
                    DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_nums} WHERE chan_id={$channel_id_to}");
                }
            }
            if (count($insert_array) > 0) {
                $rets = DB::table('transport_info')->insert($insert_array);
                if (!$rets) {
                    throw new ExceptionNew("insert failed");
                }
                //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                if ($request['type'] == 'out') {
                    //添加渠道积分
                    $sql = "SELECT sum(b.channel_integral) as integral
                            FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                            WHERE a.company_id={$company_id} AND a.code in ('".implode('\',\'', $value_array)."')";
                    $tmp_integral = DB::select($sql);
                    if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                        $total_integral += $tmp_integral[0]['integral'];
                    }
                    $sql = "UPDATE trace_2019_code
                        SET transport_chain = CONCAT(transport_chain,',{$channel_id_to},')
                        WHERE code in ('".implode('\',\'', $value_array)."')";
                    DB::update($sql);
                }
                foreach ($code_list as $vv) {
                    if ($request['goods_id']) {
                        //出库商品数量及出库实际商品数量
                        $total_num = count($code_list);
                        DB::table('transport_info')->where('transport_id', $ret)->where('goods_id', $request['goods_id'])->increment('det_real_quantity', 1);
                        DB::table('transport_info')->where('transport_id', $ret)->where('goods_id', $request['goods_id'])->increment('det_real_actual', 1);
                        $num = 0;
                        $whereArray = [];
                        foreach ($codes as $code) {
                            $tab_codeid = substr($code, 0, 5);    //二维码标识
                            $tab_yemo =  substr($code, 5, 4);     //年月
                            // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
                            if ($num == 0) {
                                $table_name = $tab_codeid.$tab_yemo;
                                $tab_tablename = DB::table('table_link')
                                    ->where('tab_codeid', $tab_codeid)
                                    ->where('tab_yemo', $tab_yemo)
                                    ->select('tab_tablenam')
                                    ->first();
                                $codePrefix = $tab_tablename['tab_tablenam'];
                            } else {
                                if ($table_name == $tab_codeid.$tab_yemo) {
                                } else {
                                    $tab_tablename = DB::table('table_link')
                                        ->where('tab_codeid', $tab_codeid)
                                        ->where('tab_yemo', $tab_yemo)
                                        ->select('tab_tablenam')
                                        ->first();
                                    $codePrefix = $tab_tablename['tab_tablenam'];
                                }
                            }
                            $num++;
                            $whereArray[$codePrefix][] = $code;
                        }
                        foreach ($whereArray as $key => $value) {
                            $code_sqls = '';//拼接更改二维码表SQL语句
                            $code_sqls = 'UPDATE `trace_2019_code` SET goods_id = '.$request['goods_id'].',goods_name="'.$request['goods_name'].'",goods_code="'.$request['goods_code'].'" WHERE `code` IN(';
                            $where_sql = '';//where条件
                            foreach ($value as $k => $val) {
                                if ($val) {
                                    $where_sql .= "'".$val."',";
                                    $code_where[] = $val;//二维码表查询条件
                                }
                            }
                            $where_sql = trim($where_sql, ',');
                            $code_sqls = $code_sqls.$where_sql.')';
                            DB::update($code_sqls);
                            $groupResult = DB::table('group')
                                ->where('code_start', '<=', $value[0])
                                ->where('code_end', '>=', $value[0])
                                ->select('gro_number', 'gro_pnumber', 'gro_num', 'gro_gid', 'code_start', 'code_end', 'nums', 'gro_codeid')
                                ->first();
                            // 溯源码表绑定商品
                            $sql = "INSERT INTO trace_formwork_code (`gco_group`,`gco_number`,`gco_start`,`gco_end`,`gco_type`,`gco_gid`,`gco_cid`,`nums`) VALUES ";
                            foreach ($value as $kk => $vv) {
                                $sql = $sql . "('" . $groupResult['gro_number'] . "','".$vv."','".$vv."','".$vv."','2','".$request['goods_id']."','".$find_adm['adm_cid']."','".$groupResult['nums']."'),";
                            }
                            $sql = trim($sql, ",") . ";";
                            $grores = DB::insert($sql);
                            unset($sql);
                        }
                    } else {
                        //出库商品数量及出库实际商品数量
                        $total_num = count($code_list);
                        DB::table('transport_info')->where('transport_id', $ret)->where('goods_id', $vv['goods_id'])->increment('det_real_quantity', 1);
                        DB::table('transport_info')->where('transport_id', $ret)->where('goods_id', $vv['goods_id'])->increment('det_real_actual', 1);
                    }
                }
            }
        } catch (Exception $e) {
            DB::rollback();
            return false;
        }
        if ($request['goods_id']) {
            // 查询该商品下的渠道积分
            $goo_integral = DB::table('goods')
                ->where('goo_id', $request['goods_id'])
                ->select('channel_integral', 'technician_integral')
                ->first();
            //添加渠道积分
            $sql = "SELECT chan_integral from trace_channels where chan_id={$channel_id_to} LIMIT 1";
            $channel_row = DB::select($sql);
            if (count($channel_row) == 1) {
                $sql = "UPDATE trace_channels SET chan_integral=chan_integral+{$goo_integral['channel_integral']} where chan_id={$channel_id_to} LIMIT 1";
                DB::update($sql);
                DB::table('integral_record')->insert([
                    'inte_cid' => $company_id,
                    'inte_chan_id' => $channel_id_to,
                    'inte_userid' => 0,
                    'inte_user_phone' => $find_adm['adm_mobile'],
                    'inte_user_name' => $find_adm['adm_name'],
                    'inte_state' => 1,
                    'inte_integral_number' => $goo_integral['channel_integral'],
                    'inte_content' => '出库',
                    'inte_type' => 1,
                    'inte_remain_integral' => $channel_row[0]['chan_integral']+$goo_integral['channel_integral'],
                    'inte_operation_name' => $find_adm['adm_name'],
                    'inte_operation_id' => $find_adm['adm_id'],
                    'inte_addtime' => $addtime
                ]);
            }
        } elseif ($total_integral > 0) {
            $sql = "SELECT chan_integral from trace_channels where chan_id={$channel_id_to} LIMIT 1";
            $channel_row = DB::select($sql);
            if (count($channel_row) == 1) {
                $sql = "UPDATE trace_channels SET chan_integral=chan_integral+{$total_integral} where chan_id={$channel_id_to} LIMIT 1";
                DB::update($sql);
                DB::table('integral_record')->insert([
                    'inte_cid' => $company_id,
                    'inte_chan_id' => $channel_id_to,
                    'inte_userid' => 0,
                    'inte_user_phone' => $find_adm['adm_mobile'],
                    'inte_user_name' => $find_adm['adm_name'],
                    'inte_state' => 1,
                    'inte_integral_number' => $total_integral,
                    'inte_content' => '出库',
                    'inte_type' => 1,
                    'inte_remain_integral' => $channel_row[0]['chan_integral']+$total_integral,
                    'inte_operation_name' => $find_adm['adm_name'],
                    'inte_operation_id' => $find_adm['adm_id'],
                    'inte_addtime' => $addtime
                ]);
            }
        }
        $total_num = count($code_list);
        DB::table('transport')->where('id', $ret)->update(['total_num' => $total_num]);
        //三方物流
        /*if($request['wl_type'] == '1'){
            if(empty($request['wl_courier']))
            {
                return response()->json(['code'=>500,'data'=>'运输单位信息为空']);
            }
            $data['wl_department'] = $request['wl_department']; //运输单位
            $data['wl_courier'] = implode(',',$request['wl_courier']); //运输单位
            $data['wl_type'] = $request['wl_type']; //运输方式
        }elseif($request['wl_type'] == 2 || $request['wl_type'] == 3){
            $data['wl_department'] = $request['wl_department']; //运输单位
            $data['wl_user'] = $request['wl_user']; //负责人
            $data['wl_tel'] = $request['wl_tel']; //联系电话
            $data['wl_license'] = $request['wl_license']; //车牌号
            $data['wl_state'] = 1; //手动填写的出库单
            $data['wl_type'] = $request['wl_type']; //手动填写的出库单
        }
        $data['order_id'] = $ret;
        //添加物流信息
        $res = DB::table('wl')->insert($data);
        if(empty($res))
        {
            return response()->json(['code'=>500,'data'=>'运输方式添加失败']);
        }*/
        //step.3.生成操作日志
        DB::table('operate_log')->insert([
            'admin_id'=>$find_adm['adm_id'],
            'admin_name'=>$find_adm['adm_name'],
            'company_id'=>$company_id,
            'channel_id'=>$request['type'] == 'in'?$channel_id_to:$channel_from['chan_id'],
            'obj_table'=>'transport',
            'obj_id'=>$ret,
            'name'=> $request['type'] == 'in'?'入库':'出库',
            'add_time'=>date('Y-m-d H:i:s'),
            'total_num'=>$total_num]);
        DB::commit();
        return response()->json(['code' => 200, 'msg' => 'success!', 'data' => []]);
    }
    //扫码捡出
    public function outPick(Request $request)
    {
        $input = $request->only('code', 'api_token');
        $code = trim($input['code']);
        if (strpos($code, "\r\n") !== false) {
            $codes = explode("\r\n", $code);
        } elseif (strpos($code, "\n") !== false) {
            $codes = explode("\n", $code);
        } else {
            $codes = [$code];
        }
        foreach ($codes as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($codes[$key]);
                continue;
            }
            // 过滤二维码,统一返回纯数字的二维码
            $code_data = $this->filterCodeData($code);
            $fil_code[$key] = $code_data['data'];
            if ($code_data['code'] == 500) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>$code_data['data']]);
            }
        }
        // $code = implode(",", $fil_code);
        $code_start = $this->filterCodeData($request->input('code'));
        if (strpos($code_start['data'], "\r\n") !== false) {
            $code_start['data'] = explode("\r\n", $code_start['data']);
        } elseif (strpos($code_start['data'], "\n") !== false) {
            $code_start['data'] = explode("\n", $code_start['data']);
        } else {
            $code_start['data'] = [$code_start['data']];
        }
        foreach ($code_start['data'] as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($code_start['data'][$key]);
                continue;
            }
            $fil_code[$key] = $code_data['data'];
        }
        $code_end = $this->filterCodeData($request->input('code'));
        if (strpos($code_end['data'], "\r\n") !== false) {
            $code_end['data'] = explode("\r\n", $code_end['data']);
        } elseif (strpos($code_end['data'], "\n") !== false) {
            $code_end['data'] = explode("\n", $code_end['data']);
        } else {
            $code_end['data'] = [$code_end['data']];
        }
        foreach ($code_end['data'] as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($code_end['data'][$key]);
                continue;
            }
            $fil_code[$key] = $code_data['data'];
        }
        $code = implode(",", $fil_code);
        $codes=explode(",", trim($code, ","));
        if (empty($codes)) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        }
        // $code = VerifyCodeController::validator($code);
        // if (!$code) {
        //     return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        // }
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $company_id = $find_adm['adm_cid'];
        $num = 0;
        $whereArray = [];
        foreach ($codes as $code) {
            $tab_codeid = substr($code, 0, 5);    //二维码标识
            $tab_yemo =  substr($code, 5, 4);     //年月
            // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
            if ($num == 0) {
                $table_name = $tab_codeid.$tab_yemo;
                $tab_tablename = DB::table('table_link')
                    ->where('tab_codeid', $tab_codeid)
                    ->where('tab_yemo', $tab_yemo)
                    ->select('tab_tablenam')
                    ->first();
                $codePrefix = $tab_tablename['tab_tablenam'];
            } else {
                if ($table_name == $tab_codeid.$tab_yemo) {
                } else {
                    $tab_tablename = DB::table('table_link')
                        ->where('tab_codeid', $tab_codeid)
                        ->where('tab_yemo', $tab_yemo)
                        ->select('tab_tablenam')
                        ->first();
                    $codePrefix = $tab_tablename['tab_tablenam'];
                }
            }
            $num++;
            $whereArray[$codePrefix][] = $code;
        }
        //判断技师是否安装
        $tech = DB::table('warranty')
            ->where('warr_cid', $company_id)
            ->where('code', $code)
            ->value('code');
        if ($tech) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'技师安装,不能再次出入库']);
        }
        if (strpos($code, 'G') === 0) {
            $RelationObj = RelationCodeModel::where('code', $code)->first();
            //查询该箱中的产品数量
            $sql = "SELECT COUNT(*) as num
                    FROM trace_2019_code
                    WHERE company_id=$company_id AND relation_chain regexp ',{$RelationObj->id},'";
            $num = DB::select($sql);
            if (is_array($num) and count($num) > 0) {
                $res_data = array(
                    'name' => $code,
                    'code' => $code,
                    'num' => $num[0]['num']
                );
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $res_data]);
            } else {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
            }
        } else {
            //todo 修改查询方式
            $code_len = strlen($code);
            $name = DB::table('group as a')
                ->leftjoin('goods as b', 'a.gro_gid', '=', 'b.goo_id')
                ->where('code_start', '<=', $code_start['data'])
                ->where('code_end', '>=', $code_end['data'])
                ->get(['b.goo_name as name','a.gro_id','a.gro_gid','b.goo_number','a.gro_time','b.warranty_day','b.validity_period','a.production_date']);
            if (is_array($name) and count($name) > 0) {
                //生成trace_2019_code
                $exist_code = Code::where('code', $codes)->get();
                if ($exist_code) {
                    $code_list = array();
                    foreach ($codes as $code) {
                        if (strpos($code, 'G') === 0) {
                            $sql = "SELECT id from trace_relation_code WHERE code='{$code}'";
                            $relation_code = DB::select($sql);
                            if (!$relation_code or count($relation_code) < 1) {
                                continue;
                            }
                            //关联码
                            $sql = "SELECT max(group_id),goods_id,goods_name,goods_code,code,validity_period,production_date,count(*) as num
                        FROM trace_2019_code
                        WHERE relation_chain like '%,{$relation_code[0]['id']},%'
                        GROUP BY goods_id,validity_period,production_date";
                            $find_code = DB::select($sql);
                            if (count($find_code) > 0) {
                                $code_list = array_merge($code_list, $find_code);
                            }
                        } else {
                            $sql = "SELECT group_id,goods_id,goods_name,goods_code,code,validity_period,production_date,1 as num
                        FROM trace_2019_code
                        WHERE code='{$code}' LIMIT 1";
                            $find_code = DB::select($sql);
                            if (count($find_code) == 1) {
                                $code_list = array_merge($code_list, $find_code);
                            }
                        }
                    }
                    $total_integral = 0;
                    $channel_from = ['chan_id'=>0,'chan_enterprise_name'=>''];
                    if ($request['_channel_id'] > 0) {
                        $channel_from = DB::table('channels')
                            ->where('chan_cid', $company_id)
                            ->where('chan_state', 1)
                            ->where('chan_id', $request['_channel_id'])
                            ->get();
                        if (count($channel_from) == 1) {
                            $channel_from = current($channel_from);
                        }
                    }
                    foreach ($code_list as $value) {
                        $value_array[] = $value['code'];
                        //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                        if ($request['type'] == 'out') {
                            //添加渠道积分
                            $sql = "SELECT sum(b.channel_integral) as integral
                        FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                        WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                            $tmp_integral = DB::select($sql);
                            if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                                $total_integral += $tmp_integral[0]['integral'];
                            }

                            $sql = "UPDATE trace_2019_code
                    SET transport_chain = CONCAT(transport_chain,',{$request['channel_id']},')
                    WHERE company_id={$company_id} AND code in ('".implode('\',\'', $value_array)."')";
                            DB::update($sql);
                        }

                        $operator = +1;//数量操作符-
                        $sql = "SELECT *
                        FROM trace_goods_flow
                        WHERE `goof_cid` = ".$find_adm['adm_cid']."
                        AND `goof_chan_id` = ".$request['channel_id']."
                        AND `goof_gid` = ".$value['goods_id'];
                        $v_row = DB::select($sql);
                        $goof_num = $operator*$value['num'];
                        if ($v_row) {
                            //update
                            DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_num} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$request['channel_id']." AND `goof_gid`=".$value['goods_id']);
                            $fid = $v_row[0]['goof_id'];
                        }
                        //更新trace_goods_flow_info
                        $sql = "SELECT *
                        FROM trace_goods_flow_info
                        WHERE gofi_gid={$value['goods_id']}";
                        $info_row = DB::select($sql);
                        if ($info_row) {
                            //update
                            DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_num} WHERE goof_id={$info_row[0]['goof_id']}");
                        }
                        //修改库存数量
                        DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_num} WHERE chan_id={$request['channel_id']}");
                    }
                    $res = DB::table('2019_code')->where('code', $codes)->delete();
                    if ($res) {
                        return response()->json(['code' => 200, 'msg' => 'success', 'data' => '捡出成功']);
                    } else {
                        return response()->json(['code' => 200, 'msg' => 'success', 'data' => '捡出失败']);
                    }
                } else {
                    return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
                }
            } else {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
            }
        }
    }
    //一键出库
    public function akeyoutbound(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['id']) || !is_numeric($request['id'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        //获取出库单的详细信息
        if ($request['type'] == 1) {
            //出库信息
            $transport = DB::table('transport')
                ->where('id', $request['id'])
                ->first();
            //出库相信信息
            $transport_info = DB::table('transport as t')
                ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
                ->where('t.id', $request['id'])
                ->get(['goods_name','goods_code','goods_id','det_real_quantity']);
            //将出库信息以及出库详细信息组合
            foreach ($transport_info as $key=>$value) {
                $find_count = DB::table('goods_flow as a')
                    ->leftjoin('channels as b', 'a.goof_chan_id', '=', 'b.chan_id')
                    ->where('b.chan_id', $request['chan_id'])
                    ->where('goof_cid', $find_adm['adm_cid'])
                    ->where('goof_gid', $value['goods_id'])
                    ->where('goo_name', $value['goods_name'])
                    ->where('goo_number', $value['goods_code'])
                    ->first(['goof_sum']);
                if (!$find_count['goof_sum']) {
                    $find_count['goof_sum'] = 0;
                }
                $value['goof_sum'] = $find_count['goof_sum'];
                $transport['transport_info'][] = $value;
                //渠道商信息
                $transport['channel'] = DB::table('channels')
                    ->where('chan_id', $transport['channel_id_to'])
                    ->first(['chan_id','chan_enterprise_name','chan_name','chan_phone','chan_address']);
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$transport]);
        }
        // 出库提交
        $input = $request->all();
        $data = DB::table('transport')
            ->where('id', $request['id'])
            ->first();
        // $channel_id_to = intval($request['channel_id']);
        $channel_id_to = $data['channel_id_to'];
        //查询该单的收货方渠道
        if ($channel_id_to > 0) {
            $channel_to = DB::table('channels')
                ->where('chan_cid', $find_adm['adm_cid'])
                ->where('chan_state', 1)
                ->where('chan_id', $channel_id_to)
                ->get();
            if (count($channel_to) < 1) {
                return response()->json(['code' => 500, 'msg' => '未找到该渠道', 'data' => []]);
            } else {
                $channel_to = current($channel_to);
            }
        }
        
        //查询该单的发货方渠道
        $channel_from = ['chan_id'=>0,'chan_enterprise_name'=>''];
        if ($data['channel_id_from'] > 0) {
            $channel_from = DB::table('channels')
                ->where('chan_cid', $find_adm['adm_cid'])
                ->where('chan_state', 1)
                ->where('chan_id', $data['channel_id_from'])
                ->get();
            if (count($channel_from) == 1) {
                $channel_from = current($channel_from);
            }
        }
        $out_chan_id = $channel_from['chan_id'];
        DB::beginTransaction();
        // 更改出入库表
        $goods_info = json_decode($input['goods_info'], true);  //将商品详情解析为数组
        foreach ($goods_info as $key => $value) {
            // 验证出库数据
            if ($value['det_real_quantity'] > $value['goof_sum']) {
                DB::rollBack();
                return response()->json(["code"=>500,'msg'=>'error','data'=>'出库数量不得大于当前库存数量']);
            }
            // 实际数量与出库数量不一致的时候  必须备注
            if ($value['det_real_quantity'] != $value['det_real_actual']) {
                if (empty($request->input('remark'))) {
                    DB::rollBack();
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'实际数量与出库数量不一致时必须备注']);
                }
            }
            //更改出入库详情表
            $transport_info = DB::table('transport_info')
                ->where('transport_id', $input['id'])
                ->where('goods_id', $value['goods_id'])
                ->where('goods_name', $value['goods_name'])
                ->where('goods_code', $value['goods_code'])
                ->update(['det_real_actual'=>$value['det_real_actual']]);

            //出库减掉库存表
            $out_goof_id = DB::table('goods_flow')
                ->where('goof_cid', $find_adm['adm_cid'])
                ->where('goof_chan_id', $out_chan_id)//出库渠道id
                ->where('goof_gid', $value['goods_id'])
                ->where('goo_name', $value['goods_name'])
                ->where('goo_number', $value['goods_code'])
                ->value('goof_id');
            $count = DB::update('UPDATE `trace_goods_flow` SET `goof_cid`=?,`goof_sum`=`goof_sum`-'.$value['det_real_actual'].' WHERE `goof_id`=?', [$find_adm['adm_cid'],$out_goof_id]);
            if (!isset($value['validity_period'])) {
                $value['validity_period'] = '';
                $value['production_date'] = '';
            }
            // //更新trace_goods_flow_info
            // $sql_out = "SELECT *
            //             FROM trace_goods_flow_info
            //             WHERE goof_id={$out_goof_id}
            //               gofi_gid={$value['goods_id']}";
            // $info_row_out = DB::select($sql_out);
            $info_row_out = DB::table('goods_flow_info')
                ->where('goof_id', $out_goof_id)
                ->where('gofi_gid', $value['goods_id'])
                ->get();
            if (!$info_row_out) {
                //insert
                DB::table('goods_flow_info')->insert([
                    'goof_id'=>$out_goof_id,
                    'gofi_gid'=>$value['goods_id'],
                    'gofi_validity_period'=>$value['validity_period'] ? $value['validity_period'] : '',
                    'gofi_production_date'=>$value['production_date'] ? $value['production_date'] : '',
                    'gofi_expired_date'=>$value['production_date'] ? date('Y-m-d', strtotime($value['production_date'])+3600*24*$value['validity_period']):'',
                    'gofi_sum'=>$value['det_real_actual'],
                ]);
            } else {
                //update
                DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum-{$value['det_real_actual']} WHERE goof_id={$info_row_out[0]['goof_id']}");
            }
            // 渠道表  减少商品库存量
            $add_lib = DB::update('UPDATE `trace_channels` SET `chan_stock_number`=`chan_stock_number`-'.$value['det_real_actual'].' WHERE `chan_id`=?', [$out_chan_id]);

            if (!$transport_info) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'出库失败']);
            }
        }
        if (empty($request->input('remark'))) {
            $input['remark'] = "";
        }
        $transport = DB::table('transport')
            ->where('id', $input['id'])
            ->update([
                'channel_id_from' => $out_chan_id,	//出库方
                'channel_id_to' => $channel_id_to,	//入库方
                'channel_name_from' => $request['chan_enterprise_name'],	//出库方渠道名称
                'channel_name_to' => $channel_to['chan_enterprise_name'],	//入库方渠道名称
                'remark' => $input['remark'],
                'state_from' => 1,
                'total_num' => $input['count'],
                'admin_id' => $find_adm['adm_id'],
                'admin_name' => $find_adm['adm_name'],
                'add_time' => date("Y-m-d H:i:s"),
            ]);

        // 用于日志
        $sn = DB::table('transport')
            ->where('id', $input['id'])
            ->value('sn');

        if ($transport && $transport_info && $count && $add_lib) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '出入库管理', '出库', '系统编号为“'.$sn.'”的出库成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'出库成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前单号已出库']);
        }
    }
    //删除出库单
    public function deliverDel(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['id']) || !is_array($request['id'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        //判断删除个数
        if (count($request['id']) > 1) {
            $find_class = DB::table('transport')->whereIn('id', $request['id'])->get(['sn','state_from']);
            $where_type = 'whereIn';
        } else {
            $find_class = DB::table('transport')->where('id', $request['id'])->get(['sn','state_from']);
            $where_type = 'where';
        }
        if (empty($find_class)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前出库单不存在或者已删除']);
        }
        $class_name = '';
        $istype = false;
        foreach ($find_class as $key=>$value) {
            if ($value['state_from'] != 2) {
                $istype = true;
            }
            $class_name .= $value['sn'].',';
        }
        if ($istype) {
            $res = DB::table('transport')
                ->where('company_id', $find_adm['adm_cid'])
                ->$where_type('id', $request['id'])
                ->update(['state_from'=>2]);
        } else {
            $res = true;
        }
        if (!empty($res)) {
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '出库管理', '出库单删除', '删除“'.trim($class_name, ',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
        } else {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }
    // 入库单列表
    public function entryList(Request $request)
    {
        // 验证数据
        if (!$request->exists('add_time_range0')|| !$request->exists('add_time_range1') || empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $input = $request->all();
        $list = DB::table('transport as a')
                ->leftjoin('channels as b', 'b.chan_id', '=', 'a.channel_id_from')
                ->where(function ($query) use ($input) {
                    if (!empty($input['sn'])) {
                        $query->where('sn', 'like', '%'.$input['sn'].'%');
                    }
                })
                ->where(function ($query) use ($input) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($input['add_time_range0'] && $input['add_time_range1'])) {
                        $query->whereBetween('add_time', [$input['add_time_range0'],$input['add_time_range1']]);
                    } else {
                        // 如果选择开始时间
                        if (!empty($input['add_time_range0'])) {
                            $query->where('add_time', '>=', $input['add_time_range0']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($input['add_time_range1'])) {
                                $query->where('add_time', '<=', $input['add_time_range1']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($input) {
                    if (!empty($input['admin_name'])) {
                        $query->where('admin_name', 'like', '%'.$input['admin_name'].'%');
                    }
                })
                ->where(function ($query) use ($input) {
                    if (!empty($input['chan_enterprise_name'])) {
                        $query->where('chan_enterprise_name', 'like', '%'.$input['chan_enterprise_name'].'%');
                    }
                })
                ->where(function ($query) use ($input) {
                    if (!empty($input['chan_name'])) {
                        $query->where('chan_name', 'like', '%'.$input['chan_name'].'%');
                    }
                })
                ->where(function ($query) use ($input) {
                    if (!empty($input['chan_phone'])) {
                        $query->where('chan_phone', 'like', '%'.$input['chan_phone'].'%');
                    }
                })
                ->where(['company_id'=>$find_adm['adm_cid'],'type'=>1])
                ->where('state_to', 0)
                ->where('a.channel_id_to', $find_adm['adm_chan_id'])
                ->select('a.id', 'a.sn', 'a.channel_name_from', 'channel_name_to', 'state_from', 'state_to', 'a.add_time', 'total_num', 'admin_name', 'channel_id_to', 'remark', 'chan_enterprise_name', 'chan_name', 'chan_phone', 'chan_address')
                ->orderBy('id', 'desc')
                ->paginate($this->show_count);
        //入库详细信息
        $transport_info = DB::table('transport as t')
            ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
            ->where('ti.transport_id', $request['id'])
            ->get(['goods_name','goods_code','goods_id','det_real_quantitys']);
        $listData['current_page'] = $list->currentPage();
        $listData['total'] = $list->total();
        $listData['current_number'] = $this->show_count;
        $listData['last_page'] = $list->lastPage();
        $listData['data_info'] = $list->items();
        $listData['transport_info'] = $transport_info;
        $listData['button_data'] = wherebutton($request['api_token'], $request['pri_id']);
        return response()->json(['code'=>200,'data'=>'获取入库单列表','data_info'=>$listData]);
    }
    // 新增入库单
    public function new_entry(Request $request)
    {
        // 验证数据
        if (empty($request->input('sn')) ||empty($request->input('count')) ||empty($request->input('goods_info'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 验证数据
        $company_id = $find_adm['adm_cid'];	//公司id
        $channel_id = $find_adm['adm_chan_id']; //入库渠道id
        if (empty($channel_id)) {
            return response()->json(['code'=>500,'msg'=>'您的账号没有所属渠道商，不可新建入库单','data'=>'您的账号没有所属渠道商，不可新建入库单']);
        }
        $channel_id_from = $request['channel_id_from']; //发货渠道id
        $channel_name_from = $request['channel_name_from'];//发货渠道名称
        $sql = "SELECT * from trace_channels where chan_id={$channel_id}";
        $channelRow = DB::select($sql);
        if (count($channelRow) == 0) {
            $channelRow[0] = array('chan_enterprise_name'=>'');
        }
        $pre_transport = array('id'=>0,'channel_id_from'=>$request['channel_id_from'],'channel_id_to'=>$channel_id,'channel_name_from'=>$request['channel_name_from'],'channel_name_to'=>$channelRow[0]['chan_enterprise_name']);
        $pre_transport['channel_id_to'] = $channel_id;
        $pre_transport['channel_name_to'] = $channelRow[0]['chan_enterprise_name'];
        $data['company_id'] = $company_id;
        $data['sn'] = $request['sn'];	//系统单号
        $data['type'] = 1;	//0出库1入库
        $data['channel_id_from'] = $request['channel_id_from'];    //出库方
        $data['channel_id_to'] = $pre_transport['channel_id_to'];    //入库方
        $data['channel_name_from'] = $pre_transport['channel_name_from'];  //出库方渠道名称
        $data['channel_name_to'] = $pre_transport['channel_name_to'];    //入库方渠道名称
        $data['state_from'] = 1;    //出库状态0未发货1已发货
        $data['state_to'] = 0;  //入库方状态0未入库1已入库
        $data['add_time'] = date('Y-m-d H:i:s');    //添加时间
        $data['total_num'] = $request['count'];
        $data['admin_id'] = $find_adm['adm_id'];
        $data['admin_name'] = $find_adm['adm_name'];
        $data['remark'] = $request['remark'] ? $request['remark'] : '';
        $goods_info = json_decode($request['goods_info'], true);  //将商品详情解析为数组
        DB::beginTransaction();
        $id = DB::table('transport')->insertGetid($data);
        foreach ($goods_info as $key => $value) {
            $value['transport_id'] = $id; //将入库id追加进
            $goods_inf[] = $value;
        }
        $goof_inf['add_time'] = date('Y-m-d H:i:s');
        // 出入库详情表添加信息
        $transport_info = DB::table('transport_info')
            ->insert($goods_inf);

        if ($id && $transport_info) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '出入库管理', '新增入库单', '新增系统编号为"'.$data['sn'].'"入库单');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'新增入库单成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'新增入库单失败']);
        }
    }
    // 编辑入库单
    public function editEntryform(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if ($request['type'] == 1) {
            //入库信息
            $transport = DB::table('transport')
                ->where(['id'=>$request['id'],'type'=>1])
                ->first(['id','sn','total_num','channel_id_to','channel_name_to','remark','state_to', 'channel_id_from', 'channel_name_from']);
            //入库详细信息
            $transport_info = DB::table('transport as t')
                ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
                ->where(['t.id'=>$request['id'],'t.type'=>1])
                ->get(['goods_id','goods_name','goods_code','det_real_quantitys']);
            //将入库信息以及入库详细信息组合
            foreach ($transport_info as $key=>$value) {
                $find_count = DB::table('goods_flow as a')
                    ->leftjoin('channels as b', 'b.chan_id', '=', 'a.goof_chan_id')
                    ->where('b.chan_id', $request['chan_id'])
                    ->where('goof_cid', $find_adm['adm_cid'])
                    ->where('goof_gid', $value['goods_id'])
                    ->orWhere('goo_name', $value['goods_name'])
                    ->orWhere('goo_number', $value['goods_code'])
                    ->first(['goof_sum']);
                if (!$find_count['goof_sum']) {
                    $find_count['goof_sum'] = 0;
                }
                $value['goof_sum'] = $find_count['goof_sum'];
                $transport['transport_info'][] = $value;
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$transport]);
        }
        // 验证数据
        $company_id = $find_adm['adm_cid'];	//公司id
        $channel_id = $request['channel_id'];
        $sql = "SELECT * from trace_channels where chan_id={$channel_id}";
        $channelRow = DB::select($sql);
        if (count($channelRow) == 0) {
            $channelRow[0] = array('chan_enterprise_name'=>'');
        }
        $pre_transport = array('id'=>0,'channel_id_from'=>$request['channel_id_from'],'channel_id_to'=>$channel_id,'channel_name_from'=>$request['channel_name_from'],'channel_name_to'=>$channelRow[0]['chan_enterprise_name']);
        $pre_transport['channel_id_to'] = $channel_id;
        $pre_transport['channel_name_to'] = $channelRow[0]['chan_enterprise_name'];
        $data['company_id'] = $company_id;
        $data['type'] = 1;	//0出库1入库
        $data['channel_id_from'] = $pre_transport['channel_id_from'];    //出库方
        $data['channel_id_to'] = $pre_transport['channel_id_to'];    //入库方
        $data['channel_name_from'] = $pre_transport['channel_name_from'];  //出库方渠道名称
        $data['channel_name_to'] = $pre_transport['channel_name_to'];    //入库方渠道名称
        $data['state_from'] = 1;    //出库状态0未发货1已发货
        $data['state_to'] = 0;  //入库方状态0未入库1已入库
        $data['add_time'] = date('Y-m-d H:i:s');    //添加时间
        $data['total_num'] = $request['count'];
        $data['admin_id'] = $find_adm['adm_id'];
        $data['admin_name'] = $find_adm['adm_name'];
        $data['remark'] = $request['remark'] ? $request['remark'] : '';
        $goods_info = json_decode($request['goods_info'], true);  //将商品详情解析为数组
        DB::beginTransaction();
        $id = DB::table('transport')->where('id', $request['id'])->update($data);
        foreach ($goods_info as $key=>$value) {
            $transport_info = DB::table('transport_info')
                ->where('transport_id', $request['id'])
                ->where('goods_name', $value['goods_name'])
                ->where('goods_code', $value['goods_code'])
                ->where('goods_id', $value['goods_id'])
                ->update(['det_real_quantitys'=>$value['det_real_quantitys'],'add_time'=>date('Y-m-d H:i:s')]);
        }
        $sn = DB::table('transport')
            ->where('id', $request['id'])
            ->value('sn');
        if ($id && $transport_info) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '出入库管理', '编辑入库单', '编辑系统编号为"'.$sn.'"入库单');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑入库单成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑入库单失败']);
        }
    }
    // 搜索每个商品下的库存数量
    public function count(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $find_count = DB::table('goods_flow')
            ->where('goof_cid', $find_adm['adm_cid'])
            ->where('goof_gid', $request['goof_gid'])
            ->orWhere('goo_name', $request['goof_gid'])
            ->orWhere('goo_number', $request['goof_gid'])
            ->first(['goof_sum']);
        if ($find_count) {
            return response()->json(['code'=>200,'msg'=>'success','data'=>'获取成功','count'=>$find_count['goof_sum']]);
        } else {
            return response()->json(['code'=>200,'msg'=>'success','data'=>'获取成功','count'=>0]);
        }
    }
    //入库单搜索商品
    public function goodscode(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $data = $request->all();
        $list = DB::table('goods')
            ->where(['goo_cid'=>$find_adm['adm_cid'],'del_type'=>1,'goo_sta'=>1])
            ->where('goo_name', 'not like', '%--副本%')
            ->where(function ($query) use ($data) {
                $query->where('goo_name', 'like', '%'.$data['search_goods'].'%')
                    ->orWhere('goo_number', 'like', '%'.$data['search_goods'].'%');
            })
            ->orderBy('goo_id', 'desc')
            ->get(['goo_id','goo_name','goo_number']);
        $list = $this->objectToArray($list);  //将对象转化为数组
        foreach ($list as $key => $value) {
            $find_count = DB::table('goods_flow as a')
                ->leftjoin('channels as b', 'b.chan_id', '=', 'a.goof_chan_id')
                ->where('b.chan_id', $request['chan_id'])
                ->where('goof_gid', $value['goo_id'])
                ->where('goo_name', $value['goo_name'])
                ->where('goo_number', $value['goo_number'])
                ->value('goof_sum');
            if (!$find_count) {
                $find_count = 0;
            }
            $list[$key]['goof_sum'] = $find_count;
        }

        $listData['data'] = $list;
        $listData['code'] = 200;
        return response()->json($listData);
    }
    // 入库单返回商品(页面加载时调用,返回前五条数据)
    public function goodsdata(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $list = DB::table('goods')
            ->where(['goo_cid'=>$find_adm['adm_cid'],'del_type'=>1,'goo_sta'=>1])
            ->where('goo_name', 'not like', '%--副本%')
            ->orderBy('goo_id', 'desc')
            ->offset(0)->limit(5)
            ->get(['goo_id','goo_name','goo_number']);
        $list = $this->objectToArray($list);  //将对象转化为数组
        foreach ($list as $key => $value) {
            $find_count = DB::table('goods_flow')
                ->where('goof_gid', $value['goo_id'])
                ->where('goo_name', $value['goo_name'])
                ->where('goo_number', $value['goo_number'])
                ->value('goof_sum');
            if (!$find_count) {
                $find_count = 0;
            }
            $list[$key]['goof_sum'] = $find_count;
        }

        $listData['data'] = $list;
        $listData['code'] = 200;
        return response()->json($listData);
    }
    // 入库单详情
    public function lookEntry(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['id']) || !is_numeric($request['id'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $find_list = DB::table('transport as t')
            ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
            ->where(['transport_id'=>$request['id'],'type'=>1,'company_id'=>$find_adm['adm_cid']])
            ->get(['channel_id_to','goods_id', 'goods_name', 'goods_code']);
        $goods_data = array();
        foreach ($find_list as $key => $value) {
            if (empty($goods_data[$value['goods_id']])) {
                $goods_data[$value['goods_id']]['num'] = 1;
                $goods_data[$value['goods_id']]['goods_name'] = $value['goods_name'];
                $goods_data[$value['goods_id']]['goods_code'] = $value['goods_code'];
            } else {
                $goods_data[$value['goods_id']]['num']++;
            }
            // 渠道
            $goods_data['channel'] = DB::table('channels')->where('chan_id', $value['channel_id_to'])->first(['chan_enterprise_name','chan_name','chan_phone','chan_address']);
        }
        return response()->json(['code'=>200,'msg'=>'success','data'=>$goods_data]);
    }
    // 扫码入库
    public function transIn(Request $request)
    {
        //todo 入库
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        if ($request['type'] == 1) {
            //入库信息
            $transport = DB::table('transport')
                ->where('id', $request['id'])
                ->first(['id','sn','total_num','channel_id_to','channel_name_to','remark','state_to']);
            //入库详细信息
            $transport_info = DB::table('transport as t')
                ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
                ->where('t.id', $request['id'])
                ->get(['goods_id','goods_name','goods_code','det_real_quantitys']);
            //将入库信息以及入库详细信息组合
            foreach ($transport_info as $key=>$value) {
                $find_count = DB::table('goods_flow')
                    ->where('goof_cid', $find_adm['adm_cid'])
                    ->where('goof_gid', $request['goof_gid'])
                    ->orWhere('goo_name', $request['goof_gid'])
                    ->orWhere('goo_number', $request['goof_gid'])
                    ->first(['goof_sum']);
                if (!$find_count['goof_sum']) {
                    $find_count['goof_sum'] = 0;
                }
                $value['goof_sum'] = $find_count['goof_sum'];
                $transport['transport_info'][] = $value;
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$transport]);
        }
        $input = $request->only('codes');
        $codes = trim($input['codes']);
        $code_strlen = strlen($codes);
        if (!$codes) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' =>[]]);
        }
        $company_id = $find_adm['adm_cid'];
        $channel_id = $request['_channel_id'];
        $codes = $this->filterCodeData($codes);
        $codes = $codes['data'];
        if ($code_strlen == '11') {
            $codes = explode(',', trim($codes, ','));
        } else {
            //验证待组合的产品码或关联码
            $error_codes = [];
            $codes = explode(',', trim($codes, ','));
            foreach ($codes as $key=>$code) {
                $code_tmp = VerifyCodeController::validator($code);
                if (!$code_tmp) {
                    unset($codes[$key]);
                    $error_codes[] = $code;
                } else {
                    $codes[$key] = $code_tmp;
                }
            }
            if (count($error_codes) > 0 or count($codes) < 1) {
                return response()->json(['code' => 500, 'msg' => '包含错误的码', 'data' => $error_codes]);
            }
        }
        $code_list = array();
        $total_integral = 0;
        foreach ($codes as $code) {
            if (strpos($code, 'G') === 0) {
                $sql = "SELECT id from trace_relation_code WHERE code='{$code}'";
                $relation_code = DB::select($sql);
                if (!$relation_code or count($relation_code) < 1) {
                    continue;
                }
                //关联码
                $sql = "SELECT max(group_id),goods_id,goods_name,goods_code,code,validity_period,production_date,count(*) as num
                        FROM trace_2019_code
                        WHERE relation_chain like '%,{$relation_code[0]['id']},%'
                        GROUP BY goods_id,validity_period,production_date";
                $find_code = DB::select($sql);
                if (count($find_code) > 0) {
                    $code_list = array_merge($code_list, $find_code);
                }
            } else {
                $sql = "SELECT group_id,goods_id,goods_name,goods_code,code,validity_period,production_date,1 as num
                        FROM trace_2019_code
                        WHERE code='{$code}' LIMIT 1";
                $find_code = DB::select($sql);
                if (count($find_code) == 1) {
                    $code_list = array_merge($code_list, $find_code);
                }
            }
        }
        $addtime = date('Y-m-d H:i:s');
        //查询该单的发货方
        $first_code = $codes[0];
        $pre_transport = $this->getPreTransport($request, $first_code);
        //step.1.创建出入库单(transport)
        if (empty($request['remark'])) {
            $request['remark'] = '';
        }
        /*$ret = DB::table('transport')->insertGetId([
            'company_id' => $company_id,    //公司id
            'sn' => 'RK'.date('YmdHis').rand(1000,9999),    //系统单号
            'type' => 1,    //1入库0出库
            'channel_id_from' => $pre_transport['channel_id_from'],    //出库方
            'channel_id_to' => $pre_transport['channel_id_to'],    //入库方
            'channel_name_from' => $pre_transport['channel_name_from'],    //出库方渠道名称
            'channel_name_to' => $pre_transport['channel_name_to'],    //入库方渠道名称
            'state_from' => 1,    //出库状态0未发货1已发货
            'state_to' => 1,    //入库状态0未入库1已入库
            'add_time' => date('Y-m-d H:i:s'),    //添加时间
            'total_num' => 0,    //添加时间
            'admin_id' => $find_adm['adm_id'],    //操作人id
            'admin_name' => $find_adm['adm_name'],    //操作人姓名
            'remark' => $request['remark']    //备注
        ]);*/
        //step.2.创建出入库单详细(transport_info)
        $i = 0;
        $insert_array = $value_array = [];
        try {
            foreach ($code_list as $value) {
                array_push(
                    $insert_array,
                    [
                        // 'transport_id' => $ret,
                        'goods_id' => $value['goods_id'],
                        'goods_name' => $value['goods_name'] ? $value['goods_name'] : '',
                        'goods_code' => $value['goods_code'] ? $value['goods_code'] : '',
                        'code' => $value['code'],
                        'add_time' => $addtime]
                );
                $value_array[] = $value['code'];
                $i += 1;
                if ($i == 100) {
                    // $ret = DB::table('transport_info')->insert($insert_array);
                    // if(!$ret) {
                    //     throw new ExceptionNew("insert failed");
                    // }

                    //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                    if ($request['type'] == 'out') {
                        //添加渠道积分
                        $sql = "SELECT sum(b.channel_integral) as integral
                            FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                            WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                        $tmp_integral = DB::select($sql);
                        if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                            $total_integral += $tmp_integral[0]['integral'];
                        }

                        $sql = "UPDATE trace_2019_code
                        SET transport_chain = CONCAT(transport_chain,',{$pre_transport['channel_id_to']},')
                        WHERE company_id={$company_id} AND code in ('".implode('\',\'', $value_array)."')";
                        DB::update($sql);
                    }

                    $i = 0;
                    $insert_array = $value_array = [];
                }
                /*$operator = 1;//数量操作符+
                $sql = "SELECT *
                        FROM trace_goods_flow
                        WHERE `goof_cid` = ".$find_adm['adm_cid']."
                        AND `goof_chan_id` = ".$pre_transport['channel_id_to']."
                        AND `goof_gid` = ".$value['goods_id'];
                $v_row = DB::select($sql);
                $goof_num = $operator*$value['num'];
                if(!$v_row) {
                    //insert
                    $fid = DB::table('goods_flow')->insertGetId([
                        'goof_cid'=>$company_id,
                        'goof_chan_id'=>$pre_transport['channel_id_to'],    //操作人当前渠道id
                        'goof_parent_chan_id'=>$pre_transport['channel_id_from'],   //上级渠道id
                        'goof_gid'=>$value['goods_id'],
                        'goo_name'=>$value['goods_name'] ? $value['goods_name'] : '',
                        'goo_number'=>$value['goods_code'] ? $value['goods_code'] : '',
                        'goof_sum'=>$value['num']
                    ]);
                }else {
                    //update
                    DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_num} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$pre_transport['channel_id_to']." AND `goof_gid`=".$value['goods_id']);
                    $fid = $v_row[0]['goof_id'];
                }
                //更新trace_goods_flow_info
                $sql = "SELECT *
                        FROM trace_goods_flow_info
                        WHERE gofi_gid={$value['goods_id']}";
                $info_row = DB::select($sql);
                if(!$info_row) {
                    //insert
                    DB::table('goods_flow_info')->insert([
                        'goof_id'=>$fid,
                        'gofi_gid'=>$value['goods_id'],
                        'gofi_validity_period'=>$value['validity_period'] ? $value['validity_period'] : '',
                        'gofi_production_date'=>$value['production_date'] ? $value['production_date'] : '',
                        'gofi_expired_date'=>date('Y-m-d',strtotime($value['production_date'])+3600*24*$value['validity_period']),
                        'gofi_sum'=>$value['num'],
                    ]);
                }else{
                    //update
                    DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_num} WHERE goof_id={$info_row[0]['goof_id']}");
                }
                DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_num} WHERE chan_id={$pre_transport['channel_id_to']}");*/
            }
            if (count($insert_array) > 0) {
                // $rets = DB::table('transport_info')->insert($insert_array);
                // if(!$rets) {
                //     throw new ExceptionNew("insert failed");
                // }
                //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                if ($request['type'] == 'out') {
                    //添加渠道积分
                    $sql = "SELECT sum(b.channel_integral) as integral
                            FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                            WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                    $tmp_integral = DB::select($sql);
                    if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                        $total_integral += $tmp_integral[0]['integral'];
                    }
                    $sql = "UPDATE trace_2019_code
                        SET transport_chain = CONCAT(transport_chain,',{$pre_transport['channel_id_to']},')
                        WHERE code in ('".implode('\',\'', $value_array)."')";
                    DB::update($sql);
                }
                foreach ($code_list as $vv) {
                    //入库商品数量及实际数量
                    // DB::table('transport_info')->where('transport_id', $ret)->where('goods_id',$vv['goods_id'])->increment('det_real_quantitys',1);
                    // DB::table('transport_info')->where('transport_id', $ret)->where('goods_id',$vv['goods_id'])->increment('det_real_actuals',1);
                }
            }
        } catch (Exception $e) {
            DB::rollback();
            return false;
        }
        //添加渠道积分
        if ($total_integral > 0) {
            $sql = "SELECT chan_integral from trace_channels where chan_id={$pre_transport['channel_id_to']} LIMIT 1";
            $channel_row = DB::select($sql);
            if (count($channel_row) == 1) {
                $sql = "UPDATE trace_channels SET chan_integral=chan_integral+{$total_integral} where chan_id={$pre_transport['channel_id_to']} LIMIT 1";
                DB::update($sql);
                DB::table('integral_record')->insert([
                    'inte_cid' => $company_id,
                    'inte_chan_id' => $pre_transport['channel_id_to'],
                    'inte_userid' => 0,
                    'inte_user_phone' => $find_adm['adm_mobile'],
                    'inte_user_name' => $find_adm['adm_name'],
                    'inte_state' => 1,
                    'inte_integral_number' => $total_integral,
                    'inte_content' => '入库',
                    'inte_type' => 1,
                    'inte_remain_integral' => $channel_row[0]['chan_integral']+$total_integral,
                    'inte_operation_name' => $find_adm['adm_name'],
                    'inte_operation_id' => $find_adm['adm_id'],
                    'inte_addtime' => $addtime
                ]);
            }
        }
        $total_num = count($code_list);
        // DB::table('transport')->where('id', $ret)->update(['total_num' => $total_num]);
        //step.3.生成操作日志
        DB::table('operate_log')->insert([
            'admin_id'=>$find_adm['adm_id'],
            'admin_name'=>$find_adm['adm_name'],
            'company_id'=>$company_id,
            'channel_id'=>$request['type'] == 'in'?$pre_transport['channel_id_to']:$pre_transport['channel_id_from'],
            'obj_table'=>'transport',
            // 'obj_id'=>$ret,
            'name'=> $request['type'] == 'in'?'入库':'出库',
            'add_time'=>date('Y-m-d H:i:s'),
            'total_num'=>$total_num]);
        DB::commit();
        return response()->json(['code' => 200, 'msg' => 'success!', 'data' => []]);
    }
    //提交扫码入库
    public function inRefer(Request $request)
    {
        //todo 入库
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $input = $request->only('codes');
        $codes = trim($input['codes']);
        $code_strlen = strlen($codes);
        if (!$codes) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' =>[]]);
        }
        $company_id = $find_adm['adm_cid'];
        $channel_id = $request['_channel_id'];
        $codes = $this->filterCodeData($codes);
        $codes = $codes['data'];
        //验证待组合的产品码或关联码
        $error_codes = [];
        $codes = explode(',', trim($codes, ','));
        // foreach ($codes as $key=>$code) {
        //     $code_tmp = VerifyCodeController::validator($code);
        //     if (!$code_tmp) {
        //         unset($codes[$key]);
        //         $error_codes[] = $code;
        //     } else {
        //         $codes[$key] = $code_tmp;
        //     }
        // }
        // if (count($error_codes) > 0 or count($codes) < 1) {
        //     return response()->json(['code' => 500, 'msg' => '包含错误的码', 'data' => $error_codes]);
        // }
        $code_list = array();
        $total_integral = 0;
        foreach ($codes as $code) {
            $code = trim($code);
            if (strpos($code, 'G') === 0) {
                $sql = "SELECT id from trace_relation_code WHERE code='{$code}'";
                $relation_code = DB::select($sql);
                if (!$relation_code or count($relation_code) < 1) {
                    continue;
                }
                //关联码
                $sql = "SELECT max(group_id),goods_id,goods_name,goods_code,code,validity_period,production_date,count(*) as num
                        FROM trace_2019_code
                        WHERE relation_chain like '%,{$relation_code[0]['id']},%'
                        GROUP BY goods_id,validity_period,production_date";
                $find_code = DB::select($sql);
                if (count($find_code) > 0) {
                    $code_list = array_merge($code_list, $find_code);
                }
            } else {
                $sql = "SELECT group_id,goods_id,goods_name,goods_code,code,validity_period,production_date,1 as num
                        FROM trace_2019_code
                        WHERE code='{$code}' LIMIT 1";
                $find_code = DB::select($sql);
                if (count($find_code) == 1) {
                    $code_list = array_merge($code_list, $find_code);
                }
            }
        }
        $addtime = date('Y-m-d H:i:s');
        //查询该单的发货方
        // dump($codes);
        // exit;
        $first_code = trim($codes[0]);
        // dump($first_code);exit;
        $pre_transport = $this->getPreTransport($request, $first_code);
        //step.1.创建出入库单(transport)
        if (empty($request['remark'])) {
            $request['remark'] = '';
        }
        $ret = DB::table('transport')->insertGetId([
            'company_id' => $company_id,    //公司id
            'sn' => 'RK'.date('YmdHis').rand(1000, 9999),    //系统单号
            'type' => 1,    //1入库0出库
            'channel_id_from' => $pre_transport['channel_id_from'],    //出库方
            'channel_id_to' => $pre_transport['channel_id_to'],    //入库方
            'channel_name_from' => $pre_transport['channel_name_from'],    //出库方渠道名称
            'channel_name_to' => $pre_transport['channel_name_to'],    //入库方渠道名称
            'state_from' => 1,    //出库状态0未发货1已发货
            'state_to' => 1,    //入库状态0未入库1已入库
            'add_time' => date('Y-m-d H:i:s'),    //添加时间
            'total_num' => 1,    //添加时间
            'admin_id' => $find_adm['adm_id'],    //操作人id
            'admin_name' => $find_adm['adm_name'],    //操作人姓名
            'remark' => $request['remark']    //备注
        ]);
        //step.2.创建出入库单详细(transport_info)
        $i = 0;
        $insert_array = $value_array = [];
        try {
            foreach ($code_list as $value) {
                array_push(
                    $insert_array,
                    [
                        'transport_id' => $ret,
                        'goods_id' => $value['goods_id'],
                        'goods_name' => $value['goods_name'] ? $value['goods_name'] : '',
                        'goods_code' => $value['goods_code'] ? $value['goods_code'] : '',
                        'code' => $value['code'],
                        'add_time' => $addtime]
                );
                $value_array[] = $value['code'];
                $i += 1;
                if ($i == 100) {
                    $ret = DB::table('transport_info')->insert($insert_array);
                    if (!$ret) {
                        throw new ExceptionNew("insert failed");
                    }

                    //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                    if ($request['type'] == 'out') {
                        //添加渠道积分
                        $sql = "SELECT sum(b.channel_integral) as integral
                            FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                            WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                        $tmp_integral = DB::select($sql);
                        if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                            $total_integral += $tmp_integral[0]['integral'];
                        }

                        $sql = "UPDATE trace_2019_code
                        SET transport_chain = CONCAT(transport_chain,',{$pre_transport['channel_id_to']},')
                        WHERE company_id={$company_id} AND code in ('".implode('\',\'', $value_array)."')";
                        DB::update($sql);
                    }

                    $i = 0;
                    $insert_array = $value_array = [];
                }
                $operator = 1;//数量操作符+
                $sql = "SELECT *
                        FROM trace_goods_flow
                        WHERE `goof_cid` = ".$find_adm['adm_cid']."
                        AND `goof_chan_id` = ".$pre_transport['channel_id_to']."
                        AND `goof_gid` = ".$value['goods_id'];
                $v_row = DB::select($sql);
                $goof_num = $operator*$value['num'];
                if(!$v_row) {
                    //insert
                    $fid = DB::table('goods_flow')->insertGetId([
                        'goof_cid'=>$company_id,
                        'goof_chan_id'=>$pre_transport['channel_id_to'],    //操作人当前渠道id
                        'goof_parent_chan_id'=>$pre_transport['channel_id_from'],   //上级渠道id
                        'goof_gid'=>$value['goods_id'],
                        'goo_name'=>$value['goods_name'] ? $value['goods_name'] : '',
                        'goo_number'=>$value['goods_code'] ? $value['goods_code'] : '',
                        'goof_sum'=>$value['num']
                    ]);
                }else {
                    //update
                    DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_num} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$pre_transport['channel_id_to']." AND `goof_gid`=".$value['goods_id']);
                    $fid = $v_row[0]['goof_id'];
                }
                //更新trace_goods_flow_info
                $sql = "SELECT *
                        FROM trace_goods_flow_info
                        WHERE gofi_gid={$value['goods_id']}";
                $info_row = DB::select($sql);
                if(!$info_row) {
                    //insert
                    DB::table('goods_flow_info')->insert([
                        'goof_id'=>$fid,
                        'gofi_gid'=>$value['goods_id'],
                        'gofi_validity_period'=>$value['validity_period'] ? $value['validity_period'] : '',
                        'gofi_production_date'=>$value['production_date'] ? $value['production_date'] : '',
                        'gofi_expired_date'=>date('Y-m-d',strtotime($value['production_date'])+3600*24*$value['validity_period']),
                        'gofi_sum'=>$value['num'],
                    ]);
                }else{
                    //update
                    DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_num} WHERE goof_id={$info_row[0]['goof_id']}");
                }
                DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_num} WHERE chan_id={$pre_transport['channel_id_to']}");
            }
            if (count($insert_array) > 0) {
                $rets = DB::table('transport_info')->insert($insert_array);
                if (!$rets) {
                    throw new ExceptionNew("insert failed");
                }
                //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                if ($request['type'] == 'out') {
                    //添加渠道积分
                    $sql = "SELECT sum(b.channel_integral) as integral
                            FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                            WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                    $tmp_integral = DB::select($sql);
                    if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                        $total_integral += $tmp_integral[0]['integral'];
                    }
                    $sql = "UPDATE trace_2019_code
                        SET transport_chain = CONCAT(transport_chain,',{$pre_transport['channel_id_to']},')
                        WHERE code in ('".implode('\',\'', $value_array)."')";
                    DB::update($sql);
                }
                foreach ($code_list as $vv) {
                    $total_num = count($code_list);
                    //入库商品数量及实际数量
                    DB::table('transport_info')->where('transport_id', $ret)->where('goods_id', $vv['goods_id'])->increment('det_real_quantitys', 1);
                    // DB::table('transport_info')->where('transport_id', $ret)->where('goods_id',$vv['goods_id'])->update(['det_real_quantitys'=>$total_num]);
                    DB::table('transport_info')->where('transport_id', $ret)->where('goods_id', $vv['goods_id'])->increment('det_real_actuals', 1);
                    // DB::table('transport_info')->where('transport_id', $ret)->where('goods_id',$vv['goods_id'])->update(['det_real_actuals'=>$total_num]);
                }
            }
        } catch (Exception $e) {
            DB::rollback();
            return false;
        }
        //添加渠道积分
        if ($total_integral > 0) {
            $sql = "SELECT chan_integral from trace_channels where chan_id={$pre_transport['channel_id_to']} LIMIT 1";
            $channel_row = DB::select($sql);
            if (count($channel_row) == 1) {
                $sql = "UPDATE trace_channels SET chan_integral=chan_integral+{$total_integral} where chan_id={$pre_transport['channel_id_to']} LIMIT 1";
                DB::update($sql);
                DB::table('integral_record')->insert([
                    'inte_cid' => $company_id,
                    'inte_chan_id' => $pre_transport['channel_id_to'],
                    'inte_userid' => 0,
                    'inte_user_phone' => $find_adm['adm_mobile'],
                    'inte_user_name' => $find_adm['adm_name'],
                    'inte_state' => 1,
                    'inte_integral_number' => $total_integral,
                    'inte_content' => '入库',
                    'inte_type' => 1,
                    'inte_remain_integral' => $channel_row[0]['chan_integral']+$total_integral,
                    'inte_operation_name' => $find_adm['adm_name'],
                    'inte_operation_id' => $find_adm['adm_id'],
                    'inte_addtime' => $addtime
                ]);
            }
        }
        $total_num = count($code_list);
        DB::table('transport')->where('id', $ret)->update(['total_num' => $total_num]);
        //step.3.生成操作日志
        DB::table('operate_log')->insert([
            'admin_id'=>$find_adm['adm_id'],
            'admin_name'=>$find_adm['adm_name'],
            'company_id'=>$company_id,
            'channel_id'=>$request['type'] == 'in'?$pre_transport['channel_id_to']:$pre_transport['channel_id_from'],
            'obj_table'=>'transport',
            'obj_id'=>$ret,
            'name'=> $request['type'] == 'in'?'入库':'出库',
            'add_time'=>date('Y-m-d H:i:s'),
            'total_num'=>$total_num]);
        DB::commit();
        return response()->json(['code' => 200, 'msg' => 'success!', 'data' => []]);
    }
    //扫码捡入
    public function inPick(Request $request)
    {
        $input = $request->only('code', 'api_token');
        $code = trim($input['code']);
        if (strpos($code, "\r\n") !== false) {
            $codes = explode("\r\n", $code);
        } elseif (strpos($code, "\n") !== false) {
            $codes = explode("\n", $code);
        } else {
            $codes = [$code];
        }
        foreach ($codes as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($codes[$key]);
                continue;
            }
            // 过滤二维码,统一返回纯数字的二维码
            $code_data = $this->filterCodeData($code);
            $fil_code[$key] = $code_data['data'];
            if ($code_data['code'] == 500) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>$code_data['data']]);
            }
        }

        // $code = implode(",", $fil_code);
        $code_start = $this->filterCodeData($request->input('code'));
        if (strpos($code_start['data'], "\r\n") !== false) {
            $code_start['data'] = explode("\r\n", $code_start['data']);
        } elseif (strpos($code_start['data'], "\n") !== false) {
            $code_start['data'] = explode("\n", $code_start['data']);
        } else {
            $code_start['data'] = [$code_start['data']];
        }
        foreach ($code_start['data'] as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($code_start['data'][$key]);
                continue;
            }
            $fil_code[$key] = $code_data['data'];
        }
        $code_end = $this->filterCodeData($request->input('code'));
        if (strpos($code_end['data'], "\r\n") !== false) {
            $code_end['data'] = explode("\r\n", $code_end['data']);
        } elseif (strpos($code_end['data'], "\n") !== false) {
            $code_end['data'] = explode("\n", $code_end['data']);
        } else {
            $code_end['data'] = [$code_end['data']];
        }
        foreach ($code_end['data'] as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($code_end['data'][$key]);
                continue;
            }
            $fil_code[$key] = $code_data['data'];
        }
        $code = implode(",", $fil_code);
        $codes=explode(",", trim($code, ","));
        if (empty($codes)) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        }

        // $code = VerifyCodeController::validator($code);
        // if (!$code) {
        //     return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        // }
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $company_id = $find_adm['adm_cid'];
        $num = 0;
        $whereArray = [];
        foreach ($codes as $code) {
            $tab_codeid = substr($code, 0, 5);    //二维码标识
            $tab_yemo =  substr($code, 5, 4);     //年月
            // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
            if ($num == 0) {
                $table_name = $tab_codeid.$tab_yemo;
                $tab_tablename = DB::table('table_link')
                    ->where('tab_codeid', $tab_codeid)
                    ->where('tab_yemo', $tab_yemo)
                    ->select('tab_tablenam')
                    ->first();
                $codePrefix = $tab_tablename['tab_tablenam'];
            } else {
                if ($table_name == $tab_codeid.$tab_yemo) {
                } else {
                    $tab_tablename = DB::table('table_link')
                        ->where('tab_codeid', $tab_codeid)
                        ->where('tab_yemo', $tab_yemo)
                        ->select('tab_tablenam')
                        ->first();
                    $codePrefix = $tab_tablename['tab_tablenam'];
                }
            }
            $num++;
            $whereArray[$codePrefix][] = $code;
        }
        //判断技师是否安装
        $tech = DB::table('warranty')
            ->where('warr_cid', $company_id)
            ->where('code', $code)
            ->value('code');
        if ($tech) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'技师安装,不能再次出入库']);
        }

        if (strpos($code, 'G') === 0) {
            $RelationObj = RelationCodeModel::where('code', $code)->first();
            //查询该箱中的产品数量
            $sql = "SELECT COUNT(*) as num
                    FROM trace_2019_code
                    WHERE company_id=$company_id AND relation_chain regexp ',{$RelationObj->id},'";
            $num = DB::select($sql);
            if (is_array($num) and count($num) > 0) {
                $res_data = array(
                    'name' => $code,
                    'code' => $code,
                    'num' => $num[0]['num']
                );
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $res_data]);
            } else {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
            }
        } else {
            //todo 修改查询方式
            $code_len = strlen($code);
            $name = DB::table('group as a')
                ->leftjoin('goods as b', 'a.gro_gid', '=', 'b.goo_id')
                ->where('code_start', '<=', $code_start['data'])
                ->where('code_end', '>=', $code_end['data'])
                ->get(['b.goo_name as name','a.gro_id','a.gro_gid','b.goo_number','a.gro_time','b.warranty_day','b.validity_period','a.production_date']);
            if (is_array($name) and count($name) > 0) {
                //生成trace_2019_code
                $exist_code = Code::where('code', $codes)->get();
                if ($exist_code) {
                    $code_list = array();
                    foreach ($codes as $code) {
                        if (strpos($code, 'G') === 0) {
                            $sql = "SELECT id from trace_relation_code WHERE code='{$code}'";
                            $relation_code = DB::select($sql);
                            if (!$relation_code or count($relation_code) < 1) {
                                continue;
                            }
                            //关联码
                            $sql = "SELECT max(group_id),goods_id,goods_name,goods_code,code,validity_period,production_date,count(*) as num
                        FROM trace_2019_code
                        WHERE relation_chain like '%,{$relation_code[0]['id']},%'
                        GROUP BY goods_id,validity_period,production_date";
                            $find_code = DB::select($sql);
                            if (count($find_code) > 0) {
                                $code_list = array_merge($code_list, $find_code);
                            }
                        } else {
                            $sql = "SELECT group_id,goods_id,goods_name,goods_code,code,validity_period,production_date,1 as num
                        FROM trace_2019_code
                        WHERE code='{$code}' LIMIT 1";
                            $find_code = DB::select($sql);
                            if (count($find_code) == 1) {
                                $code_list = array_merge($code_list, $find_code);
                            }
                        }
                    }
                    $total_integral = 0;
                    $channel_from = ['chan_id'=>0,'chan_enterprise_name'=>''];
                    if ($request['_channel_id'] > 0) {
                        $channel_from = DB::table('channels')
                            ->where('chan_cid', $company_id)
                            ->where('chan_state', 1)
                            ->where('chan_id', $request['_channel_id'])
                            ->get();
                        if (count($channel_from) == 1) {
                            $channel_from = current($channel_from);
                        }
                    }
                    foreach ($code_list as $value) {
                        $value_array[] = $value['code'];
                        //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                        if ($request['type'] == 'out') {
                            //添加渠道积分
                            $sql = "SELECT sum(b.channel_integral) as integral
                        FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                        WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'', $value_array)."')";
                            $tmp_integral = DB::select($sql);
                            if (count($tmp_integral) == 1 and $tmp_integral[0]['integral'] > 0) {
                                $total_integral += $tmp_integral[0]['integral'];
                            }

                            $sql = "UPDATE trace_2019_code
                    SET transport_chain = CONCAT(transport_chain,',{$request['channel_id']},')
                    WHERE company_id={$company_id} AND code in ('".implode('\',\'', $value_array)."')";
                            DB::update($sql);
                        }

                        $operator = -1;//数量操作符-
                        $sql = "SELECT *
                        FROM trace_goods_flow
                        WHERE `goof_cid` = ".$find_adm['adm_cid']."
                        AND `goof_chan_id` = ".$request['channel_id']."
                        AND `goof_gid` = ".$value['goods_id'];
                        $v_row = DB::select($sql);
                        $goof_num = $operator*$value['num'];
                        // if ($v_row) {
                        //     //update
                        //     DB::update("UPDATE trace_goods_flow SET goof_sum=goof_sum+{$goof_num} WHERE `goof_cid`=".$find_adm['adm_cid']." AND `goof_chan_id`=".$request['channel_id']." AND `goof_gid`=".$value['goods_id']);
                        //     $fid = $v_row[0]['goof_id'];
                        // }
                        //更新 trace_goods_flow_info
                        $sql = "SELECT *
                        FROM trace_goods_flow_info
                        WHERE gofi_gid={$value['goods_id']}";
                        $info_row = DB::select($sql);
                        // if ($info_row) {
                        //     //update
                        //     DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$goof_num} WHERE goof_id={$info_row[0]['goof_id']}");
                        // }
                        //修改库存数量
                        // DB::update("UPDATE trace_channels SET chan_stock_number=chan_stock_number+{$goof_num} WHERE chan_id={$request['channel_id']}");
                    }
                    $res = DB::table('2019_code')->where('code', $codes)->delete();
                    if ($res) {
                        return response()->json(['code' => 200, 'msg' => 'success', 'data' => '捡出成功']);
                    } else {
                        return response()->json(['code' => 500, 'msg' => 'error', 'data' => '捡出失败']);
                    }
                }
            } else {
                return response()->json(['code' => 501, 'msg' => 'error', 'data' => []]);
            }
        }
    }
    public function getPreTransport(Request $requset, $first_code)
    {
        $find_adm = Coperationa::getUserInfo($requset['api_token']);
        $company_id = $find_adm['adm_cid'];
        $channel_id = $requset['channel_id'];
        $sql = "SELECT * from trace_channels where chan_id={$channel_id}";
        $channelRow = DB::select($sql);
        if (count($channelRow) == 0) {
            $channelRow[0] = array('chan_enterprise_name'=>'');
        }
        if (strpos($first_code, 'G') === 0) {
            $relation_code = RelationCodeModel::where('code', $first_code)->first();
            if (!$relation_code) {
                return response()->json(['code' => 500, 'msg' => '未找到关联码'.$first_code, 'data' => []]);
            }
            $sql = "SELECT * from trace_2019_code WHERE company_id=$company_id AND relation_chain LIKE '%,{$relation_code->id},%' LIMIT 1";
            $first_code_info = DB::select($sql);
        } else {
            $sql = "SELECT * from trace_2019_code WHERE company_id=$company_id AND code='{$first_code}' LIMIT 1";
            $first_code_info = DB::select($sql);
        }
        if (count($first_code_info) < 1) {
            return response()->json(['code' => 500, 'msg' => $first_code.'未找到商品'.$first_code, 'data' => []]);
        }
        $sql = "SELECT b.*
                FROM trace_transport_info a LEFT JOIN trace_transport b on a.transport_id=b.id
                WHERE b.company_id=$company_id AND a.code='{$first_code_info[0]['code']}'
                ORDER BY b.id DESC 
                LIMIT 1";
        $pre_transport = DB::select($sql);
        if (count($pre_transport) == 1) {
            $pre_transport = current($pre_transport);
        } else {
            $pre_transport = array('id'=>0,'channel_id_from'=>0,'channel_id_to'=>$channel_id,'channel_name_from'=>'','channel_name_to'=>$channelRow[0]['chan_enterprise_name']);
        }
        $pre_transport['channel_id_to'] = $channel_id;
        $pre_transport['channel_name_to'] = $channelRow[0]['chan_enterprise_name'];
        return $pre_transport;
    }
    //入库单导出
    public function export_list(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $input = $request->all();
        $data = DB::table('transport')
            ->where(function ($query) use ($input) {
                if (!empty($input['sn'])) {
                    $query->where('sn', 'like', '%'.$input['sn'].'%');
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['start_time'])) {
                    $query->where('add_time', '>=', $input['start_time']);
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['end_time'])) {
                    $query->where('add_time', '<=', $input['end_time']);
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['admin_name'])) {
                    $query->where('admin_name', 'like', '%'.$input['admin_name'].'%');
                }
            })
            ->where(['company_id'=>$find_adm['adm_cid'],'type'=>1,'state_to'=>0])
            ->orderBy('id', 'desc')
            ->get();
        if ($data) {
            foreach ($data as $key => $value) {
                $data[$key]['channel'] = DB::table('channels')->where('chan_id', $value['channel_id_from'])->first(['chan_id','chan_enterprise_name','chan_name','chan_phone','chan_address']);
            }
        }
        $file_name = '10000-'.$find_adm['adm_id'];
        try {
            if (!empty($data)) {
                \Excel::create($file_name, function ($excel) use ($data) {
                    // 销售额统计
                    $excel->sheet('销售额', function ($sheet) use ($data) {
                        $sheet->cell('A1', function ($cell) {
                            $cell->setValue('系统单号');
                        });
                        $sheet->cell('B1', function ($cell) {
                            $cell->setValue('数量');
                        });
                        $sheet->cell('C1', function ($cell) {
                            $cell->setValue('发货方');
                        });
                        $sheet->cell('D1', function ($cell) {
                            $cell->setValue('备注');
                        });
                        $sheet->cell('E1', function ($cell) {
                            $cell->setValue('操作人');
                        });
                        $sheet->cell('F1', function ($cell) {
                            $cell->setValue('状态');
                        });
                        $sheet->cell('G1', function ($cell) {
                            $cell->setValue('新增时间');
                        });

                        foreach ($data as $key => $value) {
                            $i= $key+2;
                            $state_to = $value['state_to']==0 ? '未入库' : '已入库';
                            $sheet->cell('A'.$i, $value['sn']);     //系统单号
                            $sheet->cell('B'.$i, $value['total_num']);          //数量
                            $sheet->cell('C'.$i, $value['channel']['chan_enterprise_name'].','.$value['channel']['chan_name'].','.$value['channel']['chan_phone']); //发货方
                            $sheet->cell('D'.$i, $value['remark']);           //备注
                            $sheet->cell('E'.$i, $value['admin_name']);     		//操作人
                            $sheet->cell('F'.$i, $state_to);  //状态
                            $sheet->cell('G'.$i, $value['add_time']);       //新增时间
                        }
                    });
                })->save('xls', storage_path('excel/Statement'));
                return response()->json(['code'=> 200,'msg'=>'success','data'=>"storage/excel/Statement/".$file_name.".xls"]);
            } else {
                return response()->json(['code'=> 500,'msg'=>'error']);
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }
    }
    //一键入库
    public function akeytreasury(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['id']) || !is_numeric($request['id'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 获取入库单的详细信息
        if ($request->input('type') ==1) {
            //入库信息
            $transport = DB::table('transport')
                ->where('id', $request['id'])
                ->first(['id','sn','total_num','channel_id_to','channel_name_to','remark','state_to']);
            //入库详细信息
            $transport_info = DB::table('transport as t')
                ->leftjoin('transport_info as ti', 't.id', '=', 'ti.transport_id')
                ->where('t.id', $request['id'])
                ->get(['goods_name','goods_code','goods_id','det_real_quantitys']);
            //将入库信息以及入库详细信息组合
            foreach ($transport_info as $key=>$value) {
                $find_count = DB::table('goods_flow as a')
                    ->leftjoin('channels as b', 'b.chan_id', '=', 'a.goof_chan_id')
                    ->where('b.chan_id', $request['chan_id'])
                    ->where('goof_cid', $find_adm['adm_cid'])
                    ->where('goof_gid', $value['goods_id'])
                    ->where('goo_name', $value['goods_name'])
                    ->where('goo_number', $value['goods_code'])
                    ->first(['goof_sum']);
                if (!$find_count['goof_sum']) {
                    $find_count['goof_sum'] = 0;
                }
                $value['goof_sum'] = $find_count['goof_sum'];
                $transport['transport_info'][] = $value;
                //渠道商信息
                $transport['channel'] = DB::table('channels')
                    ->where('chan_id', $transport['channel_id_to'])
                    ->first(['chan_id','chan_enterprise_name','chan_name','chan_phone','chan_address']);
                if (empty($transport['channel'])) {
                    return response()->json(['code'=>500,'msg'=>'未查询到入库渠道，请联系管理员','data'=>'未查询到入库渠道，请联系管理员']);
                }
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$transport]);
        }
        $channel_id = $request['channel_id'];
        $channel_id_from = $request['channel_id_from'];//发货方
        $sql = "SELECT * from trace_channels where chan_id={$channel_id}";
        $channelRow = DB::select($sql);
        if (count($channelRow) == 0) {
            $channelRow[0] = array('chan_enterprise_name'=>'');
        }
        $pre_transport = array('id'=>0,'channel_id_from'=>$channel_id_from,'channel_id_to'=>$channel_id,'channel_name_from'=>'','channel_name_to'=>$channelRow[0]['chan_enterprise_name']);
        $pre_transport['channel_id_to'] = $channel_id;
        $pre_transport['channel_name_to'] = $channelRow[0]['chan_enterprise_name'];
        if (empty($request->input('remark'))) {
            $request['remark'] = "";
        }
        // istype 1.入库  2.强制入库
        if ($request['istype']  == 1) {
            $is_lib = 1;
        } else {
            // 强制入库
            $is_lib = 3;
        }
        DB::beginTransaction();
        //更改出入库表
        $transport = DB::table('transport')
            ->where('id', $request['id'])
            ->update([
                // 'channel_id_from' => $pre_transport['channel_id_from'],    //出库方
                // 'channel_id_to' => $pre_transport['channel_id_to'],    //入库方
                // 'channel_name_from' => $pre_transport['channel_name_from'],  //出库方渠道名称
                // 'channel_name_to' => $pre_transport['channel_name_to'],    //入库方渠道名称
                'state_to' => $is_lib,
                'total_num' => $request['count'],
                'admin_id' => $find_adm['adm_id'],
                'admin_name' => $find_adm['adm_name'],
                'remark' => $request['remark'],
                'add_time' => date("Y-m-d H:i:s"),
            ]);
        //更改出入库详情表
        $goods_info = json_decode($request['goods_info'], true);  //将商品详情解析为数组
        foreach ($goods_info as $key=>$value) {
            $transport_info = DB::table('transport_info')
                ->where('transport_id', $request['id'])
                ->where('goods_name', $value['goods_name'])
                ->where('goods_code', $value['goods_code'])
                ->where('goods_id', $value['goods_id'])
                ->update(['det_real_actuals'=>$value['det_real_actuals']]);
        }
        //更改库存表,判断库中是否已有该商品
        foreach($goods_info as $key=>$value){
            $goof_id = DB::table('goods_flow')
                ->where('goof_chan_id',$pre_transport['channel_id_to'])
                ->where('goof_cid',$find_adm['adm_cid'])
                ->where('goof_gid',$value['goods_id'])
                ->where('goo_name',$value['goods_name'])
                ->where('goo_number',$value['goods_code'])
                ->value('goof_id');
            if($goof_id){
                //有该商品 追加商品数量
                $count = DB::update('UPDATE `trace_goods_flow` SET `goof_cid`=?,`goof_sum`=`goof_sum`+'.$value['det_real_actuals'].' WHERE `goof_id`=?',[$find_adm['adm_cid'],$goof_id] );
            }else{
                // 没有该商品 新增一条数据
                $count = DB::table('goods_flow')
                    ->insertGetId([
                        'goof_cid' => $find_adm['adm_cid'],
                        'goof_chan_id' => $pre_transport['channel_id_to'],
                        'goof_gid' => $value['goods_id'],
                        'goo_name' => $value['goods_name'],
                        'goo_number' => $value['goods_code'],
                        'goof_sum' => $value['det_real_actuals']
                    ]);
            }
            //更新trace_goods_flow_info
            $sql = "SELECT *
                        FROM trace_goods_flow_info
                        WHERE gofi_gid={$value['goods_id']}";
            $info_row = DB::select($sql);
            $validity_period = DB::table('goods')
                ->where('goo_cid',$find_adm['adm_cid'])
                ->where('goo_id',$value['goods_id'])
                ->value('validity_period');
            $production_date = DB::table('group')
                ->where('gro_cid',$find_adm['adm_cid'])
                ->where('gro_gid',$value['goods_id'])
                ->first(['production_date','expired_date']);
            if(!$info_row) {
                //insert
                DB::table('goods_flow_info')->insert([
                    'goof_id'=>$count,
                    'gofi_gid'=>$value['goods_id'],
                    'gofi_validity_period'=>$validity_period ? $validity_period : '',
                    'gofi_production_date'=>$production_date['production_date'] ? $production_date['production_date'] : '',
                    //'gofi_expired_date'=>date('Y-m-d',strtotime($value['production_date'])+3600*24*$value['validity_period']),
                    'gofi_expired_date'=>$production_date['expired_date'] ? $production_date['expired_date'] : '',
                    'gofi_sum'=>$value['det_real_actuals'],
                ]);
            }else{
                //update
                DB::update("UPDATE trace_goods_flow_info SET gofi_sum=gofi_sum+{$value['det_real_actuals']} WHERE goof_id={$info_row[0]['goof_id']}");
            }
            // 渠道表  追加商品库存量/商品入库量
            $add_lib = DB::update('UPDATE `trace_channels` SET `chan_stock_number`=`chan_stock_number`+'.$value['det_real_actuals'].' WHERE `chan_id`=?',[$pre_transport['channel_id_to']]);
        }
        // 用于日志
        $sn = DB::table('transport')
            ->where('id', $request['id'])
            ->value('sn');
        if ($transport && $transport_info) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '出入库管理', '入库', '系统编号为“'.$sn.'”的入库成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'入库成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前单号已入库']);
        }
    }
    //删除入库单
    public function delete(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['id']) || !is_array($request['id'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        //判断删除个数
        if (count($request['id']) > 1) {
            $find_class = DB::table('transport')->whereIn('id', $request['id'])->get(['sn','state_to']);
            $where_type = 'whereIn';
        } else {
            $find_class = DB::table('transport')->where('id', $request['id'])->get(['sn','state_to']);
            $where_type = 'where';
        }
        if (empty($find_class)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前出库单不存在或者已删除']);
        }
        $class_name = '';
        $istype = false;
        foreach ($find_class as $key=>$value) {
            if ($value['state_to'] != 2) {
                $istype = true;
            }
            $class_name .= $value['sn'].',';
        }
        if ($istype) {
            $res = DB::table('transport')
                ->where('company_id', $find_adm['adm_cid'])
                ->$where_type('id', $request['id'])
                ->update(['state_to'=>2]);
        } else {
            $res = true;
        }
        if (!empty($res)) {
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '出库管理', '入库单删除', '删除“'.trim($class_name, ',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
        } else {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }
    public function objectToArray($object)
    {
        //先编码成json字符串，再解码成数组
        return json_decode(json_encode($object), true);
    }
    public function scan(Request $request)
    {
        $input = $request->only('code', 'api_token');
        $code = trim($input['code']);
        if (strpos($code, "\r\n") !== false) {
            $codes = explode("\r\n", $code);
        } elseif (strpos($code, "\n") !== false) {
            $codes = explode("\n", $code);
        } else {
            $codes = [$code];
        }
        foreach ($codes as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($codes[$key]);
                continue;
            }
            // 过滤二维码,统一返回纯数字的二维码
            $code_data = $this->filterCodeData($code);
            $fil_code[$key] = $code_data['data'];
            if ($code_data['code'] == 500) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>$code_data['data']]);
            }
        }
        // $code = implode(",", $fil_code);
        $code_start = $this->filterCodeData($request->input('code'));
        if (strpos($code_start['data'], "\r\n") !== false) {
            $code_start['data'] = explode("\r\n", $code_start['data']);
        } elseif (strpos($code_start['data'], "\n") !== false) {
            $code_start['data'] = explode("\n", $code_start['data']);
        } else {
            $code_start['data'] = [$code_start['data']];
        }
        foreach ($code_start['data'] as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($code_start['data'][$key]);
                continue;
            }
            $fil_code[$key] = $code_data['data'];
        }
        $code_end = $this->filterCodeData($request->input('code'));
        if (strpos($code_end['data'], "\r\n") !== false) {
            $code_end['data'] = explode("\r\n", $code_end['data']);
        } elseif (strpos($code_end['data'], "\n") !== false) {
            $code_end['data'] = explode("\n", $code_end['data']);
        } else {
            $code_end['data'] = [$code_end['data']];
        }
        foreach ($code_end['data'] as $key => &$code) {
            //过滤空值
            if (!$code) {
                unset($code_end['data'][$key]);
                continue;
            }
            $fil_code[$key] = $code_data['data'];
        }
        $code = implode(",", $fil_code);
        $codes=explode(",", trim($code, ","));
        if (empty($codes)) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        }
        // $code = VerifyCodeController::validator($code);
        // if(!$code) {
        //     return response()->json(['code' => 500, 'msg' => 'error2', 'data' => []]);
        // }
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $company_id = $find_adm['adm_cid'];
        $num = 0;
        $whereArray = [];
        foreach ($codes as $code) {
            $tab_codeid = substr($code, 0, 5);    //二维码标识
            $tab_yemo =  substr($code, 5, 4);     //年月
            // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
            if ($num == 0) {
                $table_name = $tab_codeid.$tab_yemo;
                $tab_tablename = DB::table('table_link')
                    ->where('tab_codeid', $tab_codeid)
                    ->where('tab_yemo', $tab_yemo)
                    ->select('tab_tablenam')
                    ->first();
                $codePrefix = $tab_tablename['tab_tablenam'];
            } else {
                if ($table_name == $tab_codeid.$tab_yemo) {
                } else {
                    $tab_tablename = DB::table('table_link')
                        ->where('tab_codeid', $tab_codeid)
                        ->where('tab_yemo', $tab_yemo)
                        ->select('tab_tablenam')
                        ->first();
                    $codePrefix = $tab_tablename['tab_tablenam'];
                }
            }
            $num++;
            $whereArray[$codePrefix][] = $code;
        }
        //判断技师是否安装
        $tech = DB::table('warranty')
            ->where('warr_cid', $company_id)
            ->where('code', $code)
            ->value('code');
        if ($tech) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'技师安装,不能再次出入库']);
        }
        if (strpos($code, 'G') === 0) {
            $RelationObj = RelationCodeModel::where('code', $code)->first();
            //查询该箱中的产品数量
            $sql = "SELECT COUNT(*) as num
                    FROM trace_2019_code
                    WHERE company_id=$company_id AND relation_chain regexp ',{$RelationObj->id},'";
            $num = DB::select($sql);
            if (is_array($num) and count($num) > 0) {
                $res_data = array(
                    'name' => $code,
                    'code' => $code,
                    'num' => $num[0]['num']
                );
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $res_data]);
            } else {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
            }
        } else {
            //todo 修改查询方式
            $code_len = strlen($code);
            $name = DB::table('group as a')
                ->leftjoin('goods as b', 'a.gro_gid', '=', 'b.goo_id')
                ->where('code_start', '<=', $code_start['data'])
                ->where('code_end', '>=', $code_end['data'])
                ->get(['b.goo_name as name','a.gro_id','a.gro_gid','b.goo_number','a.gro_time','b.warranty_day','b.validity_period','a.production_date']);
            if (is_array($name) and count($name) > 0) {
                //生成trace_2019_code
                $exist_code = Code::where('code', $codes)->get();
                if (!$exist_code or count($exist_code) < 1) {
                    foreach ($whereArray as $k => $v) {
                        $sql = "INSERT INTO trace_2019_code (`code`,`company_id`,`group_id`,`goods_id`,`goods_name`,`goods_code`,`relation_code`,`relation_chain`,`validity_period`,`production_date`) VALUES ";
                        foreach ($v as $kk => $val) {
                            $sql = $sql . "('" . $val . "','".$find_adm['adm_cid']."','".$name[0]['gro_id']."','".$name[0]['gro_gid']."','".$name[0]['name']."','".$name[0]['goo_number']."','','','".$name[0]['validity_period']."','".$name[0]['production_date']."'),";
                        }
                        $sql = trim($sql, ",") . ";";
                        $grores = DB::insert($sql);
                        unset($sql);
                    }
                }
                $res_data = array(
                    'name' => $name[0]['name'],
                    'gro_time' => $name[0]['gro_time'],
                    'code' => $codes,
                    'num' => 1
                );
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $res_data]);
            } else {
                return response()->json(['code' => 501, 'msg' => 'error', 'data' => []]);
            }
        }
    }
    public function scanlist(Request $request)
    {
        $input = $request->only('relation_code');
        $relation_code = VerifyCodeController::validator(trim($input['relation_code']));
        if (empty($relation_code) or strpos($relation_code, 'G') !== 0) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        }
        $RelationObj = RelationCodeModel::where('code', $relation_code)->first();

        //step.1.找出直接商品
        $sql = "SELECT MIN(goods_name) as name, MIN(code) as code, count(*) as num
                from trace_2019_code
                WHERE relation_code={$RelationObj->id}
                GROUP BY goods_id";
        $goods_list = DB::select($sql);

        //step.2.找出直接箱码
        $sql = "SELECT MIN(b.goods_name) as name, a.code,count(1) as num
                from trace_relation_code a
                left join trace_2019_code b on b.relation_chain regexp concat(',',a.id,',')
                where a.up_code = {$RelationObj->id}
                GROUP BY a.code";
        $relation_list = DB::select($sql);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => array_merge($goods_list, $relation_list)]);
    }
    // 生成系统编号
    public function sysNum(Request $request)
    {
        // 验证数据 1.出库系统编号   2.入库系统编号
        if (empty($request->input('type')) || !in_array($request->input('type'), array(1,2))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        if ($request->input('type') == 1) {
            $code = 'CK'.date('YmdHis').rand(1000, 9999);
        } elseif ($request->input('type') == 2) {
            $code = 'RK'.date('YmdHis').rand(1000, 9999);
        }
        return response()->json(['code'=> 200,'msg'=>'success','data'=>'编号生成成功','number'=>$code]);
    }
    /**
     * 过滤二维码,统一返回纯数字的二维码
     * @param string $codeData
     *      http://xxxx.com?二维码& |  二维码&
     * @return mixed|string
     * @throws Exception
     */
    private function filterCodeData($codeData = "")
    {
        if (!$codeData) {
            return ['code'=>500,'msg'=>'error','data'=>'参数不可为空!'];
        }
        if (!is_string($codeData)) {
            return ['code'=>500,'msg'=>'error','data'=>'参数类型错误!'];
        }

        $codeData = rtrim($codeData, "&");
        //带链接的二维码
        if (($pos = strpos($codeData, "?")) !== false) {
            return ['code'=>200,'msg'=>'success','data'=>substr_replace($codeData, "", 0, $pos + 1)];
        }

        //不带链接的二维码
        return ['code'=>200,'msg'=>'success','data'=>$codeData];
    }

    // 获取出库商品信息
    public function getGoodsInfos(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $input = $request->all();
        $list = DB::table('goods')
            ->where('goo_cid', $find_adm['adm_cid'])
            ->where('del_type', 1)
            ->where(function ($query) use ($input) {
                if (!empty($input['goo_name'])) {
                    $query->where('goo_name', 'like', '%'.$input['goo_name'].'%');
                }
            })
            ->select('goo_id', 'goo_name', 'goo_number')
            ->orderBy('goo_id', 'desc')
            ->paginate($this->show_count);
        $listData['current_page'] = $list->currentPage();
        $listData['total'] = $list->total();
        $listData['current_number'] = $this->show_count;
        $listData['last_page'] = $list->lastPage();
        $listData['data_info'] = $list->items();
        return response()->json(['code'=>200,'data'=>'获取出库单列表','data_info'=>$listData]);
    }
}
