<?php
namespace App\Http\Controllers\Ware;

use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Verify\VerifyCodeController;
use App\Http\Models\Code;
use Illuminate\Http\Response;
use Mockery\Exception;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Db;
use Illuminate\Support\Facades\Session;
use App\Http\Models\OrdermanageModel;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Crypt;
use Excel;
use AuthenticatesUsers;
use Illuminate\Contracts\Support\JsonableInterface;

use Carbon\Carbon;
use Storage;

use App\Http\Controllers\CommonController;


class ChannelYunCangController extends Controller{
	// 列表每页显示数据个数
    protected $show_count = 10;

    public function Channel_YunCang(Request $request)
    {
        //根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $search_data = $request->all();
        $list = DB::table('channels as a')
            ->leftJoin('channels as c', 'c.chan_id', '=', 'a.chan_parent_id')
            ->where('a.chan_cid',$find_adm['adm_cid'])
            ->where(function($query) use($find_adm) {
                if ($find_adm['adm_chan_id'] > 0) {
                    $query->where('a.chan_id', $find_adm['adm_chan_id']);
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['chan_enterprise_name'])) {
                    $query->where('a.chan_enterprise_name', 'like' , '%'.$search_data['chan_enterprise_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                // 隶属渠道商
                if (!empty($search_data['chan_parent_id'])) {
                    $query->where('c.chan_enterprise_name', 'like' , '%'.$search_data['chan_parent_id'].'%' );
                }
            })
            //->select('a.chan_id','c.chan_enterprise_name as parent_enterprise_name','a.chan_enterprise_name','a.chan_stock_number')
            ->select('a.chan_id','c.chan_enterprise_name as parent_enterprise_name','a.chan_enterprise_name','a.chan_name','a.chan_phone','a.chan_address','a.chan_state','a.chan_integral','a.chan_addtime','a.chan_stock_number')
            ->orderBy('a.chan_id','desc')
            ->paginate($this->show_count);
        $data_info['current_page'] = $list->currentPage();  //当前页面页码
        $data_info['last_page'] = $list->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list->items();                //返回数据

        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);

        if($data_info) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }
}