<?php

namespace App\Http\Controllers\Verify\Zero;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

// 关联码验证器
class VerifyRelationcodeController extends Controller
{
    // 关联码列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.numeric' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    //发码验证器
    public function creatValidator($data)
    {
        //自定义错误信息
        // 自定义错误消息
        $messages = [
            'codes_num.required' => '请输入:发码数量',
            'codes_num.numeric' => '数据类型不正确',
            'max_num.required' => '请输入:装载数量',
            'max_num.numeric' => '数据类型不正确',
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            'codes_num' => 'required|numeric',
            'max_num' => 'required|numeric',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    //编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '参数错误',
            'id.numeric' => '数据类型不正确',
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|numeric',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    //关联码开启/关闭查询验证器
    public function openValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '参数错误',
            'id.array' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|array'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }
}
