<?php

namespace App\Http\Controllers\Verify;

use App\Http\Controllers\Controller;

class VerifyCodeController extends Controller
{
    // 产品码、关联码验证器
    public static function validator($code)
    {
        //产品码组成结构：公司ID(5位)+年月(4位)+商品编码[13位]+顺序编号(8位)+验证位(3位)
        //验证规则：md5(公司ID(5位)+年月(4位)+商品编码[13位]+顺序编号(8位))后，取出前三个数字，与验证位对比
        //code一般是个网址：http://test.bluearp.com/sy.php?code=500121908690000000011100000001741&
        preg_match('/.+\?(G?\d+)&?$/i',$code,$code_matches);
        if(!$code_matches) {
            if(!preg_match('/^G?\d+$/',$code)) {
                return false;
            }
        }else {
            $code = $code_matches[1];
        }
        $code = trim($code);
        $code_len = strlen($code);
        $verify_code = substr($code,-3);
        $code_clean = substr($code,0,$code_len-3);
        /*
        //箱码位数不确定呢
        if ($code_len != 20 AND $code_len != 33) {
            return false;
        }
        //必须为纯数字
        if(!preg_match('/^\d*$/',$code)) {
            return false;
        }
        */
        $md5_num = substr(preg_replace('/[^\d]/','',md5($code_clean)),0,3);
        if($md5_num != $verify_code) {
            return false;
        }else {
            return $code;
        }
    }

    //生成码的校验位
    public static function generateVerify($code, $len=3) {
        if(!$code) {
            return '';
        }
        $md5_num = substr(preg_replace('/[^\d]/','',md5($code)),0,$len);
        return $md5_num;
    }
}
