<?php

namespace App\Http\Controllers\Verify\Source;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

class VerifyTemplateController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 添加验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tem_name.required' => '请输入:模板名称',
            'tem_name.max' => '模板名称长度超过最大限制',
            'tem_type.required' => '参数错误',
            'tem_type.integer' => '参数类型错误',
            'tem_img.required' => '参数错误',
            'tem_img.integer' => '参数类型错误',
            'tem_type_swaitch.required' => '参数错误',
            'tem_type_swaitch.integer' => '参数类型错误',
            'formkey.required' => '参数错误',
            'formkey.array' => '参数错误',
            'formshow.required' => '参数错误',
            'formshow.array' => '参数错误',
            'formtype.required' => '参数错误',
            'formtype.array' => '参数错误',
            'formvalue.required' => '参数错误',
            'formvalue.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tem_name' => 'required|max:15',
            'tem_type' => 'required|integer',
            'tem_img' => 'required|integer',
            'tem_type_swaitch' => 'required|integer',
            'formkey' => 'required|array',
            'formshow' => 'required|array',
            'formtype' => 'required|array',
            'formvalue' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tem_id.required' => '参数错误',
            'tem_id.numeric' => '参数错误',
            'tem_name.required' => '请输入:模板名称',
            'tem_name.max' => '模板名称长度超过最大限制',
            'tem_type.required' => '参数错误',
            'tem_type.integer' => '参数类型错误',
            'tem_img.required' => '参数错误',
            'tem_img.integer' => '参数类型错误',
            'tem_type_swaitch.required' => '参数错误',
            'tem_type_swaitch.integer' => '参数类型错误',
            'formkey.required' => '参数错误',
            'formkey.array' => '参数错误',
            'formshow.required' => '参数错误',
            'formshow.array' => '参数错误',
            'formtype.required' => '参数错误',
            'formtype.array' => '参数错误',
            'formvalue.required' => '参数错误',
            'formvalue.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tem_id' => 'required|numeric',
            'tem_name' => 'required|max:15',
            'tem_type' => 'required|integer',
            'tem_img' => 'required|integer',
            'tem_type_swaitch' => 'required|integer',
            'formkey' => 'required|array',
            'formshow' => 'required|array',
            'formtype' => 'required|array',
            'formvalue' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tem_id.required' => '参数错误',
            'tem_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tem_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
