<?php
namespace App\Http\Controllers\Verify\Lore;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

class VerifyRegisterController extends Controller
{
    // 注册验证器
    public function registerValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'com_name.required' => '请输入：公司名称',
            'com_name.max' => '公司名称长度超过最大限制',
            'adm_username.required' => '请输入：联系人姓名',
            'adm_username.max' => '联系人姓名长度超过最大限制',
            'adm_tel.required' => '请输入：联系电话',
            'adm_tel.regex' => '手机格式不正确',
            'adm_code.required' => '请输入：验证码',
            'adm_code.integer' => '参数类型错误',
            'adm_code.min' => '参数错误',
            'adm_pas.required' => '请输入：密码',
            'adm_pas.regex' => '密码由6-15位数字或字母,或下划线组成！',
            'info_province.required' => '请输入：省',
            'info_province.max' => '参数错误',
            'info_city.required' => '请输入：市',
            'info_city.max' => '参数错误',
            'info_county.required' => '请输入：区',
            'info_county.max' => '参数类型错误',
            'info_address.required' => '请输入：公司地址',
            'info_address.max' => '公司地址长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'com_name' => 'required|max:100',
            'adm_username' => 'required|max:100',
            'adm_tel' => ['required','regex:/^1[23456789]\d{9}$/'],
            'adm_code' => 'required|integer|min:1',
            'adm_pas' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'info_province' => 'required|max:255',
            'info_city' => 'required|max:255',
            'info_county' => 'sometimes|max:255',
            'info_address' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 开始试用验证器
    public function startTheTrialValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_module.required' => '参数错误',
            'adm_module.integer' => '参数类型错误',
            'adm_module.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_module' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fom_id.required' => '参数错误',
            'fom_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fom_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
