<?php

namespace App\Http\Controllers\Verify\Integral;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

// 兑换公告验证器
class VerifyForItemController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.numeric' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 添加验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fori_item_name.required' => '参数错误',
            'fori_item_name.max' => '物品名称长度超过最大限制',
            'fori_number.required' => '参数错误',
            'fori_number.numeric' => '参数错误',
            'fori_integral_number.required' => '参数错误',
            'fori_integral_number.numeric' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fori_item_name' => 'required|max:50',
            'fori_number' => 'required|numeric',
            'fori_integral_number' => 'required|numeric',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fori_id.required' => '参数错误',
            'fori_id.numeric' => '参数错误',
            'fori_item_name.required' => '参数错误',
            'fori_item_name.max' => '物品名称长度超过最大限制',
            'fori_number.required' => '参数错误',
            'fori_number.numeric' => '参数错误',
            'fori_integral_number.required' => '参数错误',
            'fori_integral_number.numeric' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fori_id' => 'required|numeric',
            'fori_item_name' => 'required|max:50',
            'fori_number' => 'required|numeric',
            'fori_integral_number' => 'required|numeric',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 上架/下架/删除
    public function putawayValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fori_id.required' => '参数错误',
            'fori_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fori_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }
}
