<?php

namespace App\Http\Controllers\Verify\Channels;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

// 渠道商验证器
class VerifyChannelsController extends Controller
{
    // 渠道商列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.numeric' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 渠道商新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chan_enterprise_name.required' => '请输入:渠道商名称',
            'chan_enterprise_name.max' => '渠道商名称长度超过最大限制',
            'chan_name.required' => '请输入:联系人姓名',
            'chan_name.max' => '联系人姓名长度超过最大限制',
            'chan_phone.required' => '请输入:联系人电话',
            'chan_phone.regex' => '手机号格式不正确',
            'chan_address.required' => '请输入:渠道商地址',
            'chan_address.max' => '地址长度超过最大限制',
            'chan_label.required' => '请输入:选择渠道标签',
            'chan_label.numeric' => '数据类型不正确'
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            'chan_enterprise_name' => 'required|max:30',
            'chan_name' => 'required|max:50',
            'chan_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'chan_label' => 'sometimes|required|numeric',
            'chan_address' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 渠道商编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chan_id.required' => '参数错误',
            'chan_id.numeric' => '参数错误',
            'chan_enterprise_name.required' => '请输入:渠道商名称',
            'chan_enterprise_name.max' => '渠道商名称长度超过最大限制',
            'chan_name.required' => '请输入:联系人姓名',
            'chan_name.max' => '联系人姓名长度超过最大限制',
            'chan_phone.required' => '请输入:联系人电话',
            'chan_phone.regex' => '手机号格式不正确',
            'chan_address.required' => '请输入:渠道商地址',
            'chan_address.max' => '地址长度超过最大限制',
            'chan_label.required' => '请输入:选择渠道标签',
            'chan_label.numeric' => '数据类型不正确'
        ];

        // regex:pattern
        // 验证的字段必须与给定的正则表达式匹配。
        // 注意： 当使用 regex 规则时，你必须使用数组，而不是使用 | 分隔符，特别是如果正则表达式包含 | 字符。
        // sometimes  只有在该字段存在于数组中时， 才可以对字段执行验证检查

        // 数据验证
        $validator = Validator::make($data, [
            'chan_id' => 'required|numeric',
            'chan_enterprise_name' => 'required|max:30',
            'chan_name' => 'required|max:50',
            'chan_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'chan_label' => 'sometimes|required|numeric',
            'chan_address' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 渠道商启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chan_id.required' => '参数错误',
            'chan_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chan_id' => 'required|array'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 渠道商重置密码验证器
    public function resetPasswordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chan_id.required' => '参数错误',
            'chan_id.numeric' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chan_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 积分操作验证器
    public function integralValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chan_id.required' => '参数错误',
            'chan_id.numeric' => '参数错误',
            // 'integral_number.required' => '请输入:积分值',
            // 'integral_number.integer' => '请输入整数',
            // 'content.required' => '请输入操作内容',
            // 'content.max' => '长度超过最大限制'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chan_id' => 'required|numeric',
            // 'integral_number' => 'required|integer',
            // 'content' => 'required|max:255'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }
}
