<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Crypt;
use DB;
use App\Http\Models\Coperationa;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Verify\Source\VerifyTemplateController;

class TemplateController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 模板列表主页
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTemplateController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        //根据token获取用户信息
        $user = Coperationa::getUserInfo($request->input('api_token'));

        $teminfo = $request->all();
        $data = DB::table('formwork_template')
            ->where(function($query) use($teminfo) {
                if (!empty($teminfo['tem_name'] )) {
                    $query->where('tem_name', 'like' , '%'.$teminfo['tem_name'].'%' );
                }
            })
            ->where(function($query) use($teminfo) {
                if (!empty($teminfo['tem_state'] )) {
                    $query->where('tem_state',$teminfo['tem_state']);
                }
            })
            ->where(function($query) use($teminfo) {
                //如果选择开始时间并且选择结束时间
                if (!empty($teminfo['tem_addtime_range0'] && $teminfo['tem_addtime_range1'])){
                    $query->whereBetween('tem_addtime',[$teminfo['tem_addtime_range0'],$teminfo['tem_addtime_range1'].' 23:59:59']);
                }else{
                    // 如果选择开始时间
                    if (!empty($teminfo['tem_addtime_range0'])){
                        $query->where('tem_addtime','>=',$teminfo['tem_addtime_range0'].' 23:59:59');
                    }else{
                        // 如果选择结束时间
                        if (!empty($teminfo['tem_addtime_range1'])) {
                            $query->where('tem_addtime','<=',$teminfo['tem_addtime_range1'].' 23:59:59');
                        }
                    }
                }
            })
            ->where('tem_state','!=',3)
            ->where('tem_cid',$user['adm_cid'])
            ->orderBy('tem_id','desc')
            ->select('tem_id','tem_name','tem_addtime','tem_state','tem_total','tem_type')
            ->paginate($this->show_count);
        $data_info['current_page'] = $data->currentPage();  //当前页面页码
        $data_info['last_page'] = $data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;   //一页显示多少个
        $data_info['data'] = $data->items();                //返回数据
        $data_info['tem_cid'] = $user['adm_cid'];       //判断是否只有查看的权限

        $data_info['button'] = wherebutton($request['api_token'],$request['pri_id']);
        // 获取当前列表下的按钮
        if($data_info) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'模板列表获取成功','data_info'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'模板列表获取失败']);
        }
    }
    // 获取标签/渠道列表-----用于添加
    public function labelist(Request $request)
    {
        $user = Coperationa::getUserInfo($request->input('api_token'));
        if (!$user) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        if ($user['adm_id'] == '1'){
            $data['tem_cid'] = DB::table('admin')->where('adm_cid',$user['adm_cid'])->value('adm_cid');
        }
        // 渠道标签
        $data['channels_label'] = DB::table('channels_label')->where(['label_cid'=>1,'label_state'=>1])->select('label_id','label_name')->get();
        // 渠道商列表
        $data['channels'] = DB::table('channels')->where(['chan_cid'=>$user['adm_cid'],'chan_state'=>1])->select('chan_id','chan_enterprise_name','chan_label')->get();
        // 角色管理
        $data['role'] = DB::table('role')->where(['rol_cid'=>$user['adm_cid'],'rol_sta'=>1])->select('rol_id','rol_name')->get();
        $data['admin'] = DB::table('admin')->where(['adm_cid'=>$user['adm_cid'],'adm_stase'=>1])->select('adm_id','adm_name','adm_pre')->get();
        return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
    }
    // 新增
    public function addtem(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTemplateController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        //根据token获取用户信息
        $user = Coperationa::getUserInfo($request->input('api_token'));

        //判断模板名称是否存在
        $tem_name = DB::table('formwork_template')
            ->where('tem_name',trim($request['tem_name']))
            ->where('tem_state','<>',3)
            ->where('tem_cid',$user['adm_cid'])
            ->select('tem_name')
            ->first();
        if ($tem_name) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'模板名称已经存在']);
        }
        foreach ($request['formkey'] as $k => $v) {
            $arr[$k]['key']     = $request['formkey'][$k];     //信息项标题
            $arr[$k]['show']    = $request['formshow'][$k];    //显示隐藏
            $arr[$k]['type']    = $request['formtype'][$k];    //属性类型
            $arr[$k]['value']   = $request['formvalue'][$k];   //信息项内容            
        }
        $fote_add_data['tem_name'] = $request['tem_name'];
        $fote_add_data['tem_content'] = json_encode($arr);
        $fote_add_data['tem_state'] = 1;
        $fote_add_data['tem_cid'] = $user['adm_cid'];
        $fote_add_data['tem_addtime'] = date("Y-m-d H:i:s");
        $fote_add_data['tem_type'] = $request['tem_type'] ? $request['tem_type'] : 3;
        $fote_add_data['tem_img'] = $request['tem_img'];
        $fote_add_data['tem_type_swaitch'] = $request['tem_type_swaitch'];
        $fote_data = DB::table('formwork_template')->insert($fote_add_data);
        if ($fote_data) {
            Coperationa::add($user['adm_id'],$request->getClientIp(),'溯源管理->模板列表','新增','新增'.$request['tem_name'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'添加成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加失败']);
        }
    }
    // 修改
    public function edittem(Request $request)
    {
        //根据token获取用户信息
        $user = Coperationa::getUserInfo($request->input('api_token'));

        $data = DB::table('formwork_template')
            ->where('tem_id',$request['tem_id'])
            ->select('tem_id','tem_name','tem_content','tem_addtime','tem_img','tem_type_swaitch','tem_type')
            ->first();
        if (!$data) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'模板列表获取失败']);
        }
        // 渠道
        $channel = DB::table('channels')->where(['chan_cid'=>$user['adm_cid'],'chan_state'=>1])->get(['chan_id','chan_enterprise_name','chan_label']);
        // 渠道标签
        $channels_label = DB::table('channels_label')->where(['label_cid'=>1,'label_state'=>1])->get(['label_id','label_name']);
        // 角色管理
        $role = DB::table('role')->where(['rol_cid'=>$user['adm_cid'],'rol_sta'=>1])->get(['rol_id','rol_name']);
        $admin = DB::table('admin')->where(['adm_cid'=>$user['adm_cid'],'adm_stase'=>1])->get(['adm_id','adm_name','adm_pre']);
        $data['tem_content'] = object_array(json_decode($data['tem_content']));
        if ($data) {
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        } else {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'模板列表获取失败']);
        }
    }
    // 执行修改模板列表
    public function doedittem(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTemplateController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        //根据token获取用户信息
        $user = Coperationa::getUserInfo($request->input('api_token'));

        // 判断模板名称是否存在
        $tem_name = DB::table('formwork_template')
            ->where('tem_name',trim($request['tem_name']))
            ->where('tem_id','<>',$request['tem_id'])
            ->where('tem_state','<>',3)
            ->where('tem_cid',$user['adm_cid'])
            ->select('tem_name')
            ->first();
        if ($tem_name) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'模板名称已经存在']);
        }

        foreach ($request['formkey'] as $k => $v) {
            $arr[$k]['key']     = $request['formkey'][$k];     //信息项标题
            $arr[$k]['show']    = $request['formshow'][$k];    //显示隐藏
            $arr[$k]['type']    = $request['formtype'][$k];    //属性类型
            $arr[$k]['value']   = $request['formvalue'][$k];   //信息项内容            
        }
        $fote_edit_data['tem_name'] = $request['tem_name'];
        $fote_edit_data['tem_content'] = json_encode($arr);
        $fote_edit_data['tem_state'] = 1;
        $fote_edit_data['tem_cid'] = $user['adm_cid'];
        $fote_edit_data['tem_update_time'] = date("Y-m-d H:i:s");
        $fote_edit_data['tem_type'] = $request['tem_type'] ? $request['tem_type'] : 3;
        $fote_edit_data['tem_img'] = $request['tem_img'];
        $fote_edit_data['tem_type_swaitch'] = $request['tem_type_swaitch'];
        $fote_data = DB::table('formwork_template')
            ->where('tem_id',$request['tem_id'])
            ->update($fote_edit_data);
        if($fote_data){
            Coperationa::add($user['adm_id'],$request->getClientIp(),'溯源管理->模板列表','修改','修改'.$request['tem_name'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑溯源模板成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑溯源模板失败']);
        }
    }

    // 启用
    public function enable(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTemplateController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号
        $find_adm = Coperationa::getUserInfo($request['api_token']);

        // 查询信息
        $find_template = DB::table('formwork_template')
            ->whereIn('tem_id',$request['tem_id'])
            ->select('tem_name')
            ->get();
        foreach ($find_template as $key => $value) {
            $tem_name[] = $value['tem_name'];
        }

        //启用
        $update_data['tem_state'] = 1;  //状态1启用2停用
        $update_data['tem_update_time'] = date('Y-m-d H:i:s');
        $tem_res = DB::table('formwork_template')
            ->whereIn('tem_id',$request['tem_id'])
            ->update($update_data);
        if ($tem_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'模板列表','启用','模板：（'.implode(',', $tem_name).'）启用成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'模板启用成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'模板启用失败']);
        }
    }

    //停用
    public function disable(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTemplateController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号
        $find_adm = Coperationa::getUserInfo($request['api_token']);

        // 查询信息
        $find_template = DB::table('formwork_template')
            ->whereIn('tem_id',$request['tem_id'])
            ->select('tem_name')
            ->get();
        foreach ($find_template as $key => $value) {
            $tem_name[] = $value['tem_name'];
        }

        //停用
        $update_data['tem_state'] = 2;  //状态1启用2停用
        $update_data['tem_update_time'] = date('Y-m-d H:i:s');
        $tem_res = DB::table('formwork_template')
            ->whereIn('tem_id',$request['tem_id'])
            ->update($update_data);
        if ($tem_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'模板列表','停用','模板：（'.implode(',', $tem_name).'）停用成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'模板停用成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'模板停用失败']);
        }
    }

    // 删除状态
    public function deltem(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $tem_id = $request['tem_id'];
        if(empty($tem_id )) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 判断删除个数
        if (count($request->input('tem_id')) > 1) {
            $find_tem = DB::table('formwork_template')->whereIn('tem_id', $request->input('tem_id'))->get(['tem_name']);
            $where_type = 'whereIn';
        }else{
            $where_type = 'where';
            $find_tem = DB::table('formwork_template')->where('tem_id', $request->input('tem_id'))->get(['tem_name']);
        }

        if (empty($find_tem)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前模板不存在或者已删除']);
        }
        // 判断模版是否绑定溯源信息
        $find_fomwork = DB::table('formwork as f')
                        ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
                        ->where('fom_cid',$find_adm['adm_cid'])
                        ->$where_type('fom_temid',$request->input('tem_id'))
                        ->where('fom_stase',1)
                        ->where('tem_state','<>',3)
                        ->get(['fom_title','tem_name']);
        if(!empty($find_fomwork)){
            foreach ($find_fomwork as $key => $value) {
                 return response()->json(["code"=>500,'msg'=>'error','data'=>'模板('.$value['tem_name'].')下绑定了溯源信息('.$value['fom_title'].')不能被删除']);
                 die;
            }
        }

        DB::beginTransaction();
        $res = DB::table('formwork_template')
                ->where('tem_cid',$find_adm['adm_cid'])
                ->$where_type('tem_id',$request->input('tem_id'))
                ->update(['tem_state'=>'3']);
        $tem_name = '';
        foreach ($find_tem as $key => $value) {
            $tem_name .= $value['tem_name'].',';
        }
        if($res) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->模板列表','删除','删除“'.trim($tem_name,',').'”成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'模板删除成功']);
        }else{
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'模板删除失败']);
        }
    }
    // 复制
    public function copytem(Request $request)
    {
        $user = Coperationa::getUserInfo($request->input('api_token'));
        if (!$user) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $tem_id = $request['tem_id'];
        $template = DB::table('formwork_template')->where('tem_id',$tem_id)->first();
        $content = json_decode($template['tem_content'],true);
        
        // 获取复制的 模板名称
        if(strpos($template['tem_name'],'--副本')){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请编辑去掉信息中的"--副本"']);
        }else{
            $name = $template['tem_name'].'--副本';
        }
        $res_name = DB::table('formwork_template')->where("tem_name",'like',$name.'%')->select('tem_name')->orderBy('tem_id','desc')->first();
        if (!empty($res_name)) {
            if ($name != $res_name['tem_name']) {
                $str = (int)substr($res_name['tem_name'],strrpos($res_name['tem_name'],'+')+1);
                if ($str >= 30) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'最多复制30个']);
                }
                $name = $name . "+" . (++$str);
            }else{
                $name = $name . "+1";
            }
        }
        $res = DB::table('formwork_template')->insert([
                                                'tem_name'    => $name,
                                                // 'tem_canid'   => $template['tem_canid'],    //使用范围1内部使用2外部使用
                                                // 'tem_labelid' => $template['tem_labelid'],  //渠道标签id
                                                // 'tem_canids'  => $template['tem_canids'],   //渠道id
                                                'tem_content' => json_encode($content),
                                                'tem_state'   => $template['tem_state'],
                                                'tem_cid'     => $template['tem_cid'],
                                                'tem_type'    => $template['tem_type'],
                                                'tem_addtime' => date('Y-m-d H:i:s'),
                                                // 'tem_rolid'   => $template['tem_rolid'],
                                                // 'tem_admid'   => $template['tem_admid'],
                                                'tem_img'     => $template['tem_img'],
                                                'tem_type_swaitch' => $template['tem_type_swaitch']
                                                ]);
        
        if ($res) {
            Coperationa::add($user['adm_id'],$request->getClientIp(),'溯源管理->模板列表','复制','复制模板列表');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'复制模板列表成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'复制模板列表失败']);
        }
    }
}
