<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Contracts\Support\JsonableInterface;
use App\Http\Controllers\Verify\Source\VerifyTagController;

use App\Http\Models\Coperationa;
// 标签管理
class TagController extends Controller
{
	// 列表每页显示数据个数
	protected $show_count = 10;
	// 列表查询
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTagController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		$data = $request->all();
		$list = DB::table('form_label')
            ->where('lab_cid', $find_adm['adm_cid'])
            ->where(function($query) use($data) {
                if (!empty($data['lab_stase'] )) {
                    $query->where('lab_stase', '=' ,$data['lab_stase'] );
                }
            })
            ->where(function($query) use($data) {
                if (!empty($data['lab_name'] )) {
                    $query->where('lab_name', 'like' , '%'.$data['lab_name'].'%' );
                }
            })
            ->select('lab_id','lab_name','lab_stase','lab_total','lab_picurl','lab_type')
            ->orderBy('lab_id','desc')
            ->paginate($this->show_count);
		$listData['current_page'] = $list->currentPage();
		$listData['total'] = $list->total();
		$listData['data'] = $list->items();
		$listData['current_number'] = $this->show_count;
		$listData['last_page'] = $list->lastPage();
		$listData['code'] = 200;
		$listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        if ($find_adm['adm_id'] == '1') {
            $listData['lab_cid'] = DB::table('admin')->where('adm_cid',$find_adm['adm_cid'])->value('adm_cid');
        }
		return response()->json($listData);
    }

	// 添加
	public function addtag(Request $request)
	{
        // 验证数据
        $verify_data = new VerifyTagController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断标签名是否存在
		$find_label = DB::table('form_label')
			->where('lab_cid',$find_adm['adm_cid'])
			->where('lab_name',trim($request['lab_name']))
            ->select('lab_id')
			->first();
		if ($find_label) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'标签名称已存在，请重新添加']);
		}
		$lab_picurl = '';
		if (!empty($request->input('lab_picurl'))) {
			// 上传图片
			$uploadImg = new CommonController;
			foreach ($request->input('lab_picurl') as $key => $value) {
				$uploadPath = $uploadImg->uploadBase64Img($value);
				if ($uploadPath) {
					$lab_picurl .= $uploadPath.',';
				}else{
					return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
				}
			}
			$lab_picurl = trim($lab_picurl,',');
		}
		$time = date('Y-m-d H:i:s');
		$fola_add_data['lab_name'] = $request['lab_name'];
		$fola_add_data['lab_stase'] = $request['lab_stase'];
		$fola_add_data['lab_time'] = $time;
		$fola_add_data['lab_cid'] = $find_adm['adm_cid'];
		$fola_add_data['lab_type'] = $request['lab_type'] ? $request['lab_type'] : 3;
		$fola_add_data['lab_picurl'] = $lab_picurl;
		$fola_res = DB::table('form_label')->insert($fola_add_data);
		if ($fola_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'标签列表','新增','新增“'.$request->input('lab_name').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
        } else {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
        }
	}

	// 编辑
	public function edittag(Request $request)
	{
        // 验证数据
        $verify_data = new VerifyTagController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		if ($request->input('type') == 1) {
			// 查询标签信息
			$find_lab = DB::table('form_label')
				->where('lab_id',$request->input('lab_id'))
				->where('lab_cid',$find_adm['adm_cid'])
                ->select('lab_name','lab_picurl','lab_stase','lab_type')
                ->get();
			$find_lab[0]['lab_picurl'] = explode(',', $find_lab[0]['lab_picurl']);
			$find_data['lab'] = $find_lab;
			return response()->json(['code'=>200,'msg'=>'success','data'=>$find_data]);
		}
		// 判断标签名是否存在
		$find_class = DB::table('form_label')
			->where('lab_cid',$find_adm['adm_cid'])
			->where('lab_name',trim($request['lab_name']))
			->where('lab_id','<>',$request['lab_id'])
            ->select('lab_id')
			->first();
		if ($find_class) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'标签名称已存在，请重新编辑']);
		}
		$lab_picurl = '';
		if (!empty($request->input('lab_picurl'))) {
			// 上传图片
			$uploadImg = new CommonController;
			foreach ($request->input('lab_picurl') as $key => $value) {
				if (substr($value,0,11) == 'data:image/') {
					$uploadPath = $uploadImg->uploadBase64Img($value);
					if ($uploadPath) {
						$lab_picurl .= $uploadPath.',';
					}else{
						return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
					}
				}else{
					$lab_picurl .= substr($value,strlen(config('app.url'))).',';
				}
			}
			$lab_picurl = trim($lab_picurl,',');
		}
		$time = date('Y-m-d H:i:s');
        $fola_edit_data['lab_name'] = $request['lab_name'];
        $fola_edit_data['lab_stase'] = $request['lab_stase'];
        $fola_edit_data['lab_time'] = $time;
        $fola_edit_data['lab_cid'] = $find_adm['adm_cid'];
        $fola_edit_data['lab_type'] = $request['lab_type'] ? $request['lab_type'] : 3;
        $fola_edit_data['lab_picurl'] = $lab_picurl;
        $fola_edit_data['lab_update_time'] = date('Y-m-d H:i:s');
        $fola_res = DB::table('form_label')
            ->where('lab_id',$request['lab_id'])
            ->update($fola_edit_data);
        if ($fola_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'标签列表','编辑','编辑“'.$request->input('lab_name').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
        } else {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑失败']);
        }
	}

	// 删除
    public function deltag(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTagController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
		
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

        //标签下有信息不得删除
        $find_formwork = DB::table('formwork')
            ->where('fom_cid',$find_adm['adm_cid'])
            ->where('fom_stase','<>',3)
            ->whereIn('fom_label',$request['lab_id'])
            ->select('fom_id')
            ->first();
        if ($find_formwork) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前标签已添加信息,无法删除']);
        }

        //查询信息
        $find_label = DB::table('form_label')
            ->whereIn('lab_id',$request['lab_id'])
            ->get();
        foreach ($find_label as $key => $value) {
            $lab_name[] = $value['lab_name'];
        }

        $lab_res = DB::table('form_label')
            ->whereIn('lab_id',$request['lab_id'])
            ->delete();

        if ($lab_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'标签列表','删除','删除','标签：（'.implode(',', $lab_name).'）删除成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }

    // 启用
    public function enable(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTagController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

        //查询信息
        $find_label = DB::table('form_label')
            ->whereIn('lab_id',$request['lab_id'])
            ->select('lab_name')
            ->get();
        foreach ($find_label as $key => $value) {
            $lab_name = $value['lab_name'];
        }

        //启用
        $update_data['lab_stase'] = 1;  //状态1启用2停用
        $update_data['lab_update_time'] = date('Y-m-d H:i:s');
        $lab_res = DB::table('form_label')
            ->whereIn('lab_id',$request['lab_id'])
            ->update($update_data);

        if ($lab_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'标签列表','启用','启用“'.trim($lab_name,',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'启用成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'启用失败']);
        }
    }

    // 停用
    public function disable(Request $request)
    {
    	// 验证数据
        $verify_data = new VerifyTagController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 查询信息
		$find_label = DB::table('form_label')
			->whereIn('lab_id',$request['lab_id'])
			->select('lab_name')
			->get();
		foreach ($find_label as $key => $value) {
			$lab_name = $value['lab_name'];
		}

		// 停用
        $update_data['lab_stase'] = 2;	//状态1启用2停用
        $update_data['lab_update_time'] = date('Y-m-d H:i:s');
		$lab_res = DB::table('form_label')
            ->whereIn('lab_id',$request['lab_id'])
            ->update($update_data);

        if ($lab_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'标签列表','停用','停用“'.trim($lab_name,',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'停用成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'停用失败']);
        }
    }
    
}