<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\Coperationa;

class RoleController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    public function roleindex(Request $request)
    {
        $role_info = $request->all();
        $role = Coperationa::getUserInfo($request->input('api_token'));
        // 获取公司名称
        $company = DB::table('company')->where('com_stase',1)->where('com_id',$role['adm_cid'])->select('com_id','com_name')->get();
 
        $roles = DB::table('role as r')
                ->leftjoin('company as c','c.com_id','=','r.rol_cid')
                ->where('rol_creator',$role['adm_id'])
                ->where('r.rol_chan_id',$role['adm_chan_id'])
                ->where(function($query) use($role_info) {
                    if (!empty($role_info['rol_sta'] )) {
                        $query->where('rol_sta','=',$role_info['rol_sta']);
                    }
                })
                ->where(function($query) use($role_info) {
                    if (!empty($role_info['rol_name'] )) {
                        $query->where('rol_name', 'like' , '%'.$role_info['rol_name'].'%' );
                    }
                })
                ->where(function($query) use($role_info) {
                    if (!empty($role_info['rol_type'] )) {
                        $query->where('rol_type','=',$role_info['rol_type']);
                    }
                })
                ->select('rol_id','rol_name','rol_pri','rol_sta','rol_creator','rol_create_time','rol_type','com_name')
                ->orderBy('rol_id','desc')
                ->paginate($this->show_count);
        $data_info['current_page']   = $roles->currentPage();            //当前页面页码
        $data_info['last_page']      = $roles->lastPage();               //表示最后一页的页码
        $data_info['total']          = $roles->total();                  //总数据个数
        $data_info['adm_leave']      = 1;                                //总数据个数
        $data_info['current_number'] = $this->show_count;                //一页显示多少个
        $data_info['data']           = $roles->items();                  //返回数据
        $data_info['company']        = $company;                  //返回数据
        // 动态获取操作人姓名
        if($data_info['data'])
        {
            foreach($data_info['data'] as $k=>$v)
            {
                $adm_creator[] = $v['rol_creator'];
            }
            $adm_creator = DB::table('admin')
                            ->whereIn('adm_id',$adm_creator)
                            ->select('adm_id','adm_name')
                            ->get();
            foreach($data_info['data'] as $k=>$v)
            {
                foreach($adm_creator as $key=>$value)
                {
                    if($v['rol_creator'] == $adm_creator[$key]['adm_id'])
                    {
                        $data_info['data'][$k]['rol_creator'] = $adm_creator[$key]['adm_name'];
                    }
                }
            } 
        }
        if($data_info){
            // 获取当前列表下的按钮
            $button = wherebutton($request['api_token'],$request['pri_id']);   
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'角色列表获取成功','data_info'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'角色列表获取失败']);
        }
        
    }

     // 开启权限
    public function startstase(Request $request)
    {
        $adm_creator = $this->where_admid($request['api_token']);
        $rol_id = $request['rol_id'];
        $rol_sta = 1;
        // 获取操作角色名
        $rol_name = DB::table('role')->whereIn('rol_id',$rol_id)->select('rol_name')->get();
        foreach($rol_name as $k=>$v)
        {
            $name[] = $v['rol_name'];
        }
        $name = implode($name,',');

        $res = DB::table('role')->whereIn('rol_id',$rol_id)->update(['rol_sta'=>$rol_sta]);
        if($res)
        {
            Coperationa::add($adm_creator['adm_id'],$request->getClientIp(),'角色列表启用','启用','启用('.$name.')角色');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'开启角色成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'开启角色失败']);
        }
    }
    // 关闭权限
    public function shopstase(Request $request)
    {
        $adm_creator = $this->where_admid($request['api_token']);
        $rol_id = $request['rol_id'];
        if(in_array(1,$rol_id))
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'总管理员不能被停用']);
        }
        $rol_sta = 2;
        // 获取操作角色名
        $rol_name = DB::table('role')->whereIn('rol_id',$rol_id)->select('rol_name')->get();
        foreach($rol_name as $k=>$v)
        {
            $name[] = $v['rol_name'];
        }
        $name = implode($name,',');

        $res = DB::table('role')->whereIn('rol_id',$rol_id)->update(['rol_sta'=>$rol_sta]);
        if($res)
        {
            Coperationa::add($adm_creator['adm_id'],$request->getClientIp(),'角色列表停用','停用','停用('.$name.')角色');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'停用角色成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'停用角色失败']);
        }
    }

    // 添加角色页面
    public function addrole(Request $request)
    {
        // 获取角色权限
        $role_info = $this->where_admid($request['api_token']);
        $privileges_info = json_decode($role_info['role_auth'], true);

        // 对栏目列表进行分类处理              
        foreach ($privileges_info as $key => $value) {
                // 删除账号相关
                if($value['pri_id'] == 37 || $value['pri_fid'] == 37)
                {
                    unset($privileges_info[$key]);
                }
                if ($value['pri_id'] == 48 || $value['pri_fid'] == 48) {
                    unset($privileges_info[$key]);
                }
                // 删除客户列表相关
                if($value['pri_id'] == 157 || $value['pri_fid'] == 157)
                {
                    unset($privileges_info[$key]);
                }
        }
        $privileges_info = $this->category($privileges_info);
        $pri_id = DB::table('privileges')->select('pri_id','pri_funname', 'pri_fid')->get();
        foreach ($pri_id as $key => $value) {
                // 删除账号相关
                if($value['pri_id'] == 37 || $value['pri_fid'] == 37)
                {
                    unset($pri_id[$key]);
                }
                if ($value['pri_id'] == 48 || $value['pri_fid'] == 48) {
                    unset($pri_id[$key]);
                }
                // 删除客户列表相关
                if($value['pri_id'] == 157 || $value['pri_fid'] == 157)
                {
                    unset($pri_id[$key]);
                }
        }
        if(!$privileges_info){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加角色页获取失败']);
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'添加角色页获取成功','privileges_info'=>$privileges_info,'pri_id'=>$pri_id]);
    }

    // 执行添加角色
    public function addaction(Request $request)
    {
        $input = $request->only('pri_id', 'rol_name','rol_fid','rol_type');
        if(empty($input['rol_name']) || empty($input['pri_id']) || empty($input['rol_type'])){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 获取当前操作账号
        $adm_creator = Coperationa::getUserInfo($request->input('api_token'));

        // 是否已有此角色名称
        $rol_name = DB::table('role')
                    ->where('rol_cid',$adm_creator['adm_cid'])
                    ->where('rol_chan_id',$adm_creator['adm_chan_id'])
                    ->where('rol_name',$input['rol_name'])
                    ->select('rol_name')
                    ->first();
        if($rol_name){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'角色名称已存在']);
        }

        //判断全局用户或者部分用户
        $rol_pri = DB::table('role')
                    ->where('rol_id',$adm_creator['adm_pre'])
                    ->select('rol_pri')->first();

        $rol_pri = explode(',', $rol_pri['rol_pri']);
        //当前用户角色是否和添加角色相等
        if($rol_pri == (count($input['pri_id']))){
            $rol_type = 1;
        }else{
            $rol_type = 2;
        }
        
        // 开启事务
        DB::beginTransaction();
        $add_data['rol_name'] = $input['rol_name'];
        $add_data['rol_pri'] = implode(',',$input['pri_id']);
        $add_data['rol_fid'] = implode(',',$input['rol_fid']);
        $add_data['rol_sta'] = 1;
        $add_data['rol_type'] = $rol_type;
        $add_data['rol_cid'] = $adm_creator['adm_cid'];
        $add_data['rol_chan_id'] = $adm_creator['adm_chan_id'];
        $add_data['rol_creator'] = $adm_creator['adm_id'];
        $add_data['rol_create_time'] = date("Y-m-d H:i:s");
        $role_res = DB::table('role')->insert($add_data);

        if ($role_res) {
            DB::commit();
            Coperationa::add($adm_creator['adm_id'],$request->getClientIp(),'角色列表','添加','添加"'.$input['rol_name'].'"角色');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'添加角色成功']);
        }else{
            DB::rollBack(); 
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加角色失败']);
        }
    }

    // 编辑角色页
    public function editrole(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $rol_list = $request->only('rol_id');
        if($rol_list['rol_id'] == 1)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'总管理不能进行编辑']);
        }
        $role_info = DB::table('login_temporary')
                            ->where('api_token','=',$api_token)
                            ->select('role_auth')
                            ->first();
        // 对象转数组
        $privileges_info = json_decode($role_info['role_auth'], true);

        // 当前要编辑的角色权限列表
        if(!empty($rol_list['rol_id'])){
            $select_rol = DB::table('role')
                            ->where('rol_id','=',$rol_list['rol_id'])
                            ->select('rol_pri','rol_name','rol_fid')
                            ->first();
            // 角色名称
            $rolename = $select_rol['rol_name'];
            // 所有父id
            $rol_fid = explode(',',$select_rol['rol_fid']);
            // 所有权限id
            $select_rol = explode(',',$select_rol['rol_pri']);
            //重置数组下标
            $select_rol = array_values($select_rol);
        }
        // 分类
        $privileges_info = $this->category($privileges_info);

        if(!$privileges_info)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑角色页获取失败']);
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑角色页获取成功','privileges_info'=>$privileges_info,'rolename'=>$rolename,'select_rol'=>$select_rol,'rol_fid'=>$rol_fid]);
    }
    // 执行编辑角色
    public function editaction(Request $request)
    {
        $input = $request->only('pri_id','rol_name','rol_id','rol_fid','rol_type');
        if(empty($input['rol_name']) || empty($input['pri_id']) || empty($input['rol_id']) || empty($input['rol_type'])) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }

        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 操作人
        $rol_creator = $this->where_admid($request['api_token']);
        $pri_id  = implode(',',$input['pri_id']); 
        $rol_fid = implode(',',$input['rol_fid']); 
        // 获取该账号所拥有的角色
        $role_info = DB::table('admin as a')
                            ->leftjoin('role', 'role.rol_id', '=', 'a.adm_pre')
                            ->where('a.adm_id','=',$find_adm['adm_id'])
                            ->select('role.rol_pri','a.adm_cid','a.adm_leave','a.adm_flow')
                            ->first();
        // 如果当前账号不是root管理
        // if($role_info['adm_cid'] != 1 || $role_info['adm_leave'] != 1)
        // {
        // }
        $rol_title = DB::table('role')
            ->where('rol_cid',$find_adm['adm_cid'])
            ->where('rol_chan_id',$find_adm['adm_chan_id'])
            ->where('rol_id', '<>', $input['rol_id'])
            ->where('rol_name','=',trim($input['rol_name']))
            ->select('rol_name','rol_id')
            ->first();
        if($rol_title['rol_id'] !== $input['rol_id'])
        {
            if($rol_title['rol_name'] == $input['rol_name'])
            {
                return response()->json(["code"=>500,'msg'=>'error','data'=>'角色名称已经存在']);
            }
        }

        //判断全局用或者部分用户
        $rol_pri = DB::table('role')->where('rol_id',$find_adm['adm_pre'])
                                     ->select('rol_pri')->first();
        $rol_pri = explode(',',$rol_pri['rol_pri']);
        //当前用户角色是否和添加角色相等
        if($rol_pri == (count($input['pri_id'])))
        {
            $rol_type = 1;
        }else{
            $rol_type = 2;
        }

        DB::beginTransaction();
        try{
            DB::table('role')
                ->where('rol_id',$input['rol_id'])
                ->update(['rol_pri' => $pri_id,
                    'rol_name'=> $input['rol_name'],
                    'rol_fid' => $rol_fid,
                    'rol_type'=>$rol_type,
                    'rol_creator'=>$rol_creator['adm_id'],
                    'rol_create_time'=>date("Y-m-d H:i:s")
                ]);
            DB::commit();
            Coperationa::add($rol_creator['adm_id'],$request->getClientIp(),'角色列表','编辑','编辑"'.$input['rol_name'].'"角色');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑角色成功']);
        }catch(Exception $e){
            DB::rollBack(); 
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑角色失败']);
        }
    }
    //数据分类
    public function category($arr){
        $refer = array();
        $list = array();
        foreach($arr as $k => $v){
            $refer[$v['pri_id']] = & $arr[$k]; //创建主键的数组引用
        }
        foreach($arr as $k => $v){
            $fid = $v['pri_fid'];  //获取当前分类的父级id
            if($fid == 0){
                $list[] = & $arr[$k];  //顶级栏目
            }else{
                if(isset($refer[$fid])){
                    $refer[$fid]['subcat'][] = & $arr[$k]; //如果存在父级栏目，则添加进父级栏目的子栏目数组中
                }
            }
        }
        return $list;
    }

    // 对象转数组
    function object_array($array) {  
        if(is_object($array)) {  
            $array = (array)$array;  
        } if(is_array($array)) {  
            foreach($array as $key=>$value) {  
                 $array[$key] = $this->object_array($value);  
            }  
        }  
        return $array;  
    }
    function where_admid($api_token)
    {
        try{
            $api_token = Crypt::decrypt($api_token);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $adm_id = DB::table('login_temporary')
                            ->where('api_token','=',$api_token)
                            ->select('adm_id','role_auth')
                            ->first();
        return $adm_id;
    }
}
