<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Models\Coperationa;
use DB;
use Excel;
use Crypt;

class PlatformController extends Controller
{

    // 列表每页显示数据个数
    protected $show_count = 10;
    public function platindex(Request $request)
    {
        $input = $request->only('plat_name','sort','rank','plat_state','page');

        if(empty($input['sort'] && $input['rank']))
        {
             $input['sort'] = 'plat_id';
             $input['rank'] = 'desc';
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $platform = DB::table('platform')
                    ->where(function($query) use($input) {
                        if (!empty($input['plat_name'] )) {
                            $query->where('plat_name', 'like' , '%'.$input['plat_name'].'%' );
                        }
                    })
                    ->where(function($query) use($input) {
                        if (!empty($input['plat_state'] )) {
                            $query->where('plat_state','=',$input['plat_state']);
                        }
                    })
                    ->where('plat_cid',$find_adm['adm_cid'])
                    ->where('plat_state','!=','3')
                    ->select('plat_id','plat_name','plat_state','plat_number','plat_money','plat_create_time')
                    ->orderBy($input['sort'],$input['rank'])
                    ->paginate($this->show_count);
                    $data_info['current_page'] = $platform->currentPage();  //当前页面页码
                    $data_info['last_page'] = $platform->lastPage();        //表示最后一页的页码
                    $data_info['total'] = $platform->total();               //总数据个数
                    $data_info['current_number'] = $this->show_count;       //一页显示多少个
                    $data_info['data'] = $platform->items();                //返回数据
        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);
        if($data_info)
        {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'销售平台列表获取成功','data_info'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'销售平台列表获取失败']);
        }
    }
    // 添加销售平台
    public function platadd(Request $request)
    {
        $adm_id = $this->where_admid($request['api_token']);
        $input = $request->only('plat_name','plat_state');

        if(empty($input['plat_name']) || empty($input['plat_name']))
        {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'存在空值']);
        }
        // 判断平台名称是否存在
        $res1 = DB::table('platform')->where('plat_name',$input['plat_name'])->where('plat_cid',$adm_id['adm_cid'])->select('plat_name')->first();
        if($res1['plat_name'])
        {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'平台名称已经存在']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $res = DB::table('platform')->insert([
                                            'plat_name'=>$input['plat_name'],
                                            'plat_state'=>$input['plat_state'],
                                            'plat_cid'=>$find_adm['adm_cid'],
                                            'plat_create_time'=>date("Y-m-d H:i:s")
                                            ]); 
        if($res)
        {
            Coperationa::add($adm_id['adm_id'],$request->getClientIp(),'销售平台','新增','新增'.$input['plat_name']);
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'销售平台添加成功']);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'销售平台添加失败']);
        }
    }
    // 启用权限
    public function startstase(Request $request)
    {
        $adm_id = $this->where_admid($request['api_token']);
        $plat_id = $request['plat_id'];
        $plat_id = explode(',',$plat_id);
        $plat_state = 1;
        $res = DB::table('platform')->whereIn('plat_id',$plat_id)->update(['plat_state'=>$plat_state,'plat_create_time'=>date("Y-m-d H:i:s")]);
        if($res)
        {
            Coperationa::add($adm_id['adm_id'],$request->getClientIp(),'销售平台','启用','启用销售平台');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'开启平台成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'开启平台失败']);
        }
    }
    // 停用权限
    public function shopstase(Request $request)
    {
        $adm_id = $this->where_admid($request['api_token']);
        $plat_id = $request['plat_id'];
        $plat_id = explode(',',$plat_id);
        $plat_state = 2;
        $res = DB::table('platform')->whereIn('plat_id',$plat_id)->update(['plat_state'=>$plat_state,'plat_create_time'=>date("Y-m-d H:i:s")]);
        if($res)
        {
            Coperationa::add($adm_id['adm_id'],$request->getClientIp(),'销售平台','停用','停用销售平台');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'停用平台成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'停用平台失败']);
        }
    }

    // 销售平台修改页面
    public function platedit(Request $request)
    {
        $adm_id = $this->where_admid($request['api_token']);
        $plat_id = $request['plat_id'];
        $plat_name = $request['plat_name'];
        $plat_state = $request['plat_state'];

        if(empty($plat_id) || empty($plat_name) || empty($plat_state))
        {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 判断平台名称是否存在
        $res1 = DB::table('platform')->where('plat_name',$plat_name)->where('plat_cid',$adm_id['adm_cid'])->select('plat_name','plat_id')->first();
        if($res1['plat_name'] && $res1['plat_id'] != $plat_id)
        {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'平台名称已经存在']);
        }
        $res = DB::table('platform')->where('plat_id',$plat_id)->update(['plat_state'=>$plat_state,'plat_name'=>$plat_name,'plat_create_time'=>date("Y-m-d H:i:s")]);
        if($res)
        {
            Coperationa::add($adm_id['adm_id'],$request->getClientIp(),'销售平台','修改','修改'.$request['plat_name'].'销售平台');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑平台成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑平台失败']);
        }
    }

    public function platimpot(Request $request)
    {
        $input = $request->all();

        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $platform = DB::table('platform')
        ->where(function($query) use($input) {
            if (!empty($input['plat_name'] )) {
                $query->where('plat_name', 'like' , '%'.$input['plat_name'].'%' );
            }
        })
        ->where(function($query) use($input) {
            if (!empty($input['plat_state'] )) {
                $query->where('plat_state','=',$input['plat_state']);
            }
        })
        ->orderBy('plat_id','desc')
        ->select('plat_name','plat_number','plat_money','plat_state','plat_create_time')
        ->get();

        $time = date('Y-m-d H:i:s',time());

        if($api_token){
            $adm_id = DB::table('login_temporary')
                            ->where('api_token','=',$api_token)
                            ->select('adm_id')
                            ->first();
        }
        
        if(!empty($platform)){
            Excel::create('10000'.$adm_id['adm_id'], function($excel) use ($platform) {
            $excel->sheet('platform', function($sheet) use ($platform)
            {
                $sheet->cell('A1', function($cell) {$cell->setValue('【操作时间】'); });
                $sheet->cell('B1', function($cell) {$cell->setValue('【销售平台】');   });
                $sheet->cell('C1', function($cell) {$cell->setValue('【订单量】');   });
                $sheet->cell('D1', function($cell) {$cell->setValue('【订单金额】'); });
                $sheet->cell('E1', function($cell) {$cell->setValue('【销售平台状态】');   });
                
                if (!empty($platform)) {
                    foreach ($platform as $key => $value) {
                        if($value['plat_state']==1)
                        {
                            $value['plat_state'] = '启用';
                        }else{
                            $value['plat_state'] = '停用';
                        }
                        $i= $key+2;
                        $sheet->cell('A'.$i, $value['plat_create_time']);
                        $sheet->cell('B'.$i, $value['plat_name']);
                        $sheet->cell('C'.$i, $value['plat_number']);
                        $sheet->cell('D'.$i, $value['plat_money']);
                        $sheet->cell('E'.$i, $value['plat_state']);
                    }
                }
            });
            })->save('xls',storage_path('excel/platform'));
            return response()->json(["code"=>200,'msg'=>'success','data'=>"storage/excel/platform/10000".$adm_id['adm_id'].".xls"]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'无数据']);
        } 
    }
    function where_admid($api_token)
    {
        try{
            $api_token = Crypt::decrypt($api_token);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $adm_id = DB::table('login_temporary')
                            ->where('api_token','=',$api_token)
                            ->select('adm_id','adm_cid')
                            ->first();
        return $adm_id;
    }
}