<?php

namespace App\Http\Controllers\Pda;

use App\Jobs\Integral;
use App\Jobs\GoodsFlow;
use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
use App\Http\Models\Transport;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Verify\VerifyCodeController;
use App\Http\Models\Code;
use App\Http\Models\RelationCodeModel;
use Illuminate\Http\Response;
use Mockery\Exception;
use Session;
use DB;
use AuthenticatesUsers;

class TransportController extends Controller
{
    public function transIn(Request $request) {
        //todo 入库
        $input = $request->only('codes');
        $codes = trim($input['codes']);
        if(!$codes) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' =>[]]);
        }

        $company_id = $request['_company_id'];
        $channel_id = $request['_channel_id'];

        //验证待组合的产品码或关联码
        $error_codes = [];
        $codes = explode(',', trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0 OR count($codes) < 1) {
            return response()->json(['code' => 500, 'msg' => '包含错误的码', 'data' => $error_codes]);
        }

        //查询该单的发货方
        $first_code = $codes[0];
        $pre_transport = $this->getPreTransport($first_code, $request);
        //step.1.创建出入库单(transport)
        $TransObj = new Transport;
        $TransObj->company_id = $company_id;
        $TransObj->sn = $company_id.date('YmdHis').rand(1000,9999);
        $TransObj->type = 1;//1=入库;0=出库
        $TransObj->channel_id_from = $pre_transport['channel_id_from'];
        $TransObj->channel_id_to = $pre_transport['channel_id_to'];
        $TransObj->channel_name_from = $pre_transport['channel_name_from'];
        $TransObj->channel_name_to = $pre_transport['channel_name_to'];;
        $TransObj->state_from = 1;
        $TransObj->state_to = 1;
        $TransObj->add_time = date('Y-m-d H:i:s');
        $TransObj->total_num = 0;
        $TransObj->admin_id = $request['_admin_id'];
        $TransObj->admin_name = $request['_admin_name'];
        $ret = $TransObj->save();
        //step.2.创建出入库单详细(transport_info)
        if($ret == 1) {
            $admin_info = array(
                '_admin_name' => $request['_admin_name'],
                '_admin_id' => $request['_admin_id'],
                '_company_id' => $request['_company_id'],
                );
            //出入库日志&积分添加
            $this->dispatch(new Integral($TransObj->sn, $codes,'in', $admin_info));
            //库存更新
            $this->dispatch(new GoodsFlow($TransObj->sn, $codes, 'in', $admin_info));
            //修改发货方的状态
            if($pre_transport['id'] > 0) {
                DB::table('transport')->where('id', $pre_transport['id'])->update(['state_to' => 1]);
            }
        }

        /*
        if($ret == 1) {
            $total_num = $this->insertTransInfo($TransObj->sn, $codes,'in', $find_adm);
        }
        if($total_num > 0) {
            $TransObj->total_num = $total_num;
            $TransObj->save();
            //修改发货方的状态
            if($pre_transport['id'] > 0) {
                DB::table('transport')->where('id', $pre_transport['id'])->update(['state_to' => 1]);
            }
        }
        */
        return response()->json(['code' => 200, 'msg' => 'success!', 'data' => []]);
    }

    //出库
    public function transOut(Request $request) {
        $input = $request->only('codes','channel_id');
        $codes = trim($input['codes']);
        $channel_id_to = intval($input['channel_id']);

        if(!$codes) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' =>[]]);
        }

        $company_id = $request['_company_id'];
        $channel_id = $request['_channel_id'];

        //验证待组合的产品码或关联码
        $error_codes = [];
        $codes = explode(',', trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0 OR count($codes) < 1) {
            return response()->json(['code' => 500, 'msg' => '包含错误的码', 'data' => $error_codes]);
        }

        $channel_to['chan_enterprise_name'] = '';

        //查询该单的收货方渠道
        if($channel_id_to > 0) {
            $channel_to = DB::table('channels')
                ->where('chan_cid',$company_id)
                ->where('chan_state',1)
                ->where('chan_id',$channel_id_to)
                ->get();
            if(count($channel_to) < 1) {
                return response()->json(['code' => 500, 'msg' => '未找到该渠道', 'data' => []]);
            }else {
                $channel_to = current($channel_to);
            }
        }
        //查询该单的发货方渠道
        $channel_from = ['chan_id'=>0,'chan_enterprise_name'=>''];
        if($request['_channel_id'] > 0) {
            $channel_from = DB::table('channels')
                ->where('chan_cid',$company_id)
                ->where('chan_state',1)
                ->where('chan_id',$request['_channel_id'])
                ->get();
            if(count($channel_from) == 1) {
                $channel_from = current($channel_from);
            }
        }

        //step.1.创建出入库单(transport)
        $TransObj = new Transport;
        $TransObj->company_id = $company_id;
        $TransObj->sn = $company_id.date('YmdHis').rand(1000,9999);
        $TransObj->type = 0;//1=入库;0=出库
        $TransObj->channel_id_from = $channel_from['chan_id'];
        $TransObj->channel_id_to = $channel_id_to;
        $TransObj->channel_name_from = $channel_from['chan_enterprise_name'];
        $TransObj->channel_name_to = $channel_to['chan_enterprise_name'];
        $TransObj->state_from = 1;
        $TransObj->state_to = 0;
        $TransObj->add_time = date('Y-m-d H:i:s');
        $TransObj->total_num = 0;
        $TransObj->admin_id = $request['_admin_id'];
        $TransObj->admin_name = $request['_admin_name'];
        $ret = $TransObj->save();
        
        //step.2.创建出入库单详细(transport_info)
        if($ret == 1) {
            $admin_info = array(
                '_admin_name' => $request['_admin_name'],
                '_admin_id' => $request['_admin_id'],
                '_company_id' => $request['_company_id'],
            );
            $this->dispatch(new Integral($TransObj->sn, $codes, 'out', $admin_info));
            //todo 库存
            $this->dispatch(new GoodsFlow($TransObj->sn, $codes, 'out', $admin_info));
        }

        /*
        if($ret == 1) {
            $total_num = $this->insertTransInfo($TransObj->sn, $codes,'out',$find_adm);
        }
        if($total_num > 0) {
            $TransObj->total_num = $total_num;
            $TransObj->save();
        }
        */
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => []]);
    }


    //params $type : in(出库) / out(入库)
    public function insertTransInfo($sn, $codes, $type = '', $find_adm='') {
        //Jobs/Integral.php
    }

    public function getPreTransport($first_code, $find_adm) {
        $company_id = $find_adm['_company_id'];
        $channel_id = $find_adm['_channel_id'];
        $sql = "SELECT * from trace_channels where chan_id={$channel_id}";
        $channelRow = DB::select($sql);
        if(count($channelRow) == 0){
            $channelRow[0] = array('chan_enterprise_name'=>'');
        }
        if(strpos($first_code,'G') === 0) {
            $relation_code = RelationCodeModel::where('code', $first_code)->first();
            if(!$relation_code) {
                return response()->json(['code' => 500, 'msg' => '未找到关联码'.$first_code, 'data' => []]);
            }
            $sql = "SELECT * from trace_2019_code WHERE company_id=$company_id AND relation_chain LIKE '%,{$relation_code->id},%' LIMIT 1";
            $first_code_info = DB::select($sql);
        }else {
            $sql = "SELECT * from trace_2019_code WHERE company_id=$company_id AND code='{$first_code}' LIMIT 1";
            $first_code_info = DB::select($sql);
        }
        if(count($first_code_info) < 1) {
            return response()->json(['code' => 500, 'msg' => $first_code.'未找到商品'.$first_code, 'data' => []]);
        }
        $sql = "SELECT b.*
                FROM trace_transport_info a LEFT JOIN trace_transport b on a.transport_id=b.id
                WHERE b.company_id=$company_id AND a.code='{$first_code_info[0]['code']}'
                ORDER BY b.id DESC 
                LIMIT 1";
        $pre_transport = DB::select($sql);
        if(count($pre_transport) == 1) {
            $pre_transport = current($pre_transport);
        }else {
            $pre_transport = array('id'=>0,'channel_id_from'=>0,'channel_id_to'=>$channel_id,'channel_name_from'=>'','channel_name_to'=>$channelRow[0]['chan_enterprise_name']);
        }
        $pre_transport['channel_id_to'] = $channel_id;
        $pre_transport['channel_name_to'] = $channelRow[0]['chan_enterprise_name'];
        return $pre_transport;
    }

    public function channelList(Request $request) {
        $company_id = $request['_company_id'];
        $channel_id = $request['_channel_id'];
        $channel_list = DB::table('channels')
            ->where('chan_cid',$company_id)
            ->where('chan_parent_id',$channel_id)
            ->where('chan_state',1)
            ->select('chan_id','chan_enterprise_name as title','chan_name as name','chan_phone as phone')
            ->get();
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $channel_list]);
    }
}

