<?php

namespace App\Http\Controllers\Pda;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Session;
use DB;
use App\Http\Models\Coperationa;
use App\Http\Models\RelationCodeModel;
use AuthenticatesUsers;
use App\Http\Controllers\Verify\VerifyCodeController;

//关联码
class RelationCodeController extends Controller
{
    public function __construct() {
        DB::connection()->enableQueryLog(); // 开启查询日志

    }

    public function create(Request $request)
    {
        // 获取操作人
        $company_id = $request['_company_id'];
        $channel_id = $request['_channel_id'];
        if(!$company_id) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'公司信息不完整']);
        }
        //该箱码最大装载量
        $max_num = intval($request->input('max_num'));
        $max_num = max(1, $max_num);

        //获取最大的关联码
        $max_code = RelationCodeModel::getMaxCode($company_id);
        if(is_array($max_code) AND $max_code['code']) {
            $code_serial = substr($max_code['code'],10,-3);
            $code_serial = sprintf('%06d',$code_serial+1);
        }else {
            $code_serial = sprintf('%06d',1);
        }

        //关联码生成规则：G+企业ID(5位)+年月(4位)+顺序码(6位)+验证码(3位)
        $relation_code = 'G';
        $relation_code .= sprintf('%05d',$company_id).date('ym').$code_serial;
        //生成校验位
        $verify_code = VerifyCodeController::generateVerify($relation_code, 3);
        if(!$verify_code) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
        }else {
            $relation_code .= $verify_code;
        }
        $relation_data = array(
            'code'=>$relation_code,
            'max_num' => $max_num,
            'company_id'=>$company_id,
            'channel_id'=> $channel_id,
            'add_time'=>date('Y-m-d H:i:s'),
            'state'=>1,
            'up_code'=>0,
            'chain_code'=>''
        );
        if(RelationCodeModel::create($relation_data)) {
            $url = config('app.url').'/sy.php?code='.$relation_code.'&';
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $relation_code]);
        }else {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'写入数据库失败']);
        }
    }

}

