<?php

namespace App\Http\Controllers\MobileWeb\Verify;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

// 主页验证器
class VerifyHomepageController extends Controller
{
    // 手机号发送验证码
    public function phoneValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'phone.required' => '请输入手机号',
            'phone.regex' => '手机号格式不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'phone' => ['required','regex:/^1[3456789]\d{9}$/']
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 登录验证器
    public function loginValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'phone.required' => '请输入手机号',
            'phone.regex' => '手机号格式不正确',
            'password.required' => '请输入密码',
            // 'password.digits' => '验证码格式不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'phone' => ['required','regex:/^1[345678]\d{9}$/'],
            'password' => 'required'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 注册验证器
    public function registerValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tech_employer_address.required' => '参数错误',
            'tech_name.required' => '参数错误',
            'tech_name.max' => '技师姓名长度超过最大限制',
            'tech_phone.required' => '请输入手机号',
            'tech_phone.regex' => '手机号格式不正确',
            'tech_identity_card.required' => '参数错误',
            'tech_address.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tech_employer_address' => 'required',
            'tech_name' => 'required|max:50',
            'tech_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'tech_identity_card' => 'sometimes',
            'tech_address' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 登录验证token
    public function webLoginValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'api_token.required' => '请输入token',
            'userid.required' => '参数错误',
            'userid.numeric' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'api_token' => 'required',
            'userid' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 扫一扫，扫码获取产品信息
    public function scanCodeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'api_token.required' => '请输入token',
            'userid.required' => '参数错误',
            'userid.numeric' => '参数错误',
            'code.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'api_token' => 'required',
            'userid' => 'required|numeric',
            'code' => 'required'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 扫一扫，提交质保信息验证器
    public function subWarrantyInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'api_token.required' => '请输入token',
            'userid.required' => '参数错误',
            'userid.numeric' => '参数错误',
            'gid.required' => '参数错误',
            'gid.numeric' => '参数错误',
            'code.required' => '参数错误',
            'type.required' => '参数错误',
            'type.numeric' => '参数错误',
            // 'info_name.required' => '参数错误',
            // 'info_name.array' => '参数错误',
            // 'info_content.required' => '参数错误',
            // 'info_content.array' => '参数错误',
            // 'info_show.required' => '参数错误',
            // 'info_show.array' => '参数错误',
            // 'info_type.required' => '参数错误',
            // 'info_type.array' => '参数错误',
            // 'info_required.required' => '参数错误',
            // 'info_required.array' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'api_token' => 'required',
            'userid' => 'required|numeric',
            'gid' => 'required|numeric',
            'code' => 'required',
            'type' => 'required|numeric',
            // 'info_name' => 'required|array',
            // 'info_content' => 'required|array',
            // 'info_show' => 'required|array',
            // 'info_type' => 'required|array',
            // 'info_required' => 'required|array'
        ], $messages);


        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 兑换物品验证器
    public function reduceIntegralValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'api_token.required' => '请输入token',
            'userid.required' => '参数错误',
            'userid.numeric' => '参数错误',
            'fori_id.required' => '参数错误',
            'fori_id.numeric' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'api_token' => 'required',
            'userid' => 'required|numeric',
            'fori_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }
}
