<?php
namespace App\Http\Controllers\Massif;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use App\Http\Models\Massif\DigitalmapModel as Digital;
use Illuminate\Support\Facades\Crypt;
use Validator;
class DigitalmapController extends Controller{
	//数字地图 页面的加载页面；
	public function maplist(Request $request){
		// $token='e931ec0f040fe9f16cb00c793acc68c40c6c1e05';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		$massif_id=(int)$request->input('massif_id',null);
		if(!$user){
			return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
		}
		// if(empty((int)$request->input("pri_id",0))){
		// 	return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少按钮id']);
		// }
		$obj=new Digital();
		$res=$obj->Map_List($user,$massif_id);
		$res['button']=wherebutton($request->input("api_token"),(int)$request->input("pri_id",0));
		return response()->json($res);
	}

	//添加农田
	public function addfarmland(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}

			//农田名称
			$data['far_name']=$request->input('massif_name',null);
			//经度，纬度
			$data['far_longitude']=$request->input('longitude',null);
			$data['far_latitude']=$request->input('latitude',null);
			//负责人 电话  地址
			$data['respon_user']=$request->input('respon_name',null);
			$data['respon_tel']=$request->input('respon_tel',null);
			$data['far_address']=$request->input('address',null);
			$data=CommenModel::checkData_dc($data,2);
			$data['create_user']=$user['admin_id'];
			$data['far_state']=1;
			$data['far_cid']=$user['adm_cid'];
			$data['create_time']=date('Y-m-d H:i:s');

			//图片
			$file=$request->input('massif_image',null);

			if(empty($file)){throw new Exception("上传图片不能为空");}
			$this->check_far_data($data);

		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}
		$obj=new Digital();
		$res=$obj->Add_Farmland($data,$file,$user,1);
		return json_encode($res);
	}

	public function check_far_data($data){
		if(empty($data['far_longitude']) || empty($data['far_latitude'])){throw new Exception("经纬度不能为空");}

		$path1='/^([a-zA-Z]|[0-9]|[\x{4e00}-\x{9fa5}]|_){4,15}$/u';
		if(!preg_match($path1,$data['far_name'])){throw new Exception("农田名称错误,应由任意字母数字中文下划线组成4-15位字符");}

		$path1='/^([a-zA-Z]|[0-9]|[\x{4e00}-\x{9fa5}]|_){6,30}$/u';
		if(!preg_match($path1,$data['far_address'])){throw new Exception("农田地址错误,应由任意字母数字中文下划线组成6-30位字符");}
		
		$preg_user="/^[\x{4e00}-\x{9fa5}]{2,5}$/u";
		if(!preg_match($preg_user,$data['respon_user'])){throw new Exception("负责人姓名格式错误,应由2-5个中文字符组成");}

		$preg_tel="/^((0\d{2,3}-?\d{7,8})|(1\d{10}))$/";
		if(!preg_match($preg_tel,$data['respon_tel'])){throw new Exception("电话\手机号码格式错误");}
	}

	//编辑农田
	public function editfarmland(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}

			$data['far_id']=(int)$request->input('massif_id',null);
			//农田名称
			$data['far_name']=$request->input('massif_name',null);
			//经度，纬度
			$data['far_longitude']=$request->input('longitude',null);
			$data['far_latitude']=$request->input('latitude',null);
			//负责人 电话  地址
			$data['respon_user']=$request->input('respon_name',null);
			$data['respon_tel']=$request->input('respon_tel',null);
			$data['far_address']=$request->input('address',null);
			$file=$request->input('massif_image',null);

			if(empty($data['far_id'])){throw new Exception("农田id不能为空");}
			$this->check_far_data($data);

		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}
		$obj=new Digital();
		$res=$obj->Add_Farmland($data,$file,$user,2);
		return json_encode($res);
	}

	//删除农田
	public function delfarmland(Request $request){
		// $token='e931ec0f040fe9f16cb00c793acc68c40c6c1e05';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);}

		$far_id=(int)$request->input('massif_id',null);
		if(empty($far_id)){return json_encode(['code'=>500,'msg'=>'error','data'=>'农田id不能为空']);}
		$obj=new Digital();
		$res=$obj->del_Farmland($far_id,$user);
		return json_encode($res);
	}

	//添加区域
	public function addregion(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}

			//区域名称  农田id  面积  颜色  比例
			$data['reg_name']     =$request->input('region_name',null);
			$data['reg_color']    =$request->input('region_color',null);
			$data=CommenModel::checkData_dc($data,2);

			$data['acreage']=$data['reg_surplus']=sprintf("%.2f",(float)$request->input('region_acreage',null));

			$data['far_id']       =(int)$request->input('massif_id',null);

			$file=$request->input('region_image',null);
			if(empty($data['far_id'])){throw new Exception("农田id不能为空");}
			if(empty($file)){throw new Exception("上传图片不能为空");}

			$this->check_region($data);
			//坐标数据
			$coordinate=$request->input('coordinate');
			// $coordinate=$this->simula_array;
			if(empty($coordinate)){throw new Exception("坐标数据不能为空");}
			if(count($coordinate)<3){throw new Exception("最少三个点");}
			$data['coordinate']=json_encode($coordinate);

		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}
		//透明度
		$data['slide']        =((int)$request->input('region_slide'))>100 || ((int)$request->input('region_slide'))<0?50:(int)$request->input('region_slide',50);
		$data['reg_parent_id']=0;  //区域为0   地块为地区id   因为这是父子关系
		$obj=new Digital();
		$res=$obj->Add_region($data,$user,$file,1,1);
		return json_encode($res);

	}
	//编辑区域
	public function editregion(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}

			//区域名称  农田id  面积  颜色  比例
			$data['reg_name']     =$request->input('region_name',null);
			$data['reg_color']    =$request->input('region_color',null);
			$data=CommenModel::checkData_dc($data,2);
			$data['region_id']    =(int)$request->input('region_id',null);
			$data['acreage']=$data['reg_surplus']=sprintf("%.2f",(float)$request->input('region_acreage',null));

			if(empty($data['region_id'])){throw new Exception("区域id不能为空");}

			$data['far_id']       =(int)$request->input('massif_id',null);

			$file=$request->input('region_image',null);
			if(empty($data['far_id'])){throw new Exception("农田id不能为空");}

			$this->check_region($data);
			//坐标数据
			$coordinate=$request->input('coordinate');
			// $coordinate=$this->simula_array;
			if(empty($coordinate)){throw new Exception("坐标数据不能为空");}
			if(count($coordinate)<3){throw new Exception("最少三个点");}
			$data['coordinate']=json_encode($coordinate);

		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}
		//透明度
		$data['slide']        =((int)$request->input('region_slide'))>100 || ((int)$request->input('region_slide'))<0?50:(int)$request->input('region_slide',50);

		$obj=new Digital();
		$res=$obj->Add_region($data,$user,$file,2,1);
		return json_encode($res);
	}

	//编辑地块
	public function editmassif(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}

			//区域名称  区域id  农田id  面积  颜色  比例
			$data['reg_name']     =$request->input('region_name',null);
			$data['reg_color']    =$request->input('region_color',null);
			$data=CommenModel::checkData_dc($data,2);

			// $data['reg_parent_id']=(int)$request->input('field_id',null);

			$data['acreage']=$data['reg_surplus']=sprintf("%.2f",(float)$request->input('region_acreage',null));

			$data['slide']        =((int)$request->input('region_slide'))>100 || ((int)$request->input('region_slide'))<0?50:(int)$request->input('region_slide',50);

			$data['region_id']    =(int)$request->input('region_id',null);
			if(empty($data['region_id'])){throw new Exception("地块id不能为空");}

			// if(empty($data['reg_parent_id'])){throw new Exception("区域id不能为空");}

			$file=$request->input('region_image',null);

			//坐标数据
			$coordinate=$request->input('coordinate');
			// $coordinate=$this->simula_array;
			if(empty($coordinate)){throw new Exception("坐标数据不能为空");}
			if(count($coordinate)<3){throw new Exception("最少三个点");}
			$data['coordinate']=json_encode($coordinate);
		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}

		$obj=new Digital();
		$res=$obj->Add_region($data,$user,$file,2,2);
		return json_encode($res);
	}

	//校验区域数据   1校验区域和地块      2校验耕地和仓库
	public function check_region($data,$state=1){
		if($state==1){
			if(empty($data['reg_name']) || strlen($data['reg_name'])<4){throw new Exception("区域名称最少4位");}
			$path="/^#(\d|[a-zA-Z]){6}$/i";
			if(!preg_match($path,$data['reg_color'])){throw new Exception("颜色格式错误,应是以#开头任意6位字母或数字结尾");}
			if($data['acreage']<=0){throw new Exception("占地面积不能为0");}
		}elseif($state==2){
			// if(empty($data['reg_id'])){throw new Exception("地块id不能为空");}
			if(empty($data['cul_name']) || strlen($data['cul_name'])<4){throw new Exception("名称最少4位");}
			$path="/^#(\d|[a-zA-Z]){6}$/i";
			if(!preg_match($path,$data['cul_color'])){throw new Exception("颜色格式错误,应是以#开头任意6位字母或数字结尾");}

			if($data['cul_acreage']<=0){throw new Exception("占地面积不能为0");}
		}
	}

	//添加耕地详情
	public function addcultails(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}
			$data['cultiv_id']=(int)$request->input('cultiv_id',null);
			$data['add_time']=date("Y-m-d H:i:s",strtotime($request->input('add_time',null)));
			$data['invest_goods']=$request->input('cultiv_thing',null);
			$data['details']=$request->input('details','');
			$data['add_user']=$user['admin_id'];
			if(empty($data['cultiv_id']) || empty($data['invest_goods'])){throw new Exception("缺少参数");}

		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}
		$obj=new Digital();
		$res=$obj->addCultails($data,$user);
		return json_encode($res);
	}

	//编辑 耕地的耕种情况
	public function editcultails(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}
			$data['det_id']=(int)$request->input('culdet_id',null);
			$data['add_time']=date("Y-m-d H:i:s",strtotime($request->input('add_time',null)));
			$data['invest_goods']=$request->input('cultiv_thing',null);
			$data['details']=$request->input('details','');
			$data['add_user']=$user['admin_id'];
			$data['update_time']=date("Y-m-d H:i:s");
			$data['update_user']=$user['admin_id'];
			if(empty($data['det_id']) || empty($data['invest_goods'])){throw new Exception("缺少参数");}
			
		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}
		$obj=new Digital();
		$res=$obj->Edit_Cultails($data,$user);
		return json_encode($res);
	}

	//删除 耕地记录
	public function deltcultails(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}
			$det_id=$request->input('culdet_id',null);

			if(empty($det_id)){throw new Exception("缺少耕地信息");}
			$res=CommenModel::checkData_dc($det_id);
			if(!$res){throw new Exception("数据格式错误");}
			
			
		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}
		$obj=new Digital();
		$res=$obj->Del_Cultails($det_id,$user);
		return json_encode($res);
	}

	//删除区域
	public function delregion(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);}

		$id=(int)$request->input("region_id",null);
		if(empty($id)){return json_encode(['code'=>500,'msg'=>'error','data'=>'区域id不能为空']);}

		$obj=new Digital();
		$res=$obj->Del_Region($id,$user,1);
		return json_encode($res);
	}

	//删除 地块，区域，耕地 数据
	public function deltlandata(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		$type=(int)$request->input('type',0);
		if(!in_array($type,[1,2,3])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'未知类型'],JSON_UNESCAPED_UNICODE);
		}
		$lan_id=(int)$request->input('lan_id',null);
		if(empty($lan_id)){return ['code'=>500,'msg'=>'error','data'=>'id不能为空'];}

		if($type==1){
			$obj=new Digital();
			$res=$obj->Del_Region($lan_id,$user,1);
			return json_encode($res);
		}elseif($type==2){

			$obj=new Digital();
			$res=$obj->Del_Region($lan_id,$user,2);
			return json_encode($res);
		}else{

			$obj=new Digital();
			$res=$obj->Del_Cultiv($lan_id,$user,1);
			return json_encode($res);
		}
	}

	//删除地块
	public function delmassif(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);}

		$id=(int)$request->input("region_id",null);
		if(empty($id)){return json_encode(['code'=>500,'msg'=>'error','data'=>'id不能为空']);}

		$obj=new Digital();
		$res=$obj->Del_Region($id,$user,2);
		return json_encode($res);
	}

	//删除耕地
	public function delcultiv(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);}

		$id=(int)$request->input("cultiv_id",null);
		if(empty($id)){return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少耕地id']);}

		$obj=new Digital();
		$res=$obj->Del_Cultiv($id,$user,1);
		return json_encode($res);
	}

	//删除仓库
	public function delware(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){return ['code'=>500,'msg'=>'error','data'=>'token错误'];}

		$id=(int)$request->input("cultiv_id",null);
		if(empty($id)){return ['code'=>500,'msg'=>'error','data'=>'缺少仓库id'];}

		$obj=new Digital();
		$res=$obj->Del_Cultiv($id,$user,2);
		return json_encode($res);
	}


	//添加地块
	public function addmassif(Request $request){

		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}

			//区域名称  区域id  农田id  面积  颜色  比例
			$data['reg_name']     =$request->input('region_name',null);
			$data['reg_color']    =$request->input('region_color',null);
			$data=CommenModel::checkData_dc($data,2);

			$data['reg_parent_id']=(int)$request->input('field_id',null);
			
			$data['acreage']=$data['reg_surplus']=sprintf("%.2f",(float)$request->input('region_acreage',null));
			$data['slide']        =((int)$request->input('region_slide'))>100 || ((int)$request->input('region_slide'))<0?50:(int)$request->input('region_slide',50);

			if(empty($data['reg_parent_id'])){throw new Exception("区域id不能为空");}

			$file=$request->input('region_image',null);
			if(empty($file)){throw new Exception("上传图片不能为空");}

			//坐标数据
			$coordinate=$request->input('coordinate');
			// $coordinate=$this->simula_array;
			if(empty($coordinate)){throw new Exception("坐标数据不能为空");}
			if(count($coordinate)<3){throw new Exception("最少三个点");}
			$data['coordinate']=json_encode($coordinate);
		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}
		
		$obj=new Digital();
		$res=$obj->Add_region($data,$user,$file,1,2);
		return json_encode($res);
	}

	//添加耕地
	public function addcultiv(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}

			//耕地名称  类型   地块id   面积  颜色   透明度  农田id
			$data['cul_name']     =$request->input('cultiv_name',null);
			$data['cul_color']    =$request->input('cultiv_color',null);
			$data=CommenModel::checkData_dc($data,2);

			$data['cul_acreage']      =sprintf("%.2f",(float)$request->input('cultiv_acreage',null));
			$data['cul_type']=1;  //1 耕地   2 仓库      地块id
			$data['reg_id']       =(int)$request->input('region_id',null);
			$data['cul_slide']    =((int)$request->input('cultiv_slide'))>100 || ((int)$request->input('cultiv_slide'))<0?50:(int)$request->input('cultiv_slide',50);

			$file=$request->input('cultiv_image',null);
			if(empty($file)){throw new Exception("上传图片不能为空");}
			$this->check_region($data,2);

			//坐标数据
			$coordinate=$request->input('coordinate');
			// $coordinate=$this->simula_array;
			if(empty($coordinate)){throw new Exception("坐标数据不能为空");}
			if(count($coordinate)<3){throw new Exception("最少三个点");}
			$data['cul_coordinate']=json_encode($coordinate);
		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}

		$obj=new Digital();
		$res=$obj->Add_cultiva($data,$user,$file,1,1);
		return json_encode($res);
	}

	//添加仓库
	public function addware(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){
				return ['code'=>500,'msg'=>'error','data'=>'token错误'];
			}
			//仓库名称  类型
			$data['cul_name']     =$ware['rep_name']=$request->input('cultiv_name',null);
			$data['cul_color']    =$request->input('cultiv_color',null);
			$data=CommenModel::checkData_dc($data,2);

			$data['cul_acreage']      =sprintf("%.2f",(float)$request->input('cultiv_acreage',null));

			$data['reg_id']       =(int)$request->input('region_id',null);
			$data['cul_capacity'] =(float)$request->input('cul_capacity',0);
			$data['cul_slide']    =((int)$request->input('cultiv_slide'))>100 || ((int)$request->input('cultiv_slide'))<0?50:(int)$request->input('cultiv_slide',50);
			$data['cul_type']=2;  //1 耕地   2 仓库

			$ware['rep_type']=$data['cul_ware_type']=(int)$request->input('state',1);
			if(!in_array($ware['rep_type'],[1,2,3])){
				$ware['rep_type']=1;
			}
			$ware['rep_province']=$request->input('province','');
			$ware['is_ok']   =(int)$request->input('is_ok',1);
			$ware['rep_county']  =$request->input('county','');
			$ware['rep_city']    =$request->input('city','');
			$ware['rep_address'] =$request->input('address','');
			$this->check_region($data,2);
			$this->check_ware_data($ware);
			$file=$request->input('cultiv_image',null);
			if(empty($file)){throw new Exception("上传图片不能为空");}

			//坐标数据
			$coordinate=$request->input('coordinate',null);
			// $coordinate=$this->simula_array;
			if(empty($coordinate)){throw new Exception("坐标数据不能为空");}
			if(count($coordinate)<3){throw new Exception("最少三个点");}
			$data['cul_coordinate']=json_encode($coordinate);
		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}

		$obj=new Digital();
		$res=$obj->Add_ware($data,$ware,$user,$file,1);
		return json_encode($res);
	}

	//校验添加和编辑仓库的数据
	public function check_ware_data($data){
		$path1="/^[\x{4e00}-\x{9fa5}|\w|\d]{6,}$/u";
		if(!preg_match($path1,$data['rep_address']))throw new Exception("详细地址格式错误,可以以中文，数字，字母组成,最少六位");
		$path2="/^[\x{4e00}-\x{9fa5}]{2,}$/u";
		$arr=[$data['rep_city'],$data['rep_province']];

		if(!CommenModel::check_preg($arr,$path2)) throw new Exception("地址格式错误,最少2位中文字符");
		$str='/^([a-zA-Z]|[0-9]|[\x{4e00}-\x{9fa5}]|_){4,25}$/u';
		if(!preg_match($str,$data['rep_name']))throw new Exception("仓库名最少4位,最多25位,由任意字母数字中文下划线组成");
	}

	//编辑耕地
	public function editcultiv(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}

			//耕地名称  类型   地块id   面积  颜色   透明度  农田id
			$data['cul_name']     =$request->input('cultiv_name',null);
			$data['cul_color']    =$request->input('cultiv_color',null);
			$data=CommenModel::checkData_dc($data,2);

			$data['cultiva_time'] =$request->input('cultiva_time',null);
			$data['cultiva_year'] =(int)$request->input('cultiv_year',0);
			if(empty($data['cultiva_time'])){
				$data['cultiva_year']=0;
			}
			if($data['cultiva_year'] <0){
				$data['cultiva_year']=0;
			}

			$data['cul_acreage']  =sprintf("%.2f",(float)$request->input('cultiv_acreage',null));
			// $data['reg_id']       =(int)$request->input('region_id',null);
			$data['cul_slide']    =((int)$request->input('cultiv_slide'))>100 || ((int)$request->input('cultiv_slide'))<0?50:(int)$request->input('cultiv_slide',50);

			$data['cultiv_id']       =(int)$request->input('cultiv_id',null);
			if(empty($data['cultiv_id'])){throw new Exception("耕地id不能为空");}
			
			$this->check_region($data,2);
			$file=$request->input('cultiv_image',null);

			//坐标数据
			$coordinate=$request->input('coordinate');
			// $coordinate=$this->simula_array;
			if(empty($coordinate)){throw new Exception("坐标数据不能为空");}
			if(count($coordinate)<3){throw new Exception("最少三个点");}
			$data['cul_coordinate']=json_encode($coordinate);
		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}

		$obj=new Digital();
		$res=$obj->Add_cultiva($data,$user,$file,2,1);
		$old='';
		if(!empty($data['cultiva_time'])){
			$old=date("Y-m-d",strtotime("+".$data['cultiva_year']." years",strtotime($data['cultiva_time']))); 
		}
		$res['old_time']=$old;
		return json_encode($res);
	}

	//编辑仓库
	public function editware(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(empty($user)){throw new Exception("token错误");}
			$id=(int)$request->input('cultiv_id');
			$type=(int)$request->input('type',2);
			if($type==1){
				$data=Db::table('cultivation')->where(['cul_id'=>$id,'cul_cid'=>$user['adm_cid']])->leftjoin('repertory','cultiv_id','=','cul_id')->select('cul_name as cultiv_name','cul_acreage as cultiv_acreage','cul_capacity','cul_ware_type as state','cul_id as cultiv_id','cul_color as cultiv_color','rep_province as province','is_ok','rep_county as county','rep_city as city','rep_address as address','cul_coordinate as coordinate')->first();
				$data['coordinate']=json_decode($data['coordinate'],true);
				return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);

				//返回仓库数据
			}

			//耕地名称  类型   地块id   面积  颜色   透明度  农田id
			$data['cul_name']     =$ware['rep_name']=$request->input('cultiv_name',null);
			$data['cul_color']    =$request->input('cultiv_color',null);
			$data=CommenModel::checkData_dc($data,2);

			$data['cul_acreage']      =sprintf("%.2f",(float)$request->input('cultiv_acreage',null));
			//地块id
			// $data['reg_id']       =(int)$request->input('region_id',null);
			$data['cul_slide']    =((int)$request->input('cultiv_slide'))>100 || ((int)$request->input('cultiv_slide'))<0?50:(int)$request->input('cultiv_slide',50);
			//容量   类型
			$data['cul_capacity'] =(float)$request->input('cul_capacity',0);
			$data['cultiv_id']       =(int)$request->input('cultiv_id',null);
			if(empty($data['cultiv_id'])){throw new Exception("仓库id不能为空");}
			$ware['rep_type']=$data['cul_ware_type']=(int)$request->input('state',1);
			if(!in_array($ware['rep_type'],[1,2,3])){
				$ware['rep_type']=1;
			}
			$ware['rep_province']=$request->input('province','');
			$ware['is_ok']       =(int)$request->input('is_ok',1);
			$ware['rep_county']  =$request->input('county','');
			$ware['rep_city']    =$request->input('city','');
			$ware['rep_address']     =$request->input('address','');

			$this->check_ware_data($ware);
			$this->check_region($data,2);
			$file=$request->input('cultiv_image',null);
			//坐标数据
			$coordinate=$request->input('coordinate');
			// $coordinate=$this->simula_array;
			if(empty($coordinate)){throw new Exception("坐标数据不能为空");}
			if(count($coordinate)<3){throw new Exception("最少三个点");}
			$data['cul_coordinate']=json_encode($coordinate);
		}catch(Exception $e){
			return json_encode(['code'=>500,'msg'=>'error','data'=>$e->getMessage()]);
		}

		$obj=new Digital();
		$res=$obj->Add_ware($data,$ware,$user,$file,2);
		return json_encode($res);
	}

	//添加环境监控
	public function addenviron(Request $request){
		// $token='e931ec0f040fe9f16cb00c793acc68c40c6c1e05';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);

		if(empty($user)){return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);}

		$type=(int)$request->input('type',1);
		if($type==2){
			$region_data=Db::table('massif_region')->where(['reg_state'=>1,'reg_cid'=>$user['adm_cid'],'reg_parent_id'=>0])->select('reg_id as field_id','reg_name as field_name')->get();

			$envir=Db::table('environment')->where(['env_state'=>1,'env_cid'=>$user['adm_cid']])->select('env_id','env_name')->orderBy('env_id','desc')->get();
			return response()->json(['code'=>200,'msg'=>'success','data'=>['envir'=>$envir,'region'=>$region_data]]);

		}

		//环境名称  环境编号 备注  添加人 公司 类型  时间
		$data['env_name']  =(int)$request->input('env_old_id');
		$data['env_number']  =$request->input('env_number');
		$data['env_remarks'] =$request->input('env_remarks',null);
		$data=CommenModel::checkData_dc($data,2);
		
		$data['env_regid']  =(int)$request->input('region_id');         //区域id

		$data['env_longitude']     =$request->input('longitude',null);  //经度
		$data['env_latitude']      =$request->input('latitude',null);   //纬度
		$data['env_aid']    =$user['admin_id'];
		$data['env_cid']    =$user['adm_cid'];
		$data['env_time']   =date('Y-m-d H:i:s');

		if(empty($data['env_name'])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少绑定环境id']);
		}

		if(empty($data['env_longitude']) || empty($data['env_latitude'])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少经纬度']);
		}
		if(empty($data['env_number'])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少环境编号']);
		}
		$obj=new Digital();
		$res=$obj->add_Environ($data,$user,1);
		return json_encode($res);
	}
	
	//编辑环境
	public function editenviron(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);

		if(empty($user)){return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);}
		$type=(int)$request->input('type',1);

		if($type==2){
			$region_data=Db::table('massif_region')->where(['reg_state'=>1,'reg_cid'=>$user['adm_cid'],'reg_parent_id'=>0])->select('reg_id as field_id','reg_name as field_name')->get();

			$envir=Db::table('environment')->where(['env_state'=>1,'env_cid'=>$user['adm_cid']])->select('env_id','env_name')->orderBy('env_id','desc')->get();
			return response()->json(['code'=>200,'msg'=>'success','data'=>['envir'=>$envir,'region'=>$region_data]]);
		}

		//环境名称  环境编号 备注  添加人 公司 类型  时间
		$data['env_id']      =(int)$request->input('env_id');
		$data['env_name']    =(int)$request->input('env_old_id');
		$data['env_number']  =$request->input('env_number');
		$data['env_remarks'] =$request->input('env_remarks',null);
		$data=CommenModel::checkData_dc($data,2);
		
		$data['env_regid']  =(int)$request->input('region_id');         //区域id

		$data['env_longitude']     =$request->input('longitude',null);  //经度
		$data['env_latitude']      =$request->input('latitude',null);   //纬度
		$data['env_aid']    =$user['admin_id'];
		$data['env_cid']    =$user['adm_cid'];
		$data['env_time']   =date('Y-m-d H:i:s');
		if(empty($data['env_id'])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少环境监控id']);
		}
		if(empty($data['env_name'])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少绑定环境id']);
		}

		if(empty($data['env_longitude']) || empty($data['env_latitude'])){
			unset($data['env_longitude']);
			unset($data['env_latitude']);
		}
		if(empty($data['env_number'])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少环境编号']);
		}
		$obj=new Digital();
		$res=$obj->add_Environ($data,$user,2);
		return json_encode($res);
	}

	//添加摄像头
	public function addcamera(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user))return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);
		$data['equ_name']          =$request->input('equip_name',null);      //设备名称
		$data['equ_number']        =$request->input('equip_number',null);    //设备名称
		if(empty($data['equ_name']) || empty($data['equ_number'])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'参数不能为空']);
		}
		$data['equ_longitude']     =$request->input('longitude',null);         //经度
		$data['equ_latitude']      =$request->input('latitude',null);          //纬度

		$data['appKey']            =$request->input('appKey',' ');
		$data['appSecret']         =$request->input('appSecret',' ');


		//区域id  地块id  耕地id
		$data['equ_regid']  =(int)$request->input('region_id',null);    //区域id
		$data['equ_landid'] =$request->input('field_id')?(int)$request->input('field_id'):'';
		$data['equ_culid']  =$request->input('cultiv_id')?(int)$request->input('cultiv_id'):'';

		$data['equ_cid']=$user['adm_cid'];//公司
		$data['equ_aid']=$user['admin_id'];//用户
		$obj=new Digital();
		$res=$obj->Add_Camera($data,$user);
		return json_encode($res);
	}

	//删除摄像头
	public function delcamera(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user))return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);

		//摄像头id
		$equip_id =(int)$request->input('equip_id',null); 
		if(empty($equip_id)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少摄像头id']);
		}
		$obj=new Digital();
		$res=$obj->Del_Camera($equip_id,$user,1);
		return json_encode($res);
	}
	//删除环境
	public function delenviron(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user))return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);

		//摄像头id
		$equip_id =(int)$request->input('env_id',null); 
		if(empty($equip_id)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少环境id']);
		}
		$obj=new Digital();
		$res=$obj->Del_Camera($equip_id,$user,2);
		return json_encode($res);
	}

	//编辑摄像头
	public function editcamera(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);

		if(empty($user)){return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);}

		$type=(int)$request->input('equip_type',2);
		if($type==1){
			$data=Db::table('equipment')->where(['equ_id'=>(int)$request->input('equip_id',null)])->leftjoin('massif_region as a','a.reg_id','=','equ_regid')->leftjoin('massif_region as b','b.reg_id','=','equ_landid')->leftjoin('cultivation as c','c.cul_id','=','equ_culid')->select('equ_id','equ_name','equ_number','equ_regid','a.reg_name as region_name','b.reg_name as land_name','equ_landid','equ_culid','cul_name as cultiv_name','equ_longitude','equ_latitude','appKey','appSecret')->first();
			return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
		}

		$data['equip_id']          =(int)$request->input('equip_id',null);   //设备id
		$data['equ_name']          =$request->input('equip_name',null);      //设备名称
		$data['equ_number']        =$request->input('equip_number',null);    //设备编号
		if(empty($data['equ_name']) || empty($data['equ_number'])){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'参数不能为空']);
		}
		$data['equ_longitude']     =$request->input('longitude',null);         //经度
		$data['equ_latitude']      =$request->input('latitude',null);          //纬度
		if(empty($data['equ_longitude']) || empty($data['equ_latitude'])){
			unset($data['equ_latitude']);
			unset($data['equ_longitude']);
		}
		$data['appKey']            =$request->input('appKey',' ');
		$data['appSecret']         =$request->input('appSecret',' ');

		if(empty($data)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'设备id不能为空']);
		}

		//区域id  地块id  耕地id
		$data['equ_regid']  =(int)$request->input('region_id',null);    //区域id
		$data['equ_landid'] =$request->input('field_id')?(int)$request->input('field_id'):'';
		$data['equ_culid']  =$request->input('cultiv_id')?(int)$request->input('cultiv_id'):'';

		// $data['equ_cid']=$user['adm_cid'];//公司
		$data['equ_aid']=$user['admin_id'];//用户
		$obj=new Digital();
		$res=$obj->Add_Camera($data,$user,2);
		return json_encode($res);
	}


	//获取地块列表  只是获取左边的三级联动列表
	public function massiflist(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));

		$user=CommenModel::getUserToken($token);
		if(empty($user))return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);

		// if(empty((int)$request->input("pri_id",0))){return json_encode(['code'=>500,'msg'=>'error','data'=>'缺少按钮id'],JSON_UNESCAPED_UNICODE);}
		//获取所有的区域和地块信息
		$massif_data=Db::table('massif_region')->where('reg_state','!=',3)->where(['reg_cid'=>$user['adm_cid']])->selectRaw("reg_id as region_id,reg_name as region_name,reg_parent_id as son_id,1 as land_type")->orderBy('reg_id','asc')->get();

		$massif_data=array_column($massif_data,null,'region_id');

		//获取所有的耕地信息
		$cultiv_data=Db::table('cultivation')->where('cul_state','!=',3)->where(['cul_cid'=>$user['adm_cid'],'cul_type'=>1])->selectRaw("cul_id as cultiv_id,cul_name as cultiv_name,reg_id as region_id,2 as land_type")->get();
		//将耕地信息放到地块下
		foreach ($cultiv_data as $key => $val){
			$massif_data[$val['region_id']]['cultiv'][]=$val;
		}
		unset($cultiv_data);
		$data=[];
		//统计所有区域
		foreach ($massif_data as $key => $value){
			if($value['son_id']==0){
				$data[$key]=$value;
			}
			continue;
		}
		//将地块信息放到区域下
		foreach ($massif_data as $key => $val){
			if(empty($data[$val['son_id']])) continue;

			$data[$val['son_id']]['massif'][]=$val;
		}
		unset($massif_data);
		$res=['code'=>200,'msg'=>'success','data'=>array_values($data)];

		$res['button']=wherebutton($request->input("api_token"),(int)$request->input("pri_id",0));
		return json_encode($res);
	}

	//获取 区域 地块 下的耕地信息
	public function cultivated(Request $request){
		// $token='d54c08ee4e8661563585a3a576792ef1b5c8f52c';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user))return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		//获取地块信息；
		$region_id=(int)$request->input('region_id',null);
		$region_list=Db::table('massif_region')->where('reg_state','!=',3)->where(['reg_cid'=>$user['adm_cid'],'reg_id'=>$region_id])->select('reg_id as region_id','reg_name as region_name','reg_parent_id as son_id','reg_image','acreage')->first();

		if(empty($region_list)){return json_encode(['code'=>200,'msg'=>'success','data'=>[]]);}
		$type=1;
		//如果是区域
		if($region_list['son_id']==0){
			$region_list['explode']='区域';
			$data_son=Db::table('massif_region')->where('reg_state','!=',3)->where(['reg_cid'=>$user['adm_cid'],'reg_parent_id'=>$region_list['region_id']])->selectRaw("reg_id as region_id,reg_name as region_name,'地块' as explode,reg_image,acreage,1 as cultiva,'' as cultiva_time")->get();
			$region_list['son_id']=1;
			$region_list['cultiva']=1;
			$region_list['cultiva_time']='';
			$data[]=$region_list;
			foreach ($data_son as $key => $val){
				// $data_son[$key]['coordinate']=json_decode($val['coordinate'],true);
				$data_son[$key]['son_id']=2;
				$data[]=$data_son[$key];
			}
			$type=1;
		}else{
			$region_list['explode']='地块';
			$region_list['son_id']=2;
			$region_list['cultiva']=1;
			$region_list['cultiva_time']='';
			// $region_list['coordinate']=json_decode($region_list['coordinate'],true);
			$data[]=$region_list;
			$type=2;
		}
		//获取所有耕地
		$all_region_id=array_column($data,'region_id');
		$cultiv_data=Db::table('cultivation')->where('cul_state','!=',3)->where(['cul_cid'=>$user['adm_cid'],'cul_type'=>1])->whereIn('reg_id',$all_region_id)->selectRaw("cul_id as region_id,cul_name as region_name,reg_id as farel,'耕地' as explode,cul_image as reg_image,cul_acreage as acreage,3 as son_id,cultiva_time,cultiva_year")->get();
		if($type==1){

			$new_data=array_column($data_son,null,'region_id');
			foreach ($new_data as $key => $val){
				$new_data[$key]['list'][]=$val;
				unset($new_data[$key]['acreage']);
				unset($new_data[$key]['cultiva']);
				unset($new_data[$key]['explode']);
				unset($new_data[$key]['reg_image']);
				unset($new_data[$key]['son_id']);
				unset($new_data[$key]['cultiva_time']);
			}

			foreach ($cultiv_data as $key => $value){
				$cultiv_data[$key]['cultiva']=1;
				//判断是否有培养时间
				if(!empty($value['cultiva_time'])){
					//获取培育到期的时间戳
					$oldtime=strtotime("+".$value['cultiva_year']." years",strtotime($value['cultiva_time']));
					//判断，培育时间是当前时间之后的，然后判断不超过三个月的培育耕地
					if($oldtime>time() && strtotime("-3 month",$oldtime)<time()){
						$cultiv_data[$key]['cultiva_time']=date('Y-m-d',$oldtime);
						$cultiv_data[$key]['cultiva']=2;
					}else{
						$cultiv_data[$key]['cultiva_time']='';
					}
				}
				$new_data[$value['farel']]['list'][]=$cultiv_data[$key];
			}
			$new_data[0]['region_name']=$region_list['region_name'];
			$new_data[0]['region_id']=$region_list['region_id'];
			$new_data[0]['list']=$data;

			foreach ($new_data as $key => $value) {
				if(count($value['list'])<2 && $key !=0){
					unset($new_data[$key]);
				}
			}
			// sort($new_data);
		}else{
			foreach ($cultiv_data as $key => $value) {
				$cultiv_data[$key]['cultiva']=1;
				//判断是否有培养时间
				if(!empty($value['cultiva_time'])){
					//获取培育到期的时间戳
					$oldtime=strtotime("+".$value['cultiva_year']." years",strtotime($value['cultiva_time']));
					if($oldtime>time() && strtotime("-3 month",$oldtime)<time()){

						$cultiv_data[$key]['cultiva_time']=date('Y-m-d',$oldtime);
						$cultiv_data[$key]['cultiva']=2;
					}else{
						$cultiv_data[$key]['cultiva_time']='';
					}
				}
				// $cultiv_data[$key]['coordinate']=json_decode($value['coordinate'],true);
				$data[]=$cultiv_data[$key];
			}
			
			$new_data[0]['region_id']=$data[0]['region_id'];
			$new_data[0]['region_name']=$data[0]['region_name'];
			$new_data[0]['list']=$data;
		}
		$data=['code'=>200,'msg'=>'成功','data'=>$new_data];
		return response()->json($data);

	}

	//获取耕地的耕种详情
	public function cultails(Request $request){
		// $token='e931ec0f040fe9f16cb00c793acc68c40c6c1e05';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user))return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		//获取耕地id  用于获取耕地详情
		$id=(int)$request->input('cultiv_id',null);
		$where['details']=null;
		if(empty($id)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'耕地id不能为空']);
		}
		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);
		}
		$obj=new Digital();
		$res=$obj->getCultivat_Land($user,$id,$where);
	
		return json_encode($res);
	}

	//获取耕地详情列表 信息
	public function cultailslist(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user))return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误'],JSON_UNESCAPED_UNICODE);

		//获取耕地id  用于获取耕地详情
		$id=(int)$request->input('cultiv_id',null);
		if(empty($id)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'耕地id不能为空']);
		}
		$where['time']=$request->input("cultiv_time",null);
		$where['inputhing']  =$request->input("cultiv_thing",null);
		$where['user_name']  =$request->input('user_name',null);
		$where['details']    =$request->input('details',null);
		$where['page']       =(int)$request->input('page',1);
		$where['page_count'] =(int)$request->input('page_count',10);
		$obj=new Digital();
		$res=$obj->getCultivat_Land($user,$id,$where);
		unset($res['data']['cultiv_data']);
		unset($res['data']['region_data']);
		unset($res['data']['plot_data']);
		unset($res['data']['region_list']);
		return json_encode($res);
	}

	//编辑  获取农田信息
	public function getmatfar(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		//获取农田id
		$id=(int)$request->input('massif_id',null);
		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);
		}
		if(empty($id))return json_encode(['code'=>500,'msg'=>'error','data'=>'农田id不能为空']);
		$data=Db::table('farmland')->where('far_state','!=',3)->where(['far_cid'=>$user['adm_cid'],'far_id'=>$id])->select('far_id as massif_id','far_longitude as longitude','far_latitude as latitude','far_address as address','farmland_img as image','far_name as massif_name','respon_user as respon_name','respon_tel')->first();
		if(empty($data)){return json_encode(['code'=>500,'msg'=>'error','data'=>'没有该农田']);}
		return json_encode(['code'=>200,'msg'=>'success','data'=>$data]);
	}

	//获取区域信息 或地块信息
	public function getregion(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);

		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);
		}
		//获取区域id  或 地块 id
		$id=(int)$request->input('region_id',null);
		//判断是区域还是地块  如果是区域则获取 农田列表  是地块则获取区域列表
		$data=Db::table('massif_region')->where('reg_state','!=',3)->where(['reg_cid'=>$user['adm_cid'],'reg_id'=>$id])->select('reg_id as region_id','reg_name as region_name','far_id as massif_id','reg_parent_id','reg_color as region_color','reg_image','slide as region_slide','acreage as region_acreage','coordinate')->first();

		if(empty($data)){return json_encode(['code'=>500,'msg'=>'error','data'=>'没有该区域数据']);}

		$data['coordinate']=json_decode($data['coordinate'],true);
		if($data['reg_parent_id']==0){
			//获取农田列表  移除 已经与区域的农田
			//获取所有关联在区域表的农田id
			$mass_data=Db::table('massif_region')->where('reg_state','!=',3)->where(['reg_cid'=>$user['adm_cid'],'reg_parent_id'=>0])->select('reg_id','far_id')->get();
			$id_data=array_column($mass_data,'far_id','reg_id');
			unset($id_data[$id]);
			$data['type']=1;
			$massif=DB::table('farmland')->where(['far_state'=>1,'far_cid'=>$user['adm_cid']])->whereNotIn('far_id',$id_data)->select('far_id as massif_id','far_name as massif_name','far_id as values')->get();
			return json_encode(['code'=>200,'msg'=>'success','data'=>['region'=>$data,'massif_data'=>$massif,'region_data'=>[]]]);
		}else{
			$data['type']=2;
			//获取区域列表
			$massif=DB::table('massif_region')->where(['reg_state'=>1,'reg_cid'=>$user['adm_cid'],'reg_parent_id'=>0])->select('reg_id as field_id','reg_name as field_name','reg_id as values')->get();
			return json_encode(['code'=>200,'msg'=>'success','data'=>['region'=>$data,'massif_data'=>[],'region_data'=>$massif]]);

		}
		
	}

	//获取耕地或者仓库信息
	public function getarable(Request $request){
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);

		//获取耕地id 或 仓库id
		$id=(int)$request->input('cultiv_id',null);

		//因为他是编辑 所以不用传递区域id   因为数据库 有区域id  除非删除
		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);
		}

		$data=Db::table('cultivation')->where('cul_state','!=',3)->where(['cul_cid'=>$user['adm_cid'],'cul_id'=>$id])->select('cul_id as cultiv_name','cul_name as cultiv_name','reg_id as region_id','cul_acreage as cultiv_acreage','cul_color as cultiv_color','cul_slide as cultiv_slide','cul_ware_type as ware_type','cul_capacity')->first();
		if(empty($data)){return json_encode(['code'=>500,'msg'=>'error','data'=>'没有该区域数据']);}

		$reg_parent_id=Db::table('massif_region')->where(['reg_id'=>$data['region_id']])->select('reg_parent_id')->pluck('reg_parent_id');
		//获取这个区域下所有地块信息
		$region=DB::table('massif_region')->where(['reg_state'=>1,'reg_cid'=>$user['adm_cid'],'reg_parent_id'=>$reg_parent_id])->select('reg_id as region_id','reg_name as region_name','reg_id as values')->get();
		return json_encode(['code'=>200,'msg'=>'success','data'=>['cultiv'=>$data,'region'=>$region]]);
	}

	//获取农田列表
	public function farmland(Request $request){
		// $token='e931ec0f040fe9f16cb00c793acc68c40c6c1e05';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);
		}
		//获取所有的农田信息；
		$farmland=Db::table('farmland')->where(['far_cid'=>$user['adm_cid'],'far_state'=>1])->select('far_id as massif_id','far_name as massif_name')->get();
		if(empty($farmland)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'没有农田信息,请先添加农田']);
		}else{
			return json_encode(['code'=>200,'msg'=>'success','data'=>$farmland]);
		}
	}

	//获取区域列表
	public function regionlist(Request $request){
		// $token='e931ec0f040fe9f16cb00c793acc68c40c6c1e05';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);
		}
		$region_data=Db::table('massif_region')->where(['reg_state'=>1,'reg_cid'=>$user['adm_cid'],'reg_parent_id'=>0])->select('reg_id as field_id','reg_name as field_name')->get();
		if(empty($region_data)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'没有区域信息,请先添加区域']);
		}else{
			return json_encode(['code'=>200,'msg'=>'success','data'=>$region_data]);
		}
	}

	//获取地块列表
	public function massifdata(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误']);
		}
		$region_id=(int)$request->input('region_id',null);
		if(empty($region_id)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'区域id不能为空']);
		}

		$massif_data=Db::table('massif_region')->where(['reg_state'=>1,'reg_cid'=>$user['adm_cid'],'reg_parent_id'=>$region_id])->select('reg_id as region_id','reg_name as region_name')->get();
		$one=['region_id'=>'','region_name'=>''];

		if(empty($massif_data)){
			return json_encode(['code'=>200,'msg'=>'success','data'=>[$one]]);
		}else{
			array_unshift($massif_data,$one);
			return json_encode(['code'=>200,'msg'=>'success','data'=>$massif_data]);
		}
	}

	//获取耕地列表
	public function cultivalist(Request $request){
		// $token='e931ec0f040fe9f16cb00c793acc68c40c6c1e05';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(empty($user)){
			return json_encode(['code'=>500,'msg'=>'error','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		$region_id=(int)$request->input('field_id',null);
		$one=['cultiv_id'=>'','cultiv_name'=>''];
		if(empty($region_id)){
			return json_encode(['code'=>200,'msg'=>'success','data'=>[$one]]);
		}

		$massif_data=Db::table('cultivation')->where(['cul_state'=>1,'cul_cid'=>$user['adm_cid'],'cul_type'=>1,'reg_id'=>$region_id])->select('cul_id as cultiv_id','cul_name as cultiv_name')->get();
		// $one=['cultiv_id'=>'','cultiv_name'=>''];
		array_unshift($massif_data,$one);
		return json_encode(['code'=>200,'msg'=>'success','data'=>$massif_data],JSON_UNESCAPED_UNICODE);
	}
	// // 搜索 获取环境监控
	// public function getenvirlist(Request $request){
	// 	$token=Crypt::decrypt($request->input("api_token"));
	// 	$user=CommenModel::getUserToken($token);
	// 	if(empty($user)){
	// 		return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
	// 	}
	// 	$name=$request->input('env_name',null);

	// 	$envir=Db::table('environment')->where(['env_state'=>1,'env_cid'=>$user['adm_cid']])->where('env_name','like',$name.'%')->select('env_id','env_name')->limit(10)->orderBy('env_id','desc')->get();
	// 	return response()->json(['code'=>200,'msg'=>'success','data'=>$envir]);
	// }
	

}