<?php

namespace App\Http\Controllers\Lore;
use App\Http\Models\Register;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\DB;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;

use App\Http\Models\Coperationa;
use Crypt;
class RegisterController extends Controller
{
    // 注册
    public function register(Request $request){
        date_default_timezone_set("PRC");  //设置为北京时区
        $input = $request->all(); //接收所有的值
        // 验证数据
        if (empty($request->input('com_name'))||empty($request->input('adm_username'))||empty($request->input('adm_tel'))||empty($request->input('adm_code'))||empty($request->input('adm_pas'))||empty($request->input('info_province'))||empty($request->input('info_city'))||empty($request->input('info_county'))||empty($request->input('info_address'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $pwd_preg='/^[\w\_]{6,15}$/u';
        if(!preg_match($pwd_preg,$input['adm_pas'])){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '密码由6-15位数字,字母或下划线组成！']);
        }
        // 验证手机验证码
        $tel = DB::table('telcode')
                ->where('tel_phone',"=",$input['adm_tel'])
                ->orderBy('tel_id','desc')
                ->first(['tel_created_at','tel_code']);
        $code_time = strtotime($tel['tel_created_at']);
        if($code_time < time()-600){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机验证码超时']);
        }
        if($tel['tel_code'] != $input['adm_code']){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机验证码错误']);
        }
        // 查询该手机号是否注册过
        $is_register = DB::table('admin')->where('adm_mobile', $input['adm_tel'])->count();
        if($is_register['adm_mobile']){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该手机号已注册过账号,不可重复注册']);
        }
        DB::beginTransaction();//开启事务
        // 验证公司名称是否存在
        $is_comname = DB::table('company')->where('com_name',$input['com_name'])->first(['com_name']);
        if($is_comname){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该公司已存在']);
        }
        // 验证账号是否存在
        $is_admacc = DB::table('admin')->where('adm_acc',$input['adm_tel'])->first(['adm_acc']);
        if ($is_admacc) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该账号已存在']);
        }
        // 图片上传
        $goo_picurl = '';
        if (!empty($request->input('com_logo'))) {
            // 上传图片
            $uploadImg = new CommonController;
            foreach ($request->input('com_logo') as $key => $value) {
                if (substr($value,0,11) == 'data:image/') {
                    $uploadPath = $uploadImg->uploadBase64Img($value);
                    if ($uploadPath) {
                        $goo_picurl .= $uploadPath.',';
                    }else{
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                    }
                }else{
                    $goo_picurl .= substr($value,strlen($this->URLPATH)).',';
                }
            }
            $goo_picurl = trim($goo_picurl,','); //图片的路径
        }

        // 会员表
        $company_id = DB::table('company')
                      ->insertGetId(['com_name'=> $input['com_name'],
                                     'com_logo'=> $goo_picurl,
                                     'com_fid'=> 1,
                                     'com_nature' => 2
                                    ]);
        // 计算二维码标识
        $sta = 6; //初始第一位数
        $number = $company_id/10000;
        $keyword= substr($number,0,1);
        $sta = $sta+$keyword;//处理后的第一位数
        if ((floor($number) - $number) ==0){
            $last = 0;
        }
        // 公司id为小于等于四位数时
        if(strlen($company_id) <=4){
           $len = 4-strlen($company_id);
           $zero = "";
           for($i=0;$i<$len;$i++){
                   $zero .= 0;
           }
           $sum = $sta.$zero.$company_id;
        }else{
           // 公司id为五位数时
           $zero = substr($company_id,1);
           $sum = $sta.$zero;
        }
        // 会员附属表
        $data = [
            $company_id,                //公司id
            $input['adm_username'],     //联系人
            $input['adm_tel'],          //联系电话
            $sum,                       //二维码标识
            $input['info_province'],    //省
            $input['info_city'],        //市
            $input['info_county'],      //县
            $input['info_address'],     //详细地址
        ];
        $info_data = DB::insert('insert into trace_company_info (`info_cid`,`info_person`, `info_mobile`,`info_code_id`,`info_province`,`info_city`,`info_county`,`info_address`) values(?,?,?,?,?,?,?,?)',$data);
        // 角色表
        $pris = Db::table('role')->whereIn("rol_id",  [1, 3, 4, 5])->select('rol_pri')->get();
        $rol_pri = '';
        foreach ($pris as $pri){
            $rol_pri .="{$pri['rol_pri']},";
        }
        $rol_res = DB::table('role')
                          ->insertGetid([
                            'rol_name'  => '总管理',
                            'rol_pri'   => trim($rol_pri,','),
                            'rol_sta'   => 1,
                            'rol_cid'   => $company_id,
                            'rol_create_time' => date('Y-m-d H:i:s'),
                            'rol_type'  => 1
                            ]);
        // 账号表
        $Register = new Register();
        $reg['adm_cid'] = $company_id;
        $reg['adm_name'] = $input['adm_username'];
        $reg['adm_acc'] = $input['adm_tel'];
        $reg['adm_pas'] = md5(md5($input['adm_pas']."admin"));
        $reg['adm_mobile'] = $input['adm_tel'];
        $reg['adm_pre'] = $rol_res; //权限
        $reg['adm_module'] = "1,3,4,5";
        $reg['adm_type'] = "3";
        $reg['adm_identifies'] = $input['adm_identifies'];
        $reg['adm_leave'] = 1;
        $add_data = Register::insertGetId($reg);
        // 信息表
        $mes_res = DB::table('message')->insert([
                                                'msg_title'   => " 【注册消息】注册成功，欢迎您登陆云溯源平台！ ",
                                                'msg_content' => "感谢您注册蓝科溯源企业旗下的云溯源平台（http://md.bluearp.com/
                                                )账户,请您牢记您的用户名与密码,希望我们的服务能够让您的商品溯源工作更加智能便捷！
                                                如您在使用过程有任何疑问，请咨询在线客服或及时与我们联系，客服热线400-8170015",
                                                'msg_adm_id'  => $add_data
                                                ]);
        if($company_id && $add_data && $info_data){
            DB::commit();
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '注册成功']);
        }else{
            DB::rollBack();
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '注册失败']);
        }
    }
    // 忘记密码
    public function forget_pas(Request $request){
        date_default_timezone_set("PRC");  //设置为北京时区
        $input = $request->all(); //接收所有的值

        $pwd_preg='/^[\w\_]{6,15}$/u';
        if(!preg_match($pwd_preg,$input['adm_pas'])){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '密码由6-15位数字,字母或下划线组成！']);
        }
        // 验证手机验证码
        $tel = DB::table('telcode')
                ->where('tel_phone',"=",$input['adm_tel'])
                ->orderBy('tel_id','desc')
                ->first(['tel_created_at','tel_code']);
        $code_time = strtotime($tel['tel_created_at']);
        if($code_time < time()-600){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机验证码超时']);
        }
        if($tel['tel_code'] != $input['adm_code']){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机验证码错误']);
        }
        // 验证登录密码与确认密码是否一致
        if($input['adm_pas'] <> $input['adm_affpas']){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入一致的登录密码与确认密码']);
        }
        $adm_pas = md5(md5($input['adm_pas']."admin"));
        // 账号表
        $add_data = DB::table('admin')
                    ->where('adm_mobile',$input['adm_tel'])
                    ->update([
                        'adm_pas' => $adm_pas
                        ]);
        if($add_data){
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '操作成功']);
        }else{
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '新密码与原密码一致']);
        }
    }

    // 手机验证码
    public function telCode(Request $request){
        if (!in_array($request->input('type'),array(1,2)) || empty($request->input('phone'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $code = mt_rand(1000, 9999);//生成四位验证码
        if ($request->input('type') == 1) {
            // 验证手机号的正确性     
            if(!preg_match("/^1[3456789]{1}\d{9}$/",$request->input('phone'))){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请输入正确的手机号']);
            }
            $tel = DB::table('admin')->where('admin.adm_mobile', $request->input('phone'))->value('adm_mobile');
            // var_dump($tel);exit;
            if($tel != NULL){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '当前手机号已注册']);
            }
            $tel_status = 1;
            $tel_type = '注册';
            $message = "您注册的\"云溯源系统\"账号的验证码为{$code}，十分钟内有效。";//短信信息
        }else if ($request->input('type') == 2){
            $tel_status = 2;
            $tel_type = '找回';
            // 验证手机号的正确性     
            if(!preg_match("/^1[3456789]{1}\d{9}$/",$request->input('phone'))){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请输入正确的手机号']);
            }
            // 验证账号是否存在
            $is_admacc = DB::table('admin')->where('adm_mobile',$request->input('phone'))->first(['adm_mobile']);
            if (empty($is_admacc)) {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '此手机号码未注册']);
            }
            $message = "您正在找回的\"云溯源系统\"账号密码,验证码为{$code}，十分钟内有效。";//短信信息
        }
        $this->sendSmsCode($request->input('phone'),$message);//发送短信
        DB::table('telcode')->insert(['tel_phone'=>$request->input('phone'),'tel_code'=>$code,'tel_status'=>$tel_status,'tel_type'=>$tel_type]);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => '发送成功']);
    }

    private function sendSmsCode($mobile, $content)
    {
        $username = "lksy";
        $pwd = "19r1rt22";
        $password = md5($username . "" . md5($pwd));

        $url = "http://www1.jc-chn.cn/smsSend.do?";

        $param = http_build_query(
            array(
                'username' => $username,
                'password' => $password,
                'mobile' => $mobile,
                // 'content'=>iconv("GB2312","UTF-8",$content)
                'content' => $content
            )
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    // 上传营业执照
    function companyInfo(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        if(!empty($request['info_license']))
        {
            $image = $request['info_license'];
            $imageName = date("His",time())."_".rand(1111,9999).'.png';
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';

            $path = "uploads/license/".date("Ymd",time());
            // 获取原营业执照文件名
            $oldphoto = DB::table('login_temporary as lt')
                            ->leftjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
                            ->leftjoin('company as c', 'c.com_id', '=', 'a.adm_cid')
                            ->leftjoin('company_info as ci','ci.info_cid','=','c.com_id')
                            ->where('lt.api_token','=',$api_token)
                            ->select('info_license','c.com_id')
                            ->first();


            if (!is_dir($path)){ //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            $imageSrc=  $path."/". $imageName;  //图片名字
            if(is_file($upload_files.$oldphoto['info_license']))
            {
                // 修改新logo文件名
                $newphoto = DB::table('company as c')
                            ->leftjoin('company_info as ci','ci.info_cid','=','c.com_id')
                            ->where('com_id','=',$oldphoto['com_id'])
                            ->update(['info_license'=>$imageSrc]);
                // 修改原图片权限
                chmod($upload_files.$oldphoto['info_license'],0777);
                // 删除原图片
                unlink($upload_files.$oldphoto['info_license']); 
            }else{
                $newphoto = DB::table('company as c')
                            ->leftjoin('company_info as ci','ci.info_cid','=','c.com_id')
                            ->where('com_id','=',$oldphoto['com_id'])
                            ->update(['info_license'=>$imageSrc]);
            }
            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(["code"=>200,'msg'=>'success','data'=>'上传营业执照成功','path'=>$imageSrc]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'还未选择营业执照']);
        }
    }

    // 开始试用
    public function startTheTrials(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        DB::beginTransaction();//开启事务
        try{
            $endData = date("Y-m-d H:i:s", strtotime("+3day"));
            $adm_res = DB::table('admin')
                    ->where('adm_id',$find_adm['adm_id'])
                    ->update([
                        'adm_endtime' => $endData,
                        'adm_nature'  => 2,
                        'adm_flow'    => 2
                        ]);
            if ($adm_res === false) throw new Exception("账号表更新失败");
            $com_res = DB::table('company')
                    ->where('com_id',$find_adm['adm_cid'])
                    ->update([
                        'com_expiretime' => $endData,
                        'com_nature'  => 1
                        ]);
            if ($com_res === false) throw new Exception("公司表更新失败");
            DB::commit();
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '申请成功']);
        }catch(Exception $e){
            DB::rollBack();
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '申请失败']);
        }
    }
    public function startTheTrial(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        DB::beginTransaction();//开启事务
        try{
            $endData = date("Y-m-d H:i:s", strtotime("+3day"));
            // 角色表
            $jurisdiction = "";
            $jur = explode(',',$request['adm_module']);
            foreach ($jur as $key => $val) {
                $rol_jur = DB::table('role')->where('rol_id','=',$val)->select('rol_pri')->first();
                $jurisdiction .= $rol_jur['rol_pri'].",";
            }
            $adm_res = DB::table('admin')
                    ->leftjoin('role','role.rol_id','=','admin.adm_pre')
                    ->where('adm_id',$find_adm['adm_id'])
                    ->update([
                        'adm_endtime' => $endData,
                        'adm_nature'  => 2,
                        'adm_flow'    => 2,
                        'rol_pri'         => trim($jurisdiction,','),   //角色权限
                        'adm_module'    => $request['adm_module'], 
                        'rol_update_time' => date("Y-m-d H:i:s")        //添加时间
                        ]);
            if ($adm_res === false) throw new Exception("账号表更新失败");
            $com_res = DB::table('company')
                    ->where('com_id',$find_adm['adm_cid'])
                    ->update([
                        'com_expiretime' => $endData,
                        'com_nature'  => 1
                        ]);
            if ($com_res === false) throw new Exception("公司表更新失败");
            DB::commit();
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '申请成功']);
        }catch(Exception $e){
            DB::rollBack();
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '申请失败']);
        }
    }
    // 缴费
    public function setMeal(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $roles = DB::table('role')->whereIn('rol_id',[1,3,4,5])->selectRaw('rol_id,rol_name,rol_price,rol_discounts')->get();
        $validPri = DB::table('admin')->where('adm_id',$find_adm['adm_id'])->select('adm_endtime','adm_flow','adm_module')->get();
        // 转换时间戳   到期减去当前  判断是否大于0  大于0 则转换否则 复制0
        foreach($validPri as $key=>$val){
            $end_time = strtotime($val['adm_endtime']);
            // dd($end_time);
            $diff_time = $end_time-time();
            if($diff_time > 0){
                if($diff_time < 60*60){
                    $validPri[$key]['adm_endtime'] = '不足1小时';
                }else{
                    $day = floor($diff_time/(24*60*60));
                    $hour = floor($diff_time%(24*60*60)/(60*60));
                    $validPri[$key]['adm_endtime'] = $day.'天'.$hour.'小时';
                }
            }else{
                $validPri[$key]['adm_endtime'] = '0天';
            }
        }
        $userInfo = DB::table('company as c')->leftjoin('company_info as ci','ci.info_cid','=','c.com_id')->where('com_id',$find_adm['adm_cid'])->select('com_name','info_license','com_id')->first();
        $userInfo = ['company_name' => $userInfo['com_name'], 'company_user_name' => $find_adm['adm_mobile'],'info_license'=>$userInfo['info_license'],'com_id'=>$userInfo['com_id'],'adm_id'=>$find_adm['adm_id']];
        return response()->json(['code' => 200, 'msg' => 'success', 'roles' => $roles,'userInfo' => $userInfo,'validPri'=>$validPri]);
    }
    public function setMeals(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $roles = DB::table('role')->whereIn('rol_id',[1,3,4,5])->selectRaw('rol_id,rol_name,rol_price,rol_discounts')->get();
        $validPri = DB::table('admin')->where('adm_id',$find_adm['adm_id'])->select('adm_endtime','adm_flow')->get();
        // 转换时间戳   到期减去当前  判断是否大于0  大于0 则转换否则 复制0
        foreach($validPri as $key=>$val){
            $end_time = strtotime($val['adm_endtime']);
            // dd($end_time);
            $diff_time = $end_time-time();
            if($diff_time > 0){
                if($diff_time < 60*60){
                    $validPri[$key]['adm_endtime'] = '不足1小时';
                }else{
                    $day = floor($diff_time/(24*60*60));
                    $hour = floor($diff_time%(24*60*60)/(60*60));
                    $validPri[$key]['adm_endtime'] = $day.'天'.$hour.'小时';
                }
            }else{
                $validPri[$key]['adm_endtime'] = '0天';
            }
        }
        $userInfo = DB::table('company as c')->leftjoin('company_info as ci','ci.info_cid','=','c.com_id')->where('com_id',$find_adm['adm_cid'])->select('com_name','info_license','com_id')->first();
        $userInfo = ['company_name' => $userInfo['com_name'], 'company_user_name' => $find_adm['adm_mobile'],'info_license'=>$userInfo['info_license'],'com_id'=>$userInfo['com_id'],'adm_id'=>$find_adm['adm_id']];
        return response()->json(['code' => 200, 'msg' => 'success', 'roles' => $roles,'userInfo' => $userInfo,'validPri'=>$validPri]);
    }
    // 支付
    public function return_urls(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $endDate = date('Y-m-d H:i:s', strtotime("+1year"));
        $nowDate = date("Y-m-d H:i:s");
        $out_trade_no = $request['trade_no'];
        $sql = DB::table('order')
                ->where('order_no',$out_trade_no)
                ->update([
                    'order_valid' => $endDate,
                    'payment_at'  => $nowDate,
                    'order_adm_id' => $find_adm['adm_id'],
                    'order_status' => 6
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '订单表更新失败']);
        }
        $admRes = DB::table('admin')->where('adm_id',$find_adm['adm_id'])->select('adm_pre','adm_module')->first();
        $sql = DB::table('admin')
                ->where('adm_id',$find_adm['adm_id'])
                ->update([
                    'adm_payment_status' => 2,
                    'adm_flow'  => 3,
                    'adm_endtime' => $endDate,
                    'adm_nature' => 2
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '账号表更新失败']);
        }
        $sql = DB::table('company')
                ->where('com_id',$find_adm['adm_cid'])
                ->update([
                    'com_nature' => 3,
                    'com_expiretime'  => $endDate
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '公司表更新失败']);
        }
        $pris = Db::table('role')->whereIn("rol_id",  [1, 3, 4, 5])->select('rol_pri')->get();
        $rol_pri = '';
        foreach ($pris as $pri){
            $rol_pri .="{$pri['rol_pri']},";
        }
        $sql = DB::table('role')
                ->where('rol_id',$admRes['adm_pre'])
                ->update([
                    'rol_pri' => trim($rol_pri,',')
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '角色表更新失败']);
        }
        $sql = DB::table('message')
                ->insert([
                    'msg_title' => '【支付消息】 支付成功',
                    'msg_content' => '尊敬的用户，您已成功购买云溯源平台服务，订单号为'.$out_trade_no.'！
如您在使用过程有任何疑问，请咨询在线客服或及时与我们联系，客服热线400-8170015',
                    'msg_adm_id' => $find_adm['adm_id']
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '信息表更新失败']);
        }
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => '支付成功']);
    }
    public function return_url(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $endDate = date('Y-m-d H:i:s', strtotime("+1year"));
        $nowDate = date("Y-m-d H:i:s");
        $out_trade_no = $request['trade_no'];
        $sql = DB::table('order')
                ->where('order_no',$out_trade_no)
                ->update([
                    'order_valid' => $endDate,
                    'payment_at'  => $nowDate,
                    'order_adm_id' => $find_adm['adm_id'],
                    'order_status' => 6
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '订单表更新失败']);
        }
        $admRes = DB::table('admin')->where('adm_id',$find_adm['adm_id'])->select('adm_pre','adm_module')->first();
        $sql = DB::table('admin')
                ->leftjoin('role','role.rol_id','=','admin.adm_pre')
                ->where('adm_id',$find_adm['adm_id'])
                ->update([
                    'adm_payment_status' => 2,
                    'adm_flow'  => 3,
                    'adm_endtime' => $endDate,
                    'adm_nature' => 2
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '账号表更新失败']);
        }
        $sql = DB::table('company')
                ->where('com_id',$find_adm['adm_cid'])
                ->update([
                    'com_nature' => 3,
                    'com_expiretime'  => $endDate
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '公司表更新失败']);
        }
        // $pris = Db::table('role')->whereIn("rol_id",  [1, 3, 4, 5])->select('rol_pri')->get();
        $pris = Db::table('role')->where("rol_id",  $admRes['adm_module'])->select('rol_pri')->get();
        // var_dump($pris);exit;
        $rol_pri = '';
        foreach ($pris as $pri){
            $rol_pri .="{$pri['rol_pri']},";
        }
        $sql = DB::table('role')
                ->where('rol_id',$admRes['adm_pre'])
                ->update([
                    'rol_pri' => trim($rol_pri,','),
                    'rol_update_time' => date('Y-m-d H:i:s')
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '角色表更新失败']);
        }
        $sql = DB::table('message')
                ->insert([
                    'msg_title' => '【支付消息】 支付成功',
                    'msg_content' => '尊敬的用户，您已成功购买云溯源平台服务，订单号为'.$out_trade_no.'！
如您在使用过程有任何疑问，请咨询在线客服或及时与我们联系，客服热线400-8170015',
                    'msg_adm_id' => $find_adm['adm_id']
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '信息表更新失败']);
        }
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => '支付成功']);
    }
    public function adds(Request $request){
       // $vtiger = DB::connection('mysql_two');
        $sql = DB::table('environment')->select('env_id')->get();
        //$plate_management = ($vtiger->table('plate_management')->count())/8;
        foreach ($sql as $k => $v) {
            $sql = DB::table('plate_management')->where("monitor_id",$v['env_id'])->select('plate_name','monitor_id')->get();
            if($sql){

foreach ($sql as $key => $value) {
                $env_equipment[$key]['key'] = $value['plate_name'];
                $env_equipment[$key]['show'] = (int)"1";
                $env_equipment[$key]['sort'] = $key+1;
            }
            $env_equipment = json_encode($env_equipment);
            var_dump($env_equipment);
            $res = DB::table('environment')->where('env_id',$value['monitor_id'])->update(['env_equipment'=>$env_equipment]);
            unset($env_equipment);
            }
            
        }
        // var_dump($sqls);exit;
        // var_dump($sql);exit;
    }
}