<?php
namespace App\Http\Controllers\Lore;

use App\Http\Models\Register;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use App\Http\Models\Coperationa;
use Crypt;
use App\Http\Controllers\Verify\Lore\VerifyRegisterController;

class RegisterController extends Controller
{
    // 注册
    public function register(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRegisterController;
        $error_message = $verify_data->registerValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        date_default_timezone_set("PRC");  //设置为北京时区
        $input = $request->all(); //接收所有的值

        // 验证手机验证码
        $tel = DB::table('telcode')
            ->where('tel_phone', $input['adm_tel'])
            ->orderBy('tel_id', 'desc')
            ->select('tel_created_at', 'tel_code')
            ->first();
        $code_time = strtotime($tel['tel_created_at']);
        if ($code_time < time()-600) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机验证码超时']);
        }
        if ($tel['tel_code'] != $input['adm_code']) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机验证码错误']);
        }

        // 查询该手机号是否注册过
        $is_register = DB::table('admin')
            ->where('adm_mobile', $input['adm_tel'])
            ->count();
        if ($is_register['adm_mobile']) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data' => '该手机号已注册过账号,不可重复注册']);
        }

        // 验证公司名称是否存在
        $is_comname = DB::table('company')
            ->where('com_name', $input['com_name'])
            ->value('com_name');
        if ($is_comname) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'该公司已存在']);
        }

        // 验证账号是否存在
        $is_admacc = DB::table('admin')
            ->where('adm_acc', $input['adm_tel'])
            ->value('adm_acc');
        if ($is_admacc) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'该账号已存在']);
        }

        DB::beginTransaction();//开启事务
        // 图片上传
        $goo_picurl = '';
        if (!empty($request->input('com_logo'))) {
            // 上传图片
            $uploadImg = new CommonController;
            foreach ($request->input('com_logo') as $key => $value) {
                if (substr($value, 0, 11) == 'data:image/') {
                    $uploadPath = $uploadImg->uploadBase64Img($value);
                    if ($uploadPath) {
                        $goo_picurl .= $uploadPath.',';
                    } else {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                    }
                } else {
                    $goo_picurl .= substr($value, strlen($this->URLPATH)).',';
                }
            }
            $goo_picurl = trim($goo_picurl, ','); //图片的路径
        }
        // 会员表（客户信息表）添加
        $com_data['com_name'] = $input['com_name'];//会员名称
        $com_data['com_logo'] = $goo_picurl;//公司logo
        $com_data['com_fid'] = 1;//上级id
        $com_data['com_expiretime'] = date('Y-m-d H:i:s', time()+24*3*60*60);//上级id
        $com_data['com_stase'] = 1;//状态1正常2停用3禁用
        $com_data['com_nature'] = 2;//账号性质1临时2注册3正式
        $com_data['com_creattime'] = date('Y-m-d H:i:s');//首次开通时间（注册时间）
        $com_id = DB::table('company')->insertGetId($com_data);

        // 计算二维码标识
        $sta = 6; //初始第一位数
        $number = $com_id/10000;
        $keyword= substr($number, 0, 1);
        $sta = $sta+$keyword;//处理后的第一位数
        if ((floor($number) - $number) ==0) {
            $last = 0;
        }
        // 公司id为小于等于四位数时
        if (strlen($com_id) <=4) {
            $len = 4-strlen($com_id);
            $zero = "";
            for ($i=0;$i<$len;$i++) {
                $zero .= 0;
            }
            $sum = $sta.$zero.$com_id;
        } else {
            // 公司id为五位数时
            $zero = substr($com_id, 1);
            $sum = $sta.$zero;
        }
        // 会员附属表
        $info_data['info_cid'] = $com_id;//公司id
        $info_data['info_person'] = $input['adm_username'];//联系人
        $info_data['info_mobile'] = $input['adm_tel'];//联系电话
        $info_data['info_code_id'] = $sum;//二维码标识
        $info_data['info_province'] = $input['info_province'];//省
        $info_data['info_city'] = $input['info_city'];//市
        $info_data['info_county'] = $input['info_county'];//县
        $info_data['info_address'] = $input['info_address'];//详细地址
        $info_id = DB::table('company_info')->insert($info_data);
        
        // 角色表
        $rol_data['rol_name'] = '总管理';//角色名称
        $rol_data['rol_pri'] = '36,219';//角色权限
        $rol_data['rol_sta'] = 1;//状态1正常2停用 3渠道管理员
        $rol_data['rol_cid'] = $com_id;//所属公司/品牌商id
        $rol_data['rol_create_time'] = date('Y-m-d H:i:s');//创建时间
        $rol_data['rol_type'] = 1;//1.全局功能2.部分功能
        $rol_id = DB::table('role')->insertGetid($rol_data);
        
        // 账号表
        $Register = new Register();
        $adm_data['adm_cid'] = $com_id;//所属企业/品牌方id
        $adm_data['adm_name'] = $input['adm_username'];
        $adm_data['adm_acc'] = $input['adm_tel'];
        $adm_data['adm_pas'] = md5(md5($input['adm_pas']."admin"));
        $adm_data['adm_mobile'] = $input['adm_tel'];
        $adm_data['adm_pre'] = $rol_id; //权限
        $adm_data['adm_type'] = "3";
        $adm_data['adm_identifies'] = $input['adm_identifies'];
        $adm_data['adm_leave'] = 1;
        $adm_id = Register::insertGetId($adm_data);

        // 信息表
        $msg_data['msg_title'] = "【注册消息】注册成功，欢迎您登陆云溯源平台！";
        $msg_data['msg_content'] = "感谢您注册蓝科溯源企业旗下的云溯源平台（https://suyuan.bluearp.com/)账户,请您牢记您的用户名与密码,希望我们的服务能够让您的商品溯源工作更加智能便捷！如您在使用过程有任何疑问，请咨询在线客服或及时与我们联系，客服热线400-8170015";
        $msg_data['msg_adm_id'] = $adm_id;
        $msg_id = DB::table('message')->insert($msg_data);
        
        if ($com_id && $adm_id && $rol_id && $info_id && $msg_id) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'注册成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'注册失败']);
        }
    }

    // 忘记密码
    public function forget_pas(Request $request)
    {
        date_default_timezone_set("PRC");  //设置为北京时区
        $input = $request->all(); //接收所有的值

        $pwd_preg='/^[\w\_]{6,15}$/u';
        if (!preg_match($pwd_preg, $input['adm_pas'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'密码由6-15位数字,字母或下划线组成！']);
        }
        // 验证手机验证码
        $tel = DB::table('telcode')
            ->where('tel_phone', $input['adm_tel'])
            ->orderBy('tel_id', 'desc')
            ->select('tel_created_at', 'tel_code')
            ->first();
        $code_time = strtotime($tel['tel_created_at']);
        if ($code_time < time()-600) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机验证码超时']);
        }
        if ($tel['tel_code'] != $input['adm_code']) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机验证码错误']);
        }
        // 验证登录密码与确认密码是否一致
        if ($input['adm_pas'] <> $input['adm_affpas']) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入一致的登录密码与确认密码']);
        }
        $adm_pas = md5(md5($input['adm_pas']."admin"));
        // 账号表
        $adm_data['adm_pas'] = $adm_pas;//密码
        $adm_data['update_time'] = date('Y-m-d H:i:s');//更新时间
        $add_data = DB::table('admin')
            ->where('adm_mobile', $input['adm_tel'])
            ->update($adm_data);
        if ($add_data) {
            // 获取当前操作账号
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '更换密码', '更换密码', $find_adm['adm_name'].'更换密码成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'操作成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'新密码与原密码一致']);
        }
    }

    // 手机验证码
    public function telCode(Request $request)
    {
        if (!in_array($request->input('type'), array(1,2)) || empty($request->input('phone'))) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }
        $code = mt_rand(1000, 9999);//生成四位验证码
        if ($request->input('type') == 1) {
            // 验证手机号的正确性
            if (!preg_match("/^1[3456789]{1}\d{9}$/", $request->input('phone'))) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入正确的手机号']);
            }
            $tel = DB::table('admin')
                ->where('admin.adm_mobile', $request->input('phone'))
                ->value('adm_mobile');
            if ($tel != null) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前手机号已注册']);
            }
            $tel_status = 1;
            $tel_type = '注册';
            $message = "您注册的\"云溯源系统\"账号的验证码为{$code}，十分钟内有效。";//短信信息
        } elseif ($request->input('type') == 2) {
            $tel_status = 2;
            $tel_type = '找回';
            // 验证手机号的正确性
            if (!preg_match("/^1[3456789]{1}\d{9}$/", $request->input('phone'))) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入正确的手机号']);
            }
            // 验证账号是否存在
            $is_admacc = DB::table('admin')
                ->where('adm_mobile', $request->input('phone'))
                ->first(['adm_mobile']);
            if (empty($is_admacc)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'此手机号码未注册']);
            }
            $message = "您正在找回的\"云溯源系统\"账号密码,验证码为{$code}，十分钟内有效。";//短信信息
        }
        $_SERVER['HTTP_COOKIE']=isset($_SERVER['HTTP_COOKIE'])?$_SERVER['HTTP_COOKIE']:"";

        if ($_SERVER['HTTP_COOKIE']=="") {
            DB::table('telcode')->insert(['tel_phone'=>$request->input('phone'),'tel_code'=>$code,'tel_status'=>'4','tel_type'=>'非法','tel_url'=>json_encode($_SERVER)]);
            //$this->sendSmsCode("18201152647","云溯源注册出现异常，请紧急查看");//发送短信
            //DB::table('telcode')->insert(['tel_phone'=>"18201152647",'tel_code'=>$code,'tel_status'=>'5','tel_type'=>'预警']);
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => 'success']);
        }
        $_SERVER['HTTP_CACHE_CONTROL']=isset($_SERVER['HTTP_CACHE_CONTROL'])?$_SERVER['HTTP_CACHE_CONTROL']:"";
        if ($_SERVER['HTTP_CACHE_CONTROL']=="max-age=0") {
            DB::table('telcode')->insert(['tel_phone'=>$request->input('phone'),'tel_code'=>$code,'tel_status'=>'4','tel_type'=>'非法','tel_url'=>json_encode($_SERVER)]);
            //$this->sendSmsCode("18201152647","云溯源注册出现异常，请紧急查看");//发送短信
            //DB::table('telcode')->insert(['tel_phone'=>"18201152647",'tel_code'=>$code,'tel_status'=>'5','tel_type'=>'预警']);
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => 'success']);
        }
        $res=DB::table('telcode')
            ->where('tel_created_at', ">", date("Y-m-d"))
            ->where('tel_status', "=", "1")
            ->count();
        if ($res>10) {
            DB::table('telcode')->insert(['tel_phone'=>$request->input('phone'),'tel_code'=>$code,'tel_status'=>'3','tel_type'=>'频繁','tel_url'=>json_encode($_SERVER)]);
            if ($res==101) {
                $this->sendSmsCode("18201152647", "云溯源注册出现异常，请紧急查看");//发送短信
                DB::table('telcode')->insert(['tel_phone'=>"18201152647",'tel_code'=>$code,'tel_status'=>'5','tel_type'=>'预警']);
            }
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '频繁发送，请稍后再试']);
        } else {
            $this->sendSmsCode($request->input('phone'), $message);//发送短信
            DB::table('telcode')->insert(['tel_phone'=>$request->input('phone'),'tel_code'=>$code,'tel_status'=>$tel_status,'tel_type'=>$tel_type]);
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '发送成功']);
        }
    }

    private function sendSmsCode($mobile, $content)
    {
        $username = "lksy";
        $pwd = "19r1rt22";
        $password = md5($username . "" . md5($pwd));

        $url = "http://www1.jc-chn.cn/smsSend.do?";

        $param = http_build_query(
            array(
                'username' => $username,
                'password' => $password,
                'mobile' => $mobile,
                // 'content'=>iconv("GB2312","UTF-8",$content)
                'content' => $content
            )
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    // 上传营业执照
    public function companyInfo(Request $request)
    {
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(['code'=>500, 'msg'=>'error','data'=>'非法api_token']);
        }

        if (!empty($request['info_license'])) {
            $image = $request['info_license'];
            $imageName = date("His", time())."_".rand(1111, 9999).'.png';
            if (strstr($image, ",")) {
                $image = explode(',', $image);
                $image = $image[1];
            }
            $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';

            $path = "uploads/license/".date("Ymd", time());
            // 获取原营业执照文件名
            $oldphoto = DB::table('login_temporary as lt')
                            ->leftjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
                            ->leftjoin('company as c', 'c.com_id', '=', 'a.adm_cid')
                            ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'c.com_id')
                            ->where('lt.api_token', '=', $api_token)
                            ->select('info_license', 'c.com_id')
                            ->first();


            if (!is_dir($path)) { //判断目录是否存在 不存在就创建
                mkdir($path, 0777, true);
            }
            $imageSrc=  $path."/". $imageName;  //图片名字
            if (is_file($upload_files.$oldphoto['info_license'])) {
                // 修改新logo文件名
                $newphoto = DB::table('company as c')
                            ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'c.com_id')
                            ->where('com_id', '=', $oldphoto['com_id'])
                            ->update(['info_license'=>$imageSrc]);
                // 修改原图片权限
                chmod($upload_files.$oldphoto['info_license'], 0777);
                // 删除原图片
                unlink($upload_files.$oldphoto['info_license']);
            } else {
                $newphoto = DB::table('company as c')
                            ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'c.com_id')
                            ->where('com_id', '=', $oldphoto['com_id'])
                            ->update(['info_license'=>$imageSrc]);
            }
            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'上传营业执照成功', 'path'=>$imageSrc]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'还未选择营业执照']);
        }
    }

    // 开始试用
    public function startTheTrial(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyRegisterController;
        $error_message = $verify_data->startTheTrialValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        DB::beginTransaction();//开启事务
        try {
            $endData = date("Y-m-d H:i:s", strtotime("+3day"));
            // 角色表
            $jurisdiction = "";
            $jur = explode(',', $request['adm_module']);
            foreach ($jur as $key => $val) {
                $rol_jur = DB::table('role')
                    ->where('rol_id', '=', $val)
                    ->select('rol_pri', 'rol_name')
                    ->first();
                $jurisdiction .= $rol_jur['rol_pri'].",";
            }
            // dump($rol_jur);
            // exit;
            $adm_update_data['adm_endtime'] = $endData;
            $adm_update_data['adm_nature'] = 2;
            $adm_update_data['adm_flow'] = 2;
            $adm_update_data['rol_pri'] = trim($jurisdiction, ',');//角色权限
            $adm_update_data['adm_module'] = $request['adm_module'];
            $adm_update_data['update_time'] = date("Y-m-d H:i:s");//修改时间
            $adm_update_data['rol_update_time'] = date("Y-m-d H:i:s");//修改时间
            $adm_res = DB::table('admin')
                ->leftjoin('role', 'role.rol_id', '=', 'admin.adm_pre')
                ->where('adm_id', $find_adm['adm_id'])
                ->update($adm_update_data);
            
            if ($adm_res === false) {
                throw new Exception("账号表更新失败");
            }
            $com_update_data['com_expiretime'] = $endData;
            $com_update_data['com_nature'] = 1;
            $com_update_data['com_updatetime'] = date('Y-m-d H:i:s');
            $com_res = DB::table('company')
                ->where('com_id', $find_adm['adm_cid'])
                ->update($com_update_data);
            
            if ($com_res === false) {
                throw new Exception("公司表更新失败");
            }
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '申请试用', '申请试用', $find_adm['adm_name'].'申请试用'.$rol_jur['rol_name'].'成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'申请成功']);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'申请失败']);
        }
    }

    // 缴费
    public function setMeal(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $roles = DB::table('role')
            ->whereIn('rol_id', [1,3,4,5])
            ->select('rol_id', 'rol_name', 'rol_price', 'rol_discounts')
            ->get();
        $validPri = DB::table('admin')
            ->where('adm_id', $find_adm['adm_id'])
            ->select('adm_endtime', 'adm_flow', 'adm_module')
            ->get();
        // 转换时间戳   到期减去当前  判断是否大于0  大于0 则转换否则 复制0
        foreach ($validPri as $key=>$val) {
            $end_time = strtotime($val['adm_endtime']);
            // dd($end_time);
            $diff_time = $end_time-time();
            if ($diff_time > 0) {
                if ($diff_time < 60*60) {
                    $validPri[$key]['adm_endtime'] = '不足1小时';
                } else {
                    $day = floor($diff_time/(24*60*60));
                    $hour = floor($diff_time%(24*60*60)/(60*60));
                    $validPri[$key]['adm_endtime'] = $day.'天'.$hour.'小时';
                }
            } else {
                $validPri[$key]['adm_endtime'] = '0天';
            }
        }
        $userInfo = DB::table('company as c')
            ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'c.com_id')
            ->where('com_id', $find_adm['adm_cid'])
            ->select('com_name', 'info_license', 'com_id')
            ->first();
        $userInfo = ['company_name'=>$userInfo['com_name'], 'company_user_name'=>$find_adm['adm_mobile'], 'info_license'=>$userInfo['info_license'], 'com_id'=>$userInfo['com_id'], 'adm_id'=>$find_adm['adm_id']];
        return response()->json(['code'=>200, 'msg'=>'success', 'roles'=>$roles, 'userInfo'=>$userInfo, 'validPri'=>$validPri]);
    }

    public function setMeals(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $roles = DB::table('role')->whereIn('rol_id', [1,3,4,5])->selectRaw('rol_id,rol_name,rol_price,rol_discounts')->get();
        $validPri = DB::table('admin')->where('adm_id', $find_adm['adm_id'])->select('adm_endtime', 'adm_flow')->get();
        // 转换时间戳   到期减去当前  判断是否大于0  大于0 则转换否则 复制0
        foreach ($validPri as $key=>$val) {
            $end_time = strtotime($val['adm_endtime']);
            // dd($end_time);
            $diff_time = $end_time-time();
            if ($diff_time > 0) {
                if ($diff_time < 60*60) {
                    $validPri[$key]['adm_endtime'] = '不足1小时';
                } else {
                    $day = floor($diff_time/(24*60*60));
                    $hour = floor($diff_time%(24*60*60)/(60*60));
                    $validPri[$key]['adm_endtime'] = $day.'天'.$hour.'小时';
                }
            } else {
                $validPri[$key]['adm_endtime'] = '0天';
            }
        }
        $userInfo = DB::table('company as c')->leftjoin('company_info as ci', 'ci.info_cid', '=', 'c.com_id')->where('com_id', $find_adm['adm_cid'])->select('com_name', 'info_license', 'com_id')->first();
        $userInfo = ['company_name'=>$userInfo['com_name'], 'company_user_name'=>$find_adm['adm_mobile'], 'info_license'=>$userInfo['info_license'], 'com_id'=>$userInfo['com_id'], 'adm_id'=>$find_adm['adm_id']];
        return response()->json(['code'=>200, 'msg'=>'success', 'roles'=>$roles, 'userInfo'=>$userInfo, 'validPri'=>$validPri]);
    }

    // 支付
    public function return_url(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $endDate = date('Y-m-d H:i:s', strtotime("+1year"));
        $nowDate = date("Y-m-d H:i:s");
        $out_trade_no = $request['trade_no'];
        $sql = DB::table('order')
                ->where('order_no', $out_trade_no)
                ->update([
                    'order_valid' => $endDate,
                    'payment_at'  => $nowDate,
                    'order_adm_id' => $find_adm['adm_id'],
                    'order_status' => 6
                    ]);
        if ($sql === false) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'订单表更新失败']);
        }
        $admRes = DB::table('admin')->where('adm_id', $find_adm['adm_id'])->select('adm_pre', 'adm_module')->first();
        $sql = DB::table('admin')
                ->leftjoin('role', 'role.rol_id', '=', 'admin.adm_pre')
                ->where('adm_id', $find_adm['adm_id'])
                ->update([
                    'adm_payment_status' => 2,
                    'adm_flow'  => 3,
                    'adm_endtime' => $endDate,
                    'adm_nature' => 2
                    ]);
        if ($sql === false) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'账号表更新失败']);
        }
        $sql = DB::table('company')
                ->where('com_id', $find_adm['adm_cid'])
                ->update([
                    'com_nature' => 3,
                    'com_expiretime'  => $endDate
                    ]);
        if ($sql === false) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'公司表更新失败']);
        }
        // $pris = Db::table('role')->whereIn("rol_id",  [1, 3, 4, 5])->select('rol_pri')->get();
        $pris = Db::table('role')->where("rol_id", $admRes['adm_module'])->select('rol_pri')->get();
        $rol_pri = '';
        foreach ($pris as $pri) {
            $rol_pri .="{$pri['rol_pri']},";
        }
        $sql = DB::table('role')
                ->where('rol_id', $admRes['adm_pre'])
                ->update([
                    'rol_pri' => trim($rol_pri, ','),
                    'rol_update_time' => date('Y-m-d H:i:s')
                    ]);
        if ($sql === false) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '角色表更新失败']);
        }
        $sql = DB::table('message')
                ->insert([
                    'msg_title' => '【支付消息】 支付成功',
                    'msg_content' => '尊敬的用户，您已成功购买云溯源平台服务，订单号为'.$out_trade_no.'！如您在使用过程有任何疑问，请咨询在线客服或及时与我们联系，客服热线400-8170015',
                    'msg_adm_id' => $find_adm['adm_id']
                ]);
        if ($sql === false) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'信息表更新失败']);
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'支付成功']);
    }

    public function adds(Request $request)
    {
        // $vtiger = DB::connection('mysql_two');
        $sql = DB::table('environment')->select('env_id')->get();
        //$plate_management = ($vtiger->table('plate_management')->count())/8;
        foreach ($sql as $k => $v) {
            $sql = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id')->get();
            if ($sql) {
                foreach ($sql as $key => $value) {
                    $env_equipment[$key]['key'] = $value['plate_name'];
                    $env_equipment[$key]['show'] = (int)"1";
                    $env_equipment[$key]['sort'] = $key+1;
                }
                $env_equipment = json_encode($env_equipment);
                $res = DB::table('environment')->where('env_id', $value['monitor_id'])->update(['env_equipment'=>$env_equipment]);
                unset($env_equipment);
            }
        }
        // var_dump($sqls);exit;
        // var_dump($sql);exit;
    }

    public function adds2(Request $request)
    {
        $vtiger = DB::connection('mysql_two');
        $sql = DB::table('environment')->select('env_id')->get();
        //$plate_management = ($vtiger->table('plate_management')->count())/8;
        foreach ($sql as $k => $v) {
            // 光照度
            $sql2 = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id', 'id')->get();
            if ($sql2) {
                foreach ($sql2 as $key => $value) {
                    $res2 = $vtiger->table('device_illumination')->where('plate_id', $value['id'])->get();
                    foreach ($res2 as $kk => $vv) {
                        $res2 = DB::table('device_illumination')->where('env_id', $value['id'])->update(['env_id'=>$value['monitor_id']]);
                    }
                }
            }
            // 二氧化碳检测表
            $sql3 = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id', 'id')->get();
            if ($sql3) {
                foreach ($sql3 as $key => $value) {
                    // var_dump($value);exit;
                    $res3 = $vtiger->table('device_co2')->where('plate_id', $value['id'])->get();
                    foreach ($res3 as $kk => $vv) {
                        $res3 = DB::table('device_co2')->where('env_id', $value['id'])->update(['env_id'=>$value['monitor_id']]);
                    }
                }
            }
            // 湿度
            $sql4 = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id', 'id')->get();
            if ($sql4) {
                foreach ($sql4 as $key => $value) {
                    // var_dump($value);exit;
                    $res4 = $vtiger->table('device_air_humidity')->where('plate_id', $value['id'])->get();
                    foreach ($res4 as $kk => $vv) {
                        $res4 = DB::table('device_moisture')->where('env_id', $value['id'])->update(['env_id'=>$value['monitor_id']]);
                    }
                }
            }
            // 雨量
            $sql5 = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id', 'id')->get();
            if ($sql5) {
                foreach ($sql5 as $key => $value) {
                    // var_dump($value);exit;
                    $res5 = $vtiger->table('device_rainfall')->where('plate_id', $value['id'])->get();
                    foreach ($res5 as $kk => $vv) {
                        $res5 = DB::table('device_rainfall1')->where('env_id', $value['id'])->update(['env_id'=>$value['monitor_id']]);
                    }
                }
            }
            // 土壤湿度
            $sql6 = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id', 'id')->get();
            if ($sql6) {
                foreach ($sql6 as $key => $value) {
                    // var_dump($value);exit;
                    $res6 = $vtiger->table('device_soil_moisture')->where('plate_id', $value['id'])->get();
                    foreach ($res6 as $kk => $vv) {
                        $res6 = DB::table('device_soil_moisture1')->where('env_id', $value['id'])->update(['env_id'=>$value['monitor_id']]);
                    }
                }
            }
            // 温度
            $sql7 = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id', 'id')->get();
            if ($sql7) {
                foreach ($sql7 as $key => $value) {
                    // var_dump($value);exit;
                    $res7 = $vtiger->table('device_air_temperature')->where('plate_id', $value['id'])->get();
                    foreach ($res7 as $kk => $vv) {
                        $res7 = DB::table('device_temperature')->where('env_id', $value['id'])->update(['env_id'=>$value['monitor_id']]);
                    }
                }
            }
            // 风向
            $sql8 = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id', 'id')->get();
            if ($sql8) {
                foreach ($sql8 as $key => $value) {
                    // var_dump($value);exit;
                    $res8 = $vtiger->table('device_wind_direction')->where('plate_id', $value['id'])->get();
                    foreach ($res8 as $kk => $vv) {
                        $res8 = DB::table('device_wind_direction1')->where('env_id', $value['id'])->update(['env_id'=>$value['monitor_id']]);
                    }
                }
            }
            // 风速
            $sql9 = DB::table('plate_management')->where("monitor_id", $v['env_id'])->select('plate_name', 'monitor_id', 'id')->get();
            if ($sql9) {
                foreach ($sql9 as $key => $value) {
                    // var_dump($value);exit;
                    $res9 = $vtiger->table('device_wind_speed')->where('plate_id', $value['id'])->get();
                    foreach ($res9 as $kk => $vv) {
                        $res9 = DB::table('device_wind_speed')->where('env_id', $value['id'])->update(['env_id'=>$value['monitor_id']]);
                    }
                }
            }
        }
        // var_dump($sqls);exit;
        // var_dump($sql);exit;
    }
}
