<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Models\Admin;
use App\Http\Models\Register;
use Illuminate\Support\Facades\Crypt;
use Session;
use DB;
use AuthenticatesUsers;

class LoginController extends Controller
{

    public function __construct() {
        DB::connection()->enableQueryLog(); // 开启查询日志
    }

    public function getAdmin(Request $request) {
        $url = 'https://iamgateway.tn2jjd.com/humi-cloud-user-center/user';
        if ($request['Authorization']) {
            Session::put('token', $request['Authorization']);
        }
        $headers['Authorization'] = session()->get('token');
        $method = 'POST';
        $data = [];
        $res = curlRequest($url, $data, $headers, $timeout = 10, $method);
        $res = json_decode($res,true);
        if ($res['code'] == 200) {
            $add_data = $res['data'];
            if (!$add_data['accountNonExpired']) {
                return response()->json(["code"=>301,'msg'=>'登录过期','data'=>'登录过期']);
            }
            $find_data = DB::table('get_admin')->where('username',$add_data['username'])->exists();
            $add_data['authorities'] = json_encode($res['data']['authorities']);
            if (!$find_data) {
                $add_data['create_time'] = date('Y-m-d H:i:s');
                $add_data_res = DB::table('get_admin')->insertGetId($add_data);
            } else {
                $add_data['update_time'] = date('Y-m-d H:i:s');
                $add_data_res = DB::table('get_admin')
                    ->where('id',$find_data['id'])
                    ->update($add_data);
            }
            $find_admin = DB::table('admin')
                ->where('adm_acc', $add_data['username'])
                ->first();
            if (!$find_admin) {
                $find_phone = DB::table('admin')
                    ->where('adm_mobile', $add_data['phoneNo'])
                    ->first();
                if (!$find_phone) {
                    $add_admin['adm_cid'] = 1;
                    $add_admin['adm_name'] = $add_data['username'];
                    $add_admin['adm_pre'] = 2;
                    $add_admin['adm_module'] = 1;
                    $add_admin['adm_mobile'] = $add_data['phoneNo'];
                    $add_admin['adm_acc'] = $add_data['username'];
                    $admin_res = DB::table('admin')->insertGetId($add_admin);
                } else {
                    $add_admin['adm_acc'] = $add_data['username'];
                    $admin_res = DB::table('admin')->where('adm_id',$find_phone['adm_id'])->update($add_admin);
                }
            }
            $record = DB::table('admin')->where('adm_acc',$add_data['username'])->first(['adm_mobile','adm_pas','adm_id','adm_chan_id','adm_flow','adm_cid','adm_stase','adm_pre','adm_name','adm_account_type']);
            $str = $headers['Authorization'];
            $api_token = sha1($str);  //加密
            $login_temporary = DB::table('login_temporary')
                ->where('adm_id','=',$record['adm_id'])
                ->select('adm_id','last_login', 'tem_id')
                ->first();

            // $account_type = $record['adm_chan_id'] ? 2 : 1;//账号类型：1公司品牌商账号2渠道商账号
            $account_type = 1;//账号类型：1公司品牌商账号2渠道商账号
        
            // 查找此用户对应得角色权限
            $role_auth = $this->whererole($record['adm_id']);
            // 确认此账号默认跳转页面
            $default_url = $this->dispose_navigation($role_auth['role_auth']);
            // 尚未申请试用跳转到申请试用界面
            if($record['adm_flow'] == 1){
                    // $default_url = "AdminRegulate/RegisterstartTheTrial";
                    $default_url = "Summarize";
            }
            // 支付跳转到概括界面
            if($record['adm_flow'] == 3){
                // 判断是否有概括页面权限
                $home_url = 'App\Http\Controllers\SummarizeController@,';
                if (in_array($home_url,$role_auth)) {
                    $default_url = "Summarize";
                }
            }
            if (empty($login_temporary)) {
                //如果用户第一次登陆,将用户的登录状态保存到临时表
                $res = DB::table('login_temporary')->insert([
                    'adm_id'     =>$record['adm_id'],                         //账号id
                    'adm_cid'    =>$record['adm_cid'],                        //公司id
                    'last_login' =>time() + 24*60*60,                          //最后登陆时间
                    'api_token'  =>$api_token,                              //api_token
                    'adm_name'   =>$record['adm_name'],                       //账号姓名
                    'role_auth'  =>json_encode($role_auth['role_auth']),    //当前账号所有角色权限
                    'auth_routes'=>json_encode($role_auth['routes_auth']),  //当前账号所有角色权限路径
                    'tem_ip'    => $_SERVER['REMOTE_ADDR']
                    ]);
                if (!$res) {
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'api_token写入失败']);
                }
            } else {
                $res = DB::table('login_temporary')->where('tem_id', $login_temporary['tem_id'])->update([
                    'adm_id'     =>$record['adm_id'],                         //账号id
                    'adm_cid'    =>$record['adm_cid'],                        //公司id
                    'last_login' =>time() + 24*60*60,                          //最后登陆时间
                    'api_token'  =>$api_token,                              //api_token
                    'adm_name'   =>$record['adm_name'],                       //账号姓名
                    'role_auth'  =>json_encode($role_auth['role_auth']),    //当前账号所有角色权限
                    'auth_routes'=>json_encode($role_auth['routes_auth']),  //当前账号所有角色权限路径
                    'tem_ip'    => $_SERVER['REMOTE_ADDR']
                    ]);

            }
            // 生成前台token
            $userinfo = array(
                            'api_token'=>Crypt::encrypt($api_token),
                            'account_type'=>$account_type
                        );
            Session::put('api_token', $api_token);
            return response()->json(["code"=>200,'msg'=>'success','data'=>'api_token获取成功','userinfo'=>$userinfo,'default_url'=>$default_url]);
        } else {
            return $res;
        }
    }

    //退出
    public function newLoginout(Request $request)
    {
        $url = 'https://iamgateway.tn2jjd.com/humi-cloud-user-center/logout';
        if ($request['Authorization']) {
            Session::put('token', $request['Authorization']);
        }
        $headers['Authorization'] = session()->get('token');
        $method = '';
        $data['returnType'] = $request['returnType'];
        $data['redirect_url'] = $request['redirect_url'];
        $res = curlRequest($url, $data, $headers, $timeout = 10, $method);
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $new_res= DB::table('login_temporary')->where('api_token',$api_token)->update(['last_login'=>time() - 24*60*60]);
        return $res;
        // $res = json_decode($res,true);
        // if ($res['code'] == 200) {

        // }
    }

    public function login(Request $request)
    {
        $input = $request->only('username', 'password','islogin','adm_tel');
        $adm_acc = $request->get('ID');
        $adm_pas = $request->get('pas');
        $record = DB::table('admin')->where('adm_acc',$adm_acc)->where('adm_pas',$adm_pas)->first(['adm_mobile','adm_pas','adm_id','adm_chan_id','adm_flow','adm_cid','adm_stase','adm_pre','adm_name','adm_account_type']);
        if (!$record) $record = DB::table('admin')->where('adm_mobile',$adm_acc)->where('adm_pas',$adm_pas)->first(['adm_mobile','adm_pas','adm_id','adm_chan_id','adm_flow','adm_cid','adm_stase','adm_pre','adm_name','adm_account_type']);
        if ($record) {
            // 生成token
            $str = md5(uniqid(md5(microtime(true)),true));  //生成一个不会重复的字符串
            $api_token = sha1($str);  //加密

            $login_temporary = DB::table('login_temporary')
                ->where('adm_id','=',$record['adm_id'])
                ->select('adm_id','last_login')
                ->first();

            $account_type = $record['adm_chan_id'] ? 2 : 1;//账号类型：1公司品牌商账号2渠道商账号
        
            // 查找此用户对应得角色权限
            $role_auth = $this->whererole($record['adm_id']);
            $role_pda_auth = $this->pdarole($record['adm_id']);
            // 确认此账号默认跳转页面
            $default_url = $this->dispose_navigation($role_auth['role_auth']);
            // 尚未申请试用跳转到申请试用界面
            if($record['adm_flow'] == 1){
                    $default_url = "AdminRegulate/RegisterstartTheTrial";
            }
            // 支付跳转到概括界面
            if($record['adm_flow'] == 3){
                // 判断是否有概括页面权限
                $home_url = 'App\Http\Controllers\SummarizeController@,';
                if (in_array($home_url,$role_auth)) {
                    $default_url = "Summarize";
                }
            }
            if (empty($login_temporary)) {
                //如果用户第一次登陆,将用户的登录状态保存到临时表
                $res = DB::table('login_temporary')->insert([
                    'adm_id'     =>$record['adm_id'],                         //账号id
                    'adm_cid'    =>$record['adm_cid'],                        //公司id
                    'last_login' =>time() + 30*60,                          //最后登陆时间
                    'api_token'  =>$api_token,                              //api_token
                    'adm_name'   =>$record['adm_name'],                       //账号姓名
                    'role_auth'  =>json_encode($role_auth['role_auth']),    //当前账号所有角色权限
                    'role_pda_auth'  =>json_encode($role_pda_auth['role_auth']),    //当前账号所有角色权限
                    'auth_routes'=>json_encode($role_auth['routes_auth']),  //当前账号所有角色权限路径
                    'tem_ip'    => $_SERVER['REMOTE_ADDR']
                    ]);
                if (!$res) {
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'api_token写入失败']);
                }
            } else {
                $res = DB::table('login_temporary')->where('tem_id', $login_temporary->tem_id)->update([
                    'adm_id'     =>$record['adm_id'],                         //账号id
                    'adm_cid'    =>$record['adm_cid'],                        //公司id
                    'last_login' =>time() + 30*60,                          //最后登陆时间
                    'api_token'  =>$api_token,                              //api_token
                    'adm_name'   =>$record['adm_name'],                       //账号姓名
                    'role_auth'  =>json_encode($role_auth['role_auth']),    //当前账号所有角色权限
                    'role_pda_auth'  =>json_encode($role_pda_auth['role_auth']),    //当前账号所有角色权限
                    'auth_routes'=>json_encode($role_auth['routes_auth']),  //当前账号所有角色权限路径
                    'tem_ip'    => $_SERVER['REMOTE_ADDR']
                    ]);
            }
            // 生成前台token
            $userinfo = array(
                            'api_token'=>Crypt::encrypt($api_token),
                            'account_type'=>$account_type
                            );

            return response()->json(["code"=>200,'msg'=>'success','data'=>'api_token获取成功','userinfo'=>$userinfo,'default_url'=>$default_url]);
        }
        // $input = $request->only('username', 'password','islogin','adm_tel');
        if(empty($input['username']) || empty($input['password'])){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
        }

        $username = trim($input['username']);
        $password = trim($input['password']);

        if(empty($username)) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'用户名为空']);
        }

        if(empty($password)) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'密码为空']);
        }

        $pwd_preg='/^[\w\_]{6,15}$/u';
        if(!preg_match($pwd_preg,$password)){
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'密码由6-15位数字或字母,或下划线组成！']);
        }
        // 查询是否有此用户
        $user = DB::table('admin')
                ->leftJoin('company', 'admin.adm_cid', '=', 'company.com_id')
                ->where('admin.adm_acc', $username)
                ->orderBy('adm_id','desc')
                ->first(['adm_mobile','adm_pas','adm_id','adm_chan_id','adm_flow','adm_cid','adm_stase','adm_pre','adm_name','com_stase','adm_account_type']);

        if (!$user) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'无此用户']);
        }
        // 获取账号所属公司
        if($user['com_stase'] != 1)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该账号所属公司已停用']);
        }
        
        $password = md5(md5(trim($password.'admin')));
        if($password !== $user['adm_pas'])
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'密码错误']);
        }
        // 判断该账号是否停用
        if($user['adm_stase'] != 1)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该账号已停用']);
        }
        // 判断该账号权限
        if (!in_array($user['adm_account_type'],array(1,2)) || $user['adm_account_type'] != 1) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该账号无权限登录']);
        }
        // 判断该账号所属角色已是否停用
        $rol_sta = DB::table('role')->where('rol_id','=',$user['adm_pre'])
                                                       ->select('rol_sta')
                                                       ->first();
        if($rol_sta['rol_sta'] == 2)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该账号所属角色已停用,请联系总管理员']);
        }
        // 生成token
        $str = md5(uniqid(md5(microtime(true)),true));  //生成一个不会重复的字符串
        $api_token = sha1($str);  //加密

        $login_temporary = DB::table('login_temporary')
            ->where('adm_id','=',$user['adm_id'])
            ->select('adm_id','last_login','tem_ip')
            ->first();
        $account_type = $user['adm_chan_id'] ? 2 : 1;//账号类型：1公司品牌商账号2渠道商账号
        if(!empty($login_temporary))
        {
            $hours = time();
            //var_dump($_SERVER['REMOTE_ADDR']);exit;
            // 判断当前用户是否已经登录,以及验证登录时间是否过期
            if(/*$login_temporary['tem_ip'] == $_SERVER['REMOTE_ADDR'] && */$hours < $login_temporary['last_login'])
            {
                if($input['islogin'] == '1')
                {
                    // 强制登录
                    $res = $this->remote_login($api_token,$login_temporary['adm_id'],$user['adm_name']);
                    $res['account_type'] = $account_type;
                    $role_auth = $this->whererole($login_temporary['adm_id']);
                    $role_pda_auth = $this->pdarole($login_temporary['adm_id']);
                    $default_url = $this->dispose_navigation($role_auth['role_auth']);
                    return response()->json(["code"=>200,'msg'=>'success','data'=>'api_token获取成功','userinfo'=>$res,'default_url'=>$default_url]);
                }
                return response()->json(["code"=>400,'msg'=>'error','data'=>'该用户已经登录']);
            }
            // 查找此用户对应得角色权限
            $role_auth = $this->whererole($login_temporary['adm_id']);
            $role_pda_auth = $this->pdarole($login_temporary['adm_id']);
            // 确认此账号默认跳转页面
            $default_url = $this->dispose_navigation($role_auth['role_auth']);

            // 尚未申请试用跳转到申请试用界面
            if($user['adm_flow'] == 1){
                $default_url = "AdminRegulate/RegisterstartTheTrial";
            }

            // 支付跳转到概括界面
            if($user['adm_flow'] == 3){
                // 判断是否有概括页面权限
                $home_url = 'App\Http\Controllers\SummarizeController@,';
                if (in_array($home_url,$role_auth)) {
                    $default_url = "Summarize";
                }
            }

            //登陆过期更新原有的登陆临时表的登陆信息
            if($hours > $login_temporary['last_login'])
            {
                //修改登陆状态
                $settoken = DB::table('login_temporary')->where('adm_id',$login_temporary['adm_id'])
                    ->update([
                        'last_login'  =>$hours + 30*60,                         //最后登录时间
                        'api_token'   =>$api_token,                             //api_token
                        'role_auth'   =>json_encode($role_auth['role_auth']),   //当前账号所有角色权限
                        'role_pda_auth'   =>json_encode($role_pda_auth['role_auth']),   //当前账号所有角色权限
                        // 'pda_auth_routes'   =>json_encode($role_pda_auth['routes_auth']),   //当前账号所有角色权限
                        'auth_routes' =>json_encode($role_auth['routes_auth']), //当前账号所有角色权限路径
                        'adm_name'    =>$user['adm_name']
                    ]);
                if(empty($settoken))
                {
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'api_token写入失败']);
                }
                // 生成前台token
                $userinfo = array(
                    'api_token'=>Crypt::encrypt($api_token),
                    'account_type'=>$account_type
                );
                return response()->json(["code"=>200,'msg'=>'success','data'=>'api_token获取成功','userinfo'=>$userinfo,'default_url'=>$default_url]);
            }
        }
        
         // 查找此用户对应得角色权限
        $role_auth = $this->whererole($user['adm_id']);
        $role_pda_auth = $this->pdarole($user['adm_id']);
        // 确认此账号默认跳转页面
        $default_url = $this->dispose_navigation($role_auth['role_auth']);
        // 尚未申请试用跳转到申请试用界面
        if($user['adm_flow'] == 1){
                $default_url = "AdminRegulate/RegisterstartTheTrial";
        }
        // 支付跳转到概括界面
        if($user['adm_flow'] == 3){
            // 判断是否有概括页面权限
            $home_url = 'App\Http\Controllers\SummarizeController@,';
            if (in_array($home_url,$role_auth)) {
                $default_url = "Summarize";
            }
        }
        
        //如果用户第一次登陆,将用户的登录状态保存到临时表
        $res = DB::table('login_temporary')->insert([
            'adm_id'     =>$user['adm_id'],                         //账号id
            'adm_cid'    =>$user['adm_cid'],                        //公司id
            'last_login' =>time() + 30*60,                          //最后登陆时间
            'api_token'  =>$api_token,                              //api_token
            'adm_name'   =>$user['adm_name'],                       //账号姓名
            'role_auth'  =>json_encode($role_auth['role_auth']),    //当前账号所有角色权限
            'auth_routes'=>json_encode($role_auth['routes_auth']),  //当前账号所有角色权限路径
            'role_pda_auth'  =>json_encode($role_pda_auth['role_auth']),    //当前账号所有角色权限
            // 'pda_auth_routes'=>json_encode($role_pda_auth['routes_auth']),  //当前账号所有角色权限路径
            'tem_ip'    => $_SERVER['REMOTE_ADDR']
            ]);
        if (!$res) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'api_token写入失败']);
        }
        // 生成前台token
        $userinfo = array(
                        'api_token'=>Crypt::encrypt($api_token),
                        'account_type'=>$account_type
                        );

        return response()->json(["code"=>200,'msg'=>'success','data'=>'api_token获取成功','userinfo'=>$userinfo,'default_url'=>$default_url]);
    }
    //退出
    public function loginout(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $res= DB::table('login_temporary')->where('api_token',$api_token)->update(['last_login'=>time() - 24*60*60]);
        if($res)
        {
            return response()->json(["code"=>200,'msg'=>'success','data'=>'退出成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'退出失败']);
        }
    }

    // 用户信息
    public function userinfo(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $userinfo = DB::table('login_temporary as lt')
                            ->rightjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
                            ->where('lt.api_token','=',$api_token)->select('a.adm_name','a.adm_acc','a.adm_chan_id')->first();
        if($userinfo)
        {
            return response()->json(["code"=>200,'msg'=>'success','data'=>'登陆成功','userinfo'=>$userinfo]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'登陆失败','userinfo'=>$userinfo]);
        }
    }

    // 左侧一级二级导航
    public function navigation(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $role_info = DB::table('login_temporary')
                            ->where('api_token','=',$api_token)
                            ->select('role_auth')
                            ->first();
        // 对象转数组
        $role_info  = object_array(json_decode($role_info['role_auth']));

        foreach($role_info as $k=>$v)
        {
            $role_info[$k]['name']= $v['pri_acna'].$v['pri_funna'];
            $role_info[$k]['path']= $v['pri_acna'].$v['pri_funna'];
            $role_info[$k]['meta']['title'] = $v['pri_funname'];
            $role_info[$k]['meta']['pri_id'] = $v['pri_id'];
            unset($role_info[$k]['pri_funname']);
            unset($role_info[$k]['pri_acna']);
            unset($role_info[$k]['pri_funna']);
        }
        // 获取二级两级导航栏  
        // 正则替换/
        foreach($role_info as $key =>$value)
        {
            $role_info[$key]['name'] = preg_replace("/\w+\\\/", '',  $value['name']);
            $role_info[$key]['path'] = preg_replace("/\w+\\\/", '', $value['path']);
        }
        // 将数据分类
        $navigation_category = $this->navigation_category($role_info);

        foreach($navigation_category as $key=>$value)
        {
            $navigation_category[$key]['component'] = 'Layout';

        }
        foreach($navigation_category as $key=>$value)
        {
            if($value['pri_id'] == 1)
            {
                $navigation_category[$key]['redirect'] = $value['name'];
                $navigation_category[$key]['children'][] = $value;
                foreach($value as $k=>$v)
                {
                    $navigation_category[$key]['children'][$key]['component'] = $value['name'];
                }
            }
            if($value['pri_fid'] != 0)
            {
                unset($value['tit_pic']);
            }
        }
        if(!$navigation_category)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'导航获取失败']);
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'导航获取成功','navigation_category'=>$navigation_category]);
    }

    // 获取该账号有哪些权限
    protected function whererole($adm_id)
    {
        // 获取该账号所拥有的角色
        $role_info = DB::table('admin as a')
                            ->leftjoin('role', 'role.rol_id', '=', 'a.adm_pre')
                            ->where('a.adm_id','=',$adm_id)
                            ->select('role.rol_pri','a.adm_cid','a.adm_leave','a.adm_flow')
                            ->first();
        $rol_id = explode(',',$role_info['rol_pri']);
        // 取得当前角色所拥有的权限
        $privileges = DB::table('privileges')
                            ->select('pri_id','pri_fid','pri_funname', 'pri_acna','pri_funna','tit_pic')
                            ->whereIn('privileges.pri_id',$rol_id)
                            ->get();

        // 如果当前账号不是root管理去除客户管理相关权限、账号管理和角色管理相关权限
        if($role_info['adm_cid'] != 1 || $role_info['adm_leave'] != 1)
        {
            foreach($privileges as $key=>$value)
            {
                if($role_info['adm_leave'] != 1)
                {
                    // 删除账号相关
                    if($value['pri_id'] == 37 || $value['pri_fid'] == 37)
                    {
                        unset($privileges[$key]);
                    }
                    if ($value['pri_id'] == 48 || $value['pri_fid'] == 48) {
                        unset($privileges[$key]);
                    }
                }
                // 删除客户列表相关
                if($value['pri_id'] == 157 || $value['pri_fid'] == 157)
                {
                    unset($privileges[$key]);
                }
            }
        }

        $privileges = array_values($privileges);
        foreach($privileges as $key=>$value)
        {
            // 权限路由
            $privileges_info['routes_auth'][] = 'App\Http\Controllers\\'.$value['pri_acna'].'Controller'.'@'.$value['pri_funna'].',';
        }
        // 角色权限
        $privileges_info['role_auth'] = $privileges;
        return $privileges_info;
    }

    // 获取该账号有哪些pda权限
    protected function pdarole($adm_id)
    {
        // 获取该账号所拥有的角色
        $role_info = DB::table('admin as a')
            ->leftjoin('role', 'role.rol_id', '=', 'a.adm_pre')
            ->where('a.adm_id','=',$adm_id)
            ->select('role.rol_pda_pri','a.adm_cid','a.adm_leave','a.adm_flow')
            ->first();
        $rol_id = explode(',',$role_info['rol_pda_pri']);
        // 取得当前角色所拥有的权限
        $privileges = DB::table('pda_privileges')
            ->whereIn('pri_id',$rol_id)
            ->select('pri_id','pri_fid','pri_funname', 'pri_acna','pri_funna','tit_pic')
            ->get();

        $privileges = array_values($privileges);
        foreach($privileges as $key=>$value)
        {
            // 权限路由
            $privileges_info['routes_auth'][] = 'App\Http\Controllers\\'.$value['pri_acna'].'Controller'.'@'.$value['pri_funna'].',';
        }
        // 角色权限
        $privileges_info['role_auth'] = $privileges;
        return $privileges_info;
    }

    // 顶掉已登录账号
    function remote_login($api_token,$adm_id,$adm_name)
    {
        // 查找此用户对应得角色权限
        $role_auth = $this->whererole($adm_id);

        $settoken = DB::table('login_temporary')->where('adm_id',$adm_id,$adm_name)
                                        ->update([
                                                'last_login'  =>time() + 30*60,                         //最后登录时间
                                                'api_token'   =>$api_token,                             //api_token
                                                'role_auth'   =>json_encode($role_auth['role_auth']),   //当前账号所有角色权限
                                                'auth_routes' =>json_encode($role_auth['routes_auth']), //当前账号所有角色权限路径
                                                'adm_name'    =>$adm_name
                                                ]);
        if(empty($settoken))
        {
             return response()->json(["code"=>500,'msg'=>'error','data'=>'api_token写入失败']);
        }
        // 生成前台token
        $api_token = array(
                        'api_token'=>Crypt::encrypt($api_token)
                        );
        return $api_token;
    }

    //导航栏分类
    function navigation_category($arr){
        $refer = array();
        $list = array();
        foreach($arr as $k => $v){
            $refer[$v['pri_id']] = & $arr[$k]; //创建主键的数组引用
        }
        foreach($arr as $k => $v){
            $fid = $v['pri_fid'];  //获取当前分类的父级id
            if($fid == 0){
                $list[] = & $arr[$k];  //顶级栏目
            }else{
                if(isset($refer[$fid])){
                    $refer[$fid]['children'][] = $arr[$k]; //如果存在父级栏目，则添加进父级栏目的子栏目数组中   
                    foreach($refer[$fid]['children'] as $key=>$value)
                    {
                        $refer[$fid]['children'][$key]['component'] = $value['name'];
                    }
                }
            }
        }
        return $list;
    }
    // 获取默认跳转路径
    function dispose_navigation($arr)
    {
        foreach($arr as $k => $v){
            if($v['pri_id'] == 1)
            {
                 $default_url = $v['pri_acna'];
                return $default_url;
            }
            if($v['pri_fid'] == 0)
            {
                $list[] = $v;  //顶级栏目
            }
        }
        foreach($arr as $key=>$v)
        {
            if($v['pri_fid'] == $list[0]['pri_id'])
            {
                $pri_acna = $v['pri_acna'].$v['pri_funna'];
                break;
            }
        }
        $default_url = $list[0]['pri_acna'].'/'.$pri_acna;
        return $default_url; 
    }
}
