<?php

namespace App\Http\Controllers\Integral;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\Integral\VerifyExchangeNoticeController;

// 兑换公告
class ExchangeNoticeController extends Controller
{
    // 公告信息
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyExchangeNoticeController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $data_info = DB::table('exchange_notice')
                        ->where('exno_cid',$find_adm['adm_cid'])
                        ->where('exno_chan_id',$find_adm['adm_chan_id'])
                        ->select('exno_content')
                        ->first();
        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);

        if($data_info) {
            return response()->json(['code'=> 200,'msg'=>'success', 'data'=>$data_info, 'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据', 'button'=>$button]);
        }
    }

    // 编辑保存
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyExchangeNoticeController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $exno_id = DB::table('exchange_notice')
                        ->where('exno_cid',$find_adm['adm_cid'])
                        ->where('exno_chan_id',$find_adm['adm_chan_id'])
                        ->select('exno_id')
                        ->first();
        $exno_data['exno_content'] = $request['content'];
        $exno_data['exno_userid'] = $find_adm['adm_id'];
        $exno_data['exno_user_name'] = $find_adm['adm_name'];
        $exno_data['exno_updatetime'] = date('Y-m-d H:i:s');
        if ($exno_id) {
            $exno_res = DB::table('exchange_notice')->where('exno_id',$exno_id['exno_id'])->update($exno_data);
        }else{
            $exno_data['exno_cid'] = $find_adm['adm_cid'];
            $exno_data['exno_chan_id'] = $find_adm['adm_chan_id'];
            $exno_res = DB::table('exchange_notice')->insert($exno_data);
        }
                       
        if($exno_res) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'保存成功']);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'保存失败']);
        }
    }
}

