<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Contracts\Support\JsonableInterface;

use App\Http\Models\Coperationa;
use App\Http\Models\InfoModify;
use App\Http\Controllers\Verify\VerifyCodeController;
use App\Http\Controllers\Verify\Source\VerifyFormworkController;
/**
 * 溯源管理-信息维护
 */
class InfoModifyController extends Controller
{
    protected $show_count = 10;
    // 页面信息
    public function index(Request $request){
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 溯源标签信息
        $lab_list = DB::table('form_label')->where('lab_cid',$find_adm['adm_cid'])->where('lab_stase',1)->orWhere('lab_cid',0)->select('lab_id','lab_name')->get();
        $find_class = DB::table('goo_classifi')
            ->where('cla_cid',$find_adm['adm_cid'])
            ->where('cla_stase',1)
            ->select('cla_id','cla_name')
            ->get();
        // 信息标签 -- 模板列表
        $tem_list = DB::table('formwork as f')
            ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
            ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
            ->where('fom_stase',1)
            ->where('fom_cid',$find_adm['adm_cid'])
            ->select('lab_id','lab_cid','fom_cid','lab_name','fom_id','fom_title','fom_content','fom_label','fom_temid','fom_number','tem_id','tem_type_swaitch')
            ->get();
        // 环境信息
        $env_list = DB::table('environment')
                ->where('env_cid', $find_adm['adm_cid'])
                ->where('env_state', 1)
                ->select('env_id','env_name','env_number')
                ->get();
        // 防窜信息
        $reg_list = DB::table('region')
                    ->where('ent_cid',$find_adm['adm_cid'])
                    ->where('start',1)
                    ->where('reg_del',1)
                    ->select('id','group_name')
                    ->get();
        $list['lab_list'] = $lab_list;//信息标签
        $list['tem_list'] = $tem_list;//信息标签 -- 模板列表
        $list['env_list'] = $env_list;//环境信息
        $list['reg_list'] = $reg_list;//防窜信息
        return response()->json(['code'=>200,'msg'=>'success','data'=>$list]);
    }

    // 搜索环境信息
    public function search_environment(Request $request)
    {
        // 验证数据
        if (!$request->exists('search_data') ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $data = $request->all();

        $list = DB::table('environment')
                ->where('env_cid', $find_adm['adm_cid'])
                ->where('env_state', 1)
                ->where(function($query) use($data){
                    $query->where('env_name', 'like' , '%'.$data['search_data'].'%')
                          ->orWhere('env_number', 'like' , '%'.$data['search_data'].'%');
                })
                ->select('env_id','env_name','env_number')
                ->orderBy('env_id','desc')
                ->get();
        $listData['data'] = $list;
        $listData['code'] = 200;
        return response()->json($listData);
    }
    // 按时间查找批次号
    public function searchtime(Request $request)
    {
        if (!in_array($request->input('type'),array(1,2,3))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        if ($request->input('type') == 1) {
            if (!$request->exists('gro_time')) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            // 根据token获取用户信息
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            $data = $request->all();
            $batch = DB::table('group')
                    ->leftjoin('goods','goods.goo_id','=','group.gro_gid')
                    ->where('gro_time','like','%'.$request['gro_time'].'%')
                    ->where('gro_cid',$find_adm['adm_cid'])
                    ->selectRaw('gro_number,gro_pnumber,gro_time,gro_codeid,gro_gid,goo_id,goo_name,gro_num')
                    ->get();
                    return response()->json(['code'=>200,'msg'=>'success','data'=>$batch]);
        }else if($request->input('type') == 2){
            // 按溯源码号查找批次号
            if (!$request->exists('batch_code')) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            // 根据token获取用户信息
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            $codeid = substr($request['batch_code'],0,5);
            $yemo = substr($request['batch_code'],5,4);
            // 去产品码表查询该码号在哪个分组下
            $group = DB::table("formwork_code")->where('gco_start','<=',$request['batch_code'])->where('gco_end','>=',$request['batch_code'])->select('gco_group')->first();
            if (!$group) {
                $batch = DB::table('group')->leftjoin('goods','goods.goo_id','=','group.gro_gid')->where('code_start','<=',$request['batch_code'])->where('code_end','>=',$request['batch_code'])->where('gro_cid',$find_adm['adm_cid'])->select('gro_pnumber','gro_time','goo_id','goo_name','gro_num')->first();
                return response()->json(['code'=>200,'msg'=>'success','data'=>$batch]);
            }else{
                $batch = DB::table('group')->leftjoin('goods','goods.goo_id','=','group.gro_gid')->where('code_start','<=',$request['batch_code'])->where('code_end','>=',$request['batch_code'])->where('gro_cid',$find_adm['adm_cid'])->select('gro_pnumber','gro_time','goo_id','goo_name','gro_num')->first();
                return response()->json(['code'=>200,'msg'=>'success','data'=>$batch]);
            }
            // 去group表根据分组查询出哪个批次
            // $batch = DB::table('group')->leftjoin('goods','goods.goo_id','=','group.gro_gid')->where('gro_number',$group['gco_group'])->where('gro_cid',$find_adm['adm_cid'])->select('gro_pnumber','gro_time','goo_id','goo_name','gro_num')->first();
            // $batch = DB::table('group')->leftjoin('goods','goods.goo_id','=','group.gro_gid')->where('code_start',$request['batch_code'])->where('code_end',$request['batch_code'])->where('gro_cid',$find_adm['adm_cid'])->select('gro_pnumber','gro_time','goo_id','goo_name','gro_num')->first();
        }else if($request->input('type') == 3) {
            // 按商品名称查找批次号
            if (!$request->exists('goo_name')) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            // 根据token获取用户信息
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            $batch = DB::table('goods')
                    ->leftjoin('group','goods.goo_id','=','group.gro_gid')
                    ->where('goo_name','like','%'.$request['goo_name'].'%')
                    ->where('gro_cid',$find_adm['adm_cid'])
                    ->selectRaw('gro_number,gro_pnumber,gro_time,gro_codeid,gro_gid,goo_id,goo_name,gro_num')
                    ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>$batch]);
        }
    }
    // 保存溯源
    public function handleformwork(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 判断当前复制列表是否为复制列表
        if(strpos($request['fom_title'],'---副本') !==false){
             return response()->json(["code"=>500,'msg'=>'error','data'=>'请去掉信息名称中的 " ---副本 "']);
        }

        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $fom_title = DB::table('formwork')
                            ->where('fom_cid',$find_adm['adm_cid'])
                            ->where('fom_stase',1)
                            ->where('fom_title','=',trim($request['fom_title']))
                            ->select('fom_title','fom_id','fom_temid')
                            ->first();
        if($fom_title['fom_id'] != $request['fom_id'])
        {
            if($fom_title['fom_title'] == $request['fom_title'])
            {
                return response()->json(["code"=>500,'msg'=>'error','data'=>'信息名称已经存在']);
            }
        }

        // 判断是否更改信息所属模板
        if ($request->input('fom_id') != $fom_title['fom_temid']) {
            // 更改模板所属标签数量
            $res_class1 = DB::update('UPDATE `trace_formwork_template` SET `tem_total`=`tem_total`+1  WHERE `tem_id`=?',[$request->input('fom_temid')] );
            $res_class2 = DB::update('UPDATE `trace_formwork_template` SET `tem_total`=`tem_total`-1  WHERE `tem_id`=?',[$fom_title['fom_temid']] );
            if ($res_class1 && $res_class2) {
                $res_class = true;
            }else{
                $res_class = false;
            }
        }else{
            $res_class = true;
        }
        
        $day=date('Ymd');
        $file_data=[];
        foreach ($request['formkey'] as $k => $v){
            $arr[$k]['key'] = $request['formkey'][$k];          //信息项标题
            $arr[$k]['show'] = $request['formshow'][$k];        //显示隐藏
            $arr[$k]['type'] = $request['formtype'][$k];        //属性类型

            $url= $request['formvalue'][$k];   //信息项内容     
            if(($arr[$k]['type']==6 || $arr[$k]['type']==7) && !empty($url)){
                //判断是否是临时文件;
                if(strpos($url,'temporary')){
                    $end=explode('.',$url)[1];  //获取后缀
                    $file_name=$arr[$k]['type']==6?'images':'videos';
                    $new_name='uploads/formwork/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path=public_path().'/'.$new_name;  //新的文件地址
                    $old_url=public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if(!is_dir(dirname($new_path))){
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url=$new_name;
                }else{
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
            }   
            $arr[$k]['value']=$url;
            $arr[$k]['content']=$request['contents'][$k];
        }
        // $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        $res_info = DB::table('formwork')->where('fom_id','=',$request['fom_id'])->first();

        $resinfo = object_array(json_decode($res_info['fom_content']));
        $res = DB::table('formwork')->where('fom_id','=',$request['fom_id'])->update([
                                                                                      'fom_title'   => $request['fom_title'],
                                                                                      'fom_label'   => $request['fom_label'],
                                                                                      'fom_temid'   => $request['fom_temid'],
                                                                                      'fom_content' => json_encode($arr),
                                                                                      'fom_cretime' => date("Y-m-d H:i:s"),
                                                                                      ]);
        DB::table('formwork')->where('fom_id','=',$res_info['fom_fid'])->decrement('fom_count');

        if($res)
        {
            $old_file=[];
            // 删除原图片或者视频
            foreach($resinfo as $key=>$value)
            {
                if($value['type'] == 6 || $value['type'] == 7)
                {
                    $old_file[]=$value['value'];
                }
            }

            //判断是否有之前的数据； 获取修改后的文件和之前的文件的差距。
            if(!empty($old_file)){
                $diff_file=array_diff($old_file,$file_data);
                if(!empty($diff_file)){
                    //删除旧的文件
                    foreach ($diff_file as $key => $val) {
                        chmod(public_path().'/'.$val,0777);
                        unlink(public_path().'/'.$val);
                    }
                }
            }
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','修改','修改'.$request['fom_title'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'修改溯源信息成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'修改溯源信息失败']);
        }
    }
    // 图片上传
    public function imageform(Request $request)
    {
        $image =  $request['images'];
        $imageName = "IMG_".date("His",time())."_".rand(1111,9999).'.png';
        // 当前文件根路径
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';

        if(!empty($image))
        {
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $path = "uploads/formwork/temporary";

            if (!is_dir($path)){             //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            $imageSrc= $path."/". $imageName;  //图片名字

            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(["code"=>200,'msg'=>'success','data'=>'图片上传成功','path'=>$imageSrc]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'还未选择图片']);
        }
    }
    // 删除图片
    public function delimageform(Request $request)
    {
        $image =  $request['images'];
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        foreach($image as $k=>$v)
        {
            if(is_file($image[$k])){
                // 修改原圖片权限
                chmod($upload_files.$image[$k],0777);
                // 删除原圖片
                unlink($upload_files.$image[$k]); 
            }
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'']);
    }
    // 清除溯源信息
    public function del(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (!in_array($request->input('search_type'),array(1,2,3,4,5))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 二维码查询
        if ($request->input('search_type') == 1) {
            //验证产品码是否正确
            $codes = trim($request['codes']);
            $error_codes = [];
            $codes = explode(',', trim($codes,','));
            foreach($codes as $key=>$code) {
                $code_tmp = VerifyCodeController::validator($code);
                if(!$code_tmp) {
                    unset($codes[$key]);
                    $error_codes[] = $code;
                }else {
                    $codes[$key] = $code_tmp;
                }
            }
            if(count($error_codes) > 0) {
                return response()->json(['code' => 500, 'msg' => '错误的码', 'data' => $error_codes]);
            }
            // 查询产品码的信息
            $code_goods = DB::table('group')
                            ->where('code_start', '<=', $codes)
                            ->where('code_end', '>=', $codes)
                            ->select('gro_id','gro_number','gro_pnumber','code_start','code_end')
                            ->first();
            if (empty($code_goods)) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'非本系统码2']);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
            }
        }else if ($request->input('search_type') == 2) {
            $groupResult = DB::table('group')->where('gro_pnumber',$request->input('edit'))
                        ->select('gro_codeid','gro_number','gro_pnumber','gro_num','gro_gid')->first();
            if (empty($groupResult)) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'错误的批次号']);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
            }
        }else if ($request->input('search_type') == 3) {
            // 查询产品码的信息
            $code_goods = DB::table('group')
                            ->where('code_start', '<=', $request->input('codes')[0])
                            ->where('code_end', '>=', $request->input('codes')[1])
                            ->select('gro_id','gro_number','gro_pnumber','code_start','code_end')
                            ->first();
            if (empty($code_goods)) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'非本系统码2']);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
            }
        }else if($request->input('search_type') == 5){
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            $search_result = DB::table('group')->where('gro_cid', $find_adm['adm_cid'])
                ->select('gro_pnumber','gro_number')
                ->orderBy('gro_id','desc')
                ->offset(0)->limit(5)
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>$search_result]);
        }
        
        // 录入信息
        if (!in_array($request->input('type'),array(1,2,3)) || empty($request->input('edit'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        
        // 查找公司信息
        $find_company_info = DB::table('company_info')->where('info_cid', $find_adm['adm_cid'])
                ->select('info_code_id','info_result_style','info_usenum')->first();
        $info_code_id = $find_company_info['info_code_id'];//公司标识
        if ($request->input('type') == 1) {
            //编辑录入，编辑录入支持多表操作
            if (strpos($request->input('edit'), "\r\n") !== false) {
                $codes = explode("\r\n", $request->input('edit'));
            } elseif (strpos($request->input('edit'), "\n") !== false) {
                $codes = explode("\n", $request->input('edit'));
            } else {
                $codes = [$request->input('edit')];
            }
            // (限制10000条)
            if(count($codes) > 10000){
                $max = count($codes)-10000;
                return response()->json(['code'=>500,'msg'=>'error','data'=>'每次最多输入1000条,您多输入了'.$max.'条']);
            }
            foreach ($codes as $key => &$code) {
                //过滤空值
                if (!$code) {
                    unset($codes[$key]);
                    continue;
                }
                // 过滤二维码,统一返回纯数字的二维码
                $code_data = $this->filterCodeData($code);
                $fil_code[$key] = $code_data['data'];
                if ($code_data['code'] == 500) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>$code_data['data']]);
                }
            }
            $codes = implode(",", $fil_code);
            $codes=explode(",",trim($codes,","));
            //根据批次号获取关联二维码表
            $code_start = $this->filterCodeData($request->input('edit'));
            $code_end = $this->filterCodeData($request->input('edit'));
            $groupResult = DB::table('group')->where('code_start','<=',$code_start['data'])->where('code_end','>=',$code_end['data'])
                         ->select('gro_number','gro_pnumber','gro_num','gro_gid','code_start','code_end','nums','gro_codeid')->first();
            DB::beginTransaction();
            if ($groupResult == null) {
                // 二维码与二维码所属表的映射关系
                $tableNameArray = $this->initTableLinkArray($info_code_id);
                // $codes = explode(",",$codes);
                /**
                 * 拼接where条件
                 * [
                 *  '400011808' => ['400011808000115','400011808000290']',
                 *  '400021808' => ['400021808000115','400021808000290']'
                 * ]
                 */
                $table_name = "";
                $num = 0;
                $whereArray = [];
                foreach ($codes as $code){
                    $tab_codeid = substr($code, 0, 5);    //二维码标识
                    if($tab_codeid != $info_code_id){
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入正确的产品码']);
                    }
                    $tab_yemo =  substr($code, 5, 4);     //年月
                    // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
                    if($num == 0){
                        $table_name = $tab_codeid.$tab_yemo;
                        $tab_tablename = DB::table('table_link')
                            ->where('tab_codeid',$tab_codeid)
                            ->where('tab_yemo',$tab_yemo)
                            ->select('tab_tablenam')
                            ->first();
                        $codePrefix = $tab_tablename['tab_tablenam'];
                    }else{
                        if($table_name == $tab_codeid.$tab_yemo){
                        }else{
                            $tab_tablename = DB::table('table_link')
                            ->where('tab_codeid',$tab_codeid)
                            ->where('tab_yemo',$tab_yemo)
                            ->select('tab_tablenam')
                            ->first();
                            $codePrefix = $tab_tablename['tab_tablenam'];
                        }
                    }
                    $num++;
                    $whereArray[$codePrefix][] = $code; 
                }
                // 溯源模板系统信息录入,记录操作时间、操作人
                $gco_op_id = $this->opLogs($request->input('code_source_id'),$find_adm['adm_name']);
                if (false === $gco_op_id) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                }
                $request->offsetSet('code_op_id', $gco_op_id);
                foreach ($whereArray as $key => $value){
                    $tablename = 'trace_'.$key.'_code';//数据表名
                    $code_sql = '';//拼接更改二维码表SQL语句
                    $gco_temstr = ',';
                    $code_sql = 'UPDATE `'.$tablename.'` SET `gco_temstr`= "'.$gco_temstr.'"  WHERE `gco_number` IN(';
                    $where_sql = '';//where条件
                    foreach ($value as $k => $val) {
                        if ($val) {
                            $where_sql .= "'".$val."',";
                            $code_where[] = $val;//二维码表查询条件
                        }
                    }
                    $where_sql = trim($where_sql,',');
                    $code_sql = $code_sql.$where_sql.')';
                }
                // 更新二维码表
                try{
                    $vtiger = DB::connection('mysql_two');
                    $code_res =  $vtiger->update($code_sql);
                }catch (\Exception $e){
                    DB::rollBack();
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'信息输入错误']);
                }
                if (false === $code_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                }
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息溯源','清除信息','清除溯源信息成功');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'清除溯源信息成功']);
            }
            $num = 0;
            $whereArray = [];
            foreach ($codes as $code){
                $tab_codeid = substr($code, 0, 5);    //二维码标识
                $tab_yemo =  substr($code, 5, 4);     //年月
                // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
                if($num == 0){
                    $table_name = $tab_codeid.$tab_yemo;
                    $tab_tablename = DB::table('table_link')
                        ->where('tab_codeid',$tab_codeid)
                        ->where('tab_yemo',$tab_yemo)
                        ->select('tab_tablenam')
                        ->first();
                    $codePrefix = $tab_tablename['tab_tablenam'];
                }else{
                    if($table_name == $tab_codeid.$tab_yemo){
                    }else{
                        $tab_tablename = DB::table('table_link')
                        ->where('tab_codeid',$tab_codeid)
                        ->where('tab_yemo',$tab_yemo)
                        ->select('tab_tablenam')
                        ->first();
                        $codePrefix = $tab_tablename['tab_tablenam'];
                    }
                }
                $num++;
                $whereArray[$codePrefix][] = $code; 
            }
            // 溯源模板系统信息录入,记录操作时间、操作人
            if (!empty($request->input('code_source_id'))) {
                $gco_op_id = DB::table('base_op')->insertGetId([
                    'form_id' => $request->input('code_source_id',','),
                    'op_date' => date('Y-m-d H:i:s'),
                    'op_man'  => $find_adm['adm_name']
                    ]);
            }else{
                $gco_op_id = '';
            }
            foreach ($whereArray as $key => $value) {
                $tablename = 'trace_formwork_code';//数据表名
                $code_sql = '';//拼接更改二维码表SQL语句
                $gco_temstr = ',';
                $gco_info = ',';
                // $code_sql = 'UPDATE `'.$tablename.'` SET `gco_temstr`= "'.$gco_temstr.'"  WHERE `gco_number` IN(';
                $code_sql = 'UPDATE `'.$tablename.'` SET `gco_info`= "'.$gco_info.'" , `gco_temstr` = "'.$gco_temstr.'"  WHERE `gco_number` IN(';
                $where_sql = '';//where条件
                foreach ($value as $k => $val) {
                    if ($val) {
                        $where_sql .= "'".$val."',";
                        $code_where[] = $val;//二维码表查询条件
                    }
                }
                $where_sql = trim($where_sql,',');
                $code_sql = $code_sql.$where_sql.')';

                // 更新二维码表
                try{
                    $code_res =  DB::update($code_sql);
                }catch (\Exception $e){
                    DB::rollBack();
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'信息输入错误']);
                }
                if (false === $code_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                }
            }
            $code_res = DB::update($code_sql);
            if (false === $code_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
            }else{
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息维护','清除溯源信息','清除溯源信息成功');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'清除溯源信息成功']);
            }
        }else if ($request->input('type') == 2) {
            // 批次录入
            //根据批次号获取关联二维码表
            $groupResult = DB::table('group')->where('gro_pnumber',$request->input('edit'))
                        ->select('gro_codeid','gro_number','gro_pnumber','gro_num','gro_gid','code_start','code_end')->first();
            if (empty($groupResult)) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            DB::beginTransaction();
            if ($groupResult['code_start'] == '' || $groupResult['code_end'] == '') {
                if (!empty($request->input('code_source_id'))) {
                    // 溯源模板系统信息录入,记录操作时间、操作人
                    $gco_op_id = $this->opLogs($request->input('code_source_id'),$find_adm['adm_name']);
                    if (false === $gco_op_id) {
                        DB::rollBack();
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                    }
                }else{
                    $gco_op_id = '';
                }
                $request->offsetSet('code_op_id', $gco_op_id);
                $tablename = 'trace_'.$groupResult['gro_codeid'].'_code';//数据表名
                // 更新二维码表信息
                $gco_temstr = ',';
                $code_sql = 'UPDATE `'.$tablename.'` SET `gco_temstr`= "'.$gco_temstr.'"  WHERE `gco_group`='.$groupResult['gro_number'];
                $vtiger = DB::connection('mysql_two');
                $code_res = $vtiger->update($code_sql);
                if (false === $code_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'清除溯源信息失败']);
                }else{
                    DB::commit();
                    Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息溯源','清除溯源信息','清除溯源信息成功');
                    return response()->json(['code'=>200,'msg'=>'success','data'=>'清除溯源信息成功']);
                }
            }
            if (!empty($request->input('code_source_id'))) {
                // 溯源模板系统信息录入,记录操作时间、操作人
                $gco_op_id = $this->opLogs($request->input('code_source_id'),$find_adm['adm_name']);
                if (false === $gco_op_id) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                }
            }else{
                $gco_op_id = '';
            }
            $request->offsetSet('code_op_id', $gco_op_id);

            $tablename = 'trace_formwork_code';//数据表名
            // 更新二维码表信息
            $gco_temstr = ',';
            $gco_info = ',';
            // $code_sql = 'UPDATE `'.$tablename.'` SET `gco_temstr`= "'.$gco_temstr.'"  WHERE `gco_group`='.$groupResult['gro_number'];
            $code_sql = 'UPDATE `'.$tablename.'` SET `gco_info`= "'.$gco_info.'" , `gco_temstr` = "'.$gco_temstr.'"  WHERE `gco_group`='.$groupResult['gro_number'];
            $code_res = DB::update($code_sql);
            if (false === $code_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'清除溯源信息失败']);
            }else{
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息维护','清除溯源信息','清除溯源信息成功');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'清除溯源信息成功']);
            }
        }else {
            // 区间录入
            //判断起始溯源码是否小于结束溯源码
            if (!is_array($request->input('edit')) || empty($request->input('edit')[0]) || empty($request->input('edit')[1])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            if ($request->input('edit')[0] >= $request->input('edit')[1]) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'起始溯源不能大于等于结束溯源']);
            }
            $code_start = $this->filterCodeData($request->input('edit')[0]);
            $code_end = $this->filterCodeData($request->input('edit')[1]);
            $tablename_info = DB::table('formwork_code')->where('gco_cid',$find_adm['adm_cid'])->where('gco_start',$code_start['data'])->where('gco_end',$code_end['data'])->select('gco_start','gco_end')->first();
            // if ($tablename_info == NULL) {
            //     return response()->json(['code'=>500,'msg'=>'error','data'=>'请检查输入的二维码是否正确!']);
            // }
            DB::beginTransaction();
            if ($tablename_info == null) {
                $tablename_info = $this->getCodeTableNameByCodeData($request->input('edit')[0]);
                if ($tablename_info['code'] == 500) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>$tablename_info['data']]);
                }
                // 溯源模板系统信息录入,记录操作时间、操作人
                $gco_op_id = $this->opLogs($request->input('code_source_id'),$find_adm['adm_name']);
                if (false === $gco_op_id) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败1']);
                }
                $request->offsetSet('code_op_id', $gco_op_id);
                $tablename = 'trace_'.$tablename_info['data'];//数据表名
                $gco_temstr = ',';
                $code_sql = 'UPDATE `'.$tablename.'` SET `gco_temstr` = "'.$gco_temstr.'"  WHERE `gco_number` BETWEEN "'.$request->input('edit')[0].'" AND "'.$request->input('edit')[1].'" AND `gco_cid` = '.$find_adm['adm_cid'];
                $vtiger = DB::connection('mysql_two');
                $code_res = $vtiger->update($code_sql);
                if (false === $code_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'清除溯源信息失败']);
                }else{
                    DB::commit();
                    Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息维护','清除溯源信息',$request->input('edit')[0].'至'.$request->input('edit')[1].'区间成功');
                    return response()->json(['code'=>200,'msg'=>'success','data'=>'信息录入成功']);
                }
            }
            // 溯源模板系统信息录入,记录操作时间、操作人
            $gco_op_id = $this->opLogs($request->input('code_source_id'),$find_adm['adm_name']);
            if (false === $gco_op_id) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'清除溯源信息失败']);
            }
            $request->offsetSet('code_op_id', $gco_op_id);
            
            $tablename = 'trace_formwork_code';//数据表名
            $gco_temstr = ',';
            $gco_info = ',';
            // $code_sql = 'UPDATE `'.$tablename.'` SET `gco_temstr` = "'.$gco_temstr.'"  WHERE `gco_start` = "'.$request->input('edit')[0].'" AND `gco_end` = "'.$request->input('edit')[1].'"';
            $code_sql = 'UPDATE `'.$tablename.'` SET `gco_info` = "'.$gco_info.'" , `gco_temstr`="'.$gco_temstr.'"  WHERE `gco_start` = "'.$request->input('edit')[0].'" AND `gco_end` = "'.$request->input('edit')[1].'"';
            $code_res = DB::update($code_sql);
            if (false === $code_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'清除溯源信息失败']);
            }else{
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息维护','清除溯源信息',$request->input('edit')[0].'至'.$request->input('edit')[1].'区间成功');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'清除溯源信息成功']);
            }
        }
    }
    // 信息维护
    public function modify(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (!in_array($request->input('search_type'),array(1,2,3,4,5))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 二维码查询
        if ($request->input('search_type') == 1) {
        	//编辑录入，编辑录入支持多表操作
            if (strpos($request->input('codes'), "\r\n") !== false) {
                $codes = explode("\r\n", $request->input('codes'));
            } elseif (strpos($request->input('codes'), "\n") !== false) {
                $codes = explode("\n", $request->input('codes'));
            } else {
                $codes = [$request->input('codes')];
            }
            // (限制10000条)
            if(count($codes) > 10000){
                $max = count($codes)-10000;
                return response()->json(['code'=>500,'msg'=>'error','data'=>'每次最多输入1000条,您多输入了'.$max.'条']);
            }
            foreach ($codes as $key => &$code) {
                //过滤空值
                if (!$code) {
                    unset($codes[$key]);
                    continue;
                }
                // 过滤二维码,统一返回纯数字的二维码
                $code_data = $this->filterCodeData($code);
                $fil_code[$key] = $code_data['data'];
                if ($code_data['code'] == 500) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>$code_data['data']]);
                }
            }
            $codes = implode(",", $fil_code);
            // var_dump($codes);exit;
            $codes=explode(",",trim($codes,","));
            DB::beginTransaction();
            //根据批次号获取关联二维码表
            $code_start = $this->filterCodeData($request->input('codes'));
            $code_end = $this->filterCodeData($request->input('codes'));


            // $codes = trim($request['codes']);
            // $groupResult = DB::table('group')->where('code_start','<=',$codes)->where('code_end','>=',$codes)
                         // ->select('gro_number','gro_pnumber','gro_num','gro_gid','code_start','code_end','nums','gro_codeid')->first();
            $groupResult = DB::table('group')->where('code_start','<=',$code_start['data'])->where('code_end','>=',$code_end['data'])
                         ->select('gro_number','gro_pnumber','gro_num','gro_gid','code_start','code_end','nums','gro_codeid')->first();
            // var_dump($groupResult);exit;
            if ($groupResult == null) {
                // 编辑录入
                // $search_result = $this->isHasCode($request->input('codes'));
                $search_result = $this->filterCodeData($request->input('codes'));
                // var_dump($search_result);exit;
                if ($search_result['code'] == 200) {
                    return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
                }else{
                    return response()->json($search_result);
                }
            }
            // $codeData = trim($codes, "\r\n");
            // $codeData = trim($codes, "\n");
            // $codeData = $this->filterCodeData($codeData);
            // if ($codeData['code'] == 500) return $codeData;
            // 查询产品码的信息
            $code_goods = DB::table('group')
                            ->where('code_start', '<=', $code_start['data'])
                            ->where('code_end', '>=', $code_end['data'])
                            ->select('gro_id','gro_number','gro_pnumber','code_start','code_end')
                            ->first();
            if (empty($code_goods)) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'非本系统码2']);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
            }
        }else if ($request->input('search_type') == 2) {
            $groupResult = DB::table('group')->where('gro_pnumber',$request->input('edit'))
                        ->where('gro_cid',$find_adm['adm_cid'])
                        ->select('gro_codeid','gro_number','gro_pnumber','gro_num','gro_gid')->first();
            if (empty($groupResult)) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'错误的批次号']);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
            }
        }else if ($request->input('search_type') == 3) {
            // 查询产品码的信息
            $code_goods = DB::table('group')
                            ->where('code_start', '<=', $request->input('codes')[0])
                            ->where('code_end', '>=', $request->input('codes')[1])
                            ->where('gro_cid',$find_adm['adm_cid'])
                            ->select('gro_id','gro_number','gro_pnumber','code_start','code_end')
                            ->first();
            if (empty($code_goods)) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'非本系统码']);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
            }
        }else if($request->input('search_type') == 5){
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            $search_result = DB::table('group')->where('gro_cid', $find_adm['adm_cid'])
                ->select('gro_pnumber','gro_number')
                ->orderBy('gro_id','desc')
                ->offset(0)->limit(5)
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>$search_result]);
        }
        // 录入信息
        if (!in_array($request->input('type'),array(1,2,3)) || empty($request->input('edit'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        if (empty($request->input('code_good_id')) && empty($request->input('code_environment_id')) && empty($request->input('code_gco_coderegid')) && empty($request->input('code_source_id')) && empty($request->input('code_production_date',''))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择追加溯源信息']);
        }
        
        // 查找公司信息
        $find_company_info = DB::table('company_info')->where('info_cid', $find_adm['adm_cid'])
                ->select('info_code_id','info_result_style','info_usenum')->first();
        $info_code_id = $find_company_info['info_code_id'];//公司标识

        if ($request->input('type') == 1) {
            //编辑录入，编辑录入支持多表操作
            if (strpos($request->input('edit'), "\r\n") !== false) {
                $codes = explode("\r\n", $request->input('edit'));
            } elseif (strpos($request->input('edit'), "\n") !== false) {
                $codes = explode("\n", $request->input('edit'));
            } else {
                $codes = [$request->input('edit')];
            }
            // (限制10000条)
            if(count($codes) > 10000){
                $max = count($codes)-10000;
                return response()->json(['code'=>500,'msg'=>'error','data'=>'每次最多输入1000条,您多输入了'.$max.'条']);
            }
            foreach ($codes as $key => &$code) {
                //过滤空值
                if (!$code) {
                    unset($codes[$key]);
                    continue;
                }
                // 过滤二维码,统一返回纯数字的二维码
                $code_data = $this->filterCodeData($code);
                $fil_code[$key] = $code_data['data'];
                if ($code_data['code'] == 500) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>$code_data['data']]);
                }
            }
            $codes = implode(",", $fil_code);
            // var_dump($codes);exit;
            $codes=explode(",",trim($codes,","));
            DB::beginTransaction();
            //根据批次号获取关联二维码表
            $code_start = $this->filterCodeData($request->input('edit'));
            $code_end = $this->filterCodeData($request->input('edit'));
            // var_dump($code_start['data']);exit;
            $groupResult = DB::table('group')->where('code_start','<=',trim($code_start['data']))->where('code_end','>=',trim($code_end['data']))
                         ->select('gro_number','gro_pnumber','gro_num','gro_gid','code_start','code_end','nums','gro_codeid')->first();
            // var_dump($groupResult);exit;
            if ($groupResult == null) {
                // 二维码与二维码所属表的映射关系
                $tableNameArray = $this->initTableLinkArray($info_code_id);
                // $codes = explode(",",$codes);
                /**
                 * 拼接where条件
                 * [
                 *  '400011808' => ['400011808000115','400011808000290']',
                 *  '400021808' => ['400021808000115','400021808000290']'
                 * ]
                 */
                $table_name = "";
                $num = 0;
                $whereArray = [];
                foreach ($codes as $code){
                    $tab_codeid = substr($code, 0, 5);    //二维码标识
                    if($tab_codeid != $info_code_id){
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入正确的产品码']);
                    }
                    $tab_yemo =  substr($code, 5, 4);     //年月
                    // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
                    if($num == 0){
                        $table_name = $tab_codeid.$tab_yemo;
                        $tab_tablename = DB::table('table_link')
                            ->where('tab_codeid',$tab_codeid)
                            ->where('tab_yemo',$tab_yemo)
                            ->select('tab_tablenam')
                            ->first();
                        $codePrefix = $tab_tablename['tab_tablenam'];
                    }else{
                        if($table_name == $tab_codeid.$tab_yemo){
                        }else{
                            $tab_tablename = DB::table('table_link')
                            ->where('tab_codeid',$tab_codeid)
                            ->where('tab_yemo',$tab_yemo)
                            ->select('tab_tablenam')
                            ->first();
                            $codePrefix = $tab_tablename['tab_tablenam'];
                        }
                    }
                    $num++;
                    $whereArray[$codePrefix][] = $code; 
                }
                // 溯源模板系统信息录入,记录操作时间、操作人
                $gco_op_id = $this->opLogs($request->input('code_source_id'),$find_adm['adm_name']);
                if (false === $gco_op_id) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                }
                $request->offsetSet('code_op_id', $gco_op_id);
                // DB::connection()->enableQueryLog();#开启执行日志
                foreach ($whereArray as $key => $value){
                    $tablename = 'trace_'.$key.'_code';//数据表名
                    $code_sql = '';//拼接更改二维码表SQL语句
                    $code_sql = 'UPDATE `'.$tablename.'` SET '.$this->prepareData($request->all()).'  WHERE `gco_number` IN(';
                    $where_sql = '';//where条件
                    foreach ($value as $k => $val) {
                        if ($val) {
                            $where_sql .= "'".$val."',";
                            $code_where[] = $val;//二维码表查询条件
                        }
                    }
                    $where_sql = trim($where_sql,',');
                    $code_sql = $code_sql.$where_sql.')';
                    // dd(DB::getQueryLog());
                }
                // 更新二维码表
                try{
                    $vtiger = DB::connection('mysql_two');
                    $code_res =  $vtiger->update($code_sql);
                }catch (\Exception $e){
                    DB::rollBack();
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'信息输入错误']);
                }
                if (false === $code_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                }
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息溯源','录入信息','编辑录入成功');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'信息录入成功1']);
            }
            $num = 0;
            $whereArray = [];
            foreach ($codes as $code){
                $tab_codeid = substr($code, 0, 5);    //二维码标识
                $tab_yemo =  substr($code, 5, 4);     //年月
                // 查询第一次循环时的表名,如果本次查询与下次循环相同,则跳过下次循环查询
                if($num == 0){
                    $table_name = $tab_codeid.$tab_yemo;
                    $tab_tablename = DB::table('table_link')
                        ->where('tab_codeid',$tab_codeid)
                        ->where('tab_yemo',$tab_yemo)
                        ->select('tab_tablenam')
                        ->first();
                    $codePrefix = $tab_tablename['tab_tablenam'];
                }else{
                    if($table_name == $tab_codeid.$tab_yemo){
                    }else{
                        $tab_tablename = DB::table('table_link')
                        ->where('tab_codeid',$tab_codeid)
                        ->where('tab_yemo',$tab_yemo)
                        ->select('tab_tablenam')
                        ->first();
                        $codePrefix = $tab_tablename['tab_tablenam'];
                    }
                }
                $num++;
                $whereArray[$codePrefix][] = $code; 
            }
            // 溯源模板系统信息录入,记录操作时间、操作人
            if (!empty($request->input('code_source_id'))) {
                $gco_op_id = DB::table('base_op')->insertGetId([
                    'form_id' => $request->input('code_source_id',','),
                    'op_date' => date('Y-m-d H:i:s'),
                    'op_man'  => $find_adm['adm_name']
                    ]);
            }else{
                $gco_op_id = '';
            }
            foreach ($whereArray as $k => $v) {
                $sql = "INSERT INTO trace_formwork_code (`gco_number`,`gco_type`,`gco_gid`,`gco_envid`,`gco_coderegid`,`gco_temstr`,`gco_cid`,`gco_group`,`gco_start`,`gco_end`,`production_date`,`nums`,`gco_op_id`,`gco_info`) VALUES ";
                // $sql = "INSERT INTO trace_formwork_codes (`gco_number`,`gco_type`) VALUES ";
                foreach ($v as $kk => $val) {
                    $sql = $sql . "('" . $val . "',2,'" . $request->input('code_good_id','') . "','" . $request->input("code_environment_id",0) . "','" . $request->input("code_gco_coderegid",0) . "','" . $request->input("code_source_id",",") . "','" . $find_adm["adm_cid"] . "','" . $groupResult["gro_number"] . "','" . $val . "','" . $val . "','" . $request->input('code_production_date','') . "','" . $groupResult['nums'] . "','" . $gco_op_id . "','" . $request->input("code_source_id",",") . "'),";
                }
                $sql = trim($sql, ",") . ";";
                $grores = DB::insert($sql);
                DB::table('group')->where('code_start','<=',trim($code_start['data']))->where('code_end','>=',trim($code_end['data']))->update(['production_date'=>$request->input('code_production_date','')]);
                unset($sql);
            }
            if (false === $codes) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
            }else{
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息维护','录入信息','编辑录入成功');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'信息录入成功2']);
            }
        } else if ($request->input('type') == 2) {
            // 批次录入
            //根据批次号获取关联二维码表
            $groupResult = DB::table('group')->where('gro_pnumber',$request->input('edit'))
                        ->select('gro_codeid','gro_number','gro_pnumber','gro_num','gro_gid','code_start','code_end','nums')->first();
            if (empty($groupResult)) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入正确的批次号']);
            }
            
            DB::beginTransaction();
            if ($groupResult['code_start'] == '' || $groupResult['code_end'] == '') {
                if (!empty($request->input('code_source_id'))) {
                    // 溯源模板系统信息录入,记录操作时间、操作人
                    $gco_op_id = $this->opLogs($request->input('code_source_id'),$find_adm['adm_name']);
                    if (false === $gco_op_id) {
                        DB::rollBack();
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                    }
                }else{
                    $gco_op_id = '';
                }
                $request->offsetSet('code_op_id', $gco_op_id);
                $tablename = 'trace_'.$groupResult['gro_codeid'].'_code';//数据表名
                // 更新二维码表信息
                $code_sql = 'UPDATE `'.$tablename.'` SET '.$this->prepareData($request->all()).'  WHERE `gco_group`='.$groupResult['gro_number'];
                $vtiger = DB::connection('mysql_two');
                $code_res = $vtiger->update($code_sql);
                if (false === $code_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                }else{
                    DB::commit();
                    Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息溯源','录入信息',$groupResult['gro_pnumber'].'批次录入成功');
                    return response()->json(['code'=>200,'msg'=>'success','data'=>'信息录入成功']);
                }
            }
            $gco_op_id = DB::table('base_op')->insertGetId([
                'form_id' => $request->input('code_source_id',','),
                'op_date' => date('Y-m-d H:i:s'),
                'op_man'  => $find_adm['adm_name']
                ]);
            $data = [
                $groupResult['gro_number'],
                1,
                $request->input('code_good_id',''),
                $request->input('code_environment_id',0),
                $request->input('code_gco_coderegid',0),
                $request->input('code_source_id',','),
                $find_adm['adm_cid'],
                $groupResult['code_start'],
                $groupResult['code_end'],
                $request->input('code_production_date',''),
                $groupResult['nums'],
                $gco_op_id,
                $request->input('code_source_id',','),
            ];
            $codes = DB::insert('insert into trace_formwork_code (`gco_group`,`gco_type`,`gco_gid`,`gco_envid`,`gco_coderegid`,`gco_temstr`,`gco_cid`,`gco_start`,`gco_end`,`production_date`,`nums`,`gco_op_id`,`gco_info`) values(?,?,?,?,?,?,?,?,?,?,?,?,?)',$data);
            DB::table('group')->where('gro_pnumber',$request->input('edit'))->update(['production_date'=>$request->input('code_production_date','')]);
            if (false === $codes) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
            }else{
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息维护','录入信息',$groupResult['gro_pnumber'].'批次录入成功');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'信息录入成功']);
            }
        }else {
            // 区间录入
            //判断起始溯源码是否小于结束溯源码
            if (!is_array($request->input('edit')) || empty($request->input('edit')[0]) || empty($request->input('edit')[1])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            if ($request->input('edit')[0] >= $request->input('edit')[1]) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'起始溯源不能大于等于结束溯源']);
            }
            $code_start = $this->filterCodeData($request->input('edit')[0]);
            $code_end = $this->filterCodeData($request->input('edit')[1]);
            $groupResult = DB::table('group')->where('code_start','<=',$code_start['data'])->where('code_end','>=',$code_end['data'])
                        ->select('gro_number','gro_pnumber','gro_num','gro_gid','code_start','code_end','nums')->first();
            DB::beginTransaction();
            if ($groupResult == null) {
                $tablename_info = $this->getCodeTableNameByCodeData($request->input('edit')[0]);
                if ($tablename_info['code'] == 500) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>$tablename_info['data']]);
                }
                // 溯源模板系统信息录入,记录操作时间、操作人
                $gco_op_id = $this->opLogs($request->input('code_source_id'),$find_adm['adm_name']);
                if (false === $gco_op_id) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败1']);
                }
                $request->offsetSet('code_op_id', $gco_op_id);
                $tablename = 'trace_'.$tablename_info['data'];//数据表名
                $code_sql = 'UPDATE `'.$tablename.'` SET '.$this->prepareData($request->all()).'  WHERE `gco_number` BETWEEN "'.$request->input('edit')[0].'" AND "'.$request->input('edit')[1].'" AND `gco_cid` = '.$find_adm['adm_cid'];
                $vtiger = DB::connection('mysql_two');
                $code_res = $vtiger->update($code_sql);
                if (false === $code_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
                }else{
                    DB::commit();
                    Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息维护','录入信息',$request->input('edit')[0].'至'.$request->input('edit')[1].'区间录入成功');
                    return response()->json(['code'=>200,'msg'=>'success','data'=>'信息录入成功1']);
                }
            }
            // 溯源模板系统信息录入,记录操作时间、操作人
            $gco_op_id = DB::table('base_op')->insertGetId([
                'form_id' => $request->input('code_source_id',','),
                'op_date' => date('Y-m-d H:i:s'),
                'op_man'  => $find_adm['adm_name']
                ]);
            $data = [
                $code_start['data'],
                $code_end['data'],
                3,
                $request->input('code_good_id',''),
                $request->input('code_environment_id',0),
                $request->input('code_gco_coderegid',0),
                $request->input('code_source_id',','),
                $find_adm['adm_cid'],
                $groupResult['gro_number'],
                $request->input('code_production_date',''),
                $groupResult['nums'],
                $gco_op_id,
                $request->input('code_source_id',','),
            ];
            $codes = DB::insert('insert into trace_formwork_code (`gco_start`,`gco_end`,`gco_type`,`gco_gid`,`gco_envid`,`gco_coderegid`,`gco_temstr`,`gco_cid`,`gco_group`,`production_date`,`nums`,`gco_op_id`,`gco_info`) values(?,?,?,?,?,?,?,?,?,?,?,?,?)',$data);
            DB::table('group')->where('code_start','<=',$code_start['data'])->where('code_end','>=',$code_end['data'])->update(['production_date'=>$request->input('code_production_date','')]);
            if (false === $codes) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息录入失败']);
            }else{
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'信息维护','录入信息',$request->input('edit')[0].'至'.$request->input('edit')[1].'区间录入成功');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'信息录入成功2']);
            }
        }
    }
    /**
     * 根据二维码查询二维码信息
     * @param string $codeData
     * @return mixed
     * @throws Exception
     */
    public function isHasCode($codeData = "")
    {
        $codeData = trim($codeData, "\r\n");
        $codeData = trim($codeData, "\n");
        $codeData = $this->filterCodeData($codeData);
        if ($codeData['code'] == 500) return $codeData;
        $table_name = $this->getCodeTableNameByCodeData($codeData['data']);
        if ($table_name['code'] == 500) return $table_name;
        return ['code'=>200,'msg'=>'success','data'=>""];
    }

    /**
     * 过滤二维码,统一返回纯数字的二维码
     * @param string $codeData
     *      http://xxxx.com?二维码& |  二维码&
     * @return mixed|string
     * @throws Exception
     */
    private function filterCodeData($codeData = "")
    {
        if (!$codeData) return ['code'=>500,'msg'=>'error','data'=>'参数不可为空!'];
        if (!is_string($codeData)) return ['code'=>500,'msg'=>'error','data'=>'参数类型错误!'];
        
        $codeData = rtrim($codeData, "&");
        //带链接的二维码
        if (($pos = strpos($codeData, "?")) !== false) {
            return ['code'=>200,'msg'=>'success','data'=>substr_replace($codeData, "", 0, $pos + 1)];
        }

        //不带链接的二维码
        return ['code'=>200,'msg'=>'success','data'=>$codeData];
    }
    /**
     * 根据二维码获取二维码所在表
     * @param string $codeData
     * @return bool|Model
     * @throws Exception
     */
    public function getCodeTableNameByCodeData($codeData = "")
    {
        if (!$codeData) return ['code'=>500,'msg'=>'error','data'=>'参数不可为空!'];
        if (!is_string($codeData)) return ['code'=>500,'msg'=>'error','data'=>'参数类型错误!'];

        // 根据/n转化为数组
        $codeArr = explode("\n",$codeData);
        $codeDataArr = array_unique($codeArr);
        // 判断二维码的长度和格式
        $all_num = 20;//二维码生成位数
        $tableyemo = '';//二维码所在表名，前9位数
        foreach ($codeDataArr as $key => &$value) {
            // $value = rtrim($value, "&");
            // if (mb_strlen($value) != 20) {
            //     return ['code'=>500,'msg'=>'error','data'=>'录入的二维码位数不正确!'];
            // }
            if ($key == 0) {
                $tableyemo = mb_substr($value,0,9);
            }else{
                if (mb_substr($value,0,9) != $tableyemo) {
                    // 同一张张表
                    return ['code'=>500,'msg'=>'error','data'=>'请录入同一批次二维码!'];
                }
            }
        }
        //编辑录入，只能录入同一批次/张表
        $codePrefix = substr($tableyemo, 0, 5);    //二维码标识
        $codeYm = substr($tableyemo, 5, 4);       //年月

        //根据二维码标识和二维码年月获取二维码所在表
        $vtiger = DB::connection('mysql_two');
        $codeTableName = DB::table('table_link')
                    ->where('tab_codeid', $codePrefix)
                    ->where('tab_yemo', $codeYm)
                    ->select('tab_tablenam')
                    ->first();

        if (!$codeTableName){
            return ['code'=>500,'msg'=>'error','data'=>'请检查输入的二维码是否正确!'];
        } else{
            $number = $vtiger->table($codeTableName['tab_tablenam'].'_code')->whereIn('gco_number',$codeDataArr)->count();
            if ($number != count($codeDataArr)) {
                return ['code'=>500,'msg'=>'error','data'=>'请检查输入的二维码是否正确!'];
            }else{
                return ['code'=>200,'msg'=>'success','data'=>$codeTableName['tab_tablenam'] . "_code"];
            }

        }
    }
    /**
     * 二维码与二维码所属表的映射关系
     * @return array
     * [
     *  '400011808' => codeTableName1,
     *  '400021808' => codeTableName2
     *  .....
     * ]
     */
    private function initTableLinkArray($info_code_id){
        $result = DB::table('table_link')
                    ->where('tab_codeid' ,$info_code_id)
                    ->select('tab_codeid','tab_yemo','tab_tablenam')
                    ->get();
        $newArr = [];
        foreach ($result as $key => $val){
            $newArr[$val['tab_codeid'].$val['tab_yemo']] = $val['tab_tablenam']."_code";
        }
        return $newArr;
    }

    /**
     * 拼接需要添加的SQL语句
     * @param $data
     * @return string
     * @throws Exception
     */
    private function prepareData($data = []){
        $sql = '';
        // 商品
        if (!empty($data['code_good_id'])) {
            $sql = '`gco_gid`='.$data['code_good_id'].',';
        }
        // 环境
        if (!empty($data['code_environment_id'])) {
            $sql .= '`gco_envid`='.$data['code_environment_id'].',';
        }
        // 防窜
        if (!empty($data['code_gco_coderegid'])) {
            $sql .= '`gco_coderegid`='.$data['code_gco_coderegid'].',';
        }
        // 溯源
        if (!empty($data['code_source_id'])) {
            $sql .= "`gco_temstr`=CONCAT(gco_temstr,',".$data['code_source_id']."'),";
        }
        // 生产日期
        if (!empty($data['code_production_date'])) {
            $sql = "`production_date`='".$data['code_production_date']."'";;
        }
        // 操作时间、操作人
        if (!empty($data['code_op_id'])) {
            $sql .= "`gco_op_id`=CONCAT(`gco_op_id`,',".$data['code_op_id']."'),";
        }
        return rtrim($sql,',');

    }

    /**
     * 记录操作时间、操作人
     * @return mixed
     * @throws Exception
     */
    private function opLogs($code_source_id,$admin_name)
    {
        $code_source_id = trim($code_source_id,',');
        $source_id = explode(',',$code_source_id);
        // 查询溯源模板信息
        $fomIdArr = DB::table('formwork')
                ->whereIn('fom_id', $source_id)
                ->select('fom_id','fom_content')->get();
        $base_formid = '';
        foreach ($fomIdArr as $key => $value) {
            $data = json_decode($value['fom_content'],true);
            $istype = false;
            foreach ($data as $k => $val) {
                // 判断溯源模板信息中是否有操作时间、操作人类型
                if (in_array($val['type'],[2,3])) {
                    $istype = true;
                    break;
                }
            }
            if (true === $istype) {
                $base_formid .= $value['fom_id'].',';
            }
        }
        if (empty($base_formid)) {
            return 0;
        }

        $res = DB::insert('INSERT INTO `trace_base_op` (`form_id`, `op_date`, `op_man`) VALUES (?,?,?)',[trim($base_formid,','),date('Y-m-d H:i:s'),$admin_name]);
        $id = DB::getPdo()->lastInsertId();
        return $id;
    }

    /**
     * 判断批次号是否存在
     * @return mixed
     */
    private function sectionCode($code,$adm_cid){
        $list = DB::table('group')
                ->where('gro_cid', $adm_cid)
                ->where('gro_pnumber', 'like' , '%'.$code.'%')
                ->select('gro_number','gro_pnumber')->get();
        return $list;
    }
}