<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Contracts\Support\JsonableInterface;

use App\Http\Models\Coperationa;
// 行业列表
class IndustryController extends Controller
{
	// 列表每页显示数据个数
	protected $show_count = 10;

	// 添加行业
	public function addins(Request $request)
	{
		// 验证数据
		if ( empty($request->input('ins_name'))|| !in_array($request->input('ins_stase'),array(1,2)) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断行业名是否存在
		$find_industry = DB::table('industry')
			->where('ins_cid',$find_adm['adm_cid'])
			->where('ins_name',$request->input('ins_name'))
			->select('ins_id')
			->first();
		if ($find_industry) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'行业名称已存在，请重新添加']);
		}
		
		$time = date('Y-m-d H:i:s');
		$data = [
			$find_adm['adm_cid'], 
			$request->input('ins_name'), 
			$request->input('ins_stase'), 
			$time
		];
		$bool = DB::insert('insert into trace_industry (`ins_cid`, `ins_name`, `ins_stase`, `ins_time`) values(?,?,?,?)',$data);
		if ($bool) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'行业列表','新增','新增“'.$request->input('ins_name').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
		}
	}
	// 编辑行业
	public function editins(Request $request)
	{
		// 验证数据
		if ( empty($request->input('ins_id')) || !is_numeric($request->input('ins_id')) || empty($request->input('ins_name'))|| !in_array($request->input('ins_stase'),array(1,2)) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断行业名是否存在
		$find_industry = DB::table('industry')
			->where('ins_cid',$find_adm['adm_cid'])
			->where('ins_name',$request->input('ins_name'))
			->where('ins_id','<>',$request->input('ins_id'))
			->select('ins_id')
			->first();
		if ($find_industry) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'行业名称已存在，请重新编辑']);
		}

		$time = date('Y-m-d H:i:s');
		$data = [
			$request->input('ins_name'), 
			$request->input('ins_stase'), 
			$request->input('ins_id'), 
			$find_adm['adm_cid']
		];
		$bool = DB::update('UPDATE `trace_industry` SET `ins_name`=? , `ins_stase`=?  WHERE  `ins_id`=? AND ins_cid=?',$data);
		if ($bool) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'行业列表','编辑','编辑“'.$request->input('ins_name').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑失败']);
		}
	}

    // 启用
    public function enable(Request $request)
    {
    	// 验证数据
		if ( empty($request->input('ins_id')) || !is_array($request->input('ins_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		// 查询行业名称
		$industry_data = DB::table('industry')->whereIn('ins_id',$request->input('ins_id'))->select('ins_name')->get();
		$ins_name = '';
		foreach ($industry_data as $key => $value) {
			$ins_name .= $value['ins_name'].',';
		}
		$data['ins_stase'] = 1;	//状态1启用2停用
		$data['ins_updtime'] = date('Y-m-d H:i:s');
		$res = DB::table('industry')->whereIn('ins_id',$request->input('ins_id'))->update($data);
		if ($res) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'行业列表','启用','启用“'.trim($ins_name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'启用成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'启用失败']);
		}
    }
    // 停用
    public function disable(Request $request)
    {
    	// 验证数据
		if ( empty($request->input('ins_id')) || !is_array($request->input('ins_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		// 查询行业名称
		$industry_data = DB::table('industry')->whereIn('ins_id',$request->input('ins_id'))->select('ins_name')->get();
		$ins_name = '';
		foreach ($industry_data as $key => $value) {
			$ins_name .= $value['ins_name'].',';
		}
		$data['ins_stase'] = 2;	//状态1启用2停用
		$data['ins_updtime'] = date('Y-m-d H:i:s');
		$res = DB::table('industry')->whereIn('ins_id',$request->input('ins_id'))->update($data);
		if ($res) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'行业列表','停用','停用“'.trim($ins_name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'停用成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'停用失败']);
		}
    }
    // 列表查询
    public function index(Request $request)
    {
    	if (empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		
		$data = $request->all();
		$list = DB::table('industry')
				->where('ins_cid', $find_adm['adm_cid'])
				->where(function($query) use($data) {
					if (!empty($data['ins_stase'] )) {
						$query->where('ins_stase', '=' ,$data['ins_stase'] );
					}
				})
				->where(function($query) use($data) {
					if (!empty($data['ins_name'] )) {
						$query->where('ins_name', 'like' , '%'.$data['ins_name'].'%' );
					}
				})
				->select('ins_id','ins_name','ins_stase','ins_time')
				->orderBy('ins_id','desc')
				->paginate($this->show_count);
		$listData['current_page'] = $list->currentPage();
		$listData['total'] = $list->total();
		$listData['data'] = $list->items();
		$listData['current_number'] = $this->show_count;
		$listData['last_page'] = $list->lastPage();
		$listData['code'] = 200;
		$listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
		return response()->json($listData);
    }
}