<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Contracts\Support\JsonableInterface;
use Storage;
use Excel;
use Session;
use App\Http\Models\CommenModel;
use App\Http\Models\Coperationa;
use App\Http\Controllers\CommonController;
use App\Http\Models\Goods\GoodsModel;
use Illuminate\Support\Facades\Crypt;
use Cookie;
use \Exception;
/**
 * 商品管理
 */
class GoodsController extends Controller
{
	// 列表每页显示数据个数
	protected $show_count = 10;
    // 列表查询
    public function index(Request $request)
    {
        //验证数据
		if (empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// // 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		if (!empty($request->input('goo_sta'))) {
			if (!in_array($request->input('goo_sta'),array(1,2))) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
			}
		}

		// 查询分类信息
		$find_class = DB::table('goo_classifi')
			->where('cla_cid',$find_adm['adm_cid'])
			->where('cla_stase',1)
			->select('cla_id','cla_name','cla_parent_id')
			->get();
		$find_nav = DB::table('navigation')
			->where('nav_cid',$find_adm['adm_cid'])
			->where('nav_state',1)
			->where('nav_del',1)
			->get();
		$data = $request->all();
		$list = DB::table('goods as a')
				->leftJoin('goo_classifi as b', 'a.goo_classifi', '=', 'b.cla_id')
				->leftjoin('navigation as c','a.goo_navid','=','c.nav_id')
				->where('a.del_type', 1)
				->where('a.goo_cid', $find_adm['adm_cid'])
				->where(function($query) use($data) {
					if (!empty($data['goo_name'] )) {
						$query->where('a.goo_name', 'like' , '%'.$data['goo_name'].'%' );
					}
				})
				->where(function($query) use($data) {
					if (!empty($data['goo_number'] )) {
						$query->where('a.goo_number', 'like' , '%'.$data['goo_number'].'%' );
					}
				})
				->where(function($query) use($data) {

					if (!empty($data['goo_classifi'] )) {
						$str=Db::table('goo_classifi')->where(['cla_id'=>$data['goo_classifi']])->select('cla_id','cla_parent_id')->first();
						if($str['cla_parent_id']==0){
							$str=Db::table('goo_classifi')->where(['cla_id'=>$data['goo_classifi']])->select('cla_id')->get();
							$id=array_column($str,'cla_id');
							$query->whereIn('a.goo_classifi',$id);
						}else{
							$query->where('a.goo_classifi', '=' ,$data['goo_classifi'] );
						}

					}
				})
				->where(function($query) use($data) {
					if (!empty($data['goo_sta'] )) {
						$query->where('a.goo_sta', '=' ,$data['goo_sta'] );
					}
				})
				->where(function($query) use($data) {
                    if (!empty($data['nav_name'])) {
                        $query->where('c.nav_name', 'like' , '%'.$data['nav_name'].'%' );
                    }
                })//导航id
				->select('a.goo_id','a.goo_name','a.goo_number','b.cla_name','a.goo_sta','a.goo_code_percent','a.technician_integral','a.channel_integral','a.warranty_day','a.validity_period','c.nav_name','a.goo_classifi')
				->orderBy('a.goo_id','desc')
				->paginate($this->show_count);

		$listData['current_page'] = $list->currentPage();
		$listData['total'] = $list->total();
		$listData['data'] = $list->items();
		$listData['last_page'] = $list->lastPage();
		$listData['current_number'] = $this->show_count;
		$listData['goo_class'] = $find_class;
		$listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
		$listData['code'] = 200;
		return response()->json($listData);
    }
    
    // 添加商品
	public function addgo(Request $request)
	{
		// 验证数据
		if (!in_array($request->input('type'),array(1,2))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request['api_token']);

		// 获取添加商品页面信息
		if ($request->input('type') == 1) {
            $data = $request->all();
			$class_id=(int)$request->input('cla_id');
			if(empty($class_id)){
				// 查询分类信息
				$find_class = DB::table('goo_classifi')
					->where('cla_cid',$find_adm['adm_cid'])
					->where('cla_stase',1)->where('cla_parent_id',0)
                    ->get(['cla_id','cla_name']);
			}else{
				$find_class = DB::table('goo_classifi')
					->where('cla_cid',$find_adm['adm_cid'])
					->where('cla_stase',1)
					->where('cla_parent_id',$class_id)
                    ->get(['cla_id as class_id','cla_name as class_name']);
			}

			// 查询导航信息
			$find_nav = DB::table('navigation')
				->where(['nav_del'=>1,'nav_state'=>1,'nav_cid'=>$find_adm['adm_cid']])
                ->where(function($query) use($data) {
                    if (!empty($data['nav_name'] )) {
                        $query->where('nav_name', 'like' , '%'.$data['nav_name'].'%' );
                    }
                })
				->orWhere('nav_id',1)
				->get(['nav_id','nav_name']);
			$find_data['goo_class'] = $find_class;
			$find_data['navigation'] = $find_nav;
			if ($find_adm['adm_id'] == '1') {
				$find_data['goo_cid'] = DB::table('admin')->where('adm_cid',$find_adm['adm_cid'])->value('adm_cid');
			}
			return response()->json(['code'=>200,'msg'=>'success','data'=>$find_data]);
		}
		$nav_id=(int)$request->input('nav_id');
		$res1=DB::table('navigation')
            ->where('nav_id',$nav_id)
            ->where('nav_del',1)
            ->where('nav_state',1)
            ->where('nav_cid',$find_adm['adm_cid'])
            ->orWhere('nav_id',1)
            ->select('nav_id')
            ->first();
		if(empty($res1)){
			return response()->json(['code'=>500,'msg'=>'error','data'=>'导航错误']);
		}
		$day=date('Ymd');
		foreach ($request->input('info_name') as $key => $value) {
			if ($value == '商品名称') {
				$goo_name = $request->input('info_content')[$key];
			}
			if ($value == '条形码号') {
				$goo_number = $request->input('info_content')[$key];
			}
			$goo_pro[$key]['key'] = $value;
			$goo_pro[$key]['show'] = $request->input('info_show')[$key];		//显示隐藏
			$goo_pro[$key]['type'] = $request->input('info_type')[$key];		//属性类型
			$goo_pro[$key]['pri'] = $request->input('info_pri')[$key];			//是否打印
			$url = $request->input('info_content')[$key];						//内容
			if (($goo_pro[$key]['type']==6 || $goo_pro[$key]['type']==7) && !empty($url)) {
				//判断是否是临时文件;
                if(strpos($url,'temporary')){
                    $end=explode('.',$url)[1];  //获取后缀
                    $file_name=$goo_pro[$key]['type']==6?'images':'videos';
                    $new_name='uploads/goods/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path=public_path().'/'.$new_name;  //新的文件地址
                    $old_url=public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if(!is_dir(dirname($new_path))){
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url=$new_name;
                }else{
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
			}
			$goo_pro[$key]['value']=$url;   
		}

		// 查询商品名称是否存在
		$find_goo_name = DB::table('goods')
				->where('del_type', 1)
				->where('goo_cid', $find_adm['adm_cid'])
				->where('goo_name', $goo_name)
				->first();
		if ($find_goo_name) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'商品名称已存在']);
		}
		// 查询条形码号是否存在
		$find_goo_number = DB::table('goods')
				->where('del_type', 1)
				->where('goo_cid', $find_adm['adm_cid'])
				->where('goo_number', $goo_number)
				->first();
		if ($find_goo_number) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'条形码号已存在']);
		}
		$goo_picurl = '';
        if (!empty($request->input('goo_picurl'))) {
            // 上传图片
            $uploadImg = new CommonController;
            foreach ($request->input('goo_picurl') as $key => $value) {
                $uploadPath = $uploadImg->uploadBase64Img($value);
                if ($uploadPath) {
                    $goo_picurl .= $uploadPath.',';
                }else{
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                }
            }
            $goo_picurl = trim($goo_picurl,',');
        }
		$goo_image = '';
		if (!empty($request->input('goo_image'))) {
			// 上传终端模板效果图片
			$uploadImgs = new CommonController;
			foreach ($request->input('goo_image') as $key => $value) {
				$uploadPath = $uploadImgs->uploadBase64Img($value);
				if ($uploadPath) {
					$goo_image .= $uploadPath.',';
				}else{
					return response()->json(['code'=>500,'msg'=>'error','data'=>'模板图片上传失败']);
				}
			}
			$goo_image = trim($goo_image,',');
		}
		$time = date('Y-m-d H:i:s');
		$goo_add_data['goo_name'] = $goo_name;
		$goo_add_data['goo_number'] = $goo_number;
		$goo_add_data['goo_cid'] = $find_adm['adm_cid'];
		$goo_add_data['goo_classifi'] = $request['goo_classifi'];
		$goo_add_data['goo_picurl'] = $goo_picurl;
		$goo_add_data['goo_pro'] = json_encode($goo_pro);
		$goo_add_data['goo_sta'] = 1;
		$goo_add_data['goo_time'] = $time;
		$goo_add_data['goo_navid'] = $nav_id;
		$goo_add_data['technician_integral'] = $request['technician_integral'] ? $request['technician_integral'] : 0;
		$goo_add_data['channel_integral'] = $request['channel_integral'] ? $request['channel_integral'] : 0;
		$goo_add_data['warranty_day'] = $request['warranty_day'] ? $request['warranty_day'] : 0;
		$goo_add_data['validity_period'] = $request['validity_period'] ? $request['validity_period'] : 0;
		$goo_add_data['goo_image'] = $goo_image;
		DB::beginTransaction();
		//添加商品
		$goo_res = DB::table('goods')->insertGetId($goo_add_data);

		// 商品所属分类数量更改
		$res_class = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request->input('goo_classifi')] );
		// 商品所属导航数量更改
		$res_nav = DB::update('UPDATE `trace_navigation` SET `nav_total` = `nav_total`+1 WHERE `nav_id`=?',[$request->input('goo_navid')]);
		if ($goo_res && $res_class && $res_nav) {
			DB::commit();
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品列表','新增','新增“'.$goo_name.'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
		}else{
			DB::rollBack();
			return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
		}
	}
    // 编辑商品
	public function editgo(Request $request)
	{
		// 验证数据
		if (!in_array($request->input('type'),array(1,2)) || !$request->exists('edit_id') || !is_numeric($request->input('edit_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		if ($request->input('type') == 1) {
			// 获取商品页面信息
			// 查询分类信息
			$find_class = DB::table('goo_classifi as a')
				->where('a.cla_cid', $find_adm['adm_cid'])
				->where('a.cla_stase', 1)
				->selectRaw('trace_a.cla_id,trace_a.cla_name,trace_a.cla_stase,trace_a.cla_level,trace_a.cla_total,trace_a.cla_parent_id,trace_a.cla_parent_ids,if(trace_b.cla_name is null,"顶级分类",trace_b.cla_name) as class_name')
				->leftJoin('goo_classifi as b','a.cla_parent_id','=','b.cla_id')
				->orderBy('a.cla_id','desc')
				->get();
			// 查询导航信息
			$find_nav = DB::table('navigation')
				->where(['nav_del'=>1,'nav_state'=>1,'nav_cid'=>$find_adm['adm_cid']])
				->orWhere('nav_id',1)
				->select('nav_id','nav_name')->get();
			// 查询商品信息
			$find_goods = DB::table('goods')
				->where('goo_id',$request->input('edit_id'))
				->where('goo_cid',$find_adm['adm_cid'])
				->select('goo_name','goo_number','goo_classifi','goo_picurl','goo_pro','goo_navid','technician_integral','channel_integral','warranty_day','validity_period','goo_image')->get();

			$find_goods[0]['goo_pro'] = json_decode($find_goods[0]['goo_pro']);
			$find_goods[0]['goo_picurl'] = explode(',', $find_goods[0]['goo_picurl']);
			$find_goods[0]['goo_image'] = explode(',', $find_goods[0]['goo_image']);
			$find_data['goo_class'] = $find_class;
			$find_data['navigation'] = $find_nav;
			$find_data['goods'] = $find_goods;
			if ($find_adm['adm_id'] == '1') {
				$find_data['goo_cid'] = DB::table('goods')->where('goo_cid',$find_adm['adm_cid'])->value('goo_cid');
			}
			return response()->json(['code'=>200,'msg'=>'success','data'=>$find_data]);
		}
		// 验证数据
		if (!$request->exists('goo_classifi') || !is_numeric($request->input('goo_classifi'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}

		$nav_id=(int)$request->input('nav_id');
		$res1=DB::table('navigation')
            ->where('nav_id',$nav_id)
            ->where('nav_del',1)
            ->where('nav_state',1)
            ->where('nav_cid',$find_adm['adm_cid'])
            ->orWhere('nav_id',1)
            ->select('nav_id')
            ->first();
		if(empty($res1)){
			return response()->json(['code'=>500,'msg'=>'error','data'=>'导航错误']);
		}
		$day=date('Ymd');
		$file_data=[];
		foreach ($request->input('info_name') as $key => $value) {
			// 判断当前复制列表是否为复制列表
	        if(strpos($request->input('info_content')[$key],'---副本') !==false){
	             return response()->json(["code"=>500,'msg'=>'error','data'=>'请去掉信息名称中的 " ---副本 "']);
	        }

			if ($value == '商品名称') {
				$goo_name = $request->input('info_content')[$key];
			}
			if ($value == '条形码号') {
				$goo_number = $request->input('info_content')[$key];
			}
			$goo_pro[$key]['key'] = $value;
			$goo_pro[$key]['show'] = $request->input('info_show')[$key];		//显示隐藏
			$goo_pro[$key]['type'] = $request->input('info_type')[$key];		//属性类型
			$goo_pro[$key]['pri'] = $request->input('info_pri')[$key];			//是否打印
			$url 				   = $request->input('info_content')[$key];		//内容
			if(($goo_pro[$key]['type']==6 || $goo_pro[$key]['type']==7) && !empty($url)){
                //判断是否是临时文件;
                if(strpos($url,'temporary')){
                    $end=explode('.',$url)[1];  //获取后缀
                    $file_name=$goo_pro[$key]['type']==6?'images':'videos';
                    $new_name='uploads/goods/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path=public_path().'/'.$new_name;  //新的文件地址
                    $old_url=public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if(!is_dir(dirname($new_path))){
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url=$new_name;
                }else{
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
            }   
            $goo_pro[$key]['value']=$url;
		}
		// 查询商品名称是否存在
		$find_goo_name = DB::table('goods')
				->where('del_type', 1)
				->where('goo_cid', $find_adm['adm_cid'])
				->where('goo_name', $goo_name)
				->where('goo_id','<>', $request->input('edit_id'))
				->select('goo_name','goo_classifi')
				->first();
		if ($find_goo_name) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'商品名称已存在']);
		}
		// 查询条形码号是否存在
		$find_goo_number = DB::table('goods')
				->where('del_type', 1)
				->where('goo_cid', $find_adm['adm_cid'])
				->where('goo_number', $goo_number)
				->where('goo_id','<>', $request->input('edit_id'))
				->select('goo_number')
				->first();
		if ($find_goo_number) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'条形码号已存在']);
		}
		$goo_picurl = '';
        if ($request->input('img_state') == 1) {
            if (!empty($request->input('goo_picurl'))) {
                // 上传图片
                $uploadImg = new CommonController;
                foreach ($request->input('goo_picurl') as $key => $value) {
                    if (stristr($value, 'data:image')) {
                        $uploadPath = $uploadImg->uploadBase64Img($value);
                        if ($uploadPath) {
                            $goo_picurl .= $uploadPath.',';
                        }else{
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                        }
                    }else{
                        // 获取原图片路径
                        $path = explode(config('app.url'),$value);
                        $path_url = trim($path[1],'/');
                        $path_type = explode('.',$path_url);
                        // 新图片路径文件名
                        $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                        $pathName = "/image/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                        // 复制图片
                        $new_url = copy(base_path().'/'.$path_url, storage_path().$pathName);
                        // 返回路径
                        $filePath = "storage". $pathName;
                        $goo_picurl .= $filePath.',';
                    }
                }
                $goo_picurl = trim($goo_picurl,',');
            }
        }
		$goo_image = '';
		if (!empty($request->input('goo_image'))) {
			// 上传图片
			try{
				foreach ($request->input('goo_image') as $key => $value) {
					$goo_image.=CommenModel::uploadBase64Img($value,'goods').',';
				}
			}catch(Exception $e){
				return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
			}
			$goo_image = trim($goo_image,',');
		}
		$time = date('Y-m-d H:i:s');
        $goo_edit_data['goo_name'] = $goo_name;
        $goo_edit_data['goo_number'] = $goo_number;
        $goo_edit_data['goo_cid'] = $find_adm['adm_cid'];
        $goo_edit_data['goo_classifi'] = $request['goo_classifi'];
        $goo_edit_data['goo_picurl'] = $goo_picurl;
        $goo_edit_data['goo_pro'] = json_encode($goo_pro);
        $goo_edit_data['goo_navid'] = $nav_id;
        $goo_edit_data['technician_integral'] = $request['technician_integral'] ? $request['technician_integral'] : 0;
        $goo_edit_data['channel_integral'] = $request['channel_integral'] ? $request['channel_integral'] : 0;
        $goo_edit_data['warranty_day'] = $request['warranty_day'] ? $request['warranty_day'] : 0;
        $goo_edit_data['validity_period'] = $request['validity_period'] ? $request['validity_period'] : 0;
        $goo_edit_data['goo_image'] = $goo_image;
        $goo_edit_data['goo_update_time'] = $time;

		DB::beginTransaction();

		// 判断是否更改商品所属分类
		$find_goo_classifi = DB::table('goods')
				->where('goo_cid', $find_adm['adm_cid'])
				->where('goo_id', $request->input('edit_id'))
				->select('goo_classifi')
				->first();
		if ($request->input('goo_classifi') != $find_goo_classifi['goo_classifi']) {
			// 更改商品所属分类数量
			$res_class1 = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request->input('goo_classifi')] );
			$res_class2 = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`-1  WHERE `cla_id`=?',[$find_goo_classifi['goo_classifi']] );
			if ($res_class1 && $res_class2) {
				$res_class = true;
			}else{
				$res_class = false;
			}
		}else{
			$res_class = true;
		}
		// 判断是否更改商品所属导航
		$find_nav = DB::table('goods')
				->where('goo_cid', $find_adm['adm_cid'])
				->where('goo_id', $request->input('edit_id'))
				->first(['goo_navid']);
		if ($request->input('nav_id') != $find_nav['goo_navid']) {
			// 更改商品所属导航数量
			$res_nav1 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`+1  WHERE `nav_id`=?',[$request->input('nav_id')] );
			$res_nav2 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`-1  WHERE `nav_id`=?',[$find_nav['goo_navid']] );
			if ($res_nav1 && $res_nav2) {
				$res_nav = true;
			}else{
				$res_nav = false;
			}
		}else{
			$res_nav = true;
		}

		//编辑商品
        $goo_res = DB::table('goods')
            ->where('goo_id',$request['edit_id'])
            ->update($goo_edit_data);

		if ($goo_res && $res_class && $res_nav) {
			DB::commit();
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品列表','编辑','编辑“'.$goo_name.'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
		}else{
			DB::rollBack();
			return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑失败']);
		}
	}

	// 营养成分
	public function editindex(Request $request)
	{
		// 验证数据
		if (!in_array($request->input('type'),array(1,2)) || !$request->exists('edit_id') || !is_numeric($request->input('edit_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		if ($request->input('type') == 1) {
			// 获取商品页面信息
			// 查询商品信息
			$find_goods = DB::table('goods')
				->where('goo_id',$request->input('edit_id'))
				->where('goo_cid',$find_adm['adm_cid'])
				->select('goo_nutrient_content')->get();

			$find_goods[0]['goo_nutrient_content'] = json_decode($find_goods[0]['goo_nutrient_content']);
			$find_data['goods'] = $find_goods;
			$find_data['goo_cid'] = DB::table('admin')->where('adm_cid',$find_adm['adm_cid'])->value('adm_cid');
			return response()->json(['code'=>200,'msg'=>'success','data'=>$find_data]);
		}

		$day=date('Ymd');
		$file_data=[];
		if(empty($request['infos_name']) || empty($request['infos_show']) || empty($request['infos_type']) || empty($request['infos_content']))
        {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'存在空值']);
        }
		foreach ($request->input('infos_name') as $key => $value) {
			// 判断当前复制列表是否为复制列表
	        if(strpos($request->input('infos_content')[$key],'---副本') !==false){
	             return response()->json(["code"=>500,'msg'=>'error','data'=>'请去掉信息名称中的 " ---副本 "']);
	        }
			$goo_nutrient_content[$key]['key'] = $value;
			$goo_nutrient_content[$key]['show'] = $request->input('infos_show')[$key];		//显示隐藏
			$goo_nutrient_content[$key]['type'] = $request->input('infos_type')[$key];		//属性类型
			$url 				   = $request->input('infos_content')[$key];		//内容
			if(($goo_nutrient_content[$key]['type']==6 || $goo_nutrient_content[$key]['type']==7) && !empty($url)){
                //判断是否是临时文件;
                if(strpos($url,'temporary')){
                    $end=explode('.',$url)[1];  //获取后缀
                    $file_name=$goo_nutrient_content[$key]['type']==6?'images':'videos';
                    $new_name='uploads/goods/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path=public_path().'/'.$new_name;  //新的文件地址
                    $old_url=public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if(!is_dir(dirname($new_path))){
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url=$new_name;
                }else{
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
            }   
            $goo_nutrient_content[$key]['value']=$url;
		}
		$time = date('Y-m-d H:i:s');
		$data = [
			json_encode($goo_nutrient_content), 
			$time,
			$request->input('edit_id')
		];
		$res_goods = DB::update('UPDATE `trace_goods` SET `goo_nutrient_content`=?, `goo_time`=? WHERE `goo_id`=?',$data);
		if ($res_goods) {
			return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑失败']);
		}
	}

	//  新---- 图片上传
    public function imageform(Request $request)
    {
        $image =  $request['images'];
        $imageName = "IMG_".time()."_".rand(1111,9999).'.png';
        // 当前文件根路径
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';

        if(!empty($image)) {
            if (strstr($image,",")) {
                $image = explode(',',$image);
                $image = $image[1];
            }
            $path = "uploads/template/temporary";
            if (!is_dir($path)) {             //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            $imageSrc= $path."/". $imageName;  //图片名字

            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(["code"=>200,'msg'=>'success','data'=>'图片上传成功','path'=>$imageSrc]);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'还未选择图片']);
        }
    }

    //  新 --- 视频上传
    public function videoform(Request $request)
    {
        $file =  $request->file('video');
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        $url_path = 'uploads/template/temporary';
        if (!is_dir($url_path)) {             //判断目录是否存在 不存在就创建
            mkdir($url_path,0777,true);
        }

        $rule = ['mp4', 'avi', 'mov','rmvb','flv','3gp'];
        // 使用 hasFile 方法判断文件在请求中是否存在
        if ($request->hasFile('video')) {
            // 使用 isValid 方法判断文件在上传过程中是否出错
            if ($file->isValid()) {
                //获取文件扩展名
                $clientName = $file->getClientOriginalName();
                // 获取文件名
                $tmpName = $file->getFileName();
                //获取文件路径
                $realPath = $file->getRealPath();
                // 获取文件大小(字节)
                $filesize =   $file->getClientSize();
                // 换算成M
                $filesize = $filesize/(1024*1024);
                if($filesize > 50) {
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'最大仅支持50M的视频上传']);
                }       
                $entension = $file->getClientOriginalExtension();
                if (!in_array($entension, $rule)) {
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'仅支持视频为:mp4,avi,mov,rmvb,flv,3gp']);
                }
                // 生成上传文件名
                $newName ="VID_".time()."_".rand(1111,9999)."." . $entension;
                $path = $file->move($upload_files.$url_path, $newName);
                // 返回路径
                $namePath = $url_path . '/' . $newName;

                return response()->json(["code"=>200,'msg'=>'success','data'=>'视频上传成功','videoSrc'=>$namePath]);
            } else {
                return response()->json(["code"=>500,'msg'=>'error','data'=>'文件上传错误']);
            }
        } else {
            return response()->json(["code"=>9000,'msg'=>'error','data'=>'文件请求不存在']);
        }
    }

    // 删除 溯源信息临时文件接口
    public function file_data(Request $request)
    {
        //请求  溯源信息的临时图片和视频
        $path=public_path().'/uploads/template/temporary';

        if(is_dir($path)) {
            if(!file_exists($path)) {
                mkdir($path,0777,true);
            }
        }
        $time=time()-24*60*60;
        $file=[];
        $resource=opendir($path);
        //获取 图片文件夹下所有文件;  并判断是否超过24 小时  超过则删除
        while($row=readdir($resource)) {
            if ($row=='.'||$row=='..') {continue;}
            $old_time=explode('_',$row)[1];
            if ($old_time<$time) {
                chmod($path.'/'.$row,0777);
                unlink($path.'/'.$row);
            }
        }
        closedir($resource);
        echo 'ok';
    }

    // 删除视频
    public function delvideoform(Request $request)
    {
        $video =  $request['video'];
        if (!is_array($video)) {
            $temp=$video;
            unset($video);
            $video[]=$temp;
        }
        foreach ($video as $key => $val) {
            if (file_exists(public_path().'/'.$val) && !empty($val)) {
                // 修改原视频权限
                chmod(public_path().'/'.$val,0777);
                // 删除原视频
                unlink(public_path().'/'.$val); 
            }
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'删除视频成功']);
    }

    // 删除图片
    public function delimageform(Request $request)
    {
        $image =  $request['images'];
        if(!is_array($image)) {
            $temp=$image;
            unset($image);
            $image[]=$temp;
        }
        foreach ($image as $key => $val) {
            if (file_exists(public_path().'/'.$val) && !empty($val)) {
                // 修改原圖片权限
                chmod(public_path().'/'.$val,0777);
                // 删除原圖片
                unlink(public_path().'/'.$val); 
            }
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'删除图片成功']);
    }

	// 删除商品
	public function delgo(Request $request){
		// 验证数据
		if ( !$request->exists('del_id') || !is_array($request->input('del_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断删除个数
		if (count($request->input('del_id')) > 1) {
			$find_goods = DB::table('goods')->whereIn('goo_id', $request->input('del_id'))->select('goo_name','goo_classifi','goo_navid','goo_cid')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find_goods = DB::table('goods')->where('goo_id', $request->input('del_id'))->select('goo_name','goo_classifi','goo_navid','goo_cid')->get();
		}

		if (empty($find_goods)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前商品不存在或者已删除']);
		}
		// 判断商品是否发码
		$find_group = DB::table('group')
			->where('gro_cid',$find_adm['adm_cid'])
			->$where_type('gro_gid',$request->input('del_id'))
			->select('gro_id')->first();

		if ($find_group) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前商品已发码，无法删除']);
		}
		DB::beginTransaction();
		$res_goods = DB::table('goods')
				->where('goo_cid', $find_adm['adm_cid'])
				->$where_type('goo_id', $request->input('del_id'))
				->update(['del_type' => 2]);
		$goo_name = '';
		foreach ($find_goods as $key => $value) {
			$goo_name .= $value['goo_name'].',';
			$goo_class[] = $value['goo_classifi'];
			$goo_navid[] = $value['goo_navid'];
			$goo_cid[] = $value['goo_cid'];
		}

		$goo_classifi = array_count_values($goo_class);
		$goo_navid = array_count_values($goo_navid);
		$goo_cid = array_count_values($goo_cid);
		$del_sql = '';
		$ids = '';
		if (count($goo_classifi) > 1 ) {
			// 所属分类商品数量更改
			$del_sql = 'UPDATE `trace_goo_classifi` SET `cla_total`=  CASE `cla_id` ';
			foreach ($goo_classifi as $key => $value) {
				$del_sql = $del_sql . ' WHEN ' .$key;
				$del_sql = $del_sql . ' THEN `cla_total`-' .$value;
				$ids = $ids . $key.',';
			}
			$del_sql = $del_sql . ' END WHERE `cla_id` IN ('.trim($ids,',').')';
		} else {
			$del_sql = 'UPDATE `trace_goo_classifi` SET  `cla_total`= `cla_total`-'.end($goo_classifi).'  WHERE  `cla_id` ='.key($goo_classifi);
		}
		if (count($goo_navid) > 1 ) {
			// 所属导航商品数量更改
			$del_sqls = 'UPDATE `trace_navigation` SET `nav_total`=  CASE `nav_id` ';
			foreach ($goo_navid as $key => $value) {
				$del_sqls = $del_sqls . ' WHEN ' .$key;
				$del_sqls = $del_sqls . ' THEN `nav_total`-' .$value;
				$ids1 = $ids1 . $key.',';
			}
			$del_sqls = $del_sqls . ' END WHERE `nav_id` IN ('.trim($ids1,',').')';
		} else {
			$del_sqls = 'UPDATE `trace_navigation` SET  `nav_total`= `nav_total`-'.end($goo_navid).'  WHERE  `nav_id` ='.key($goo_navid);
		}
		$res_nav = DB::update($del_sqls);
		if (count($goo_cid) > 1 ) {
			// 所属导航商品数量更改
			$del_sqlss = 'UPDATE `trace_company` SET `com_good`=  CASE `com_id` ';
			foreach ($goo_cid as $key => $value) {
				$del_sqlss = $del_sqlss . ' WHEN ' .$key;
				$del_sqlss = $del_sqlss . ' THEN `com_good`-' .$value;
				$ids2 = $ids2 . $key.',';
			}
			$del_sqlss = $del_sqlss . ' END WHERE `com_id` IN ('.trim($ids2,',').')';
		} else {
			$del_sqlss = 'UPDATE `trace_company` SET  `com_good`= `com_good`-'.end($goo_cid).'  WHERE  `com_id` ='.key($goo_cid);
		}
		$res_class = DB::update($del_sql);
		$res_com = DB::update($del_sqlss);
		if ($res_goods && $res_class && $res_nav && $res_com) {
			DB::commit();
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品列表','删除','删除“'.trim($goo_name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
		}else{
			DB::rollBack();
			return response()->json(['code'=>500,'msg'=>'success','data'=>'删除失败']);
		}
	}
	// 启用
    public function open_state(Request $request)
    {
    	// 验证数据
		if (empty($request->input('goo_id')) || !is_array($request->input('goo_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断个数
		if (count($request->input('goo_id')) > 1) {
			$find_goods = DB::table('goods')->whereIn('goo_id', $request->input('goo_id'))->select('goo_name','goo_sta')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find_goods = DB::table('goods')->where('goo_id', $request->input('goo_id'))->select('goo_name','goo_sta')->get();
		}

		if (empty($find_goods)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前商品不存在或者已删除']);
		}
		$name = '';
		$istype = false;
		foreach ($find_goods as $key => $value) {
			if ($value['goo_sta'] != 1) {
				$istype = true;
			}
			$name = $name.$value['goo_name'].',';
		}

		if ($istype) {
			$result = DB::table('goods')
					->where('goo_cid', $find_adm['adm_cid'])
					->$where_type('goo_id', $request->input('goo_id'))
					->update(['goo_sta'=>1]);
        } else {
            $result = true;
        }

		if (!empty($result)) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品列表','启用','启用“'.trim($name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'启用成功']);
		} else {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'启用失败']);
		}
    }

    // 停用
    public function stop_state(Request $request)
    {
    	// 验证数据
		if (empty($request->input('goo_id')) || !is_array($request->input('goo_id'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断个数
		if (count($request->input('goo_id')) > 1) {
			$find_goods = DB::table('goods')->whereIn('goo_id', $request->input('goo_id'))->select('goo_name','goo_sta')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find_goods = DB::table('goods')->where('goo_id', $request->input('goo_id'))->select('goo_name','goo_sta')->get();
		}

		if (empty($find_goods)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前商品不存在或者已删除']);
		}
		$name = '';
		$istype = false;
		foreach ($find_goods as $key => $value) {
			if ($value['goo_sta'] != 2) {
				$istype = true;
			}
			$name = $name.$value['goo_name'].',';
		}

		if ($istype) {
			$result = DB::table('goods')
					->where('goo_cid', $find_adm['adm_cid'])
					->$where_type('goo_id', $request->input('goo_id'))
					->update(['goo_sta'=>2]);
        } else {
            $result = true;
        }

		if (!empty($result)) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品列表','停用','停用“'.trim($name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'停用成功']);
		} else {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'停用失败']);
		}
    }
    //导入 excel 
    public function import(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}

		$file=$request->file('file');
		if(empty($file)){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'上传文件不能为空'],JSON_UNESCAPED_UNICODE);
		}
		if($file->isValid()){
                $res=$this->UploadsFileImport($file,$user);
                $file_name = $res['data'];
                try{
		       		$data=[];
			       	Excel::load($file_name,function($reader) use ($user,$file_name,$request){
			       		// return $file_name;
			       		DB::beginTransaction();
			           	$reader = $reader->getSheet(0); 
						//获取表中的数据 
						$results = $reader->toArray();
						// var_dump($results);exit;
						$goods_list=[];
						if (count($results[0]) > 20) {
							echo json_encode(['code'=>500,'msg'=>'error','data'=>'最多输入20列']);exit;
						}
						$i="0";
						foreach ($results as $key => $value) {
							$arr[$i]=$value;
							$i=$i+1;
							if(!isset($arrcount)){
								$arrcount=count($value);
							}
						}
						// var_dump($arrcount);exit;

						// 查找该公司导入数量
						$find_com_good = DB::table('company')
							->where('com_id',$user['adm_cid'])
							->where('com_stase',1)
							->select('com_good','com_id')
							->first();
						$cid=sprintf("%04d", $user['adm_cid']);
						// var_dump($arr);exit;
						foreach($arr as $k=>$v){
							if($k!="0" && $k!="1" && $k!="2" && $k!="3"){
								$l="0";
								$find_com_good['com_good'] = $find_com_good['com_good'] + 1;
								while($l<$arrcount){
									$array[$l]["key"]=$arr[1][$l];
									$array[$l]["value"]=(string)$arr[$k][$l];
									if ($array[$l]["value"] == '' && $array[$l]["key"]=='条形码号') {
										$xuhao=sprintf("%08d", $find_com_good['com_good']);
										$array[$l]["value"] = "N".$cid.$xuhao;
									}else{
										$array[$l]["value"]=(string)$arr[$k][$l];
									}
									$array[$l]["type"]="1";
									// $array[$l]["show"]="1";
									$array[$l]["show"]=(int)$arr[2][$l];
									if ($array[$l]["show"] == '') {
										$array[$l]["show"]="1";
									}else{
										$array[$l]["show"]=(int)$arr[2][$l];
									}
									$array[$l]["pri"]=(int)$arr[1][$l];
									if ($array[$l]["pri"] == '') {
										$array[$l]["pri"]=1;
									}else{
										$array[$l]["pri"]=(int)$arr[1][$l];
									}
									$l=$l+1;
								}
								$p="0";
								foreach($array as $kk=>$vv){
									if($vv['value']!=""){
										$newarray[$p]=$vv;
										$p=$p+1;
									}
								}
								$add_order_data['goo_name'] = $v[0];
								if ($v[0] == null) {
									echo json_encode(['code'=>500,'msg'=>'error','data'=>'商品名称不能为空']);exit;
								}
								$add_order_data['goo_number'] = $v[1];
								if ($add_order_data['goo_number'] == null) {
									$xuhao=sprintf("%08d", $find_com_good['com_good']);
									$add_order_data['goo_number'] = "N".$cid.$xuhao;
								}else{
									$add_order_data['goo_number'] = $v[1];
								}
								$add_order_data['goo_pro'] = json_encode($newarray);
								unset($array);unset($newarray);
								if (strlen($add_order_data['goo_number']) != 13 || preg_match('/^[A-Za-z0-9]{13}$/', $add_order_data['goo_number']) !== 1) {
									echo json_encode(['code'=>500,'msg'=>'error','data'=>'商品条形码号必须是13位（由数字或字母组成）']);exit;
								}
								// 查询商品名称是否存在
								$find_goo_name = DB::table('goods')
									->where('del_type', 1)
									->where('goo_cid', $user['adm_cid'])
									->where('goo_name', $add_order_data['goo_name'])
									->select('goo_name','goo_id','goo_number')
									->first();
								$find_goo_number = DB::table('goods')
									->where('del_type', 1)
									->where('goo_cid', $user['adm_cid'])
									->where('goo_number', $add_order_data['goo_number'])
									->select('goo_name','goo_id','goo_number')
									->first();
								if ($find_goo_name == '' && $find_goo_number == '') {
									if (!$request->exists('goo_classifi') || !is_numeric($request->input('goo_classifi')) || !$request->exists('goo_navid') || !is_numeric($request->input('goo_navid'))) {
										echo json_encode(['code'=>500,'msg'=>'error','data'=>'请选择分类和导航']);exit;
									}
									$add_order_data['goo_classifi'] = $request['goo_classifi'];
									$add_order_data['goo_navid'] = $request['goo_navid'];
									$add_order_data['goo_cid']	= $user['adm_cid'];
									$add_order_data['goo_time'] = date('Y-m-d H:i:s');
									$res = DB::table('goods')->insertGetId($add_order_data);
									// 商品所属分类数量更改
									$res_class = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request['goo_classifi']]);
									// 商品所属导航数量更改
									$res_nav = DB::update('UPDATE `trace_navigation` SET `nav_total` = `nav_total`+1 WHERE `nav_id`=?',[$request['goo_navid']]);
								}
								if (!$request->exists('goo_classifi') || !is_numeric($request->input('goo_classifi')) || !$request->exists('goo_navid') || !is_numeric($request->input('goo_navid'))) {
									echo json_encode(['code'=>500,'msg'=>'error','data'=>'请选择分类和导航']);exit;
								}
								$res = DB::table('goods')
									->where('goo_id',$find_goo_name['goo_id'])
									->update([
										'goo_name'=>$add_order_data['goo_name'],
										'goo_number'=>$add_order_data['goo_number'],
										'goo_classifi' => $request['goo_classifi'],
										'goo_navid' => $request['goo_navid'],
										'goo_time' => date('Y-m-d H:i:s'),
										'goo_pro' => $add_order_data['goo_pro']
										]);
								// 判断是否更改商品所属分类
								$find_goo_classifi = DB::table('goods')
										->where('goo_cid', $user['adm_cid'])
										->where('goo_id', $find_goo_name['goo_id'])
										->first(['goo_classifi']);
								if ($request->input('goo_classifi') != $find_goo_classifi['goo_classifi']) {
									// 更改商品所属分类数量
									$res_class1 = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request->input('goo_classifi')] );
									$res_class2 = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`-1  WHERE `cla_id`=?',[$find_goo_classifi['goo_classifi']] );
									if ($res_class1 && $res_class2) {
										$res_class = true;
									}else{
										$res_class = false;
									}
								}else{
									$res_class = true;
								}
								// 判断是否更改商品所属导航
								$find_nav = DB::table('goods')
										->where('goo_cid', $user['adm_cid'])
										->where('goo_id', $find_goo_name['goo_id'])
										->first(['goo_navid']);
								if ($request->input('goo_navid') != $find_nav['goo_navid']) {
									// 更改商品所属导航数量
									$res_nav1 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`+1  WHERE `nav_id`=?',[$request->input('goo_navid')] );
									$res_nav2 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`-1  WHERE `nav_id`=?',[$find_nav['goo_navid']] );
									if ($res_nav1 && $res_nav2) {
										$res_nav = true;
									}else{
										$res_nav = false;
									}
								}else{
									$res_nav = true;
								}
								if ($find_goo_name == '' && $find_goo_number == '') {
									$all_code_res = DB::update('UPDATE `trace_company` SET `com_good`=? WHERE (`com_id`=?) ',[$find_com_good['com_good'],$find_com_good['com_id']]);
								}
							}
						}
						unlink($file_name);
						DB::commit();
			        });
					return ['code'=>200,'msg'=>'success','data'=>'导入成功'];
				}catch(Exception $e){ 
					unlink($file_name);
					DB::rollBack();
					return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		   		}
            	return json_encode($res,JSON_UNESCAPED_UNICODE);
        }else{
        	return json_encode(['code'=>500,'msg'=>'失败','data'=>'上传文件失败'],JSON_UNESCAPED_UNICODE);
        }
	}
    public function importd(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}

		$file=$request->file('file');
		if(empty($file)){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'上传文件不能为空'],JSON_UNESCAPED_UNICODE);
		}
		if($file->isValid()){
                $res=$this->UploadsFileImport($file,$user);
                $file_name = $res['data'];
                try{
		       		$data=[];
			       	Excel::load($file_name,function($reader) use ($user,$file_name,$request){
			       		// return $file_name;
			       		DB::beginTransaction();
			           	$reader = $reader->getSheet(0); 
						//获取表中的数据 
						$results = $reader->toArray();
						// var_dump($results);exit;
						$goods_list=[];
						if (count($results[0]) > 20) {
							echo json_encode(['code'=>500,'msg'=>'error','data'=>'最多输入20列']);exit;
						}
						$i="0";
						foreach ($results as $key => $value) {
							// if((mb_strlen($value[0]) <= 0) || (mb_strlen($value[0]) > 40))
							// {
		     //                    echo json_encode(['code'=>500,'msg'=>'error','data'=>'商品名称为1到40个之间的汉字']);exit;
							// }
							$arr[$i]=$value;
							$i=$i+1;
							if(!isset($arrcount)){
								$arrcount=count($value);
							}
						}
						// 查找该公司导入数量
						$find_com_good = DB::table('company')
							->where('com_id',$user['adm_cid'])
							->where('com_stase',1)
							->select('com_good','com_id')
							->first();
						$cid=sprintf("%04d", $user['adm_cid']);
						// var_dump($arr);exit;
						foreach($arr as $k=>$v){
							if($k!="0" && $k!="1" && $k!="2"){
								$l="0";
								$find_com_good['com_good'] = $find_com_good['com_good'] + 1;
								while($l<$arrcount){
									$array[$l]["key"]=$arr[0][$l];
									$array[$l]["value"]=(string)$arr[$k][$l];
									if ($array[$l]["value"] == '' && $array[$l]["key"]=='条形码号') {
										$xuhao=sprintf("%08d", $find_com_good['com_good']);
										$array[$l]["value"] = "N".$cid.$xuhao;
									}else{
										$array[$l]["value"]=(string)$arr[$k][$l];
									}
									$array[$l]["type"]="1";
									// $array[$l]["show"]="1";
									$array[$l]["show"]=(int)$arr[2][$l];
									if ($array[$l]["show"] == '') {
										$array[$l]["show"]="1";
									}else{
										$array[$l]["show"]=(int)$arr[2][$l];
									}
									$array[$l]["pri"]=(int)$arr[1][$l];
									if ($array[$l]["pri"] == '') {
										$array[$l]["pri"]=1;
									}else{
										$array[$l]["pri"]=(int)$arr[1][$l];
									}
									$l=$l+1;
								}
								$p="0";
								foreach($array as $kk=>$vv){
									if($vv['value']!=""){
										$newarray[$p]=$vv;
										$p=$p+1;
									}
								}
								$add_order_data['goo_name'] = $v[0];
								if ($v[0] == null) {
									echo json_encode(['code'=>500,'msg'=>'error','data'=>'商品名称不能为空']);exit;
								}
								$add_order_data['goo_number'] = $v[1];
								if ($add_order_data['goo_number'] == null) {
									$xuhao=sprintf("%08d", $find_com_good['com_good']);
									$add_order_data['goo_number'] = "N".$cid.$xuhao;
								}else{
									$add_order_data['goo_number'] = $v[1];
								}
								$add_order_data['goo_pro'] = json_encode($newarray);
								unset($array);unset($newarray);
								// 查询商品名称是否存在
								$find_goo_name = DB::table('goods')
									->where('del_type', 1)
									->where('goo_cid', $user['adm_cid'])
									->where('goo_name', $add_order_data['goo_name'])
									->select('goo_name','goo_id','goo_number')
									->first();
								$find_goo_number = DB::table('goods')
									->where('del_type', 1)
									->where('goo_cid', $user['adm_cid'])
									->where('goo_number', $add_order_data['goo_number'])
									->select('goo_name','goo_id','goo_number')
									->first();
								if ($find_goo_name == '' && $find_goo_number == '') {
									if (!$request->exists('goo_classifi') || !is_numeric($request->input('goo_classifi')) || !$request->exists('goo_navid') || !is_numeric($request->input('goo_navid'))) {
										echo json_encode(['code'=>500,'msg'=>'error','data'=>'请选择分类和导航']);exit;
									}
									$add_order_data['goo_classifi'] = $request['goo_classifi'];
									$add_order_data['goo_navid'] = $request['goo_navid'];
									$add_order_data['goo_cid']	= $user['adm_cid'];
									$add_order_data['goo_time'] = date('Y-m-d H:i:s');
									$res = DB::table('goods')->insertGetId($add_order_data);
									// 商品所属分类数量更改
									$res_class = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request['goo_classifi']]);
									// 商品所属导航数量更改
									$res_nav = DB::update('UPDATE `trace_navigation` SET `nav_total` = `nav_total`+1 WHERE `nav_id`=?',[$request['goo_navid']]);
								}
								if (!$request->exists('goo_classifi') || !is_numeric($request->input('goo_classifi')) || !$request->exists('goo_navid') || !is_numeric($request->input('goo_navid'))) {
									echo json_encode(['code'=>500,'msg'=>'error','data'=>'请选择分类和导航']);exit;
								}
								$res = DB::table('goods')
									->where('goo_id',$find_goo_name['goo_id'])
									->update([
										'goo_name'=>$add_order_data['goo_name'],
										'goo_number'=>$add_order_data['goo_number'],
										'goo_classifi' => $request['goo_classifi'],
										'goo_navid' => $request['goo_navid'],
										'goo_time' => date('Y-m-d H:i:s'),
										'goo_pro' => $add_order_data['goo_pro']
										]);
								// 判断是否更改商品所属分类
								$find_goo_classifi = DB::table('goods')
										->where('goo_cid', $user['adm_cid'])
										->where('goo_id', $find_goo_name['goo_id'])
										->first(['goo_classifi']);
								if ($request->input('goo_classifi') != $find_goo_classifi['goo_classifi']) {
									// 更改商品所属分类数量
									$res_class1 = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request->input('goo_classifi')] );
									$res_class2 = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`-1  WHERE `cla_id`=?',[$find_goo_classifi['goo_classifi']] );
									if ($res_class1 && $res_class2) {
										$res_class = true;
									}else{
										$res_class = false;
									}
								}else{
									$res_class = true;
								}
								// 判断是否更改商品所属导航
								$find_nav = DB::table('goods')
										->where('goo_cid', $user['adm_cid'])
										->where('goo_id', $find_goo_name['goo_id'])
										->first(['goo_navid']);
								if ($request->input('goo_navid') != $find_nav['goo_navid']) {
									// 更改商品所属导航数量
									$res_nav1 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`+1  WHERE `nav_id`=?',[$request->input('goo_navid')] );
									$res_nav2 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`-1  WHERE `nav_id`=?',[$find_nav['goo_navid']] );
									if ($res_nav1 && $res_nav2) {
										$res_nav = true;
									}else{
										$res_nav = false;
									}
								}else{
									$res_nav = true;
								}
							}
						if ($find_goo_name == '' && $find_goo_number == '') {
							$all_code_res = DB::update('UPDATE `trace_company` SET `com_good`=? WHERE (`com_id`=?) ',[$find_com_good['com_good'],$find_com_good['com_id']]);
						}
						}
						unlink($file_name);
						DB::commit();
			        });
					return ['code'=>200,'msg'=>'success','data'=>'导入成功'];
				}catch(Exception $e){ 
					unlink($file_name);
					DB::rollBack();
					return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		   		}
            	return json_encode($res,JSON_UNESCAPED_UNICODE);
        }else{
        	return json_encode(['code'=>500,'msg'=>'失败','data'=>'上传文件失败'],JSON_UNESCAPED_UNICODE);
        }
	}
	public function UploadsFileImport($file,$user){
		// 获取原文件名
		$file_name = $file->getClientOriginalName();
		// 获取原扩展名
		$ext=$file->getClientOriginalExtension();
		if(!in_array($ext,['xls','xlsx'])){
       		return ['code'=>500,'msg'=>'失败','data'=>'仅支持xls和xlsx结尾的excel文件'];
       	}
		// 获取文件类型
       	$type=$file->getMimeType();
        // 临时的决定路径
       	$realpath=$file->getRealPath();
       	//生成文件名
       	$filename="goods_excel_".date('Ymd').time().".".$ext;
       	// 第一个参数是设置 在  storage/app 下的那个文件夹，第二个是文件名；可以有第三个参数
       	$bool=$file->move(public_path('uploads/excel/goods_excel'),$filename);

       	$file_name=public_path('uploads/excel/goods_excel').'/'.$filename;
		return ['code'=>200,'msg'=>'成功','data'=>$file_name];
	}

    // 导出
    public function exports(Request $request){
    	if (empty($request->input('goo_name')) && empty($request->input('goo_number')) && empty($request->input('goo_classifi')) && empty($request->input('goo_sta')) && empty($request->input('nav_name'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入查询条件']);
    	}
    	// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		if (!empty($request->input('goo_sta'))) {
			if (!in_array($request->input('goo_sta'),array(1,2))) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
			}
		}

		// 查询分类信息
		$find_class = DB::table('goo_classifi')
			->where('cla_cid',$find_adm['adm_cid'])
			->where('cla_stase',1)
			->select('cla_id','cla_name','cla_parent_id')
			->get();
		$find_nav = DB::table('navigation')
			->where('nav_cid',$find_adm['adm_cid'])
			->where('nav_state',1)
			->where('nav_del',1)
			->get();
    	$data = $request->all();
		$list = DB::table('goods as a')
			->leftJoin('goo_classifi as b', 'a.goo_classifi', '=', 'b.cla_id')
			->leftjoin('navigation as c','a.goo_navid','=','c.nav_id')
			->where('del_type', 1)
			->where('goo_cid', $find_adm['adm_cid'])
			->where(function($query) use($data) {
				if (!empty($data['goo_name'] )) {
					$query->where('a.goo_name', 'like' , '%'.$data['goo_name'].'%' );
				}
			})
			->where(function($query) use($data) {
				if (!empty($data['goo_number'] )) {
					$query->where('a.goo_number', 'like' , '%'.$data['goo_number'].'%' );
				}
			})
			->where(function($query) use($data) {

				if (!empty($data['goo_classifi'] )) {
					$str=Db::table('goo_classifi')->where(['cla_id'=>$data['goo_classifi']])->select('cla_id','cla_parent_id')->first();
					if($str['cla_parent_id']==0){
						$str=Db::table('goo_classifi')->where(['cla_id'=>$data['goo_classifi']])->select('cla_id')->get();
						$id=array_column($str,'cla_id');
						$query->whereIn('a.goo_classifi',$id);
					}else{
						$query->where('a.goo_classifi', '=' ,$data['goo_classifi'] );
					}

				}
			})
			->where(function($query) use($data) {
				if (!empty($data['goo_sta'] )) {
					$query->where('a.goo_sta', '=' ,$data['goo_sta'] );
				}
			})
			->where(function($query) use($data) {
                if (!empty($data['nav_name'])) {
                    $query->where('c.nav_name', 'like' , '%'.$data['nav_name'].'%' );
                }
            })//导航id
			->select('goo_name','goo_number','goo_pro')
			->orderBy('goo_id','desc')
			->get();
		if ($list) {
			$pathName = storage_path()."/app/excel/";
			// 创建文件夹
		    if (!file_exists($pathName)) {
		        mkdir($pathName,0775,true);
		        chmod($pathName,0775);
		    }
			// 导出Excel表名
		    $excel_name = 'excel';
			$name = "storage/app/excel/".$excel_name.".xls";//数据库存储路径
			$filePath = storage_path()."/app/excel/".$excel_name.".xls";//文件存储路径
			$filePathStorage = "excel/".$excel_name.".xls";//laravel 操作路径
	        if (Storage::exists($filePathStorage)) {
	        	// 删除文件
	    		Storage::delete($filePathStorage);
	    	}
	    	foreach ($list as $key => $value) {
	        	$goo_pro = json_decode($value['goo_pro'],true);
	        	foreach ($goo_pro as $k=>$v) {
	        		$lists[$key][$v['key']]=$v['value'];
	        		if (!isset($array[$v['key']])) {
	        			$array[$v['key']]="1";
	        		}
	        	}
	        }
	        $strexport="";
	        foreach ($array as $k=>$v) {
	        	$strexport = $strexport.$k."\t";
	        }
	        $str="";
	        foreach ($lists as $k=>$v) {
	        	foreach ($array as $kk=>$vv) {
	        		if (isset($v[$kk])) {
						$str=$str.$v[$kk]."\t";
	        		} else {
	        			$str=$str."\t";
	        		}
	        		
	        	}
	        	$str=$str."\r";
	        }
		    $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport."\r");
		    file_put_contents($filePath, $strexport, FILE_APPEND);
		    $str = iconv("UTF-8", "GB2312//IGNORE", $str."\r");
		    file_put_contents($filePath, $str, FILE_APPEND);
			return response()->json(['code'=>200,'msg'=>'success','data'=>$name]);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'暂无数据']);
		}
    }

    // 复制商品
	public function duplication(Request $request)
	{
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		// 查询商品名称是否存在
		$goods = DB::table('goods')
				->where('del_type', 1)
				->where('goo_id',$request['goo_id'])
				->first();
		if(empty($goods)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'未找到该商品,复制失败']);
		}
		$nav_id=(int)$request->input('nav_id');
		$res1=DB::table('navigation')
				->where(['nav_id'=>$nav_id,'nav_del'=>1,'nav_state'=>1,'nav_cid'=>$find_adm['adm_cid']])
				->orWhere('nav_id',1)
				->select('nav_id')
				->first();
		if(empty($res1)){
			return response()->json(['code'=>500,'msg'=>'error','data'=>'导航错误']);
		}
		$day=date('Ymd');
		foreach ($request->input('info_name') as $key => $value) {
			if (empty($value) || empty($request->input('info_content')[$key]) || !in_array($request->input('info_show')[$key],array(1,2)) ) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'信息项存在空项']);
			}
			if ($value == '商品名称') {
				$goo_name = $request->input('info_content')[$key];
			}
			if ($value == '条形码号') {
				$goo_number = $request->input('info_content')[$key];
			}
			$goo_pro[$key]['key'] = $value;
			$goo_pro[$key]['show'] = $request->input('info_show')[$key];		//显示隐藏
			$goo_pro[$key]['type'] = $request->input('info_type')[$key];		//属性类型
			$goo_pro[$key]['pri'] = $request->input('info_pri')[$key];			//是否打印
			$url = $request->input('info_content')[$key];						//内容
			if (($goo_pro[$key]['type']==6 || $goo_pro[$key]['type']==7) && !empty($url)) {
				//判断是否是临时文件;
                if(strpos($url,'temporary')){
                    $end=explode('.',$url)[1];  //获取后缀
                    $file_name=$goo_pro[$key]['type']==6?'images':'videos';
                    $new_name='uploads/goods/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path=public_path().'/'.$new_name;  //新的文件地址
                    $old_url=public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if(!is_dir(dirname($new_path))){
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url=$new_name;
                }else{
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
			}
			$goo_pro[$key]['value']=$url;   
		}
		// 查询商品名称是否存在
		$find_goo_name = DB::table('goods')
				->where('del_type', 1)
				->where('goo_cid', $find_adm['adm_cid'])
				->where('goo_name', $goo_name)
				->first();
		if ($find_goo_name) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'商品名称已存在']);
		}
        // 查询条形码号是否存在
        $find_goo_number = DB::table('goods')
            ->where('del_type', 1)
            ->where('goo_cid', $find_adm['adm_cid'])
            ->where('goo_number', $goo_number)
            ->first();
        if ($find_goo_number) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'条形码号已存在']);
        }
		$time = date('Y-m-d H:i:s');
        $goo_picurl = '';
        if (!empty($request->input('goo_picurl'))) {
            // 上传图片
            $uploadImg = new CommonController;
            foreach ($request->input('goo_picurl') as $key => $value) {
                if (stristr($value, 'data:image')) {
                    $uploadPath = $uploadImg->uploadBase64Img($value);
                    if ($uploadPath) {
                        $goo_picurl .= $uploadPath.',';
                    } else {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                    }
                } else {
                    // 获取原图片路径
                    $path = explode(config('app.url'),$value);
                    $path_url = trim($path[1],'/');
                    $path_type = explode('.',$path_url);
                    // 新图片路径文件名
                    $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                    $pathName = "/image/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                    // 复制图片
                    $new_url = copy(base_path().'/'.$path_url, storage_path().$pathName);

                    // 返回路径
                    $filePath = "storage". $pathName;
                    $goo_picurl .= $filePath.',';
                }
            }
            $goo_picurl = trim($goo_picurl,',');
        }

        $goo_copy_data['goo_name'] = $goo_name;
        $goo_copy_data['goo_number'] = $goo_number;
        $goo_copy_data['goo_cid'] = $find_adm['adm_cid'];
        $goo_copy_data['goo_classifi'] = $request['goo_classifi'];
        $goo_copy_data['goo_picurl'] = $goo_picurl;
        $goo_copy_data['goo_pro'] = json_encode($goo_pro);
        $goo_copy_data['goo_sta'] = 1;
        $goo_copy_data['goo_time'] = $time;
        $goo_copy_data['goo_navid'] = $nav_id;
        $goo_copy_data['technician_integral'] = $request['technician_integral'] ? $request['technician_integral'] : '';
        $goo_copy_data['channel_integral'] = $request['channel_integral'] ? $request['channel_integral'] : '';
        $goo_copy_data['warranty_day'] = $request['warranty_day'] ? $request['warranty_day'] : '';
        $goo_copy_data['validity_period'] = $request['validity_period'] ? $request['validity_period'] : '';
		DB::beginTransaction();
		//复制商品
		$goo_res = DB::table('goods')->insertGetId($goo_copy_data);

		// 商品所属分类数量更改
		$res_class = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request->input('goo_classifi')] );
		// 商品所属导航数量更改
		$res_nav = DB::update('UPDATE `trace_navigation` SET `nav_total` = `nav_total`+1 WHERE `nav_id`=?',[$request->input('goo_navid')]);
		if ($goo_res && $res_class && $res_nav) {
			DB::commit();
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品列表','复制','复制“'.$goo_name.'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'复制成功']);
		} else {
			DB::rollBack();
			return response()->json(['code'=>500,'msg'=>'error','data'=>'复制失败']);
		}
	}
}