<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Contracts\Support\JsonableInterface;

use App\Http\Models\Coperationa;
/**
 * 品类管理
 */
class GooClassifiController extends Controller
{
	// 列表每页显示数据个数
	protected $show_count = 10;

	// 添加品类
	public function addgc(Request $request)
	{
		// 验证数据
		if ( empty(trim($request->input('cla_name')))|| !in_array($request->input('cla_stase'),array(1,2)) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		if (strlen(mb_convert_encoding($request->input('cla_name'),"UTF-8")) >20) {
			return response()->json(['code'=>500,'msg'=>'品类名称长度20字以内','data'=>'品类名称长度20字以内']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断品类名是否存在
		$find_class = DB::table('goo_classifi')
			->where('cla_cid',$find_adm['adm_cid'])
			->where('cla_name',$request->input('cla_name'))
			->select('cla_id')
			->first();
		if ($find_class) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'品类名称已存在，请重新添加']);
		}
		$class_id=(int)$request->input('class_id',0);
		$higher = DB::table('goo_classifi')->where('cla_id',$class_id)->value('cla_parent_ids');
		if ($higher) {
            $parent = explode(',',$higher);
            $cla_id = $parent[0];
        }else{
            $cla_id = $find_adm['adm_cid'];
        }
        $higher = $higher.$class_id.',';//隶属上级id串
        $cla_parent_ids = $higher;//隶属上级id串
		if($class_id!==0){
			$res=DB::table('goo_classifi')
			->where('cla_cid',$find_adm['adm_cid'])
			->where('cla_id',$class_id)
			->select('cla_id')
			->first();
			if(empty($res)){return response()->json(['code'=>200,'msg'=>'error','data'=>'没有您选择的顶级分类']);}
		}
		$time = date('Y-m-d H:i:s');
		$data = [
			$find_adm['adm_cid'], 
			$request->input('cla_name'), 
			$request->input('cla_stase'), 
			$time,
			$find_adm['adm_type'],
			$class_id,
			$cla_parent_ids,
			$request['cla_level'],
			$request['cla_insid'] ? $request['cla_insid'] : 0
		];
		$bool = DB::insert('insert into trace_goo_classifi (`cla_cid`, `cla_name`, `cla_stase`, `cla_time`,`cla_type`,`cla_parent_id`,`cla_parent_ids`,`cla_level`,`cla_insid`) values(?,?,?,?,?,?,?,?,?)',$data);
		if ($bool) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'品类列表','新增','新增“'.$request->input('cla_name').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
		}
	}
	// 获取列表数据,添加和编辑时使用
	public function class_list(Request $request){
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		$class_data = DB::table('goo_classifi as a')
				->leftjoin('industry as i','i.ins_id','=','a.cla_insid')
				->where('a.cla_cid', $find_adm['adm_cid'])
				->where('a.cla_stase', 1)
				->selectRaw('trace_a.cla_id,trace_a.cla_name,trace_a.cla_level,trace_a.cla_stase,trace_a.cla_total,trace_a.cla_parent_id,trace_a.cla_parent_ids,if(trace_b.cla_name is null,"顶级分类",trace_b.cla_name) as class_name,ins_id,ins_name,trace_a.cla_cid')
				->leftJoin('goo_classifi as b','a.cla_parent_id','=','b.cla_id')
				->orderBy('a.cla_id','desc')
				->get();
		// 获取行业列表
		$industry_data = DB::table('industry')
			->where('ins_cid',$find_adm['adm_cid'])
			->where('ins_stase',1)
			->select('ins_id','ins_name')
			->orderBy('ins_id','desc')
			->limit(10)
			->get();
		$code=['code'=>200,'msg'=>'success','data'=>$class_data,'industry_data'=>$industry_data];
		return response()->json($code);
	}
	// 编辑品类
	public function editgc(Request $request)
	{
		// 验证数据
		if ( empty($request->input('cla_id')) || !is_numeric($request->input('cla_id')) || empty(trim($request->input('cla_name')))|| !in_array($request->input('cla_stase'),array(1,2)) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断品类名是否存在
		$find_class = DB::table('goo_classifi')
			->where('cla_cid',$find_adm['adm_cid'])
			->where('cla_name',$request->input('cla_name'))
			->where('cla_id','<>',$request->input('cla_id'))
			->select('cla_id')
			->first();
		if ($find_class) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'品类名称已存在，请重新编辑']);
		}

		$class_id=(int)$request->input('class_id',0);//隶属上级
		$higher = DB::table('goo_classifi')->where('cla_id',$class_id)->value('cla_parent_ids');
		if ($higher) {
            $parent = explode(',',$higher);
            $cla_id = $parent[0];
        }else{
            $cla_id = $find_adm['adm_cid'];
        }
        $higher = $higher.$class_id.',';//隶属上级id串
        $cla_parent_ids = $higher;//隶属上级id串
		if($class_id!==0){
			$res=DB::table('goo_classifi')
			->where('cla_cid',$find_adm['adm_cid'])
			->where('cla_id',$class_id)
			->select('cla_id')
			->first();
			if(empty($res)){return response()->json(['code'=>200,'msg'=>'error','data'=>'没有您选择的顶级分类']);}
		}

		$time = date('Y-m-d H:i:s');
		$data = [
			$class_id,
			$cla_parent_ids,
			$request->input('cla_level'),
			$request->input('cla_name'), 
			$request->input('cla_stase'), 
			$request->input('cla_insid') ? $request->input('cla_insid') : 0,
			$request->input('cla_id'),
            $time
		];
		$bool = DB::table('goo_classifi')
            ->where('cla_id',$request['cla_id'])
            ->update([
                'cla_parent_id' => $class_id,
                'cla_parent_ids' => $cla_parent_ids,
                'cla_level' => $request['cla_level'],
                'cla_name' => $request['cla_name'],
                'cla_stase' => $request['cla_stase'],
                'cla_insid' => $request->input('cla_insid') ? $request->input('cla_insid') : 0,
                'cla_time' => $time
            ]);
        $res = $this->getLow($request['cla_id'],1);
		// $bool = DB::update('UPDATE `trace_goo_classifi` SET `cla_parent_id`=?,`cla_parent_ids`=?,`cla_level`=?,`cla_name`=? , `cla_stase`=? , `cla_insid`=?,`cla_time`=?  WHERE  `cla_id`=?',$data);
		if ($bool) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'品类列表','编辑','编辑“'.$request->input('cla_name').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入要修改的内容']);
		}
	}

	/**
	 * 获取下级分类
	 * @authors ldj
	 * @email  909490343@qq.com
	 * @date   2024-02-04
	 * @param  Request          $request [description]
	 * @return [type]                    [description]
	 */
	public function getClass(Request $request) {
		if (!isset($request['cla_id'])) {
			$request['cla_id'] = 0;
		}
		$data = DB::table('goo_classifi')
			->where('cla_id', '!=', $request['cla_id'])
			->where('cla_level', 1)
			->where('cla_stase', 1)
			->select('cla_id', 'cla_name', 'cla_level')
			->get();
		$list_data = $this->getlowData($data,$request['cla_id']);
		return response()->json(['code'=>200,'msg'=>'success','data'=>$list_data]);
	}

	function getlowData(&$data,$cla_id) {
		foreach ($data as $key => $value) {
			$new_data = DB::table('goo_classifi')
				->where('cla_id', '!=', $cla_id)
				->where('cla_parent_id', $value['cla_id'])
				->where('cla_stase', 1)
				->select('cla_id', 'cla_name', 'cla_level')
				->get();
			if ($new_data) {
				$data[$key]['children'] = $new_data;
				$res = $this->getlowData($data[$key]['children'],$cla_id);
			}
		}
		return $data;
	}

	function getLow($cla_id, $type) {
		$data = DB::table('goo_classifi')
			->where('cla_id', $cla_id)
			->first();
		$cla_level = $data['cla_level'] + 1;
		if ($cla_level > 5 && $type == 1) {
			return false;
		}
		if ($cla_level > 5 && $type == 2) {
			return false;
		}
		$find_low = DB::table('goo_classifi')
        	->where('cla_parent_id', $cla_id)
        	->get();//下级
        if ($find_low) {
        	foreach ($find_low as $key => $value) {
        		$update_res = DB::table('goo_classifi')
        			->where('cla_id', $value['cla_id'])
        			->update(['cla_level'=>$cla_level]);
        		$res = $this->getLow($value['cla_id'],2);
        		if (!$res) {
        			return $res;
        		}
	        }
        }
        return true;
	}

	// 删除品类
    public function delgc(Request $request)
    {
    	// 验证数据
		if (  empty($request->input('cla_id')) || !is_array($request->input('cla_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断删除个数
		if (count($request->input('cla_id')) > 1) {
			$find_class = DB::table('goo_classifi')->whereIn('cla_id', $request->input('cla_id'))->select('cla_name','cla_parent_id','cla_id','cla_total')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find_class = DB::table('goo_classifi')->where('cla_id', $request->input('cla_id'))->select('cla_name','cla_parent_id','cla_id','cla_total')->get();
		}

		if (empty($find_class)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前品类不存在或者已删除']);
		}
		// 判断品类下是否存在子品类
		$arr=array_column($find_class, 'cla_parent_id');
		if($arr != ''){

			$id=array_column($find_class,'cla_id');
			$data=DB::table('goo_classifi')->where('cla_parent_id',$id)->select('cla_name')->get();
			if($data) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'选中的品类下存在子级品类']);
			}

		}
		// 判断当前品类下是否添加商品
		$find_goods = DB::table('goods')
			->where('del_type',1)
			->where('goo_cid',$find_adm['adm_cid'])
			// ->where('goo_type',$find_adm['adm_type'])
			->$where_type('goo_classifi',$request->input('cla_id'))
			->select('goo_id')->first();
		if ($find_goods) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前品类已添加商品，无法删除']);
		}
		$res = DB::table('goo_classifi')
				->where('cla_cid', $find_adm['adm_cid'])
				->$where_type('cla_id', $request->input('cla_id'))
				->delete();

		if (!empty($res)) {
			$class_name = '';
			foreach ($find_class as $key => $value) {
				$class_name .= $value['cla_name'].',';
			}
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'品类列表','删除','删除“'.trim($class_name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'删除失败']);
		}
    }

    // 启用
    public function open_state(Request $request)
    {
    	// 验证数据
		if ( empty($request->input('cla_id')) || !is_array($request->input('cla_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断删除个数
		if (count($request->input('cla_id')) > 1) {
			$find_class = DB::table('goo_classifi')->whereIn('cla_id', $request->input('cla_id'))->select('cla_name','cla_stase')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find_class = DB::table('goo_classifi')->where('cla_id', $request->input('cla_id'))->select('cla_name','cla_stase')->get();
		}

		if (empty($find_class)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前品类不存在或者已删除']);
		}
		$class_name = '';
		$istype = false;
		foreach ($find_class as $key => $value) {
			if ($value['cla_stase'] != 1) {
				$istype = true;
			}
			$class_name .= $value['cla_name'].',';
		}

		if ($istype) {
			$result = DB::table('goo_classifi')
					->where('cla_cid', $find_adm['adm_cid'])
					->$where_type('cla_id', $request->input('cla_id'))
					->update(['cla_stase'=>1]);
        } else {
            $result = true;
        }

		if (!empty($result)) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'品类列表','启用','启用“'.trim($class_name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'启用成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'启用失败']);
		}
    }

    // 停用
    public function stop_state(Request $request)
    {
    	// 验证数据
		if ( empty($request->input('cla_id')) || !is_array($request->input('cla_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断删除个数
		if (count($request->input('cla_id')) > 1) {
			$find_class = DB::table('goo_classifi')->whereIn('cla_id', $request->input('cla_id'))->select('cla_name','cla_stase')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find_class = DB::table('goo_classifi')->where('cla_id', $request->input('cla_id'))->select('cla_name','cla_stase')->get();
		}

		if (empty($find_class)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前品类不存在或者已删除']);
		}
		$class_name = '';
		$istype = false;
		foreach ($find_class as $key => $value) {
			if ($value['cla_stase'] != 2) {
				$istype = true;
			}
			$class_name .= $value['cla_name'].',';
		}

		if ($istype) {
			$result = DB::table('goo_classifi')
					->where('cla_cid', $find_adm['adm_cid'])
					->$where_type('cla_id', $request->input('cla_id'))
					->update(['cla_stase'=>2]);
        } else {
            $result = true;
        }

		if (!empty($result)) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'品类列表','停用','停用“'.trim($class_name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'停用成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'停用失败']);
		}
    }
    // 列表查询
    public function index(Request $request)
    {
    	if (empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		
		if (!empty($request->input('cla_stase'))) {
			if (!in_array($request->input('cla_stase'),array(1,2))) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
			}
		}
		$data = $request->all();
		$list = DB::table('goo_classifi as a')
				->leftjoin('industry as i','i.ins_id','=','a.cla_insid')
				->where('a.cla_cid', $find_adm['adm_cid'])
				->where(function($query) use($data) {
					if (!empty($data['cla_stase'] )) {
						$query->where('a.cla_stase', '=' ,$data['cla_stase'] );
					}
				})
				->where(function($query) use($data) {
					if (!empty($data['cla_name'] )) {
						$query->where('a.cla_name', 'like' , '%'.$data['cla_name'].'%' );
					}
				})
				->where(function($query) use($data) {
					if (isset($data['goo_classifi'])) {
						if ($data['goo_classifi'] === '0') {
							$query->where('a.cla_parent_id', '=' ,0);
						} elseif (!empty($data['goo_classifi'] )) {
							$str=Db::table('goo_classifi')->where(['cla_id'=>$data['goo_classifi']])->select('cla_id','cla_parent_id')->first();
							if($str['cla_parent_id']==0){
								$str=Db::table('goo_classifi')->where(['cla_parent_id'=>$data['goo_classifi']])->select('cla_id')->get();
								$id=array_column($str,'cla_id');
								$query->whereIn('a.cla_id',$id);
							}else{
								$query->where('a.cla_parent_id', '=' ,$data['goo_classifi'] );
							}
						}
					}
				})
				->selectRaw('trace_a.cla_id,trace_a.cla_name,trace_a.cla_stase,trace_a.cla_level,trace_a.cla_total,trace_a.cla_parent_id,trace_a.cla_parent_ids,if(trace_b.cla_name is null,"顶级分类",trace_b.cla_name) as class_name,ins_name,ins_id,trace_a.cla_cid')
				->leftJoin('goo_classifi as b','a.cla_parent_id','=','b.cla_id')
				->orderBy('a.cla_id','desc')
				->paginate($this->show_count);
		if ($find_adm['adm_id'] == '1') {
			$cla_cid = DB::table('goo_classifi')->where('cla_cid',$find_adm['adm_cid'])->value('cla_cid');
		}
		$listData['cla_cid'] = 1;
		//递归处理品类
		// $find_class=$this->recursionDate();
		$res = DB::table('goods as g')
				->leftjoin('goo_classifi as gc','gc.cla_id','=','g.goo_classifi')
				->where('goo_sta',1)
				->where('del_type',1)
				->where('cla_stase',1)
				->where('goo_cid',$find_adm['adm_cid'])
				->select('goo_id','goo_name','goo_classifi','goo_code_percent')
				->get();
		$listData['current_page'] = $list->currentPage();
		$listData['total'] = $list->total();
		$listData['data'] = $list->items();
		$listData['res'] = $res;
		// $listData['find_class'] = $find_class;
		
		$listData['current_number'] = $this->show_count;
		$listData['last_page'] = $list->lastPage();
		$listData['code'] = 200;
		$listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
		return response()->json($listData);
    }

    public function recursionDate($parent_id = 0)
    {
        $rows = DB::table('goo_classifi')->where('cla_parent_id', $parent_id)->selectRaw('cla_id,cla_name,cla_stase,cla_level,cla_parent_id')->get();
        $arr = array();

        if (sizeof($rows) != 0){
            foreach ($rows as $key => $val){
                $val['children'] = $this->recursionDate($val['cla_id']);
                $arr[] = $val;
            }
            return $arr;
        }

    }
}