<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Models\Prevention\RegionModel;
use Illuminate\Support\Facades\DB;
use \Exception;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Crypt;
class DistributionAreaController extends Controller
{
    /**
     区域列表
     */
    public function index(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $page=(int)$request->input('page',1);
        $where['group_name'] = $request['group_name'];
        $where['chan_enterprise_name'] = $request['chan_enterprise_name'];
        $where['chan_name'] = $request['chan_name'];
        $where['chan_phone'] = $request['chan_phone'];
        $where['start'] = $request['start'];
        $obj=new RegionModel();
        $res=$obj->Region_List($user,$page,$where);
        $res['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        return response()->json($res);

    }

    // 添加区域
    public function adddis(Request $request)
    {
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $type=(int)$request->input('type',2);

        $obj=new RegionModel();
        if($type==2){
            $res=$obj->getBreed_Data($user,$token);
            return response()->json($res);
        }
        //区域名称
        $group['group_name']=$request->input('group_name',null);
        $provinces =$request->input('provinces',null);

        if(empty($group['group_name']) || empty($provinces)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数不能为空']);
        }

        $group['ent_cid']=$user['adm_cid'];
        $group['user_id']=$user['admin_id'];
        $group['time']=date('Y-m-d H:i:s');
        $group['region_id']=rand(10,99).time();
        $group['reg_canid'] = $request->input('reg_canid',null);
        $obj=new RegionModel();
        $res=$obj->Add_Region($group,$provinces,$user,$token);
        return response()->json($res);
    }

    // 编辑区域
    public function editdis(Request $request)
    {
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $type=(int)$request->input('type',2);
        $group_id=(int)$request->input('id',null);
        if(empty($group_id)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'id不能为空']);
        }
        $obj=new RegionModel();
        if($type==2){
            $res=$obj->Get_Edit_Region($user,$token,$group_id);
            return response()->json($res);
        }
        $group['id']=(int)$request->input('id',null);
        //区域名称
        $group['group_name']=$request->input('group_name',null);
        $provinces =$request->input('provinces',null);
        $group['update_time']=date('Y-m-d H:i:s');
        $group['reg_canid'] = $request->input('reg_canid',null);
        if(empty($group['group_name']) || empty($provinces)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数不能为空']);
        }
        $obj=new RegionModel();
        $res=$obj->Edit_Region($group,$provinces,$user,$token);
        return response()->json($res);
    }

    //地区数据  缓存
    public function regioncache(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $obj=new RegionModel();
        $letter=$request->input('letter',null);
        if(empty($letter)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'搜索数据不能为空']);
        }
        $name=$request->input('name',null);
        $obj=new RegionModel();
        $res=$obj->Cache_Region($letter,$name,$token);
        return response()->json($res); 
    }

    //移除缓存
    public function delcache(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $obj=new RegionModel();

        $name=$request->input('name',null);
        $res=$obj->Cache_Del($name,$token);
        return response()->json($res); 
    }

    // 停用
    public function disable(Request $request)
    {
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $id=$request->input('id',null);
        $obj=new RegionModel();
        $res=$obj->Region_State($id,$user,2);
        return response()->json($res);
    }

    // 启用
    public function enable(Request $request)
    {
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $id=$request->input('id',null);
        $obj=new RegionModel();
        $res=$obj->Region_State($id,$user,1);
        return response()->json($res);
        
    }

    // 删除
    public function deldis(Request $request)
    {
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $id=$request->input('id',null);
        $obj=new RegionModel();
        $res=$obj->Region_State($id,$user,3);
        return response()->json($res);
    }
}
