<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Contracts\Support\JsonableInterface;
use Storage;

use App\Http\Models\Coperationa;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\Verify\VerifyCodeController;
/**
 * 下载
 */
class DerivationController extends Controller
{
	// 列表每页显示数据个数
	protected $show_count = 10;
    // 列表查询
    public function index(Request $request)
    {

		$list = DB::table('derivation')
				->where('der_sta', 1)
				->select('der_id','der_table','der_gname','der_gnumber','der_content','der_cid','der_aid','der_number')
				->get();

		if (!empty($list)) {
			if ($list[0]['der_table']==0) {
				$pathName = storage_path()."/app/excel/";
				// 创建文件夹
			    if (!file_exists($pathName)) {
			        mkdir($pathName,0775,true);
			        chmod($pathName,0775);
			    }
				foreach ($list as $key => $value) {
					// 导出Excel表名
					$value['der_gname'] = $this->replaceSpecialChar($value['der_gname']);
					$name = "storage/app/excel/" . $value['der_gname'] . $value['der_number'] . ".xls";//数据库存储路径
					$filePath = storage_path()."/app/excel/" . $value['der_gname'] . $value['der_number'] . ".xls";//文件存储路径
					$filePathStorage = "excel/" . $value['der_gname'] . $value['der_number'] . ".xls";//laravel 操作路径
					
					// 查询分组表信息
			        $group_info = DB::table('group')
							->where('gro_cid', $value['der_cid'])->where('gro_number', $value['der_content'])
							->select('gro_numbertype')->first();
					$ident = "";
			        if ($group_info['gro_numbertype'] == 2) {
			            $ident = "n";
			        }
			        if (Storage::exists($filePathStorage)) {
			        	// 删除文件
			    		Storage::delete($filePathStorage);
			    	}
			        // 查询发码信息
			        $group = DB::table('group')
			                ->where('gro_cid',$value['der_cid'])->where('gro_number',$value['der_content'])
			                ->select('code_start','code_end','gro_gid','nums','gro_validation','gro_valleaver')->first();
					$istrue="1";
			        if($group['gro_validation'] == 2 AND $group['gro_valleaver'] <= 2) {
			        	$istrue="2";
			        }
			        if(!$group['gro_validation']) {
			        	$istrue="2";
					}
					if ($group['nums'] == 33) {
						$start = (int)substr($group['code_start'],22,-3);
						$yemo = trim(substr($group['code_start'], '0','22'));
						$end = (int)substr($group['code_end'],22,-3);
					}else if ($group['nums'] == 20) {
						$start = (int)substr($group['code_start'],9,-3);
						$yemo = trim(substr($group['code_start'], '0','9'));
						$end = (int)substr($group['code_end'],9,-3);
					} elseif ($group['nums'] == 11) {
						$start = (int)substr($group['code_start'],5);
						$yemo = trim(substr($group['code_start'],'0','5'));
						$end = (int)substr($group['code_end'],5);
					}
					if($istrue=="1"){
						if ($group) {
							$validation = DB::table('validation')
								->where('val_cid',$value['der_cid'])->where('val_codenumber',$value['der_content'])
								->select('val_nums','val_leaver','val_sta','val_end','val_rand')->first();
							if ($validation) {
								$vald_leaver = $validation['val_leaver'] - 4;
								$validation_data = DB::table('validation_data')
									->where('vald_leaver', $vald_leaver)
									->whereBetween('vald_number', [$validation['val_sta'],$validation['val_end']])
									->select('vald_rand')->get();
								if ($validation_data) {
									$str[1] = substr($validation['val_rand'], 0, 2);
									$str[2] = substr($validation['val_rand'], 2);
									foreach ($validation_data as $kk => $val_data) {
										$string[1] = substr($val_data['vald_rand'], 0, 2);
										$string[2] = substr($val_data['vald_rand'], 2, 1);
										$string[3] = substr($val_data['vald_rand'], 3);
										$valdarr[] = $string[1] . $str[1] . $string[2] . $str[2] . $string[3];
									}
								}
								$strexport = "二维码地址\t二维码号\t商品名称\t条形码号\t真伪序列号\r";
								$strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
								file_put_contents($filePath, $strexport);
								unset($strexport);
								$i = 0;
								for ($x=$start; $x<=$end; $x++) {
									if ($group['nums'] == '11') {
										$numbernums = 6 - strlen($x);
										$starts = $yemo . str_pad(strval(''), $numbernums, '0', STR_PAD_LEFT);
										$a = "$starts$x";
										$der_gname = empty($value['der_gname']) ? '' : $value['der_gname'];
										$der_gnumber = empty($value['der_gnumber']) ? '' : $value['der_gnumber'];
										$strexport = "http://hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\t" . $valdarr[$i] . "\r";
                                        // $strexport = "http://www.hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\t" . $valdarr[$i] . "\r";
										$strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
										file_put_contents($filePath, $strexport, FILE_APPEND);
										unset($strexport);
										unset($valdarr[$i]);
										$i++;
									} else {
                                        //需补充码位数
                                        $numbernums = 8 - strlen($x);
                                        $starts = $yemo . str_pad(strval(''), $numbernums, '0', STR_PAD_LEFT);
                                        $a = "$starts$x";
                                        //生成校验位
                                        $verify_code = VerifyCodeController::generateVerify($a, 3);
                                        if (!$verify_code) {
                                            return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
                                        } else {
                                            $a .= $verify_code;
                                        }
                                        $der_gname = empty($value['der_gname']) ? '' : $value['der_gname'];
                                        $der_gnumber = empty($value['der_gnumber']) ? '' : $value['der_gnumber'];
                                        // $strexport = config('app.url')."/sy.php?code=" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\t" . $valdarr[$i] . "\r";
                                        $strexport = "http://hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\t" . $valdarr[$i] . "\r";
                                        // $strexport = "http://www.hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\t" . $valdarr[$i] . "\r";
                                        $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
                                        file_put_contents($filePath, $strexport, FILE_APPEND);
                                        unset($strexport);
                                        unset($valdarr[$i]);
                                        $i++;
                                    }
								}
							}else{
								$strexport = "二维码地址\t二维码号\t商品名称\t条形码号\r";
								$strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
								file_put_contents($filePath, $strexport);
								unset($strexport);
								for ($x=$start; $x<=$end; $x++) {
									if ($group['nums'] == '11') {
										$numbernums = 6 - strlen($x);
										$starts = $yemo . str_pad(strval(''), $numbernums, '0', STR_PAD_LEFT);
										$a = "$starts$x";
										$der_gname = empty($value['der_gname']) ? '' : $value['der_gname'];
										$der_gnumber = empty($value['der_gnumber']) ? '' : $value['der_gnumber'];
										$strexport = "http://hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
                                        // $strexport = "http://www.hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
										$strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
										file_put_contents($filePath, $strexport, FILE_APPEND);
										unset($strexport);
									} else {
                                        //需补充码位数
                                        $numbernums = 8 - strlen($x);
                                        $starts = $yemo . str_pad(strval(''), $numbernums, '0', STR_PAD_LEFT);
                                        $a = "$starts$x";
                                        //生成校验位
                                        $verify_code = VerifyCodeController::generateVerify($a, 3);
                                        if (!$verify_code) {
                                            return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
                                        } else {
                                            $a .= $verify_code;
                                        }
                                        $der_gname = empty($value['der_gname']) ? '' : $value['der_gname'];
                                        $der_gnumber = empty($value['der_gnumber']) ? '' : $value['der_gnumber'];
                                        // $strexport = config('app.url')."/sy.php?code=" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
                                        $strexport = "http://hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
                                        // $strexport = "http://www.hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
                                        $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
                                        file_put_contents($filePath, $strexport, FILE_APPEND);
                                        unset($strexport);
                                    }
								}
							}
						}
					}else{
						if ($group) {
							$strexport = "二维码地址\t二维码号\t商品名称\t条形码号\r";
							$strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
							file_put_contents($filePath, $strexport);
							unset($strexport);
							for ($x=$start; $x<=$end; $x++) {
								if ($group['nums'] == '11') {
									$numbernums = 6 - strlen($x);
									$starts = $yemo . str_pad(strval(''), $numbernums, '0', STR_PAD_LEFT);
									$a = "$starts$x";
									$der_gname = empty($value['der_gname']) ? '' : $value['der_gname'];
									$der_gnumber = empty($value['der_gnumber']) ? '' : $value['der_gnumber'];
									$strexport = "http://hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
									// $strexport = "http://www.hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
									$strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
									file_put_contents($filePath, $strexport, FILE_APPEND);
									unset($strexport);
								} else {
									//需补充码位数
									$numbernums = 8 - strlen($x);
									$starts = $yemo . str_pad(strval(''), $numbernums, '0', STR_PAD_LEFT);
									$a = "$starts$x";
									//生成校验位
									$verify_code = VerifyCodeController::generateVerify($a, 3);
									if(!$verify_code) {
										return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
									}else {
										$a .= $verify_code;
									}
									$der_gname = empty($value['der_gname']) ? '' : $value['der_gname'];
									$der_gnumber = empty($value['der_gnumber']) ? '' : $value['der_gnumber'];
									$strexport = "http://hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
									// $strexport = "http://www.hmtn.bluearp.com/sy.php?" . $a . $ident . "&\t" . $a . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
									$strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
									file_put_contents($filePath, $strexport, FILE_APPEND);
									unset($strexport);
								}
							}
						}
					}
			        
					$file_res = Storage::exists($filePathStorage);
					// 判断文件是否存在
			    	if (Storage::exists($filePathStorage)) {
			    		DB::update('update trace_derivation set der_sta=3,der_url=? where der_id=?',[$name,$value['der_id']]);
			    		DB::update('update trace_group set gro_derid=3 where gro_number=?',[$value['der_content']]);
			    	}else{
			    		DB::update('update trace_derivation set  der_sta=2 where der_id=?',[$value['der_id']]);
			    		DB::update('update trace_group set gro_derid=2 where gro_number=?',[$value['der_content']]);
			    	}
				}

			}elseif($list[0]['der_table']!=0){
				$pathName = storage_path()."/app/excel/";
				// 创建文件夹
			    if (!file_exists($pathName)) {
			        mkdir($pathName,0775,true);
			        chmod($pathName,0775);
			    }
				foreach ($list as $key => $value) {
					// 导出Excel表名
					$value['der_gname'] = $this->replaceSpecialChar($value['der_gname']);
					$name = "storage/app/excel/" . $value['der_gname'] . $value['der_number'] . ".xls";//数据库存储路径
					$filePath = storage_path()."/app/excel/" . $value['der_gname'] . $value['der_number'] . ".xls";//文件存储路径
					$filePathStorage = "excel/" . $value['der_gname'] . $value['der_number'] . ".xls";//laravel 操作路径
					// 查询分组表信息
			        $group_info = DB::table('group')
							->where('gro_cid', $value['der_cid'])->where('gro_number', $value['der_content'])
							->select('gro_numbertype')->first();
					$ident = "";
			        if ($group_info['gro_numbertype'] == 2) {
			            $ident = "n";
			        }
			        if (Storage::exists($filePathStorage)) {
			        	// 删除文件
			    		Storage::delete($filePathStorage);
			    	}
			    	// 查询发码信息
			        $table_code = $value['der_table'].'_code';
			        $vtiger = DB::connection('mysql_two');
			        // $table_code_info = DB::table($table_code)
			        $table_code_info = $vtiger->table($table_code)
							->where('gco_cid', $value['der_cid'])->where('gco_group', $value['der_content'])
							->select('gco_number as number','gco_gid')->get();
			        if ($table_code_info) {
			            $validation = DB::table('validation')
							->where('val_cid', $value['der_cid'])->where('val_codenumber', $value['der_content'])
							->select('val_nums','val_leaver','val_sta','val_end','val_rand')->first();
						if ($validation) {
							$vald_leaver = $validation['val_leaver'] - 4;
			                $validation_data = DB::table('validation_data')
								->where('vald_leaver', $vald_leaver)
								->whereBetween('vald_number', [$validation['val_sta'],$validation['val_end']])
								->select('vald_rand')->get();
							if ($validation_data) {
								$str[1] = substr($validation['val_rand'], 0, 2);
			                    $str[2] = substr($validation['val_rand'], 2);
			                    foreach ($validation_data as $kk => $val_data) {
									$string[1] = substr($val_data['vald_rand'], 0, 2);
			                        $string[2] = substr($val_data['vald_rand'], 2, 1);
			                        $string[3] = substr($val_data['vald_rand'], 3);
			                        $valdarr[] = $string[1] . $str[1] . $string[2] . $str[2] . $string[3];
			                    }
							}
			                $strexport = "二维码地址\t二维码号\t商品名称\t商品编号\t真伪序列号\r";
			                $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
			               	file_put_contents($filePath, $strexport);
			                unset($strexport);
			                $i = 0;
			                foreach ($table_code_info as $k => $val) {
			                	$der_gname = empty($value['der_gname']) ? '' : $value['der_gname'];
			                	$der_gnumber = empty($value['der_gnumber']) ? '' : $value['der_gnumber'];
			                	$strexport = "http://hmtn.bluearp.com/sy.php?" . $val['number'] . $ident . "&\t" . $val['number'] . "&\t" . $der_gname . "\t" . $der_gnumber . "&\t" . $valdarr[$i] . "\r";
			                	// $strexport = "http://www.hmtn.bluearp.com/sy.php?" . $val['number'] . $ident . "&\t" . $val['number'] . "&\t" . $der_gname . "\t" . $der_gnumber . "&\t" . $valdarr[$i] . "\r";
			                    $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
			                    file_put_contents($filePath, $strexport, FILE_APPEND);
			                    unset($strexport);
			                    unset($valdarr[$i]);
			                    $i++;
			                }
						}else{
							$strexport = "二维码地址\t二维码号\t商品名称\t商品编号\r";
			                $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
			                file_put_contents($filePath, $strexport);
			                unset($strexport);
			                foreach ($table_code_info as $k => $val) {
			                	$der_gname = empty($value['der_gname']) ? '' : $value['der_gname'];
			                	$der_gnumber = empty($value['der_gnumber']) ? '' : $value['der_gnumber'];
			                	$strexport = "http://hmtn.bluearp.com/sy.php?" . $val['number'] . $ident . "&\t" . $val['number'] . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
			                	// $strexport = "http://www.hmtn.bluearp.com/sy.php?" . $val['number'] . $ident . "&\t" . $val['number'] . "&\t" . $der_gname . "\t" . $der_gnumber . "&\r";
			                    $strexport = iconv("UTF-8", "GB2312//IGNORE", $strexport);
			                    file_put_contents($filePath, $strexport, FILE_APPEND);
			                    unset($strexport);
			                }
						}
					}
			        
					$file_res = Storage::exists($filePathStorage);
					// 判断文件是否存在
			    	if (Storage::exists($filePathStorage)) {
			    		DB::update('update trace_derivation set der_sta=3,der_url=? where der_id=?',[$name,$value['der_id']]);
			    		DB::update('update trace_group set gro_derid=3 where gro_number=?',[$value['der_content']]);
			    	}else{
			    		DB::update('update trace_derivation set  der_sta=2 where der_id=?',[$value['der_id']]);
			    		DB::update('update trace_group set gro_derid=2 where gro_number=?',[$value['der_content']]);
			    	}
				}
			}
		}else{
			echo '成功';
		}
    }
    public function replaceSpecialChar($strParam){
	    $regex = "/\/|\~|\!|\@|\#|\\$|\%|\^|\&|\*|\(|\)|\_|\+|\{|\}|\:|\<|\>|\?|\[|\]|\,|\.|\/|\;|\'|\`|\-|\=|\\\|\|/";
	    return preg_replace($regex,"",$strParam);
	}
}