<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;
use Session;
use App\Http\Models\Coperationa;

class CoperationaController extends Controller
{

	// 列表每页显示数据个数
	protected $show_count = 10;

	public function index(Request $request)
    {
        $coper_info = $request->all();
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $rolemsg = Coperationa::getUserInfo($request->input('api_token'));

        if(!$rolemsg['adm_pre'])
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'请先登录']);
        }
        
        $data = DB::table('coperationa')
        ->where(function($query) use($rolemsg) {
			if ($rolemsg['adm_pre'] !== 1) {
				$query->where('cop_adminid',$rolemsg['adm_id']);
			}
		})
		->where(function($query) use($rolemsg) {
            if (!empty($rolemsg['cop_channelid'] )) {
                $query->where('cop_channelid', '=' , $rolemsg['cop_channelid']);
            }
        })
        ->where(function($query) use($coper_info) {
			if (!empty($coper_info['cop_admin'] )) {
				$query->where('cop_admin', 'like' , '%'.$coper_info['cop_admin'].'%' );
			}
		})
		->where(function($query) use($coper_info) {
			if (!empty($coper_info['cop_mode'] )) {
				$query->where('cop_mode', 'like' , '%'.$coper_info['cop_mode'].'%' );
			}
		})
		->where(function($query) use($coper_info) {
			if (!empty($coper_info['cop_type'] )) {
				$query->where('cop_type', 'like' , '%'.$coper_info['cop_type'].'%' );
			}
		})
		->where(function($query) use($coper_info) {
			if (!empty($coper_info['cop_content'] )) {
				$query->where('cop_content', 'like' , '%'.$coper_info['cop_content'].'%' );
			}
		})
		->where(function($query) use($coper_info) {
			//如果选择开始时间并且选择结束时间
			if (!empty($coper_info['cop_createtime_range0']) && !empty($coper_info['cop_createtime_range1'])){
				$query->whereBetween('cop_createtime',[$coper_info['cop_createtime_range0'],$coper_info['cop_createtime_range1'].' 23:59:59']);
			}
			else{
				// 如果选择开始时间
				if (!empty($coper_info['cop_createtime_range0'])){
					$query->where('cop_createtime','>',$coper_info['cop_createtime_range0'].' 23:59:59');
				}else{
				// 如果选择结束时间
					if (!empty($coper_info['cop_createtime_range1'] )) {
						$query->where('cop_createtime','<',$coper_info['cop_createtime_range1'].' 23:59:59');
					}
				}
			}
		})
		->where('cop_cid',$rolemsg['adm_cid'])
        ->orderBy('cop_id','desc')
        ->select('cop_adminid','cop_ip','cop_mode','cop_type','cop_content','cop_createtime','cop_channelid')
        ->paginate($this->show_count);

        $data_info['current_page'] = $data->currentPage();  //当前页面页码
        $data_info['last_page'] = $data->lastPage();		//表示最后一页的页码
        $data_info['total'] = $data->total();				//总数据个数
        $data_info['current_number'] = $this->show_count;	//一页显示多少个
        $data_info['data'] = $data->items();				//返回数据
        // 动态获取操作人姓名
        if($data_info['data'])
        {
        	foreach($data_info['data'] as $k=>$v)
	        {
	            $adm_creator[] = $v['cop_adminid'];
	        }
	        $adm_creator = DB::table('admin')
	            ->whereIn('adm_id',$adm_creator)
	            ->select('adm_id','adm_name')
	            ->get();

	        foreach($data_info['data'] as $k=>$v)
	        {
	            foreach($adm_creator as $key=>$value)
	            {
	                if($v['cop_adminid'] == $adm_creator[$key]['adm_id'])
	                {
	                    $data_info['data'][$k]['cop_admin'] = $adm_creator[$key]['adm_name'];
	                }
	            }
	        }
        }
        if($data)
        {
        	return response()->json(['code'=> 200,'msg'=>'success','data'=>'操作列表获取成功','data_info'=>$data_info]);
        }else{
        	return response()->json(['code'=> 500,'msg'=>'error','data'=>'操作列表获取失败']);
        }
    }
	
}