<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Models\Coperationa;
use CoperationaAction;
use DB;
use Excel;
use Crypt;

class CompanyController extends Controller
{

    // 列表每页显示数据个数
    protected $show_count = 10;
    public function index(Request $request)
    {
        $input = $request->all();

        $platform = DB::table('company as c')
            ->leftjoin('admin as a', 'c.com_id', '=', 'a.adm_cid')
            ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'c.com_id')
            ->where(function ($query) use ($input) {
                if (!empty($input['com_name'])) {
                    $query->where('com_name', 'like', '%'.$input['com_name'].'%');
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['adm_name'])) {
                    $query->where('a.adm_name', 'like', '%'.$input['adm_name'].'%');
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['adm_mobile'])) {
                    $query->where('a.adm_mobile', '=', $input['adm_mobile']);
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['com_stase'])) {
                    $query->where('com_stase', '=', $input['com_stase']);
                }
            })
            ->where(function ($query) use ($input) {
                if (!empty($input['com_nature'])) {
                    $query->where('com_nature', '=', $input['com_nature']);
                }
            })
            ->where('com_id', '!=', '1')
            ->where('is_agent', 2)
            ->select('com_id', 'com_name', 'adm_name', 'adm_mobile', 'com_nature', 'com_stase', 'com_expiretime', 'info_audit', 'info_admin', 'adm_pre', 'adm_pas', 'adm_id', 'adm_acc')
            ->orderBy('com_id', 'desc')
            ->paginate($this->show_count);
        $data_info['current_page'] = $platform->currentPage();  //当前页面页码
        $data_info['last_page'] = $platform->lastPage();        //表示最后一页的页码
        $data_info['total'] = $platform->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $platform->items();                //返回数据
        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'], $request['pri_id']);
        if ($data_info) {
            return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>'客户列表获取成功', 'data_info'=>$data_info, 'button'=>$button]);
        } else {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'客户列表获取失败']);
        }
    }

    // 添加
    public function addcompany(Request $request)
    {
        // 验证数据
        if (!in_array($request->input('type'), array(1,2))) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        if ($request['type'] == 1) {
            // 组合权限
            $privileges = array();
            $role_data = DB::table('role')
                ->select('rol_id', 'rol_name')
                ->get();
            foreach ($role_data as $key => $val) {
                if ($val['rol_id'] == 1 || $val['rol_id'] == 3 || $val['rol_id'] == 4 || $val['rol_id'] == 5) {
                    $privileges[] = array('id'=>$val['rol_id'], 'name'=>$val['rol_name']);
                }
            }
            return response()->json(['code'=>200, 'msg'=>'success', 'prii'=>$privileges]);
        }

        $input = $request->only('com_name', 'adm_acc', 'adm_pas', 'adm_repas', 'adm_name', 'adm_mobile', 'com_expiretime', 'info_admin', 'com_nature', 'com_stase', 'info_person', 'info_mobile');
        //公司名称  登录账号  登录密码  确认密码    联系人     联系电话     到期时间         业务员       性质         状态
        // 验证字段
        if (empty($input['com_name']) || empty($input['adm_acc']) || empty($input['info_person']) || empty($input['info_mobile']) || empty($input['com_expiretime']) || empty($input['com_nature']) || empty($input['com_stase'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }
        // 验证密码
        $pwd_preg='/^[\w\_]{6,15}$/u';
        if (!preg_match($pwd_preg, $input['adm_pas'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'密码由6-15位数字或字母,或下划线组成！']);
        }
        if ($input['adm_pas'] !== $input['adm_repas']) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'两次密码输入不一致']);
        }

        // 验证手机号
        $phone_preg = "/^1[3456789]\d{9}$/";
        if (!preg_match($phone_preg, $input['info_mobile'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机号不合法！']);
        }
        // 判断手机号是否存在
        $phone = DB::table('admin')
            ->where('adm_mobile', $input['info_mobile'])
            ->first();
        if ($phone) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机号已存在']);
        }

        // 判断登录账号是否存在
        $adm_acc = DB::table('admin')
            ->where('adm_acc', $input['adm_acc'])
            ->select('adm_acc')
            ->first();
        if ($adm_acc) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'该登陆账号已存在']);
        }

        // 判断公司名称是否存在
        $com_name = DB::table('company')
            ->where('com_name', $input['com_name'])
            ->select('com_name')
            ->first();
        if ($com_name) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'公司名称重复']);
        }

        // 当前操作人
        $adm_creator = Coperationa::getUserInfo($request->input('api_token'));

        DB::beginTransaction();

        try {
            // 添加企业
            $com_data['com_name'] = $input['com_name']; //企业姓名
            $com_data['com_stase'] = $input['com_stase']; //企业状态
            $com_data['com_fid'] = $adm_creator['adm_cid']; //上级id
            $com_data['com_nature'] = $input['com_nature']; //企业姓名
            $com_data['com_expiretime'] = $input['com_expiretime']; //到期时间
            $com_id =  DB::table('company')->insertGetId($com_data);
            if (empty($com_id)) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'添加公司失敗']);
            }

            // 会员详情表
            $info_data['info_cid'] = $com_id; //所属企业
            $info_data['info_admin'] = $adm_creator['adm_name'];   //业务员
            $info_data['info_code_id'] = 60000 + $com_id; //所属企业
            $info_id = DB::table('company_info')->insert($info_data);
            if (empty($info_id)) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'添加公司详情失败']);
            }

            // 角色表
            $jurisdiction = "";
            $jur = explode(',', $request['adm_module']);
            foreach ($jur as $key => $val) {
                $rol_jur = DB::table('role')
                    ->where('rol_id', '=', $val)
                    ->select('rol_pri')
                    ->first();
                $jurisdiction .= $rol_jur['rol_pri'].",";
            }
            $role_data['rol_name'] = '总管理';//角色名
            $role_data['rol_pri'] = trim($jurisdiction, ',');//角色权限
            $role_data['rol_sta'] = 1;//状态1启用2停用
            $role_data['rol_cid'] = $com_id;//公司id
            $role_data['rol_creator'] = $adm_creator['adm_cid'];//创建人
            $role_data['rol_create_time'] = date("Y-m-d H:i:s");//添加时间
            $role_id = DB::table('role')->insertGetId($role_data);
            if (empty($role_id)) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'添加角色失败']);
            }

            // 生成密码
            $password = md5(md5(trim($input['adm_pas'].'admin')));
            // 添加所属公司账号
            $adm_data['adm_cid'] = $com_id;//公司id
            $adm_data['adm_name'] = $input['info_person'];//账号名称
            $adm_data['adm_leave'] = 1;//是否为总管理
            $adm_data['adm_pre'] = $role_id;//所属企业账号权限
            $adm_data['adm_pas'] = $password;//密码
            $adm_data['adm_acc'] = $input['adm_acc'];//登陆账号
            $adm_data['adm_mobile'] = $input['info_mobile'];//联系方式
            $adm_data['adm_endtime'] = $input['com_expiretime'];
            $adm_data['adm_nature'] = 2;//付费
            $adm_data['adm_flow'] = 3;//流程控制
            $adm_data['adm_payment_status'] = 2;//付款状态
            $adm_data['adm_module'] = $request['adm_module'];
            $adm_id = DB::table('admin')->insert($adm_data);
            if (empty($adm_id)) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'添加公司下所属账号失败']);
            }
            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error','data'=>'添加失败']);
        }
        Coperationa::add($adm_creator['adm_id'], $request->getClientIp(), '新增客户列表', '新增', '新增'.$input['com_name']);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'添加信息成功']);
    }

    // 启用权限
    public function startcompany(Request $request)
    {
        $com_data['com_stase'] = 1;
        $com_data['com_updatetime'] = date('Y-m-d H:i:s');

        $res = DB::table('company')
            ->whereIn('com_id', $request['com_id'])
            ->update($com_data);

        if ($res) {
            // 获取当前操作账号信息
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            // 查询员工信息
            $find_com = DB::table('company')
            ->whereIn('com_id', $request['com_id'])
            ->select('com_name')
            ->get();
            foreach ($find_com as $key => $value) {
                $com_name[] = $value['com_name'];
            }
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '客户列表', '启用', '客户：（'.implode(',', $com_name).'）启用成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'启用成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'启用失败']);
        }
    }

    // 停用权限
    public function stopcompany(Request $request)
    {
        $com_data['com_stase'] = 2;
        $com_data['com_updatetime'] = date('Y-m-d H:i:s');

        $res = DB::table('company')
            ->whereIn('com_id', $request['com_id'])
            ->update($com_data);

        if ($res) {
            // 获取当前操作账号信息
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            // 查询客户信息
            $find_com = DB::table('company')
            ->whereIn('com_id', $request['com_id'])
            ->select('com_name')
            ->get();
            foreach ($find_com as $key => $value) {
                $com_name[] = $value['com_name'];
            }
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '客户列表', '停用', '客户：（'.implode(',', $com_name).'）停用成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'停用成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'停用失败']);
        }
    }

    // 禁用权限
    public function disable(Request $request)
    {
        $com_data['com_stase'] = 3;
        $com_data['com_updatetime'] = date('Y-m-d H:i:s');

        $res = DB::table('company')
            ->whereIn('com_id', $request['com_id'])
            ->update($com_data);

        if ($res) {
            // 获取当前操作账号信息
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            // 查询客户信息
            $find_com = DB::table('company')
            ->whereIn('com_id', $request['com_id'])
            ->select('com_name')
            ->get();
            foreach ($find_com as $key => $value) {
                $com_name[] = $value['com_name'];
            }
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '客户列表', '禁用', '客户：（'.implode(',', $com_name).'）禁用成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'禁用成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'禁用失败']);
        }
    }

    // 添加角色
    public function getrole(Request $request)
    {
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(['code'=>500, 'msg'=>'error','data'=>'非法api_token']);
        }
        $role_info = $this->where_admid($request['api_token']);
        // 对象转数组
        $privileges_info = object_array(json_decode($role_info['role_auth']));
        //删除账号相关操作和客户列表相关功能
        foreach ($privileges_info as $key=>$value) {
            if ($value['pri_id'] == 37 || $value['pri_fid'] == 37) {
                unset($privileges_info[$key]);
            }
            if ($value['pri_id'] == 157 || $value['pri_fid'] == 157) {
                unset($privileges_info[$key]);
            }
        }
        // 对栏目列表进行分类处理
        $privileges_info = $this->category($privileges_info);

        if (!$privileges_info) {
            return response()->json(['code'=>500, 'msg'=>'error','data'=>'添加角色页获取失败']);
        }
        return response()->json(['code'=>200, 'msg'=>'success','data'=>'添加角色页获取成功','privileges_info'=>$privileges_info]);
    }

    // 客户列表编辑页面
    public function getcompanyedit(Request $request)
    {
        // 当前操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 验证数据
        if (!in_array($request->input('type'), array(1,2)) || !$request->exists('com_id') || !is_numeric($request->input('com_id'))) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        if ($request['type'] == 1) {
            // 获取当前要编辑的公司账号信息
            $companyinfo = DB::table('company as c')
                ->leftjoin('admin as a', 'a.adm_cid', '=', 'c.com_id')
                ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'c.com_id')
                ->where('com_id', $request['com_id'])
                ->where('adm_acc', $request['adm_acc'])
                ->select('com_id', 'com_name', 'adm_name', 'adm_acc', 'adm_mobile', 'adm_pre', 'com_stase', 'com_expiretime', 'info_admin', 'adm_module', 'com_nature')
                ->first();
            // 组合权限  展示用户的权限模块
            $privileges = array();
            $role_data = DB::table('role')->select('rol_id', 'rol_name')->get();
            // checked为1默认选中 check为2 默认不选中
            foreach ($role_data as $key => $val) {
                if ($val['rol_id'] == 1) {
                    // 判断是否默认选中
                    if (strstr($companyinfo['adm_module'], '1')) {
                        $privileges[] = array('id' => $val['rol_id'], 'name'=>$val['rol_name'], 'checked'=>"1");
                    } else {
                        $privileges[] = array('id' => $val['rol_id'], 'name'=>$val['rol_name'], 'checked'=>"2");
                    }
                }
                if ($val['rol_id'] == 3) {
                    // 判断是否默认选中
                    if (strstr($companyinfo['adm_module'], '3')) {
                        $privileges[] = array('id' => $val['rol_id'], 'name'=>$val['rol_name'], 'checked'=>'1');
                    } else {
                        $privileges[] = array('id' => $val['rol_id'], 'name'=>$val['rol_name'], 'checked'=>"2");
                    }
                }
                if ($val['rol_id'] == 4) {
                    // 判断是否默认选中
                    if (strstr($companyinfo['adm_module'], '4')) {
                        $privileges[] = array('id' => $val['rol_id'], 'name'=>$val['rol_name'], 'checked'=>'1');
                    } else {
                        $privileges[] = array('id' => $val['rol_id'], 'name'=>$val['rol_name'], 'checked'=>"2");
                    }
                }
                if ($val['rol_id'] == 5) {
                    // 判断是否默认选中
                    if (strstr($companyinfo['adm_module'], '5')) {
                        $privileges[] = array('id' => $val['rol_id'], 'name'=>$val['rol_name'], 'checked'=>'1');
                    } else {
                        $privileges[] = array('id' => $val['rol_id'], 'name'=>$val['rol_name'], 'checked'=>"2");
                    }
                }
            }
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'编辑角色页获取成功', 'companyinfo'=>$companyinfo, 'prii'=>$privileges]);
        }

        // 验证字段
        $input = $request->only('com_name', 'adm_acc', 'adm_pas', 'adm_repas', 'adm_name', 'adm_mobile', 'com_expiretime', 'info_admin', 'com_nature', 'com_stase', 'info_person', 'info_mobile');
        //公司名称  登录账号  登录密码  确认密码    联系人     联系电话     到期时间         业务员       性质         状态
        if (empty($input['adm_acc']) || empty($input['info_person']) || empty($input['info_mobile']) || empty($input['com_expiretime']) || empty($input['com_nature']) || empty($input['com_stase'])) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        // 验证手机号
        $phone_preg = "/^1[3456789]\d{9}$/";
        if (!preg_match($phone_preg, $input['info_mobile'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机号不合法！']);
        }

        // 判断账号是否存在
        $adm_acc = DB::table('admin')
            ->where('adm_id', $find_adm['adm_id'])
            ->where('adm_acc', $input['adm_acc'])
            ->select('adm_acc')
            ->first();
        if ($adm_acc) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'该登陆账号已存在']);
        }

        // 判断手机号是否存在
        $phone = DB::table('admin')
            ->where('adm_id', $find_adm['adm_id'])
            ->where('adm_mobile', $input['info_mobile'])
            ->select('adm_mobile')
            ->first();
        if ($phone) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机号已存在']);
        }

        // 判断公司名称是否存在
        $com_name = DB::table('company')
            ->where('com_id', $find_adm['adm_cid'])
            ->where('com_id', '<>', $request['com_id'])
            ->where('com_name', $input['com_name'])
            ->select('com_name')
            ->first();
        if ($com_name) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'公司名称重复']);
        }

        $jurisdiction = "";
        $jur = explode(',', $request['adm_module']);
        foreach ($jur as $key => $val) {
            $rol_jur = DB::table('role')->where('rol_id', '=', $val)->select('rol_pri')->first();
            $jurisdiction .= $rol_jur['rol_pri'].",";
        }
        $company = DB::table('company as c')
                        ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'c.com_id')
                        ->leftjoin('admin as a', 'a.adm_cid', '=', 'c.com_id')
                        ->leftjoin('role as r', 'r.rol_id', '=', 'a.adm_pre')
                        ->where('com_id', $request['com_id'])
                        ->where('adm_acc', $request['adm_acc'])
                        ->update([
                            'com_name'     => $request['com_name'],
                            'info_person'  => $request['info_person'],
                            'info_mobile'  => $request['info_mobile'],
                            'com_stase'    => $request['com_stase'],
                            'com_nature'   => $request['com_nature'],
                            'adm_module'   => $request['adm_module'],
                            'rol_pri'      => trim($jurisdiction, ','),
                            'adm_acc'      => $request['adm_acc'],
                            'adm_name'     => $request['info_person'],
                            'adm_nature'   => $request['com_nature'],
                            'com_expiretime'  => $request['com_expiretime'],
                            'adm_endtime'  => $request['com_expiretime'],
                            'com_updatetime' => date('Y-m-d H:i:s'),
                            'update_time' => date('Y-m-d H:i:s'),
                            'rol_update_time' => date('Y-m-d H:i:s')
                            ]);
        if ($company) {
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '客户列表', '编辑', '客户：('.$request['com_name'].')编辑成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'编辑成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'编辑失败']);
        }
    }

    // 修改公司名称
    public function docompanyedit(Request $request)
    {
        // 验证数据
        if (!in_array($request->input('type'), array(1,2)) || !$request->exists('com_id') || !is_numeric($request->input('com_id'))) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }
        if ($request['type'] == 1) {
            // 获取当前要编辑的公司账号信息
            $companyinfo = DB::table('company as c')
                ->where('com_id', $request['com_id'])
                ->select('com_id', 'com_name')
                ->first();
            return response()->json(['code'=>200, 'msg'=>'success','data'=>'编辑页获取成功', 'companyinfo'=>$companyinfo]);
        }

        // 验证数据，公司名称必填
        if (empty($request['com_name'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        // 判断公司名称是否存在
        $com_name = DB::table('company')
            ->where('com_id', '<>', $request['com_id'])
            ->where('com_name', $request['com_name'])
            ->select('com_name')
            ->first();
        if ($com_name) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'公司名称重复']);
        }

        $com_data['com_name'] = $request['com_name'];
        $com_data['com_updatetime'] = date('Y-m-d H:i:s');
                    
        $res = DB::table('company as c')
            ->leftjoin('admin as a', 'c.com_id', '=', 'a.adm_cid')
            ->where('c.com_id', $request['com_id'])
            ->update($com_data);

        if ($res) {
            // 获取当前操作账号信息
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '客户列表', '编辑', '客户：('.$request['com_name'].')编辑成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'编辑成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'编辑失败']);
        }
    }
    
    //数据分类
    public function category($arr)
    {
        $refer = array();
        $list = array();
        foreach ($arr as $k => $v) {
            $refer[$v['pri_id']] = & $arr[$k]; //创建主键的数组引用
        }
        foreach ($arr as $k => $v) {
            $fid = $v['pri_fid'];  //获取当前分类的父级id
            if ($fid == 0) {
                $list[] = & $arr[$k];  //顶级栏目
            } else {
                if (isset($refer[$fid])) {
                    $refer[$fid]['subcat'][] = & $arr[$k]; //如果存在父级栏目，则添加进父级栏目的子栏目数组中
                }
            }
        }
        return $list;
    }

    // 一键登录
    public function login(Request $request)
    {
        // 验证数据
        if (empty($request->input('adm_id')) || !is_numeric($request->input('adm_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 查询出要登录用户 登录临时表中数据
        $login_temporary = DB::table('login_temporary')->where('adm_id', $request['adm_id'])->select('last_login', 'adm_id', 'tem_tel')->first();

        // 查找此用户对应的角色权限
        $role_auth = $this->whererole($login_temporary['adm_id']);
        // 确认此账号跳转页面
        $default_url = $this->dispose_navigation($role_auth['role_auth']);
        // 修改出当前企业账号  登录临时表中的权限
        $settoken = DB::table('login_temporary')
                    ->where('adm_id', $find_adm['adm_id'])
                    ->update(['role_auth'=>json_encode($role_auth['role_auth']),
                              'auth_routes' =>json_encode($role_auth['routes_auth'])
                            ]);
        if ($settoken) {
            return response()->json(['code'=>200, 'msg'=>'success','data'=>'一键登录成功','api_token'=>$request->input('api_token'),'default_url'=>$default_url]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error','data'=>'一键登录失败']);
        }
    }

    // 获取该账号有哪些权限
    protected function whererole($adm_id)
    {
        // 获取该账号所拥有的角色
        $role_info = DB::table('admin as a')
                            ->leftjoin('role', 'role.rol_id', '=', 'a.adm_pre')
                            ->where('a.adm_id', '=', $adm_id)
                            ->select('role.rol_pri', 'a.adm_cid', 'a.adm_leave')
                            ->first();
        $rol_id = explode(',', $role_info['rol_pri']);
        // 取得当前角色所拥有的权限
        $privileges = DB::table('privileges')
                            ->select('pri_id', 'pri_fid', 'pri_funname', 'pri_acna', 'pri_funna', 'tit_pic', 'pri_type')
                            ->whereIn('privileges.pri_id', $rol_id)
                            ->get();
        // 去除可操作的相关权限 pri_type==3时
        foreach ($privileges as $key=>$value) {
            if ($value['pri_type'] == 3) {
                unset($privileges[$key]);
            }
        }
        $privileges = array_values($privileges);
        foreach ($privileges as $key=>$value) {
            // 权限路由
            $privileges_info['routes_auth'][] = 'App\Http\Controllers\\'.$value['pri_acna'].'Controller'.'@'.$value['pri_funna'].',';
        }
        // 角色权限
        $privileges_info['role_auth'] = $privileges;
        return $privileges_info;
    }

    // 获取默认跳转路径
    public function dispose_navigation($arr)
    {
        foreach ($arr as $k => $v) {
            if ($v['pri_id'] == 1) {
                $default_url = $v['pri_acna'];
                return $default_url;
            }
            if ($v['pri_fid'] == 0) {
                $list[] = $v;  //顶级栏目
            }
        }
        foreach ($arr as $key=>$v) {
            if ($v['pri_fid'] == $list[0]['pri_id']) {
                $pri_acna = $v['pri_acna'].$v['pri_funna'];
                break;
            }
        }
        $default_url = $list[0]['pri_acna'].'/'.$pri_acna;
        return $default_url;
    }

    public function where_admid($api_token)
    {
        try {
            $api_token = Crypt::decrypt($api_token);
        } catch (\Exception $e) {
            return response()->json(['code'=>500, 'msg'=>'error','data'=>'非法api_token']);
        }
        $adm_id = DB::table('login_temporary')
                            ->where('api_token', '=', $api_token)
                            ->select('adm_id', 'role_auth')
                            ->first();
        return $adm_id;
    }
}
