<?php

namespace App\Http\Controllers;


/**
 * 公共方法
 */
class CommonController extends Controller
{
	/**
	 * [uploadBase64Img 上传base64图片]
	 * @param  [type] $stream [base64数据]
	 * @param  string $folder [文件夹]
	 * @return [type]         [上传成功返回图片路径，失败返回false]
	 */
	public function uploadBase64Img($stream)
	{
	    if(stristr($stream,'data:image')){
	        $stream  = $stream;
	    }else{
	        $stream="data:image/png;base64,".$stream;
	    }
	    //获取扩展名和文件名
	    if (preg_match('/(?<=\/)[^\/]+(?=\;)/', $stream, $pregR)) $streamFileType = '.' . $pregR[0];

	    $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
	    // $pathName = "/public/image/" ;
	    $pathName = storage_path()."/image/";//获取上传图片路径
	    // 创建文件夹
	    if (!file_exists($pathName)) {
	        mkdir($pathName,0775,true);
	        chmod($pathName,0775);
	    }
	    $streamFilename = $pathName . $streamFileRand . $streamFileType;//上传到服务器图片路径

	    //处理base64文本，用正则把第一个base64,之前的部分砍掉
	    preg_match('/(?<=base64,)[\S|\s]+/', $stream, $streamForW);
	    if (file_put_contents($streamFilename, base64_decode($streamForW[0])) === false) {
	        return false;
	    } else {
	    	// 返回路径
	        $filePath = "storage/image/". $streamFileRand . $streamFileType;
	        return $filePath;
	    }
	}

}

