<?php

namespace App\Http\Controllers\Channels;

use App\Http\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use Session;
use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\Channels\VerifyChannelsController;

class ChannelsListController extends Controller
{

    // 列表每页显示数据个数
    protected $show_count = 10;
    // 渠道列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyChannelsController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $userinfo = DB::table('channels as a')
                        ->leftJoin('channels_label as b', 'b.label_id', '=', 'a.chan_label')
                        ->leftJoin('channels as c', 'c.chan_id', '=', 'a.chan_parent_id')
                        ->where('a.chan_cid',$find_adm['adm_cid'])
                        ->where(function($query) use($find_adm) {
                            if ($find_adm['adm_chan_id'] > 0) {
                                $query->where('a.chan_parent_id', $find_adm['adm_chan_id']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['chan_enterprise_name'])) {
                                $query->where('a.chan_enterprise_name', 'like' , '%'.$search_data['chan_enterprise_name'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            // 隶属渠道商
                            if (!empty($search_data['chan_parent_id'])) {
                                $query->where('c.chan_enterprise_name', 'like' , '%'.$search_data['chan_parent_id'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['chan_name'])) {
                                $query->where('a.chan_name', 'like' , '%'.$search_data['chan_name'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['chan_phone'])) {
                                $query->where('a.chan_phone', 'like' , '%'.$search_data['chan_phone'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['chan_label'])) {
                                $query->where('a.chan_label', $search_data['chan_label']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['chan_state'])) {
                                $query->where('a.chan_state', $search_data['chan_state']);
                            }
                        })
                        ->orWhere('a.chan_id',$find_adm['adm_chan_id'])
                        ->select('a.chan_id','c.chan_enterprise_name as parent_enterprise_name','b.label_name','a.chan_enterprise_name','a.chan_name','a.chan_phone','a.chan_address','a.chan_state','a.chan_integral','a.chan_addtime')
                        ->orderBy('a.chan_id','desc')
                        ->paginate($this->show_count);

        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
        $data_info['total'] = $userinfo->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $userinfo->items();                //返回数据

        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);

        if($data_info) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 获取渠道标签
    public function getLabel(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $search_data = $request->all();
        $find_label = DB::table('channels_label')
                        ->where('label_cid',$find_adm['adm_cid'])
                        ->where('label_state',1)
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['label_name'])) {
                                $query->where('label_name', 'like' , '%'.$search_data['label_name'].'%' );
                            }
                        })
                        ->select('label_id','label_name')
                        ->orderBy('label_id','desc')
                        ->limit(10)
                        ->get();
        if($find_label) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$find_label]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 新增渠道商
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyChannelsController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 判断渠道商是否存在
        $enterprise_name = DB::table('channels')->
                    where('chan_cid',$adm_info['adm_cid'])->
                    where('chan_enterprise_name',$request['chan_enterprise_name'])->first();
        if ($enterprise_name) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'渠道商名称已存在']);
        }
        // 判断手机号是否存在
        $admin = DB::table('admin');
        $phone = $admin->where('adm_mobile',$request['chan_phone'])->first();
        if ($phone) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'手机号已存在']);
        }

        DB::beginTransaction();
        $channeles_add_data = [
                'chan_cid'=>$adm_info['adm_cid'],
                'chan_parent_id'=>$adm_info['adm_chan_id'],
                'chan_enterprise_name'=>$request['chan_enterprise_name'],
                'chan_name'=>$request['chan_name'],
                'chan_phone'=>$request['chan_phone'],
                'chan_label'=>$request['chan_label'] ? $request['chan_label'] : 0,
                'chan_address'=>$request['chan_address']
            ];
        // 新增渠道商
        $chan_id =  DB::table('channels')->insertGetId($channeles_add_data);

        // 新增渠道商总管理权限
        $role_add_data = [
                'rol_name'=>'总管理',
                // 'rol_pri'=>'37,38,39,40,41,42,43,48,49,50,51,52,99,166,167,168,169,170,201,203,239,240,241,242,243,258,250,36,165,204,249,259,261,262,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315',
                'rol_pri'=>'37,38,39,40,41,42,43,48,49,50,51,52,99,166,167,168,169,170,201,203,239,240,241,242,243,258,250,36,165,204,249,259,261,262,287,288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,253,254,255,270,271',
                'rol_creator'=>$adm_info['adm_id'],
                'rol_cid'=>$adm_info['adm_cid'],
                'rol_chan_id'=>$chan_id,
                'rol_create_time'=>date('Y-m-d H:i:s')
            ];
        $rol_id = DB::table('role')->insertGetId($role_add_data);

        // 新增渠道商账号
        $admin_add_data = [
                'adm_cid'=>$adm_info['adm_cid'],
                'adm_chan_id'=>$chan_id,
                'adm_chan_type'=>1,
                'adm_name'=>$request['chan_name'],
                'adm_acc'=>$request['chan_phone'],
                'adm_mobile'=>$request['chan_phone'],
                'adm_payment_status'=>2,
                'adm_flow'=>3,
                'adm_nature'=>2,
                'adm_pas'=>md5(md5(trim('123456'.'admin'))),
                'adm_pre'=>$rol_id
        ];
        $adm_id =  DB::table('admin')->insertGetId($admin_add_data);
        
        // 渠道标签下属渠道商数量
        if ($request['chan_label']) {
            $label_res = DB::table('channels_label')->where('label_id', $request['chan_label'])->increment('label_total');
        }else{
            $label_res = true;
        }

        if ($chan_id && $rol_id && $adm_id && $label_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道列表','新增','新增渠道商：'.$request['label_name'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'新增渠道商成功']);
        }else{
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'新增渠道商失败']);
        }
    }

    // 编辑渠道商
    public function edit(Request $request)
    {
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 验证数据
        $verify_data = new VerifyChannelsController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 判断渠道商是否存在
        $enterprise_name = DB::table('channels')
                ->where('chan_cid',$adm_info['adm_cid'])
                ->where('chan_id','<>',$request['chan_id'])
                ->where('chan_enterprise_name',$request['chan_enterprise_name'])->first();
        if ($enterprise_name) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'渠道商名称已存在']);
        }

        // 判断手机号是否存在
        $phone = DB::table('admin')
                ->where('adm_id',$adm_info['adm_id'])
                ->where('adm_mobile',$request['chan_phone'])
                ->first();
        if ($phone) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'手机号已存在']);
        }

        // 查询原来渠道商的手机号
        $old_channels = DB::table('channels')->where('chan_id',$request['chan_id'])->select('chan_phone','chan_label')->first();

        DB::beginTransaction();
        $channeles_edit_data = [
                'chan_enterprise_name'=>$request['chan_enterprise_name'],
                'chan_name'=>$request['chan_name'],
                'chan_phone'=>$request['chan_phone'],
                'chan_label'=>$request['chan_label'] ? $request['chan_label'] : 0,
                'chan_address'=>$request['chan_address'],
                'chan_updatetime'=>date('Y-m-d H:i:s')
            ];
        // 编辑渠道商
        $chan_id =  DB::table('channels')->where('chan_id',$request['chan_id'])->update($channeles_edit_data);

        if ($old_channels['chan_label']) {
            // 原来渠道标签下属渠道商数量减少
            $old_label_res = DB::table('channels_label')->where('label_id', $old_channels['chan_label'])->decrement('label_total');
        }else{
            $old_label_res = true;
        }

        if ($request['chan_label']) {
            // 新的渠道标签下属渠道商数量增加
            $new_label_res = DB::table('channels_label')->where('label_id', $request['chan_label'])->increment('label_total');
        }else{
            $new_label_res = true;
        }

        // 渠道商账号
        $admin_edit_data = [
                'adm_name'=>$request['chan_name'],
                'adm_acc'=>$request['chan_phone'],
                'adm_mobile'=>$request['chan_phone'],
                'update_time'=>date('Y-m-d H:i:s')
        ];
        $adm_id =  DB::table('admin')->where('adm_mobile',$old_channels['chan_phone'])->update($admin_edit_data);

        if ($chan_id && $adm_id && $old_label_res && $new_label_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道列表','编辑','编辑渠道商：'.$request['label_name'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑渠道商成功']);
        }else{
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑渠道商失败']);
        }
    }

    // 启用
    public function start(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyChannelsController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 查询手机号
        $chan_data = DB::table('channels')->whereIn('chan_id',$request['chan_id'])->select('chan_phone')->get();
        foreach ($chan_data as $key => $value) {
            $phone[] = $value['chan_phone'];
        }

        DB::beginTransaction();
        // 渠道商启用
        $update_data['chan_state'] = 1;//状态:1启用2停用
        $update_data['chan_updatetime'] = date('Y-m-d H:i:s');
        $chan_res = DB::table('channels')->whereIn('chan_id',$request['chan_id'])->update($update_data);

        // 账号启用
        $adm_save_data['adm_stase'] = 1;
        $adm_save_data['update_time'] = date('Y-m-d H:i:s');
        $adm_res = DB::table('admin')->whereIn('adm_mobile',$phone)->update($adm_save_data);

        if($chan_res && $adm_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道列表','启用','启用('.implode(',', $phone).')账号成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'启用成功']);
        }else{
            DB::rollback();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'启用失败']);
        }
    }

    // 停用
    public function stop(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyChannelsController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 查询手机号
        $label_data = DB::table('channels')->whereIn('chan_id',$request['chan_id'])->select('chan_phone')->get();
        foreach ($label_data as $key => $value) {
            $phone[] = $value['chan_phone'];
        }
        
        DB::beginTransaction();
        // 渠道商停用
        $update_data['chan_state'] = 2;//状态:1启用2停用
        $update_data['chan_updatetime'] = date('Y-m-d H:i:s');
        $chan_res = DB::table('channels')->whereIn('chan_id',$request['chan_id'])->update($update_data);

        // 账号停用
        $adm_save_data['adm_stase'] = 2;
        $adm_save_data['update_time'] = date('Y-m-d H:i:s');
        $adm_res = DB::table('admin')->whereIn('adm_mobile',$phone)->update($adm_save_data);

        if($chan_res && $adm_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道列表','停用','停用('.implode(',', $phone).')账号成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'停用成功']);
        }else{
            DB::rollback();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'停用失败']);
        }
    }

    // 重置账号密码
    public function resetPassword(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyChannelsController;
        $error_message = $verify_data->resetPasswordValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        $chan_data = DB::table('channels')->where('chan_id',$request['chan_id'])->select('chan_phone')->first();

        // 重置密码
        $adm_save_data['adm_pas'] = md5(md5(trim('123456'.'admin')));
        $adm_save_data['update_time'] = date('Y-m-d H:i:s');
        $adm_res = DB::table('admin')->where('adm_mobile',$chan_data['chan_phone'])->update($adm_save_data);

        if($adm_res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道列表','重置密码',$chan_data['chan_phone'].'账号重置成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'重置成功']);
        }else{
            DB::rollback();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'重置失败']);
        }
    }

    // 加积分
    public function addIntegral(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyChannelsController;
        $error_message = $verify_data->integralValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 查询渠道商信息
        $chan_data = DB::table('channels as a')
                    ->leftJoin('admin as b', 'b.adm_mobile', '=', 'a.chan_phone')
                    ->where('chan_id',$request['chan_id'])
                    ->select('b.adm_id','a.chan_cid','a.chan_name','a.chan_phone','a.chan_integral','a.chan_id')->first();

        // 剩余积分
        $remain_integral = $chan_data['chan_integral'] + $request['integral_number'];

        DB::beginTransaction();
        // 渠道商积分
        $update_data['chan_integral'] = $remain_integral;
        $update_data['chan_updatetime'] = date('Y-m-d H:i:s');
        $chan_res =  DB::table('channels')->where('chan_id',$request['chan_id'])->update($update_data);

        // 添加积分操作记录
        $integral_data = [
                'inte_cid'=>$chan_data['chan_cid'],
                'inte_chan_id'=>$request['chan_id'],
                'inte_userid'=>$chan_data['chan_id'],
                'inte_user_phone'=>$chan_data['chan_phone'],
                'inte_user_name'=>$chan_data['chan_name'],
                'inte_state'=>1,//1增加积分2消耗积分
                'inte_integral_number'=>$request['integral_number'],
                'inte_content'=>$request['content'],
                'inte_type'=>1,//1渠道商积分2技师积分
                'inte_remain_integral'=>$remain_integral,
                'inte_operation_name'=>$adm_info['adm_name'],
                'inte_operation_id'=>$adm_info['adm_id']
            ];
        $inte_res =  DB::table('integral_record')->insert($integral_data);

        if($chan_res && $inte_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道列表','加积分', $chan_data['chan_phone'].'账号加'.$request['integral_number'].'积分成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'加积分成功']);
        }else{
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'加积分失败']);
        }
    }

    // 积分兑换
    public function reduceIntegral(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyChannelsController;
        $error_message = $verify_data->integralValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        if ($request['type'] == 1){
            $forminfo = $request->all();
            //兑换物品
            $foritems = DB::table('for_items')
                ->where(['fori_cid'=>$adm_info['adm_cid'],'fori_state'=>2])
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['fori_item_name'] )) {
                        $query->where('fori_item_name', 'like' , '%'.$forminfo['fori_item_name'].'%' );
                    }
                })
                ->get(['fori_id','fori_item_name','fori_integral_number','fori_number','fori_remain_integral']);
            return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$foritems]);
        }
        // 查询渠道商信息
        $chan_data = DB::table('channels as a')
                    ->leftJoin('admin as b', 'b.adm_mobile', '=', 'a.chan_phone')
                    ->where('chan_id',$request['chan_id'])
                    ->select('b.adm_id','a.chan_cid','a.chan_name','a.chan_phone','a.chan_integral','chan_id')->first();
        // 剩余积分
        $forr = DB::table('for_items')
            ->where(['fori_id'=>$request['fori_id']])
            ->first(['fori_id','fori_item_name','fori_integral_number','fori_number','fori_remain_integral']);
        $remain_integral = $chan_data['chan_integral'] - $forr['fori_integral_number'];
        if ($remain_integral<0) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'消耗积分值超过剩余积分值']);
        }

        DB::beginTransaction();
        // 渠道商积分
        // $update_data['chan_integral'] = $remain_integral;
        $update_data['chan_updatetime'] = date('Y-m-d H:i:s');
        $chan_res =  DB::table('channels')->where('chan_id',$request['chan_id'])->update($update_data);
        //物品数量减少
        $update_dates['fori_remain_integral'] = $forr['fori_remain_integral'] - 1;
        $update_dates['fori_updatetime'] = date('Y-m-d H:i:s');
        $fori_res = DB::table('for_items')->where(['fori_id'=>$request['fori_id']])->update($update_dates);
        // 添加积分操作记录
        $integral_data = [
                'inte_cid'=>$chan_data['chan_cid'],
                'inte_chan_id'=>$request['chan_id'],
                'inte_userid'=>$chan_data['adm_id'],
                'inte_user_phone'=>$chan_data['chan_phone'],
                'inte_user_name'=>$chan_data['chan_name'],
                'inte_state'=>2,//1增加积分2消耗积分
                'inte_integral_number'=>'-'.$forr['fori_integral_number'],
                'inte_content'=>'渠道商兑换['.$forr['fori_item_name'].']减少积分',
                'inte_type'=>1,//1渠道商积分2技师积分
                // 'inte_remain_integral'=>$remain_integral,
                'inte_remain_integral'=>$chan_data['chan_integral'],
                'inte_operation_name'=>$adm_info['adm_name'],
                'inte_operation_id'=>$adm_info['adm_id'],
                'inte_audit_state'=>1,  //状态1待审核2通过3驳回
                'inte_fori_id'=>$forr['fori_id'],   //物品id
            ];
        $inte_res =  DB::table('integral_record')->insertGetId($integral_data);

        // 添加兑换记录
        $aure_data = [
                'aure_cid'=>$chan_data['chan_cid'], //公司id
                'aure_chan_id'=>$chan_data['chan_id'], //渠道id
                'aure_userid'=>$chan_data['adm_id'], //用户id
                'aure_user_phone'=>$chan_data['chan_phone'],    //联系电话
                'aure_user_name'=>$chan_data['chan_name'],  //姓名
                'aure_integral_number'=>'-'.$forr['fori_integral_number'],  //消耗积分数量
                'aure_content'=>'渠道商兑换['.$forr['fori_item_name'].']减少积分',    //兑换内容
                'aure_type'=>1, //1渠道积分2技师积分
                // 'aure_remain_auregral'=>$remain_integral,   //剩余积分
                'aure_remain_auregral'=>$chan_data['chan_integral'],   //剩余积分
                'aure_operation_name'=>$adm_info['adm_name'],   //操作人姓名
                'aure_operation_id'=>$adm_info['adm_id'],   //操作人id
                'aure_audit_state'=>1,  //审核状态1待审核2通过3驳回
                'aure_fori_id'=>$forr['fori_id'],   //物品id
                'aure_inte_id'=>$inte_res,   //兑换记录id
            ];
        $aure_res = DB::table('audit_record')->insert($aure_data);

        if($chan_res && $inte_res && $fori_res && $aure_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道列表','积分兑换', $chan_data['chan_phone'].'账号消耗'.$request['integral_number'].'积分成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'积分兑换成功']);
        }else{
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'积分兑换失败']);
        }
    }
}
