<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use \Exception;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\AnticounterModel;
use App\Http\Models\Coperationa;
class AnticounterController extends Controller
{
    /**
     防伪设置
     */
    public function antiset(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $initial=Db::table('note')->where(['not_cid'=>0])->select('note_content as content','note_number as number')->first();
        $enterprise=Db::table('note')->where(['not_cid'=>$user['adm_cid']])->select('note_content as content','note_number as number')->first();
        $initial['content']=stripslashes($initial['content']);
        if(empty($enterprise)){
            $enterprise=$initial;
        }
        $enterprise['content']=stripslashes($enterprise['content']);
        // var_dump($enterprise['content']);exit;
        $show_data=$enterprise;
        $old_data=$initial;

        $show_data['content']=$this->replace_str($show_data['content']);

        $old_data['content'] =$this->replace_str($old_data['content']);

        $res=['code'=>200,'msg'=>'success','data'=>['old_data'=>$initial,'new_data'=>$enterprise,'show_data'=>$show_data,'old_show'=>$old_data]];
        $res['button_data'] = wherebutton($request['api_token'],$request['pri_id']);

        return response()->json($res);
    }

    public function replace_str($data){
        $data=str_replace('{goods}',"满天星窗帘",$data);
        $data=str_replace('{code}',"500011810015498",$data);
        $data=str_replace('{num}','1',$data);
        $data=str_replace('{nums}','1',$data);
        $data=str_replace('{time}',"2019-07-22 12:00:00",$data);
        $data=str_replace('{pros}',"天津 武清区",$data);
        return $data;
    }

    //更改 访问预警设置数据
    public function judge(Request $request){
        $arr=[1=>'{goods}',2=>'{code}',3=>'{num}',4=>'{time}',5=>'{pros}','6'=>'{nums}'];
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $type=(int)$request->input('type',0);
        $content=$request->input('content');
        if($type!=0){
            if(strpos('.'.$content,$arr[$type])){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'请勿重复添加！']);
            }
            $new_data=$show_data=$content."<p>".$arr[$type]."</p>";
        }else{
            $new_data=$show_data=$content;
        }

        $show_data=stripslashes(stripslashes($this->replace_str($show_data)));
        $new_data=stripslashes(stripslashes($new_data));

        return response()->json(['code'=>200,'msg'=>'success','data'=>['content'=>$new_data,'show_data'=>$show_data]]);
        // if()

    }

    //防伪设置 提交
    public function editantiset(Request $request){
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        } 
       $data['note_number']=(int)$request->input('number',1);
        if($data['note_number']<0){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'预警次数最少0次']);
        }
        $data['note_content']=$request->input('content',null);
        if(empty($data['note_content'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'防伪设置不能为空']);
        }
        $data['update_user'] =$user['admin_id'];
        $data['created_at']=date('Y-m-d H:i:s');
        $obj=new AnticounterModel();
        $res=$obj->Set_Anti_Style($data,$user);
        return response()->json($res); 
    }

    /**
     防伪预警列表
     */
    public function antilist(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $where['stase']      =(int)$request->input('state',null);
        if (!empty($request['time'])) {
            $time_start = $request['time'][0];
            $time_end = $request['time'][1];
            $where['time_start'] =$time_start;
            $where['time_end'] =$time_end.' 23:59:59';
        }
        // $where['time_start'] =$request->input('time_start',null);
        // $where['time_end']   =$request->input('time_end',null);
        $where['code_number']=$request->input('code_number',null);
        $where['goods_name'] =$request->input('goods_name',null);
        $where['number']     =(int)$request->input('number',null);
        $where['page']       =(int)$request->input('page',1);
        if($where['number']<0){
            $where['number']=0;
        }
        $where['pagesize']    =(int)$request->input('page_size',10);
        if($where['pagesize']>100 || $where['pagesize'] < 1){
            $where['pagesize']=10;
        }
        $obj=new AnticounterModel();
        $res=$obj->Anti_List($where,$user);
        $res['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        return response()->json($res);

    }

    /**
     防伪处理
     */
    public function antihandle(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $id=$request->input('id',null);
        if(empty($id)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'id不能为空']);
        }
        $remarks=$request->input('remarks',null);
        $obj=new AnticounterModel();
        $res=$obj->Update_state($id,$user,$remarks);
        return response()->json($res);
    }

    /**
     防伪编辑
     */
    public function editanti(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $id=$request->input('id',null);
        if(empty($id)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'id不能为空']);
        }
        $remarks=$request->input('remarks',null);
        $obj=new AnticounterModel();
        $res=$obj->Edit_Anti($id,$user,$remarks);
        return response()->json($res);
    }

    // 开启查询
    public function openQuery(Request $request)
    {
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $total_id = $request['total_id'];
        if (empty($total_id)) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $total_status = 1;
        $total_code = DB::table('info_total')->whereIn('total_id',$total_id)->select('total_code')->get();
        foreach($total_code as $k=>$v)
        {
            $name[] = $v['total_code'];
        }
        $name = implode($name,',');
        $res = DB::table('info_total')->whereIn('total_id',$total_id)->update(['total_status'=>$total_status]);
        if ($res) {
            Coperationa::add($user['admin_id'],$request->getClientIp(),'开启查询','开启',"开启(".$name.")溯源码号");
            return response()->json(["code"=>200,'msg'=>'success','data'=>'操作成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'操作失败']);
        }
    }
    // 关闭查询
    public function closeQuery(Request $request)
    {
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $total_id = $request['total_id'];
        if (empty($total_id)) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $total_status = 2;
        $total_code = DB::table('info_total')->whereIn('total_id',$total_id)->select('total_code')->get();
        foreach($total_code as $k=>$v)
        {
            $name[] = $v['total_code'];
        }
        $name = implode($name,',');
        $res = DB::table('info_total')->whereIn('total_id',$total_id)->update(['total_status'=>$total_status]);
        if ($res) {
            Coperationa::add($user['admin_id'],$request->getClientIp(),'关闭查询','关闭',"关闭(".$name.")溯源码号");
            return response()->json(["code"=>200,'msg'=>'success','data'=>'操作成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'操作失败']);
        }
    }
}