<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use App\Http\Models\Coperationa;
use Illuminate\Support\Facades\Schema;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\Verify\VerifyCodeController;
use App\Http\Controllers\Verify\Source\VerifyFormworkController;
use App\Http\Models\CommenModel;
use App\Http\Controllers\Verify\Goods\VerifyGoodsController;
use App\Http\Controllers\Verify\Source\VerifyTagController;
use App\Http\Controllers\Verify\Source\VerifyTemplateController;
use phpDocumentor\Reflection\DocBlock\Tags\Var_;

class AkeycodeController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 最大发码数量
    protected $max_gro_num = 100000;
    // 二维码表最大存储数据
    protected $max_code_table = 6000000;

    // 一键发码请求页面
    public function index(Request $request)
    {
        // 验证数据
        if (!in_array($request->input('cla_type'),array(1,3))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $input = $request->all();
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 分类信息
        if ($request['cla_type'] == 1) {
            // 系统分类，查询 root 账号创建的分类
            $data['classifi_info'] = DB::table('goo_classifi as gc')
                    ->leftjoin('industry as i','i.ins_id','=','gc.cla_insid')
                    ->where(['cla_cid'=>'1','cla_stase'=>1,'cla_type'=>1])
                    ->get(['cla_id','cla_name','ins_id','ins_name']);
            $data['industry'] = DB::table('industry')
                    ->where(['ins_cid'=>'1','ins_stase'=>1])
                    ->get(['ins_id','ins_name']);
            // 商品信息
            $datas = $request->all();
            $data['goods_info'] = DB::table('goods as a')
                ->leftJoin('goo_classifi as b','a.goo_classifi', '=', 'b.cla_id')
                ->leftjoin('navigation as c','c.nav_id','=','a.goo_navid')
                ->leftjoin('industry as i','i.ins_id','=','b.cla_insid')
                ->where('a.goo_cid',1)
                ->where('a.del_type',1)
                ->where('a.goo_sta',1)
                ->where('a.goo_image','!=','')
                ->where(function($query) use($datas) {
                    if (!empty($datas['goo_name'] )) {
                        $query->where('a.goo_name', 'like' , '%'.$datas['goo_name'].'%' );
                    }
                })
                ->where(function($query) use($datas) {
                    if (!empty($datas['goo_number'] )) {
                        $query->where('a.goo_number', 'like' , '%'.$datas['goo_number'].'%' );
                    }
                })
                ->where(function($query) use($datas) {
                    if (!empty($datas['goo_classifi'] )) {
                        $query->where('goo_classifi', '=' ,$datas['goo_classifi'] );
                    }
                })
                ->where(function($query) use($datas) {
                    if (!empty($datas['cla_insid'] )) {
                        $query->where('cla_insid', '=' ,$datas['cla_insid'] );
                    }
                })
                ->select('goo_id','a.goo_name','a.goo_pro','a.goo_picurl','a.goo_number','a.goo_classifi','b.cla_id','b.cla_name','a.goo_code_total','a.technician_integral','a.channel_integral','a.validity_period','a.warranty_day','a.goo_navid','a.goo_image','c.nav_id','c.nav_name','i.ins_id','i.ins_name','a.goo_nutrient_content')
                ->orderBy('a.goo_id','desc')
                ->paginate($this->show_count);
            $data['nav_info'] = DB::table('navigation')
                ->where(['nav_state'=>1,'nav_cid'=>1,'nav_del'=>1])
                ->orWhere('nav_id',1)
                ->select('nav_id','nav_name')
                ->get();
            $data['current_page'] = $data['goods_info']->currentPage();  //当前页面页码
            $data['last_page'] = $data['goods_info']->lastPage();        //表示最后一页的页码
            $data['total'] = $data['goods_info']->total();               //总数据个数
            $data['current_number'] = $this->show_count;       //一页显示多少个
            $data['goods_info'] = $data['goods_info']->items();                //返回数据
            return response()->json(['code'=>200,'msg'=>'success','data'=>'信息获取成功','data'=>$data]);
        }else if ($request['cla_type'] == 3) {
            // 我的分类，当前公司账号创建的分类
            $data['classifi_info'] = DB::table('goo_classifi')
                ->where('cla_cid',$find_adm['adm_cid'])
                ->where('cla_stase',1)
                ->select('cla_id','cla_name')
                ->get();
            // 商品信息
            $datas = $request->all();
            $data['goods_info'] = DB::table('goods as a')
                ->leftJoin('goo_classifi as b', 'a.goo_classifi', '=', 'b.cla_id')
                ->leftJoin('navigation as c', 'c.nav_id', '=', 'a.goo_navid')
                ->where(['a.goo_cid'=>$find_adm['adm_cid'],'a.del_type'=>1,'a.goo_sta'=>1])
                ->where(function($query) use($datas) {
                    if (!empty($datas['goo_name'] )) {
                        $query->where('a.goo_name', 'like' , '%'.$datas['goo_name'].'%' );
                    }
                })
                ->where(function($query) use($datas) {
                    if (!empty($datas['goo_number'] )) {
                        $query->where('a.goo_number', 'like' , '%'.$datas['goo_number'].'%' );
                    }
                })
                ->where(function($query) use($datas) {
                    if (!empty($datas['goo_classifi'] )) {
                        $query->where('goo_classifi', '=' ,$datas['goo_classifi'] );
                    }
                })
                ->select('goo_id','a.goo_name','a.goo_pro','a.goo_picurl','a.goo_number','a.goo_classifi','b.cla_id','b.cla_name','a.goo_code_total','a.technician_integral','a.channel_integral','a.validity_period','a.warranty_day','a.goo_navid','a.goo_image','c.nav_id','c.nav_name','a.goo_nutrient_content')
                ->orderBy('a.goo_code_total','desc')
                ->get();
            $data['nav_info'] = DB::table('navigation')
                ->where('nav_cid',$find_adm['adm_cid'])
                ->where('nav_state',1)
                ->where('nav_del',1)
                ->orWhere('nav_id',1)
                ->select('nav_id','nav_name')
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>'信息获取成功','data'=>$data]);
        }
    }

    // 添加商品
    public function addgo(Request $request)
    {
        // 验证数据
        if (!in_array($request->input('type'),array(1,2))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        if (!$request->exists('goo_classifi') || !is_numeric($request->input('goo_classifi'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $day=date('Ymd');
        //商品属性
        foreach ($request->input('info_name') as $key => $value) {
            if (empty($value) || empty($request->input('info_content')[$key]) || !in_array($request->input('info_show')[$key],array(1,2))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息项存在空项']);
            }
            if ($value == '商品名称') {
                $goo_name = $request->input('info_content')[$key];
            }
            if ($value == '条形码号') {
                $goo_number = $request->input('info_content')[$key];
            }
            $goo_pro[$key]['key'] = $value;
            $goo_pro[$key]['show'] = $request->input('info_show')[$key];        //显示隐藏
            $goo_pro[$key]['type'] = $request->input('info_type')[$key];        //属性类型
            $goo_pro[$key]['pri'] = $request->input('info_pri')[$key];          //是否打印
            $url = $request->input('info_content')[$key];                       //内容
            if (($goo_pro[$key]['type']==6 || $goo_pro[$key]['type']==7) && !empty($url)) {
                //判断是否是临时文件;
                if (strpos($url,'temporary')) {
                    $end = explode('.',$url)[1];  //获取后缀
                    $file_name = $goo_pro[$key]['type']==6?'images':'videos';
                    $new_name = 'uploads/goods/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path = public_path().'/'.$new_name;  //新的文件地址
                    $old_url = public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if (!is_dir(dirname($new_path))) {
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url = $new_name;
                } else {
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
            }
            $goo_pro[$key]['value'] = $url;
        }
        // 查询商品名称是否存在
        $find_goo_name = DB::table('goods')
            ->where('del_type',1)
            ->where('goo_cid',$find_adm['adm_cid'])
            ->where('goo_name',$goo_name)
            ->value('goo_name');
        if ($find_goo_name) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'商品名称已存在']);
        }
        // 查询条形码号是否存在
        $find_goo_number = DB::table('goods')
            ->where('del_type',1)
            ->where('goo_cid',$find_adm['adm_cid'])
            ->where('goo_number',$goo_number)
            ->value('goo_number');
        if ($find_goo_number) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'条形码号已存在']);
        }
        $goo_picurl = '';
        if (!empty($request->input('goo_picurl'))) {
            // 上传图片
            $uploadImg = new CommonController;
            foreach ($request->input('goo_picurl') as $key => $value) {
                if (stristr($value, 'data:image')) {
                    $uploadPath = $uploadImg->uploadBase64Img($value);
                    if ($uploadPath) {
                        $goo_picurl .= $uploadPath.',';
                    } else {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                    }
                } else {
                    // 获取原图片路径
                    $path = explode(config('app.url'),$value);
                    $path_url = trim($path[1],'/');
                    $path_type = explode('.',$path_url);
                    // 新图片路径文件名
                    $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                    $pathName = "/image/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                    // 复制图片
                    $new_url = copy(base_path().'/'.$path_url, storage_path().$pathName);
                    // 返回路径
                    $filePath = "storage". $pathName;
                    $goo_picurl .= $filePath.',';
                }
            }
            $goo_picurl = trim($goo_picurl,',');
        }
        //附加信息
        if ($request->input('goods_type') == 1) {
            foreach ($request->input('infos_name') as $key => $value) {
                // 判断当前复制列表是否为复制列表
                if (strpos($request->input('infos_content')[$key],'---副本') !==false) {
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'请去掉信息名称中的 " ---副本 "']);
                }
                $goo_nutrient_content[$key]['key'] = $value;
                $goo_nutrient_content[$key]['show'] = $request->input('infos_show')[$key];      //显示隐藏
                $goo_nutrient_content[$key]['type'] = $request->input('infos_type')[$key];      //属性类型
                $url                   = $request->input('infos_content')[$key];        //内容
                if (($goo_nutrient_content[$key]['type']==6 || $goo_nutrient_content[$key]['type']==7) && !empty($url)) {
                    //判断是否是临时文件;
                    if (strpos($url,'temporary')) {
                        $end=explode('.',$url)[1];  //获取后缀
                        $file_name=$goo_nutrient_content[$key]['type']==6?'images':'videos';
                        $new_name='uploads/goods/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                        $new_path=public_path().'/'.$new_name;  //新的文件地址
                        $old_url=public_path().'/'.$url;  //旧的文件地址
                        //给新地址 赋予 所有权限;
                        if (!is_dir(dirname($new_path))) {
                            mkdir(dirname($new_path), 0777, true);
                            chmod(dirname($new_path),0777);
                        }
                        rename($old_url,$new_path);  //移动
                        $url=$new_name;
                    } else {
                        //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                        $file_data[]=$url;
                    }
                }
                $goo_nutrient_content[$key]['value']=$url;
            }
        }else{
            $goo_nutrient_content = '';
        }
        $time = date('Y-m-d H:i:s');
        DB::beginTransaction();
        if ($request->input('nav_type') == 1) {
            # 系统默认导航
            $nav_data=DB::table('navigation')
                ->where(['nav_id'=>$request['nav_id']])
                ->first();
            $nav_data['nav_cid'] = $find_adm['adm_cid'];
            if ($nav_data['nav_style'] == '1') {
                $nav_style = '幽兰';
            } elseif ($nav_data['nav_style'] == '2') {
                $nav_style = '简白';
            } elseif ($nav_data['nav_style'] == '3') {
                $nav_style = '臻黑';
            } elseif ($nav_data['nav_style'] == '4') {
                $nav_style = '甜橙';
            }
            // 获取复制的 导航名称
            if (strpos($nav_data['nav_name'],'--副本')) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'请编辑去掉导航信息中的"--副本"']);
            } else {
                $name = $nav_data['nav_name'].'-'.$nav_style;
            }
            $res_name = DB::table('navigation')->where("nav_name",'like',$name.'%')->where(['nav_cid'=>$find_adm['adm_cid'],'nav_del'=>1])->select('nav_name')->orderBy('nav_id','desc')->first();
            if (!empty($res_name)) {
                if ($name != $res_name['nav_name']) {
                    $str = (int)substr($res_name['nav_name'],strrpos($res_name['nav_name'],'+')+1);
                    $name = $name . "+" . (++$str);
                }else{
                    $name = $name . "+1";
                }
            }
            $nav_data['nav_name'] = $name;
            $nav_data['nav_genre'] = 3;
            unset($nav_data['nav_id']);
            unset($nav_data['nav_total']);
            $nav_id = DB::table('navigation')->insertGetId($nav_data);
            if (!$nav_id) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'添加导航失败']);
            }
        } else {
            $nav_id=(int)$request->input('nav_id');
        }
        $goo_add_data['goo_name'] = $goo_name;
        $goo_add_data['goo_number'] = $goo_number;
        $goo_add_data['goo_cid'] = $find_adm['adm_cid'];
        $goo_add_data['goo_classifi'] = $request['goo_classifi'];
        $goo_add_data['goo_picurl'] = $goo_picurl;
        $goo_add_data['goo_pro'] = json_encode($goo_pro);
        $goo_add_data['goo_sta'] = 1;
        $goo_add_data['goo_time'] = $time;
        $goo_add_data['goo_navid'] = $nav_id;
        $goo_add_data['technician_integral'] = $request['technician_integral'] ? $request['technician_integral'] : 0;
        $goo_add_data['channel_integral'] = $request['channel_integral'] ? $request['channel_integral'] : 0;
        $goo_add_data['warranty_day'] = $request['warranty_day'] ? $request['warranty_day'] : 0;
        $goo_add_data['validity_period'] = $request['validity_period'] ? $request['validity_period'] : 0;
        $goo_add_data['goo_nutrient_content'] = json_encode($goo_nutrient_content);
        $goo_res = DB::table('goods')->insertGetId($goo_add_data);
        
        // 商品所属分类数量更改
        $res_class = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request->input('goo_classifi')] );
        // 商品所属导航数量更改
        $res_nav = DB::update('UPDATE `trace_navigation` SET `nav_total` = `nav_total`+1 WHERE `nav_id`=?',[$nav_id]);
        if ($goo_res && $res_class && $res_nav) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品列表','新增','新增“'.$goo_name.'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功','goo_id'=>$goo_res,'goo_name'=>$goo_name]);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
        }
    }

    // 编辑商品
    public function editgo(Request $request)
    {
        // 验证数据
        if (!in_array($request->input('type'),array(1,2)) || !$request->exists('edit_id') || !is_numeric($request->input('edit_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 验证数据
        if (!$request->exists('goo_classifi') || !is_numeric($request->input('goo_classifi'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $day=date('Ymd');
        $file_data=[];
        //商品属性
        foreach ($request->input('info_name') as $key => $value) {
            if (empty($value) || empty($request->input('info_content')[$key]) || !in_array($request->input('info_show')[$key],array(1,2)) ) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息项存在空项']);
            }
            // 判断当前复制列表是否为复制列表
            if(strpos($request->input('info_content')[$key],'---副本') !==false){
                 return response()->json(["code"=>500,'msg'=>'error','data'=>'请去掉信息名称中的 " ---副本 "']);
            }
            if ($value == '商品名称') {
                $goo_name = $request->input('info_content')[$key];
            }
            if ($value == '条形码号') {
                $goo_number = $request->input('info_content')[$key];
            }
            $goo_pro[$key]['key'] = $value;
            $goo_pro[$key]['show'] = $request->input('info_show')[$key];        //显示隐藏
            $goo_pro[$key]['type'] = $request->input('info_type')[$key];        //属性类型
            $goo_pro[$key]['pri'] = $request->input('info_pri')[$key];          //是否打印
            $url                   = $request->input('info_content')[$key];     //内容
            if (($goo_pro[$key]['type']==6 || $goo_pro[$key]['type']==7) && !empty($url)) {
                //判断是否是临时文件;
                if (strpos($url,'temporary')) {
                    $end=explode('.',$url)[1];  //获取后缀
                    $file_name=$goo_pro[$key]['type']==6?'images':'videos';
                    $new_name='uploads/goods/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path=public_path().'/'.$new_name;  //新的文件地址
                    $old_url=public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if(!is_dir(dirname($new_path))){
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url=$new_name;
                }else{
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
            }   
            $goo_pro[$key]['value']=$url;
        }
        // 查询商品名称是否存在
        $find_goo_name = DB::table('goods')
            ->where('del_type',1)
            ->where('goo_cid',$find_adm['adm_cid'])
            ->where('goo_name',$goo_name)
            ->where('goo_id','<>',$request['edit_id'])
            ->select('goo_name')
            ->first();
        if ($find_goo_name) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'商品名称已存在']);
        }
        // 查询条形码号是否存在
        $find_goo_number = DB::table('goods')
            ->where('del_type',1)
            ->where('goo_cid',$find_adm['adm_cid'])
            ->where('goo_number',$goo_number)
            ->where('goo_id','<>', $request['edit_id'])
            ->select('goo_number')
            ->first();
        if ($find_goo_number) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'条形码号已存在']);
        }
        $goo_picurl = '';
        if (!empty($request->input('goo_picurl'))) {
            // 上传图片
            $uploadImg = new CommonController;
            foreach ($request->input('goo_picurl') as $key => $value) {
                if (stristr($value, 'data:image')) {
                    $uploadPath = $uploadImg->uploadBase64Img($value);
                    if ($uploadPath) {
                        $goo_picurl .= $uploadPath.',';
                    }else{
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                    }
                }else{
                    // 获取原图片路径
                    $path = explode(config('app.url'),$value);
                    $path_url = trim($path[1],'/');
                    $path_type = explode('.',$path_url);
                    // 新图片路径文件名
                    $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                    $pathName = "/image/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                    // 复制图片
                    $new_url = copy(base_path().'/'.$path_url, storage_path().$pathName);
                    // 返回路径
                    $filePath = "storage". $pathName;
                    $goo_picurl .= $filePath.',';
                }
            }
            $goo_picurl = trim($goo_picurl,',');
        }
        //附加信息
        if ($request->input('goods_type') == 1) {
            foreach ($request->input('infos_name') as $key => $value) {
                // 判断当前复制列表是否为复制列表
                if(strpos($request->input('infos_content')[$key],'---副本') !==false){
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'请去掉信息名称中的 " ---副本 "']);
                }
                $goo_nutrient_content[$key]['key'] = $value;
                $goo_nutrient_content[$key]['show'] = $request->input('infos_show')[$key];      //显示隐藏
                $goo_nutrient_content[$key]['type'] = $request->input('infos_type')[$key];      //属性类型
                $url                   = $request->input('infos_content')[$key];        //内容
                if(($goo_nutrient_content[$key]['type']==6 || $goo_nutrient_content[$key]['type']==7) && !empty($url)){
                    //判断是否是临时文件;
                    if(strpos($url,'temporary')){
                        $end=explode('.',$url)[1];  //获取后缀
                        $file_name=$goo_nutrient_content[$key]['type']==6?'images':'videos';
                        $new_name='uploads/goods/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                        $new_path=public_path().'/'.$new_name;  //新的文件地址
                        $old_url=public_path().'/'.$url;  //旧的文件地址
                        //给新地址 赋予 所有权限;
                        if(!is_dir(dirname($new_path))){
                            mkdir(dirname($new_path), 0777, true);
                            chmod(dirname($new_path),0777);
                        }
                        rename($old_url,$new_path);  //移动
                        $url=$new_name;
                    }else{
                        //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                        $file_data[]=$url;
                    }
                }
                $goo_nutrient_content[$key]['value']=$url;
            }
        }else{
            $goo_nutrient_content = '';
        }
        $time = date('Y-m-d H:i:s');
        $nav_id=(int)$request->input('nav_id');
        $goo_edit_data['goo_name'] = $goo_name;
        $goo_edit_data['goo_number'] = $goo_number;
        $goo_edit_data['goo_classifi'] = $request['goo_classifi'];
        $goo_edit_data['goo_picurl'] = $goo_picurl;
        $goo_edit_data['goo_pro'] = json_encode($goo_pro);
        $goo_edit_data['goo_navid'] = $nav_id;
        $goo_edit_data['technician_integral'] = $request['technician_integral'] ? $request['technician_integral'] : 0;
        $goo_edit_data['channel_integral'] = $request['channel_integral'] ? $request['channel_integral'] : 0;
        $goo_edit_data['warranty_day'] = $request['warranty_day'] ? $request['warranty_day'] : 0;
        $goo_edit_data['validity_period'] = $request['validity_period'] ? $request['validity_period'] : 0;
        $goo_edit_data['goo_nutrient_content'] = json_encode($goo_nutrient_content);
        $goo_edit_data['goo_update_time'] = $time;
        DB::beginTransaction();
        // 判断是否更改商品所属分类
        $find_goo_classifi = DB::table('goods')
            ->where('goo_id',$request['edit_id'])
            ->select('goo_classifi')
            ->first();
        if ($request->input('goo_classifi') != $find_goo_classifi['goo_classifi']) {
            // 更改商品所属分类数量
            $res_class1 = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`+1  WHERE `cla_id`=?',[$request->input('goo_classifi')] );
            $res_class2 = DB::update('UPDATE `trace_goo_classifi` SET `cla_total`=`cla_total`-1  WHERE `cla_id`=?',[$find_goo_classifi['goo_classifi']] );
            if ($res_class1 && $res_class2) {
                $res_class = true;
            }else{
                $res_class = false;
            }
        }else{
            $res_class = true;
        }
        // 判断是否更改商品所属导航
        $find_nav = DB::table('goods')
                ->where(['goo_cid'=>$find_adm['adm_cid'],'goo_id'=>$request->input('edit_id')])
                ->first(['goo_navid']);
        if ($nav_id != (int)$request->input('nav_id')) {
            // 更改商品所属导航数量
            $res_nav1 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`+1  WHERE `nav_id`=?',[$nav_id]);
            $res_nav2 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`-1  WHERE `nav_id`=?',[(int)$request->input('nav_id')]);
            if ($res_nav1 && $res_nav2) {
                $res_nav = true;
            }else{
                $res_nav = false;
            }
        }else{
            $res_nav = true;
        }
        $goods_res = DB::table('goods')
            ->where('goo_id',$request['edit_id'])
            ->update($goo_edit_data);

        if ($goods_res && $res_class && $res_nav) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品列表','编辑','编辑“'.$goo_name.'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功','goo_id'=>$request['edit_id']]);
        }else{
            DB::rollBack();
            return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑失败']);
        }
    }

    //  新---- 图片上传
    public function imageform(Request $request)
    {
        $image =  $request['images'];
        $imageName = "IMG_".time()."_".rand(1111,9999).'.png';
        // 当前文件根路径
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        if (!empty($image)) {
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $path = "uploads/template/temporary";
            if (!is_dir($path)) {             //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            $imageSrc= $path."/". $imageName;  //图片名字

            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(["code"=>200,'msg'=>'success','data'=>'图片上传成功','path'=>$imageSrc]);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'还未选择图片']);
        }
    }

    // 删除 溯源信息临时文件接口
    public function file_data(Request $request)
    {
        //请求  溯源信息的临时图片和视频
        $path=public_path().'/uploads/template/temporary';
        if(is_dir($path)) {
            if (!file_exists($path)) {
                mkdir($path,0777,true);
            }
        }
        $time=time()-24*60*60;
        $file=[];
        $resource=opendir($path);
        //获取 图片文件夹下所有文件;  并判断是否超过24 小时  超过则删除
        while($row=readdir($resource)) {
            if ($row=='.'||$row=='..') {continue;}
            $old_time=explode('_',$row)[1];
            if ($old_time<$time) {
                chmod($path.'/'.$row,0777);
                unlink($path.'/'.$row);
            }
        }
        closedir($resource);
        echo 'ok';
    }

    // 删除图片
    public function delimageform(Request $request)
    {
        $image =  $request['images'];
        if (!is_array($image)) {
            $temp=$image;
            unset($image);
            $image[]=$temp;
        }
        foreach ($image as $key => $val) {
            if (file_exists(public_path().'/'.$val) && !empty($val)) {
                // 修改原圖片权限
                chmod(public_path().'/'.$val,0777);
                // 删除原圖片
                unlink(public_path().'/'.$val); 
            }
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'删除图片成功']);
    }

    // 获取导航信息
    public function navigation_info(Request $request)
    {
        // 根据token获取当前操作人
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $navinfo = $request->all();
        if (empty($request['navigation_type']) || !is_numeric($request['navigation_type'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        if ($request['navigation_type'] == 1) {
            // 公共溯源设置--导航信息
            $data['nav_data'] = DB::table('navigation')
                ->where(function($query) use($navinfo) {
                    if (!empty($navinfo['nav_name'] )) {
                        $query->where('nav_name', 'like' , '%'.$navinfo['nav_name'].'%' );
                    }
                })
                ->where('nav_cid',1)
                ->where('nav_state',1)
                ->where('nav_del',1)
                ->where('nav_genre',1)
                ->select('nav_id','nav_name','nav_style')
                ->orderBy('nav_id','desc')
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }else if ($request['navigation_type'] == 2) {
            // 我的溯源设置--导航信息
            $data['nav_data'] = DB::table('navigation')
                ->where(function($query) use($navinfo) {
                    if (!empty($navinfo['nav_name'] )) {
                        $query->where('nav_name', 'like' , '%'.$navinfo['nav_name'].'%' );
                    }
                })
                ->where('nav_cid',$find_adm['adm_cid'])
                ->where('nav_state',1)
                ->where('nav_del',1)
                ->orderBy('nav_id','desc')
                ->select('nav_id','nav_name')
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
    }

    // 添加导航信息项
    public function add_nav(Request $request)
    {
        //验证数据
        if (empty($request['nav_types']) || !is_numeric($request['nav_types'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取当前操作人
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        if ($request['nav_types']==1) {
            $data = Db::table('navigation')
                ->where('nav_id',$request['nav_id'])
                ->where('nav_del',1)
                ->where('nav_cid',1)
                ->select('nav_id','nav_name','nav_style','nav_icon')
                ->first();
            if (!$data) {return response()->json(['code'=>500,'msg'=>'error','data'=>'没有这个导航']);}
            $data['nav_icon'] = json_decode($data['nav_icon'],true);
            if ($find_adm['adm_module'] == '1') {
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                }
            } else if ($find_adm['adm_module'] == '3') {
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                    if ($value['icon_ids'] == 4) {
                        unset($data['nav_icon'][$key]);
                    }
                }
                $data['nav_icon'] = array_values($data['nav_icon']);
            } else if ($find_adm['adm_module'] == '4') {
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                    if ($value['icon_ids'] == 5) {
                        unset($data['nav_icon'][$key]);
                    }
                }
                $data['nav_icon'] = array_values($data['nav_icon']);
            } else if ($find_adm['adm_module'] == '5') {
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                    if ($value['icon_ids'] == 5 || $value['icon_ids'] == 4) {
                        unset($data['nav_icon'][$key]);
                    }
                }
                $data['nav_icon'] = array_values($data['nav_icon']);
            } else {
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                }
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
        $nav_name = Db::table('navigation')
            ->where('nav_del',1)
            ->where('nav_name',trim($request['nav_name']))
            ->where('nav_cid',$find_adm['adm_cid'])
            ->where('nav_id','!=',$request['nav_id'])
            ->value('nav_name');
        if ($nav_name) {return ['code'=>500,'msg'=>'error','data'=>'导航名称重复'];}
        //处理导航图标
        $arr=[];
        foreach ($request['name'] as $k => $v) {
            if (empty($request['name'][$k])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            if (mb_strlen($v,'UTF8') > 6) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息名称最多六个字']);
            }
        }
        foreach ($request['name'] as $key => $val) {
            $arr[$key]['name']   =$val;
            $arr[$key]['icon_type']=$request['icon_type'][$key];
            $arr[$key]['show']   =$request['show'][$key] ? 2 : 1;
            $arr[$key]['system_icon']=$request['system_icon'][$key];
            $arr[$key]['icon_ids'] =$request['icon_ids'][$key];
            $arr[$key]['icon_order'] =$request['icon_order'][$key];
            $arr[$key]['pic'] = CommenModel::uploadBase64Img($request['pic'][$key],'navigation/icon','public');
            if ($arr[$key]['pic'] == false) {
                $path = explode(config('app.url'),$request['pic'][$key]);
                $path_url = trim($path[1],'/');
                $path_type = explode('.',$path_url);
                // 新图片路径文件名
                $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                $pathName = "/navigation/icon/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                // 复制图片
                $new_url = copy(base_path().'/'.$path_url, public_path().$pathName);
                // 返回路径
                $filePath = "public". $pathName;
                $arr[$key]['pic'] .= $filePath;
            }
            $arr[$key]['content']=$request['content'][$key];
        }
        
        # 系统默认导航
        $nav_data=DB::table('navigation')
            ->where(['nav_id'=>$request['nav_id']])
            ->first();
        if ($nav_data['nav_style'] == '1') {
            $nav_style = '幽兰';
        } elseif ($nav_data['nav_style'] == '2') {
            $nav_style = '简白';
        } elseif ($nav_data['nav_style'] == '3') {
            $nav_style = '臻黑';
        } elseif ($nav_data['nav_style'] == '4') {
            $nav_style = '甜橙';
        }
        // 获取复制的 导航名称
        if (strpos($nav_data['nav_name'],'--副本')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请编辑去掉导航信息中的"--副本"']);
        } else {
            $name = $nav_data['nav_name'].'-'.$nav_style;
        }
        $res_name = DB::table('navigation')
            ->where("nav_name",'like',$name.'%')
            ->where('nav_cid',$find_adm['adm_cid'])
            ->where('nav_del',1)
            ->orderBy('nav_id','desc')
            ->select('nav_name')
            ->first();
        if (!empty($res_name)) {
            if ($name != $res_name['nav_name']) {
                $str = (int)substr($res_name['nav_name'],strrpos($res_name['nav_name'],'+')+1);
                $name = $name . "+" . (++$str);
            } else {
                $name = $name . "+1";
            }
        }
        DB::beginTransaction(); //开启事务
        $nav_res = DB::table('navigation')
            ->insertGetId([
                'nav_icon' => json_encode($arr),
                'nav_column_setup' => $request['nav_column_setup'],
                'nav_name' => $name,
                'nav_style' => $request['nav_style'],
                'nav_addtime' => date('Y-m-d H:i:s'),
                'nav_user' => $find_adm['adm_id'],
                'nav_cid' => $find_adm['adm_cid'],
                'nav_state' => 1,
                'nav_genre' => 3
                ]);
        // 环境
        if ($request->input('env_types') == 1) {
            // 系统默认环境
            $env_data = DB::table('environment')
                ->where('env_id',$request['env_id'])
                ->first();
            $env_data['env_aid'] = $find_adm['adm_id'];
            $env_data['env_cid'] = $find_adm['adm_cid'];
            // 获取复制的环境名称
            if (strpos($env_data['env_name'],'--副本')) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'请编辑去掉环境信息中的"--副本"']);
            } else {
                $name = $env_data['env_name'];
            }
            $res_name = DB::table('environment')
                ->where("env_name",'like',$name.'%')
                ->where('env_cid',$find_adm['adm_cid'])
                ->orderBy('env_id','desc')
                ->value('env_name');
            if (!empty($res_name)) {
                if ($name != $res_name['env_name']) {
                    $str = (int)substr($res_name['env_name'],strrpos($res_name['env_name'],'+')+1);
                    $name = $name . "+" . (++$str);
                } else {
                    $name = $name . "+1";
                }
            }
            $env_data['env_name'] = $name;
            unset($env_data['env_id']);
            $env_id = DB::table('environment')->insertGetid($env_data);
            if (!$env_id) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'添加环境失败']);
            }
            // 设备列表数据
            // 二氧化碳检测
            $device_co2_data = DB::table('device_co2')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_co2_data)) {
                foreach ($device_co2_data as $k1=>$v1) {
                    unset($v1['id']);
                    $v1['env_id'] = $env_id;
                    $device_co2_id = DB::table('device_co2')->insert($v1);
                    if (!$device_co2_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加CO2失败']);
                    }
                }
            }
            // 光照度
            $device_illumination_data = DB::table('device_illumination')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_illumination_data)) {
                foreach ($device_illumination_data as $k2=>$v2) {
                    unset($v2['id']);
                    $v2['env_id'] = $env_id;
                    $device_illumination_id = DB::table('device_illumination')->insert($v2);
                    if (!$device_illumination_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加光照度失败']);
                    }
                }
            }
            // 湿度
            $device_moisture_data = DB::table('device_moisture')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_moisture_data)) {
                foreach ($device_moisture_data as $k3=>$v3) {
                    unset($v3['id']);
                    $v3['env_id'] = $env_id;
                    $device_moisture_id = DB::table('device_moisture')->insert($v3);
                    if (!$device_moisture_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加湿度失败']);
                    }
                }
            }
            // 雨量1
            $device_rainfall1_data = DB::table('device_rainfall1')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_rainfall1_data)) {
                foreach ($device_rainfall1_data as $k4=>$v4) {
                    unset($v4['id']);
                    $v4['env_id'] = $env_id;
                    $device_rainfall1_id = DB::table('device_rainfall1')->insert($v4);
                    if (!$device_rainfall1_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加雨量失败']);
                    }
                }
            }
            // 土壤湿度1
            $device_soil_moisture1_data = DB::table('device_soil_moisture1')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_soil_moisture1_data)) {
                foreach ($device_soil_moisture1_data as $k5=>$v5) {
                    unset($v5['id']);
                    $v5['env_id'] = $env_id;
                    $device_soil_moisture1_id = DB::table('device_soil_moisture1')->insert($v5);
                    if (!$device_soil_moisture1_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加土壤湿度失败']);
                    }
                }
            }
            // 土壤PH
            $device_soil_ph_data = DB::table('device_soil_ph')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_soil_ph_data)) {
                foreach ($device_soil_ph_data as $k6=>$v6) {
                    unset($v6['id']);
                    $v6['env_id'] = $env_id;
                    $device_soil_ph_id = DB::table('device_soil_ph')->insert($v6);
                    if (!$device_soil_ph_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加土壤PH失败']);
                    }
                }
            }
            // 土壤盐分
            $device_soil_salinity_data = DB::table('device_soil_salinity')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_soil_salinity_data)) {
                foreach ($device_soil_salinity_data as $k7=>$v7) {
                    unset($v7['id']);
                    $v7['env_id'] = $env_id;
                    $device_soil_salinity_id = DB::table('device_soil_salinity')->insert($v7);
                    if (!$device_soil_salinity_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加土壤盐分失败']);
                    }
                }
            }
            // 土壤温度1
            $device_soil_temperature1_data = DB::table('device_soil_temperature1')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_soil_temperature1_data)) {
                foreach ($device_soil_temperature1_data as $k8=>$v8) {
                    unset($v8['id']);
                    $v8['env_id'] = $env_id;
                    $device_soil_temperature1_id = DB::table('device_soil_temperature1')->insert($v8);
                    if (!$device_soil_temperature1_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加土壤温度失败']);
                    }
                }
            }
            // 温度
            $device_temperature_data = DB::table('device_temperature')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_temperature_data)) {
                foreach ($device_temperature_data as $k9=>$v9) {
                    unset($v9['id']);
                    $v9['env_id'] = $env_id;
                    $device_temperature_id = DB::table('device_temperature')->insert($v9);
                    if (!$device_temperature_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加温度失败']);
                    }
                }
            }
            // 风向1
            $device_wind_direction1_data = DB::table('device_wind_direction1')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_wind_direction1_data)) {
                foreach ($device_wind_direction1_data as $k10=>$v10) {
                    unset($v10['id']);
                    $v10['env_id'] = $env_id;
                    $device_wind_direction1_id = DB::table('device_wind_direction1')->insert($v10);
                    if (!$device_wind_direction1_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加风向失败']);
                    }
                }
            }
            // 风速
            $device_wind_speed_data = DB::table('device_wind_speed')
                ->where('env_id',$request['env_id'])
                ->get();
            if (!empty($device_wind_speed_data)) {
                foreach ($device_wind_speed_data as $k11=>$v11) {
                    unset($v11['id']);
                    $v11['env_id'] = $env_id;
                    $device_wind_speed_id = DB::table('device_wind_speed')->insert($v11);
                    if (!$device_wind_speed_id) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'添加风速失败']);
                    }
                }
            }
        }
        // 溯源
        if ($request->input('fom_types') == 1) {
            # 系统默认溯源信息
            $fom_data = DB::table('formwork as f')
                ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
                ->whereIn('fom_id',$request['fom_id'])
                ->get();
            foreach ($fom_data as $kkk => $vvv) {
                //获取复制的标签名称
                if (strpos($vvv['lab_name'],'--副本')) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'请编辑去掉溯源标签中的"--副本"']);
                } else {
                    $name = $vvv['lab_name'];
                }
                $res_name = DB::table('form_label')
                    ->where("lab_name",'like',$name.'%')
                    ->where('lab_cid',$find_adm['adm_cid'])
                    ->orderBy('lab_id','desc')
                    ->select('lab_name')
                    ->first();
                if (!empty($res_name)) {
                    if ($name != $res_name['lab_name']) {
                        $str = (int)substr($res_name['lab_name'],strrpos($res_name['lab_name'],'+')+1);
                        $name = $name . "+" . (++$str);
                    }else{
                        $name = $name . "+1";
                    }
                }
                $vvv['lab_name'] = $name;
                unset($vvv['lab_id']);
                unset($vvv['lab_total']);
                $lab_id = DB::table('form_label')->insertGetId([
                    'lab_name' => $vvv['lab_name'],
                    'lab_cid' => $find_adm['adm_cid'],
                    'lab_stase' => $vvv['lab_stase'],
                    'lab_time' => date('Y-m-d H:i:s'),
                    'lab_picurl' => $vvv['lab_picurl'],
                    'lab_type' => $find_adm['adm_type'],
                ]);
                if (!$lab_id) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'添加标签失败']);
                }
                // 获取复制的 模板名称
                if (strpos($vvv['tem_name'],'--副本')) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'请编辑去掉溯源模板中的"--副本"']);
                } else {
                    $name = $vvv['tem_name'];
                }
                $res_name = DB::table('formwork_template')
                    ->where("tem_name",'like',$name.'%')
                    ->where('tem_cid',$find_adm['adm_cid'])
                    ->select('tem_name')
                    ->orderBy('tem_id','desc')
                    ->first();
                if (!empty($res_name)) {
                    if ($name != $res_name['tem_name']) {
                        $str = (int)substr($res_name['tem_name'],strrpos($res_name['tem_name'],'+')+1);
                        $name = $name . "+" . (++$str);
                    } else {
                        $name = $name . "+1";
                    }
                }
                $vvv['tem_cid'] = $find_adm['adm_cid'];
                $vvv['tem_name'] = $name;
                $vvv['tem_addtime'] = date('Y-m-d H:i:s');
                unset($vvv['tem_id']);
                unset($vvv['tem_total']);
                $tem_id = DB::table('formwork_template')->insertGetId([
                    'tem_name' => $vvv['tem_name'],
                    'tem_content' => $vvv['tem_content'],
                    'tem_state' => $vvv['tem_state'],
                    'tem_cid' => $find_adm['adm_cid'],
                    'tem_addtime' => date('Y-m-d H:i:s'),
                    'tem_type' => $find_adm['adm_type'],
                    'tem_img' => $vvv['tem_img'],
                    'tem_type_swaitch' => $vvv['tem_type_swaitch'],
                ]);
                if (!$tem_id) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'添加模板失败']);
                }
                // 获取复制的 导航名称
                if (strpos($vvv['fom_title'],'--副本')) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'请编辑去掉溯源信息中的"--副本"']);
                } else {
                    $name = $vvv['fom_title'];
                }
                $res_name = DB::table('formwork')
                    ->where("fom_title",'like',$name.'%')
                    ->where('fom_cid',$find_adm['adm_cid'])
                    ->select('fom_title')
                    ->orderBy('fom_id','desc')
                    ->first();
                if (!empty($res_name)) {
                    if ($name != $res_name['fom_title']) {
                        $str = (int)substr($res_name['fom_title'],strrpos($res_name['fom_title'],'+')+1);
                        $name = $name . "+" . (++$str);
                    } else {
                        $name = $name . "+1";
                    }
                }
                $vvv['fom_title'] = $name;
                unset($vvv['fom_id']);
                unset($vvv['fom_fid']);
                unset($vvv['fom_count']);
                // 判断是否有这个标签
                $labels = DB::table('form_label')
                    ->where('lab_id',(int)$lab_id)
                    ->where('lab_cid',$find_adm['adm_cid'])
                    ->where('lab_stase',1)
                    ->select('lab_id','lab_name')
                    ->first();
                if (empty($labels)) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源标签']);
                } else {
                    $record = DB::table('form_label')
                        ->where('lab_id',(int)$lab_id)
                        ->increment('lab_total');
                    if (!$record) {
                        DB::rollBack();
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'更改标签数量失败']);
                    }
                }
                // 判断有这个模板吗?
                $lab = DB::table('formwork_template')
                    ->where('tem_id',(int)$tem_id)
                    ->where('tem_cid',$find_adm['adm_cid'])
                    ->where('tem_state',1)
                    ->orWhere('tem_cid',0)
                    ->select('tem_id','tem_name')
                    ->first();
                if (empty($lab)) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源模板']);
                } else {
                    $res3 = DB::table('formwork_template')
                        ->where('tem_id',(int)$tem_id)
                        ->increment('tem_total');
                    if (!$res3) {
                        DB::rollBack();
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'更改模板数量失败']);
                    }
                }
                $fom_id = DB::table('formwork')->insertGetId([
                    'fom_title' => $vvv['fom_title'],
                    'fom_label' => $lab_id,
                    'fom_content' => $vvv['fom_content'],
                    'fom_cid' => $find_adm['adm_cid'],
                    'fom_stase' => $vvv['fom_stase'],
                    'fom_temid' => $tem_id,
                    'fom_number' => $vvv['fom_number'],
                    'fom_type' => $find_adm['adm_type'],
                    'fom_picurl' => $vvv['fom_picurl']
                ]);
                if (!$fom_id) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'添加溯源失败']);
                }
            }
        }
        // 技师表单设置
        if ($request->input('wata_type') == 1) {
            # 系统默认表单信息
            $wata_data = DB::table('warranty_table')
                ->where('wata_id',$request['wata_id'])
                ->first();
            $wata_ids = DB::table('warranty_table')->where('wata_cid',$find_adm['adm_cid'])->value('wata_id');
            $wata_data['wata_cid'] = $find_adm['adm_cid'];
            $wata_data['wata_userid'] = $find_adm['adm_id'];
            $wata_data['wata_user_name'] = $find_adm['adm_name'];
            $wata_data['wata_stase'] = $request['wata_stase']; //状态1开启2关闭
            $wata_data['wata_updatetime'] = date('Y-m-d H:i:s');
            unset($wata_data['wata_id']);
            if ($wata_ids) {
                $wata_res = DB::table('warranty_table')->where('wata_id',$wata_ids)->update($wata_data);
                if (!$wata_res) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑技师表单设置失败']);
                }
            } else {
                $wata_id = DB::table('warranty_table')->insertGetId($wata_data);
                if (!$wata_id) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'添加技师表单设置失败']);
                }
            }
        }
        // 消费者表单设置
        if ($request->input('watas_type') == 1) {
            # 系统默认表单信息
            $watas_data = DB::table('warrantys_table')
                ->where('watas_id',$request['watas_id'])
                ->first();
            $watas_ids = DB::table('warrantys_table')->where('watas_cid',$find_adm['adm_cid'])->value('watas_id');
            $watas_data['watas_cid'] = $find_adm['adm_cid'];
            $watas_data['watas_userid'] = $find_adm['adm_id'];
            $watas_data['watas_user_name'] = $find_adm['adm_name'];
            $watas_data['watas_stase'] = $request['watas_stase']; //状态1开启2关闭
            $watas_data['watas_updatetime'] = date('Y-m-d H:i:s');
            unset($watas_data['watas_id']);
            if ($watas_ids) {
                $watas_res = DB::table('warrantys_table')->where('watas_id',$watas_ids)->update($watas_data);
                if (!$watas_res) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑消费者表单设置失败']);
                }
            } else {
                $watas_id = DB::table('warrantys_table')->insertGetId($watas_data);
                if (!$watas_id) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'添加技师表单设置失败']);
                }
            }
        }
        $nav_id = (int)$request->input('nav_id');
        // 判断是否更改商品所属导航
        $find_nav = DB::table('goods')
            ->where('goo_id',$request['goo_id'])
            ->select('goo_navid')
            ->first();
        if ($request->input('nav_id') != $find_nav['goo_navid']) {
            // 更改商品所属导航数量
            $res_nav1 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`+1  WHERE `nav_id`=?',[$nav_res]);
            $res_nav2 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`-1  WHERE `nav_id`=?',[$find_nav['goo_navid']]);
            if ($res_nav1 && $res_nav2) {
                $res_nav = true;
            } else {
                $res_nav = false;
            }
        } else {
            $res_nav = true;
        }
        $goods_res = DB::table('goods')
            ->where('goo_id',$request['goo_id'])
            ->update(['goo_navid'=>$nav_res]);
        if ($nav_res && $res_nav && $goods_res) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'导航列表','添加','添加'.$request['nav_name'].'”成功');
            if (isset($fom_id)){
                return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功','fom_id'=>$fom_id,'nav_id'=>$nav_res]);
            } else {
                return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
            }
        } else {
            DB::rollBack();
            return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
        }
    }

    // 修改导航信息项
    public function edit_nav(Request $request)
    {
        //验证数据
        if (empty($request['nav_types']) || !is_numeric($request['nav_types'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取当前操作人
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        if ($request['nav_types'] == 1) {
            $data = Db::table('navigation')
                ->where('nav_id',$request['nav_id'])
                ->where('nav_del',1)
                ->where('nav_cid',$find_adm['adm_cid'])
                ->select('nav_id','nav_name','nav_style','nav_icon')
                ->first();
            if (!$data) {return response()->json(['code'=>500,'msg'=>'error','data'=>'没有这个导航']);}
            $data['nav_icon'] = json_decode($data['nav_icon'],true);

            foreach ($data['nav_icon'] as $key => $value) {
                $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
        //处理导航图标
        $arr=[];
        foreach ($request['name'] as $k => $v) {
            if (empty($request['name'][$k])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            if (mb_strlen($v,'UTF8') > 6) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息名称最多六个字']);
            }
        }
        foreach ($request['name'] as $key => $val) {
            $arr[$key]['name']   =$val;
            $arr[$key]['icon_type']=$request['icon_type'][$key];
            $arr[$key]['show']   =$request['show'][$key] ? 2 : 1;
            $arr[$key]['system_icon']=$request['system_icon'][$key];
            $arr[$key]['icon_ids'] =$request['icon_ids'][$key];
            $arr[$key]['icon_order'] =$request['icon_order'][$key];
            $arr[$key]['pic'] = CommenModel::uploadBase64Img($request['pic'][$key],'navigation/icon','public');
            if ($arr[$key]['pic'] == false) {
                $path = explode(config('app.url'),$request['pic'][$key]);
                $path_url = trim($path[1],'/');
                $path_type = explode('.',$path_url);
                // 新图片路径文件名
                $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                $pathName = "/navigation/icon/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                // 复制图片
                $new_url = copy(base_path().'/'.$path_url, public_path().$pathName);
                // 返回路径
                $filePath = "public". $pathName;
                $arr[$key]['pic'] .= $filePath;
            }
            $arr[$key]['content']=$request['content'][$key];
        }
        DB::beginTransaction(); //开启事务
        // 判断是否更改商品所属导航
        $find_nav = DB::table('goods')
            ->where('goo_cid',$find_adm['adm_cid'])
            ->where('goo_id',$request['goo_id'])
            // ->where(['goo_cid'=>$find_adm['adm_cid'],'goo_id'=>$request->input('goo_id')])
            ->select('goo_navid')
            ->first();
        if ($request->input('nav_id') != $find_nav['goo_navid']) {
            // 更改商品所属导航数量
            $res_nav1 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`+1  WHERE `nav_id`=?',[$request->input('nav_id')]);
            $res_nav2 = DB::update('UPDATE `trace_navigation` SET `nav_total`=`nav_total`-1  WHERE `nav_id`=?',[$find_nav['goo_navid']]);
            if ($res_nav1 && $res_nav2) {
                $res_nav = true;
            }else{
                $res_nav = false;
            }
        } else {
            $res_nav = true;
        }
        $goods_res = DB::table('goods')
            ->where('goo_id',$request['goo_id'])
            ->update(['goo_navid'=>$request['nav_id']]);
        $nav_res = DB::table('navigation')
            ->where('nav_id',$request['nav_id'])
            ->update([
                'nav_icon' => json_encode($arr),
                'nav_column_setup' => $request['nav_column_setup'],
                'nav_updatime' => date('Y-m-d H:i:s')
                ]);
        // 消费者表单设置
        $watas = DB::table('warrantys_table')
            ->where('watas_cid',$find_adm['adm_cid'])
            ->update(['watas_stase'=>$request['watas_stase']]);
        // 技师表单设置
        $wata = DB::table('warranty_table')
            ->where('wata_cid',$find_adm['adm_cid'])
            ->update(['wata_stase'=>$request['wata_stase']]);
        if ($nav_res) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'导航列表','编辑','编辑'.$request['nav_name'].'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入要修改的信息']);
        }
    }

    // 获取溯源信息
    public function gettrainfo(Request $request)
    {
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $forminfo = $request->all();
        DB::connection()->enableQueryLog();#开启执行日志
        $data['formwork'] = DB::table('formwork as f')
            ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
            ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
            ->where(['fom_stase'=>1,'fom_cid'=>$find_adm['adm_cid']])
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['fom_title'] )) {
                    $query->where('f.fom_title', 'like' , '%'.$forminfo['fom_title'].'%' );
                }
            })
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['lab_name'] )) {
                    $query->where('lab_name', 'like' , '%'.$forminfo['lab_name'].'%' );
                }
            })
            ->select('fom_id','fom_title')
            ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>'信息获取成功','data'=>$data]);
    }

    // 获取标签,模板,信息
    public function formwork_info(Request $request)
    {
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $forminfo = $request->all();
        if (empty($request['lab_type']) || !is_numeric($request['lab_type'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        DB::connection()->enableQueryLog();#开启执行日志
        if ($request['lab_type'] == 1) {
            // 获取环境信息
            $data['env_list'] = DB::table('environment')
                ->where('env_cid',1)
                ->where('env_state',1)
                ->select('env_id','env_name','env_number')
                ->get();
            // 获取消费者表单设置信息
            $datas['warrantys_table'] = DB::table('warrantys_table')
                ->where('watas_cid',1)
                ->select('watas_id','watas_stase','watas_content')
                ->first();
            $data['watas_content'] = json_decode($datas['warrantys_table']['watas_content'],true);
            $data['watas_stase'] = $datas['warrantys_table']['watas_stase'];
            $data['watas_id'] = $datas['warrantys_table']['watas_id'];
            // 获取技师表单设置信息
            $datas['warranty_table'] = DB::table('warranty_table')
                ->where('wata_cid',1)
                ->select('wata_id','wata_stase','wata_content')
                ->first();
            $data['wata_content'] = json_decode($datas['warranty_table']['wata_content'],true);
            $data['wata_stase'] = $datas['warranty_table']['wata_stase'];
            $data['wata_id'] = $datas['warranty_table']['wata_id'];
            //获取真伪信息
            $initial=Db::table('note')
                ->where('not_cid',0)
                ->select('note_content as content','note_number as number')
                ->first();
            $enterprise=Db::table('note')
                ->where('not_cid',1)
                ->select('note_content as content','note_number as number')
                ->first();
            $initial['content']=stripslashes($initial['content']);
            if (empty($enterprise)) {
                $enterprise=$initial;
            }
            $enterprise['content'] = stripslashes($enterprise['content']);
            $show_data=$enterprise;
            $old_data=$initial;
            $show_data['content'] = $this->replace_str($show_data['content']);
            $old_data['content'] = $this->replace_str($old_data['content']);
            $data['antiset'] = ['old_data'=>$initial,'new_data'=>$enterprise,'show_data'=>$show_data,'old_show'=>$old_data];
            // 系统标签
            $data['label'] = DB::table('form_label')
                ->where('lab_cid',1)
                ->where('lab_stase',1)
                ->where('lab_type',1)
                ->select('lab_id','lab_name')
                ->get();
            $data['template'] = DB::table('formwork_template')
                ->where('tem_cid',1)
                ->where('tem_state',1)
                ->where('tem_type',1)
                ->select('tem_id','tem_name','tem_content')
                ->get();
            $data['formwork'] = DB::table('formwork as f')
                ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
                ->where(['fom_cid'=>1,'fom_stase'=>1,'fom_type'=>1])
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['fom_title'] )) {
                        $query->where('f.fom_title', 'like' , '%'.$forminfo['fom_title'].'%' );
                    }
                })
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['lab_name'] )) {
                        $query->where('lab_name', 'like' , '%'.$forminfo['lab_name'].'%' );
                    }
                })
                ->select('lab_id','lab_name','fom_id','fom_title','fom_content','fom_label','fom_picurl','tem_id','tem_name')
                ->orderBy('lab_id','desc')
                ->get();
            if (empty($data['formwork'])) {
                return response()->json(['code'=> 500,'msg'=>'error','data'=>'该标签下还没有溯源信息']);
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>'信息获取成功','data'=>$data]);
        } else if ($request['lab_type'] == 2) {
            // 获取消费者表单设置信息
            $datas['warrantys_table'] = DB::table('warrantys_table')
                ->where('watas_cid',$find_adm['adm_cid'])
                ->select('watas_id','watas_stase','watas_content')
                ->first();
            $data['watas_content'] = json_decode($datas['warrantys_table']['watas_content'],true);
            $data['watas_stase'] = $datas['warrantys_table']['watas_stase'];
            // 获取技师表单设置信息
            $datas['warranty_table'] = DB::table('warranty_table')
                ->where('wata_cid',$find_adm['adm_cid'])
                ->select('wata_id','wata_stase','wata_content')
                ->first();
            $data['wata_content'] = json_decode($datas['warranty_table']['wata_content'],true);
            $data['wata_stase'] = $datas['warranty_table']['wata_stase'];
            // 获取环境信息
            $data['env_list'] = DB::table('environment')
                ->where('env_cid',$find_adm['adm_cid'])
                ->where('env_state',1)
                ->select('env_id','env_name','env_number')
                ->get();
            //获取真伪信息
            $initial=Db::table('note')
                ->where('not_cid',0)
                ->select('note_content as content','note_number as number')
                ->first();
            $enterprise=Db::table('note')
                ->where('not_cid',$find_adm['adm_cid'])
                ->select('note_content as content','note_number as number')
                ->first();
            $initial['content']=stripslashes($initial['content']);
            if(empty($enterprise)){
                $enterprise=$initial;
            }
            $enterprise['content']=stripslashes($enterprise['content']);
            $show_data=$enterprise;
            $old_data=$initial;
            $show_data['content']=$this->replace_str($show_data['content']);
            $old_data['content'] =$this->replace_str($old_data['content']);
            $data['antiset']=['old_data'=>$initial,'new_data'=>$enterprise,'show_data'=>$show_data,'old_show'=>$old_data];
            // 我的标签
            $data['label'] = DB::table('form_label')
                ->where('lab_cid',$find_adm['adm_cid'])
                ->where('lab_stase',1)
                ->orWhere('lab_cid',0)
                ->select('lab_id','lab_name')
                ->get();
            $data['template'] = DB::table('formwork_template')
                ->where('tem_cid',$find_adm['adm_cid'])
                ->where('tem_state',1)
                ->select('tem_id','tem_name','tem_content')
                ->get();
            $data['formwork'] = DB::table('formwork as f')
                ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
                ->where('fom_stase',1)
                ->where('fom_cid',$find_adm['adm_cid'])
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['fom_title'] )) {
                        $query->where('f.fom_title', 'like' , '%'.$forminfo['fom_title'].'%' );
                    }
                })
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['lab_name'] )) {
                        $query->where('lab_name', 'like' , '%'.$forminfo['lab_name'].'%' );
                    }
                })
                ->select('lab_id','lab_name','fom_id','fom_title','fom_content','fom_picurl','fom_label','tem_id','tem_name')
                ->orderBy('lab_id','desc')
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>'信息获取成功','data'=>$data]);
        }
    }

    public function replace_str($data){
        $data=str_replace('{goods}',"满天星窗帘",$data);
        $data=str_replace('{code}',"500011810015498",$data);
        $data=str_replace('{num}','1',$data);
        $data=str_replace('{nums}','1',$data);
        $data=str_replace('{time}',"2019-07-22 12:00:00",$data);
        $data=str_replace('{pros}',"天津 武清区",$data);
        return $data;
    }

    // 添加溯源信息
    public function addformwork(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        //判断标签名称是否存在
        $lab_name = DB::table('form_label')
            ->where('lab_cid',$find_adm['adm_cid'])
            ->where('lab_name',trim($request['lab_name']))
            ->select('lab_id')
            ->first();
        if ($lab_name['lab_id']) {
            $fom_label = $lab_name['lab_id'];
        } else {
            $lab_add_data['lab_name'] = $request['lab_name'];
            $lab_add_data['lab_stase'] = 1;
            $lab_add_data['lab_time'] = date('Y-m-d H:i:s');
            $lab_add_data['lab_cid'] = $find_adm['adm_cid'];
            $lab_add_data['lab_type'] = 3;
            $fom_label = DB::table('form_label')->insertGetId($lab_add_data);
        }
        //判断信息名称是否存在
        $fom_title = DB::table('formwork')
            ->where('fom_title',trim($request['fom_title']))
            ->where('fom_cid',$find_adm['adm_cid'])
            ->where('fom_stase','<>',3)
            ->select('fom_title')
            ->first();
        if ($fom_title) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'信息名称已存在']);
        }
        //新增溯源信息
        $day = date('Ymd');
        $arr = [];
        foreach ($request['formkey'] as $key => $value) {
            $arr[$key]['key'] = $value;
            $arr[$key]['type'] = $request['formtype'][$key];
            $arr[$key]['show'] = $request['formshow'][$key];
            $url = $request['formvalue'][$key];
            if (($arr[$key]['type']==2 || $arr[$key]['type']==9) && !empty($url)) {
                //判断是否是临时文件;
                if (strpos($url,'temporary')) {
                    $end = explode('.',$url)[1];    //获取后缀
                    $file_name = $arr[$key]['type'] == 2 ? 'images' : 'videos';
                    $new_name = 'uploads/formwork/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path = public_path().'/'.$new_name;  //新的文件地址
                    $old_url = public_path().'/'.$url;  //旧的文件地址
                    //给新地址 赋予 所有权限;
                    if (!is_dir(dirname($new_path))) {
                        mkdir(dirname($new_path),0777,true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path); //移动
                    $url = $new_name;
                } else {
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[] = $url;
                }
            }
            $arr[$key]['value'] = $url;
            $arr[$key]['content'] = $request['contents'][$key]; //图文内容
        }
        $fom_picurl = '';
        if (!empty($request['fom_picurl'])) {
            //上传图片
            $uploadImg = new CommonController();
            foreach ($request['fom_picurl'] as $key => $value) {
                $uploadPath = $uploadImg->uploadBase64Img($value);
                if ($uploadPath) {
                    $fom_picurl .= $uploadPath.',';
                } else {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                }
            }
            $fom_picurl = trim($fom_picurl,',');
        }
        $tem_add_data['tem_name'] = $request['fom_title'];
        $tem_add_data['tem_content'] = json_encode($arr);
        $tem_add_data['tem_state'] = 1;
        $tem_add_data['tem_cid'] = $find_adm['adm_cid'];
        $tem_add_data['tem_addtime'] = date('Y-m-d H:i:s');
        $tem_add_data['tem_type'] = 3;
        if (!empty($fom_picurl)){
            $tem_add_data['tem_img'] = 1;
        }else{
            $tem_add_data['tem_img'] = 2;
        }
        $tem_add_data['tem_type_swaitch'] = $request['tem_type_swaitch'];
        $fom_temid = DB::table('formwork_template')->insertGetId($tem_add_data);
        $fom_add_data['fom_title'] = $request['fom_title'];
        $fom_add_data['fom_label'] = $fom_label;
        $fom_add_data['fom_content'] = json_encode($arr);
        $fom_add_data['fom_cid'] = $find_adm['adm_cid'];
        $fom_add_data['fom_stase'] = 1;
        $fom_add_data['fom_temid'] = $fom_temid;
        $fom_add_data['fom_number'] = $request['fom_number'];
        $fom_add_data['fom_type'] = $request['fom_type'] ? $request['fom_type'] : 3;
        $fom_add_data['fom_picurl'] = $fom_picurl;
        DB::beginTransaction(); //开启事务
        //判断是否有这个模板
        $template = DB::table('formwork_template')
            ->where('tem_id',$fom_temid)
            ->where('tem_cid',$find_adm['adm_cid'])
            ->where('tem_state',1)
            ->orWhere('tem_cid',0)
            ->select('tem_id','tem_name')
            ->first();
        if (empty($template)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源模板']);
        } else {
            $tem_res = DB::table('formwork_template')
                ->where('tem_id',$fom_temid)
                ->increment('tem_total');
            if (!$tem_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改模板数量失败']);
            }
        }
        //判断是否有这个标签
        $label = DB::table('form_label')
            ->where('lab_id',$fom_label)
            ->where('lab_cid',$find_adm['adm_cid'])
            ->where('lab_stase',1)
            ->orWhere('lab_cid',0)
            ->select('lab_id','lab_name')
            ->first();
        if (empty($label)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源标签']);
        } else {
            $lab_res = DB::table('form_label')
                ->where('lab_id',$fom_label)
                ->increment('lab_total');
            if (!$lab_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改标签数量失败']);
            }
        }
        $fom_res =  DB::table('formwork')->insertGetId($fom_add_data);
        if ($fom_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','新增','新增'.$request['fom_title'].'成功');
            $return_data['fom_id'] =  $fom_res;
            $return_data['lab_id'] =  $fom_label;
            $return_data['tem_id'] =  $fom_temid;
            $fom_picurl = DB::table('formwork')
                ->where('fom_id',$fom_res)
                ->value('fom_picurl');
            $return_data['fom_picurl'] =  explode(',',$fom_picurl);
            DB::commit();
            return response()->json(["code"=>200,'msg'=>'success','data'=>'添加溯源信息成功','return_data'=>$return_data]);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加溯源信息失败']);
        }
    }

    // 保存溯源
    public function handleformwork(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        //判断信息名称是否存在
        $fom_title = DB::table('formwork')
            ->where('fom_title',trim($request['fom_title']))
            ->where('fom_cid',$find_adm['adm_cid'])
            ->where('fom_stase','<>',3)
            ->select('fom_title')
            ->first();
        if ($fom_title) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请修改信息名称']);
        }
        //新增溯源信息
        $day = date('Ymd');
        $arr = [];
        foreach ($request['formkey'] as $key => $value) {
            $arr[$key]['key'] = $value;
            $arr[$key]['type'] = $request['formtype'][$key];
            $arr[$key]['show'] = $request['formshow'][$key];
            $url = $request['formvalue'][$key];
            if (($arr[$key]['type']==2 || $arr[$key]['type']==9) && !empty($url)) {
                //判断是否是临时文件;
                if (strpos($url,'temporary')) {
                    $end = explode('.',$url)[1];    //获取后缀
                    $file_name = $arr[$key]['type'] == 2 ? 'images' : 'videos';
                    $new_name = 'uploads/formwork/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path = public_path().'/'.$new_name;  //新的文件地址
                    $old_url = public_path().'/'.$url;  //旧的文件地址
                    //给新地址 赋予 所有权限;
                    if (!is_dir(dirname($new_path))) {
                        mkdir(dirname($new_path),0777,true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path); //移动
                    $url = $new_name;
                } else {
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[] = $url;
                }
            }
            $arr[$key]['value'] = $url;
            $arr[$key]['content'] = $request['contents'][$key]; //图文内容
        }
        $fom_picurl = '';
        if (!empty($request['fom_picurl'])) {
            //上传图片
            $uploadImg = new CommonController();
            foreach ($request['fom_picurl'] as $key => $value) {
                if (stristr($value,'data:image')) {
                    $uploadPath = $uploadImg->uploadBase64Img($value);
                    if ($uploadPath) {
                        $fom_picurl .= $uploadPath.',';
                    } else {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                    }
                } else {
                    //获取原图片路径
                    $path = explode(config('app.url'),$value);
                    $path_url = trim($path[1],'/');
                    $path_type = explode('.',$path_url);
                    //新图片路径文件名
                    $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                    $pathName = "/image/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                    // 复制图片
                    $new_url = copy(base_path().'/'.$path_url, storage_path().$pathName);
                    // 返回路径
                    $filePath = "storage". $pathName;
                    $fom_picurl .= $filePath.',';
                }
            }
            $fom_picurl = trim($fom_picurl,',');
        }
        if ($request['fos_type'] == 1){
            $lab = DB::table('form_label')
                ->where('lab_id',$request['fom_label'])
                ->first();
            if (!empty($lab)) {
                if ($lab['lab_name'] != $lab['lab_name']) {
                    $str = (int)substr($lab['lab_name'],strrpos($lab['lab_name'],'+')+1);
                    $name = $lab['lab_name'] . "+" . (++$str);
                }else{
                    $name = $lab['lab_name'] . "+1";
                }
            }
            unset($lab['lab_id']);
            unset($lab['lab_total']);
            unset($lab['lab_type']);
            $lab['lab_name'] = $name;
            $lab['lab_time'] = date('Y-m-d H:i:s');
            $lab['lab_type'] = 3;
            $lab['lab_cid'] = $find_adm['adm_cid'];
            $lab_id = DB::table('form_label')->insertGetId($lab);
            $tem = DB::table('formwork_template')
                ->where('tem_id',$request['fom_temid'])
                ->first();
            if (!empty($tem)) {
                if ($tem['tem_name'] != $tem['tem_name']) {
                    $str = (int)substr($tem['tem_name'],strrpos($tem['tem_name'],'+')+1);
                    $name = $tem['tem_name'] . "+" . (++$str);
                }else{
                    $name = $tem['tem_name'] . "+1";
                }
            }
            unset($tem['tem_id']);
            unset($tem['tem_total']);
            unset($tem['tem_type']);
            $tem['tem_name'] = $name;
            $tem['tem_addtime'] = date('Y-m-d H:i:s');
            $tem['tem_type'] = 3;
            $tem['tem_cid'] = $find_adm['adm_cid'];
            $tem_id = DB::table('formwork_template')->insertGetId($tem);
        }else {
            $tem_id = $request['fom_temid'];
            $lab_id = $request['fom_label'];
        }
        $fom_add_data['fom_title'] = $request['fom_title'];
        $fom_add_data['fom_label'] = $lab_id;
        $fom_add_data['fom_content'] = json_encode($arr);
        $fom_add_data['fom_cid'] = $find_adm['adm_cid'];
        $fom_add_data['fom_stase'] = 1;
        $fom_add_data['fom_temid'] = $tem_id;
        $fom_add_data['fom_number'] = $request['fom_number'];
        $fom_add_data['fom_type'] = $request['fom_type'] ? $request['fom_type'] : 3;
        $fom_add_data['fom_picurl'] = $fom_picurl;
        DB::beginTransaction(); //开启事务
        //判断是否有这个模板
        $template = DB::table('formwork_template')
            ->where('tem_id',$tem_id)
            ->where('tem_cid',$find_adm['adm_cid'])
            ->where('tem_state',1)
            ->orWhere('tem_cid',0)
            ->select('tem_id','tem_name')
            ->first();
        if (empty($template)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源模板']);
        } else {
            $tem_res = DB::table('formwork_template')
                ->where('tem_id',$tem_id)
                ->increment('tem_total');
            if (!$tem_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改模板数量失败']);
            }
        }
        //判断是否有这个标签
        $label = DB::table('form_label')
            ->where('lab_id',$lab_id)
            ->where('lab_cid',$find_adm['adm_cid'])
            ->where('lab_stase',1)
            ->orWhere('lab_cid',0)
            ->select('lab_id','lab_name')
            ->first();
        if (empty($label)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源标签']);
        } else {
            $lab_res = DB::table('form_label')
                ->where('lab_id',$lab_id)
                ->increment('lab_total');
            if (!$lab_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改标签数量失败']);
            }
        }
        $fom_res =  DB::table('formwork')->insertGetId($fom_add_data);
        if ($fom_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','新增','新增'.$request['fom_title'].'成功');
            DB::commit();
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑溯源信息成功','fom_id'=>$fom_res]);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑溯源信息失败']);
        }
    }

    // 码号信息入库
    public function addcode(request $request)
    {
        if (empty($request['gro_num']) || !is_numeric($request['gro_num']) || empty($request['gro_gid']) || !is_numeric($request['gro_gid'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        if ($request->input('gro_num') > $this->max_gro_num) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'发码数量超过'.$this->max_gro_num]);
        }

        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 查找公司信息
        $find_company_info = DB::table('company_info')
            ->where('info_cid', $find_adm['adm_cid'])
            ->select('info_code_id','info_result_style','info_cid')
            ->first();
        $info_code_id = $find_company_info['info_code_id'];//公司标识

        // 查找商品发码表信息
        $find_goods_code = DB::table('goods_code')
            ->where('gco_cid',$find_adm['adm_cid'])
            ->select('gco_id','gco_num')
            ->first();
        if ($find_goods_code) {
            $isadd = "1";
            $code = $find_goods_code['gco_num'];
        }else{
            $isadd = "0";
            $code = "0";
        }

        // 分组编号
        $gro_number = time() . str_pad($find_adm['adm_cid'], 6, '0', STR_PAD_LEFT) . str_pad(rand(0, 999), 3, '0', STR_PAD_LEFT);
        $gro_validation = $request['gro_validation'];
        if ($request['gro_validation'] == '0') {
            $gro_valleaver = '0';
        } else if($request['gro_validation'] == '1') {
            $gro_valleaver = '0';
        } else {
            $gro_valleaver = $request['gro_valleaver'];//真伪序列号位数
        }
        $info_result_style = $find_company_info['info_result_style'];//终端展示样式
        $time = date('Y-m-d H:i:s');
        $file_name = $request['file_name'];
        $gco_temstr = implode(',',$request['gco_temstr']);
        $gco_envid = implode(',',$request['gco_envid']);
        // 查询是否绑定商品
        if ($request->input('nums') == 33) {
            if (empty($request->input('gro_gid')) || !is_numeric($request->input('gro_gid'))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误2']);
            }
            //需补充码位数
            $ns = $request['nums'] - 25;
            // 查询商品条形码
            $goods = DB::table('goods')
                ->where(['goo_id'=>$request['gro_gid'],'goo_cid'=>$find_adm['adm_cid']])
                ->value('goo_number');
            $st = strlen($goods);
            // if ($st!='13' || !is_numeric($goods)) {
            //     return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品只能普通发码(20位)']);
            // }
            // 查询结束编号是否存在
            $groups = DB::table('group')
                ->where(['gro_cid'=>$find_adm['adm_cid'],'nums'=>$request['nums']])
                ->orderBy('gro_id','desc')
                ->value('code_end');
            if ($groups) {
                $number = $info_code_id . date("ym"). $goods . str_pad(strval($groups), $ns, '0', STR_PAD_LEFT);
                $num = (int)substr($groups,22,-3);
                if($num) {
                    $code_start = $num;
                } else {
                    $code_start = 1;
                }
                $code_start = $code_start + 1;
                $code_ends = (int)$code_start + (int)$request['gro_num'];
                $code_end = number_format($code_ends, 0, '', '')-1;
            } else {
                $code_start = 1;
                $code_ends = (int)$code_start + (int)$request['gro_num'];
                $code_end = number_format($code_ends, 0, '', '')-1;
            }
            $code_ks = $info_code_id . date("ym"). $goods . str_pad(strval($code_start), $ns, '0', STR_PAD_LEFT);
            $code_js = $info_code_id . date("ym"). $goods . str_pad(strval($code_end), $ns, '0', STR_PAD_LEFT);

            //生成校验位
            $verify_code = VerifyCodeController::generateVerify($code_ks, 3);
            $verify_codes = VerifyCodeController::generateVerify($code_js, 3);
            if (!$verify_code) {
                return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
            } else {
                $code_ks .= $verify_code;
                $code_js .= $verify_codes;
            }
            // 查询商品有效期
            $validity_period = DB::table('goods')
                ->where(['goo_id'=>$request['gro_gid'],'goo_cid'=>$find_adm['adm_cid']])
                ->value('validity_period');
            $expire_time = date('Y-m-d',strtotime($request['production_date'].' + '.$validity_period.' day'));
        } else if($request->input('nums') == 20) {
            //需补充码位数
            $numbernums = $request['nums'] - 12;
            // 查询结束编号是否存在
            $groups = DB::table('group')
                ->where(['gro_cid'=>$find_adm['adm_cid'],'nums'=>$request['nums']])
                ->orderBy('gro_id','desc')
                ->value('code_end');
            if ($groups) {
                $number = $info_code_id . date("ym") . str_pad(strval($groups), $numbernums, '0', STR_PAD_LEFT);
                $num = (int)substr($groups,9,-3);
                if ($num) {
                    $code_start = $num;
                } else {
                    $code_start = 1;
                }
                $code_start = $code_start + 1;
                $code_ends = (int)$code_start + (int)$request['gro_num'];
                $code_end = number_format($code_ends, 0, '', '')-1;
            } else {
                $code_start = 1;
                $code_ends = (int)$code_start + (int)$request['gro_num'];
                $code_end = number_format($code_ends, 0, '', '')-1;
            }

            $code_ks = $info_code_id . date("ym") . str_pad(strval($code_start), $numbernums, '0', STR_PAD_LEFT);
            $code_js = $info_code_id . date("ym") . str_pad(strval($code_end), $numbernums, '0', STR_PAD_LEFT);
            //生成校验位
            $verify_code = VerifyCodeController::generateVerify($code_ks, 3);
            $verify_codes = VerifyCodeController::generateVerify($code_js, 3);

            if (!$verify_code) {
                return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
            } else {
                $code_ks .= $verify_code;
                $code_js .= $verify_codes;
            }
            // 查询商品有效期
            $validity_period = DB::table('goods')
                ->where(['goo_id'=>$request['gro_gid'],'goo_cid'=>$find_adm['adm_cid']])
                ->value('validity_period');
            $expire_time = date('Y-m-d',strtotime($request['production_date'].' + '.$validity_period.' day'));
        }
        $data = [
                $gro_validation,
                $info_result_style,
                $time,
                $gro_valleaver,
                $gro_number,
                $request->input('gro_pnumber'),
                $find_adm['adm_cid'],
                $request->input('gro_release'),
                $find_adm['adm_id'],
                $request->input('gro_gid',0),
                $request->input('gro_num'),
                1,
                $request->input('gro_good_name',''),
                $file_name,
                $request->input('nums'),
                $code_ks,
                $code_js,
                $request['production_date'],
                $expire_time
            ];
        DB::beginTransaction();
        // 添加分组发码信息
        $grores = DB::insert('INSERT INTO `trace_group` (`gro_validation`,`gro_style`,`gro_time`, `gro_valleaver`, `gro_number`, `gro_pnumber`, `gro_cid`, `gro_release`, `gro_aid`, `gro_gid`, `gro_num`, `gro_type`, `gro_good_name`,`file_name`,`nums`,`code_start`,`code_end`,`production_date`,`expired_date`) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',$data);
        $val_sta = rand(1, 100001 - $request['gro_num']);
        if (isset($request['gro_validation']) && $request['gro_validation'] == '2') {
            $validation = DB::table('validation')
                            ->insert([
                                'val_cid' => $find_adm['adm_cid'],
                                'val_nums' => $request['gro_num'],
                                'val_leaver' => $gro_valleaver,
                                'val_codenumber' => $gro_number,
                                'val_sta' => $val_sta,
                                'val_end' => $val_sta + $request['gro_num'] - 1,
                                'val_rand' => $this->getRandomString('4',$find_adm['adm_cid']),
                                'val_time' => $time
                                ]);
        }
        if ($grores) {
            // 溯源模板系统信息录入,记录操作时间、操作人
            if (!empty($gco_temstr)) {
                $gco_op_id = DB::table('base_op')->insertGetId([
                    'form_id' => $gco_temstr,
                    'op_date' => date('Y-m-d H:i:s'),
                    'op_man'  => $find_adm['adm_name']
                    ]);
            } else {
                $gco_op_id = '';
            }
            if (empty($request['name']) || empty($request['content'])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            foreach ($request['name'] as $key => $val) {
                $arr[$key]['name']   =$val;
                $arr[$key]['content']=$request['content'][$key];
            }
            // 产品码表添加二维码信息
            $grores = DB::table('formwork_code')->insert([
                'gco_group' => $gro_number, //批次分组号
                'gco_start' => $code_ks,    //起始码
                'gco_end'   => $code_js,    //结束码
                'gco_type'  => 1,   //类型1批次2码号3区间
                'gco_gid'   => $request->input('gro_gid',0),    //商品id
                'gco_envid' => $gco_envid,  //环境id
                'gco_temstr' => $gco_temstr,    //溯源信息id串
                'gco_cid' => $find_adm['adm_cid'],  //公司id
                'gco_cretime' => $time, //时间
                'nums' => $request['nums'], //位数
                'production_date' => $expire_time,  //生产日期
                'gco_op_id'=>$gco_op_id,    //关联trace_公司ID_op表
                'gco_icon' => json_encode($arr) //json数据,判定溯源信息存在哪个导航按钮下面
                ]);
            unset($sql);
            $goods_code_data['goods_id'] = $request->input('gro_gid',0);
            $goods_code_data['gco_num'] = $request['gro_num'];
            $goods_code_data['gco_cid'] = $find_adm['adm_cid'];
            $goods_code_data['gco_year'] = date('Y');
            $goods_code_data['gco_month'] = date('m');
            $goods_code_data['gco_user'] = $find_adm['adm_id'];
            $goods_code_res = DB::table('goods_code')->insert($goods_code_data);

            // 查询发码量统计表数量
            $now_year = date('Y');//当前年
            $now_month = date('m');//当前月
            $find_sta_total = DB::table('statistic_send')
                ->where('sta_cid', $find_adm['adm_cid'])
                ->where('sta_year', $now_year)
                ->where('sta_month', $now_month)
                ->where('sta_type',1)
                ->select('sta_id','sta_total')
                ->first();
            // 更新发码量统计表数据
            if ($find_sta_total) {
                $sta_total_res = DB::update('UPDATE `trace_statistic_send` SET `sta_total`=`sta_total`+? WHERE (`sta_id`=?) ',[$request->input('gro_num'),$find_sta_total['sta_id']]);
            }else{
                $sta_total_res = DB::insert('INSERT INTO `trace_statistic_send` (`sta_cid`, `sta_year`, `sta_month`, `sta_total`, `sta_type`) values(?,?,?,?,?)',[$find_adm['adm_cid'],$now_year,$now_month,$request->input('gro_num'),1]);
            }

            if (!empty($request->input('gro_gid'))) {
                // 查询商品信息
                $find_goods = DB::table('goods')
                    ->where(['del_type'=>1,'goo_cid'=>$find_adm['adm_cid']])
                    ->get(['goo_id','goo_classifi','goo_code_total']);

                $company_info = DB::table('company_info')
                    ->where('info_cid', $find_adm['adm_cid'])
                    ->first(['info_usenum']);
                $compan_count = $company_info['info_usenum'] + $request->input('gro_num');//公司总的发码量
                foreach ($find_goods as $key => $value) {
                    if ($value['goo_id'] == $request->input('gro_gid')) {
                        $goo_count = $value['goo_code_total'] + $request->input('gro_num');
                    } else {
                        $goo_count = $value['goo_code_total'];
                    }
                    if ($goo_count>0) {
                        // 计算商品发码量占比
                        $goo_code_percent = round(($goo_count / $compan_count)*100,2);
                        // 更新商品发码量占比
                        $goods_res = DB::update('UPDATE `trace_goods` SET `goo_code_percent`=? WHERE (`goo_id`=?) ',[$goo_code_percent,$value['goo_id']]);
                        if ($goods_res === false) {
                            DB::rollBack();
                        }
                    }
                }
                // 更新商品发码数量
                $goods_res = DB::update('UPDATE `trace_goods` SET `goo_code_total`=`goo_code_total`+? WHERE (`goo_id`=?) ',[$request->input('gro_num'),$request->input('gro_gid')]);
                // 查询商品分类
                $find_class_id = DB::table('goods')
                    ->where('goo_id', $request->input('gro_gid'))
                    ->select('goo_classifi')
                    ->first();
                // 更新商品分类发码数量
                $goo_classifi_res = DB::update('UPDATE `trace_goo_classifi` SET `cla_code_total`=`cla_code_total`+? WHERE (`cla_id`=?) ',[$request->input('gro_num'),$find_class_id['goo_classifi']]);
                // 更新公司总的发码数量
                $company_info_res = DB::update('UPDATE `trace_company_info` SET `info_usenum`=`info_usenum`+? WHERE (`info_cid`=?) ',[$request->input('gro_num'),$find_adm['adm_cid']]);
            } else {
                $goods_res = true;
                $company_info_res = true;
                $goo_classifi_res = true;
            }
            if ($grores && $goods_code_res && $sta_total_res && $goods_res && $company_info_res && $goo_classifi_res) {
                DB::commit();
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'发码列表','创建二维码','创建'.$request->input('gro_num').'个产品码');
                return response()->json(['code'=>200,'msg'=>'success','data'=>'发码成功','qrcode'=>config('app.url')."/sy.php?".$code_ks."&"]);
            } else {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'发码失败']);
            }
        } else {
            DB::rollBack();
            return response()->json(['code'=>500,'msg'=>'error','data'=>'发码失败']);
        }
    }

    //生成指定位数序列号
    function getRandomString($len,$adm_cid, $chars = null)
    {
        if (is_null($chars)) {
            $chars = "abcdefghijklmnpqrstuvwxyz123456789";
        }
        mt_srand(10000000 * (double)microtime());
        for ($i = 0, $str = '', $lc = strlen($chars) - 1; $i < $len; $i++) {
            $str .= $chars[mt_rand(0, $lc)];
        }
        $res = DB::table('validation')
                ->where('val_cid',$adm_cid)
                ->where('val_rand',$str)
                ->first();
        if ($res) {
            $this->getRandomString('4');
        } else {
            return $str;
        }
    }
}
