<?php

    /**
     * [uploadBase64Img 上传base64图片]
     * @param  [type] $stream [base64数据]
     * @return [type]         [上传成功返回图片路径，失败返回false]
     */
    function uploadBase64Img($stream)
    {
        if(stristr($stream,'data:image')){
            $stream  = $stream;
        }else{
            $stream="data:image/png;base64,".$stream;
        }
        //获取扩展名和文件名
        if (preg_match('/(?<=\/)[^\/]+(?=\;)/', $stream, $pregR)) $streamFileType = '.' . $pregR[0];

        $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        // $pathName = "/public/image/" ;
        $pathName = storage_path()."/image/";//获取上传图片路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName,0775,true);
            chmod($pathName,0775);
        }
        $streamFilename = $pathName . $streamFileRand . $streamFileType;//上传到服务器图片路径

        //处理base64文本，用正则把第一个base64,之前的部分砍掉
        preg_match('/(?<=base64,)[\S|\s]+/', $stream, $streamForW);
        if (file_put_contents($streamFilename, base64_decode($streamForW[0])) === false) {
            return false;
        } else {
            // 返回路径
            $filePath = "storage/image/". $streamFileRand . $streamFileType;
            return $filePath;
        }
    }

    /**
     * [wherebutton 获取当前列表下的按钮]
     * @param  [type] $api_token [用户token]
     * @param  [type] $pri_id    [当前列表的id]
     * @return [type]            [description]
     */
    function wherebutton($api_token,$pri_id)
    {
        if(empty($pri_id))
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        try{
            $api_token = Crypt::decrypt($api_token);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $role_info = DB::table('login_temporary')
                            ->where('api_token','=',$api_token)
                            ->select('role_auth')
                            ->first();
        // 对象转数组
        $role_info  = object_array(json_decode($role_info['role_auth']));
        // 获取到当前列表下的按钮
        $wherebutton = [];

        foreach($role_info as $key=>$value)
        {
            if($value['pri_fid'] == $pri_id)
            {
                $wherebutton[] = $value;
            }
        }
        if(!$wherebutton)
        {
            return false;
        }
        return $wherebutton;
    }
    
     // 对象转数组
    function object_array($array) {  
        if(is_object($array)) {  
            $array = (array)$array;  
        } if(is_array($array)) {  
            foreach($array as $key=>$value) {  
                 $array[$key] = object_array($value);  
            }  
        }  
        return $array;  
    }

    // 发送短信验证码
    function sendSmsCode($mobile, $content)
    {
        $username = "lksy";
        $pwd = "19r1rt22";
        $password = md5($username . "" . md5($pwd));

        $url = "http://www1.jc-chn.cn/smsSend.do?";

        $param = http_build_query(
            array(
                'username' => $username,
                'password' => $password,
                'mobile' => $mobile,
                // 'content'=>iconv("GB2312","UTF-8",$content)
                'content' => $content
            )
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    /**
     * [webCreateToken 移动web端生成token]
     * @param  [type] $userid [技师账号id]
     * @return [type]         [description]
     */
    function webCreateToken($userid)
    {
        $token_str = $userid.date('Y-m-d').'jidjld465afd2134ds65f4';
        $api_token = sha1($token_str);  //加密
        return Crypt::encrypt($api_token);
    }

    /**
     * [webVerifyToken 移动web端验证token]
     * @param  [type] $userid    [技师账号id]
     * @param  [type] $api_token [api_token]
     * @return [type]            [description]
     */
    function webVerifyToken($userid, $api_token)
    {
        $token_str = $userid.date('Y-m-d').'jidjld465afd2134ds65f4';
        $token = sha1($token_str);  //加密

        try{
            $api_token = Crypt::decrypt($api_token);
        }catch (\Exception $e){
            return ['code'=>500,'msg'=>'error','data'=>'非法api_token'];
        }
        
        if ($token == $api_token) {
            return ['code'=>200,'msg'=>'success','data'=>''];
        }else{
            return ['code'=>500,'msg'=>'error','data'=>'api_token错误'];
        }
    }

    // 分解二维码
    function splitCode($code)
    {
        // 50004 1908 00000005 823
        // 50004 1909 00000005 823
        // 50004190800001719 - 50004190800010933
        // 20
        // 50004 1908 6922266440090 00000030 667
        // 33
        $code_len = strlen($code);
        $data['company_symbol'] = substr($code, 0, 5);//公司标识
        $data['yemo'] = substr($code, 5, 4);//年月

        if ($code_len == 33) {
            $data['bar_code'] = substr($code, 9, 13);//条形码
            $data['number'] = substr($code, 22, 8);//码号
        }else{
            $data['bar_code'] = '';//条形码
            $data['number'] = substr($code, 9, 8);//码号
        }
        return $data;
    }

    // 日志记录，记录操作数据
    function logRecord($data, $file_name = 'log', $type = 1)
    {
        // $file_path = "./Uploads/".$file_name.".txt";
        $file_path = storage_path() . "/logs/" . $file_name . ".txt";
        $myfile = fopen($file_path, "a");
        if ($type == 1) {
            $txt = json_encode($data) . "\r\n\r\n";
        }else{
            $txt = json_encode($data, JSON_UNESCAPED_UNICODE) . "\r\n\r\n";
        }
        fwrite($myfile, $txt);
        fclose($myfile);
    }

    /**
     * curl 请求 CURLOPT_POSTFIELDS
     * @param  [type]  $url     路径
     * @param  [type]  $data    参数
     * @param  [type]  $headers headers头
     * @param  integer $timeout [description]
     * @param  string  $method  [description]
     * @return [type]           [description]
     */
    function curlRequest($url, $data = [], $headers = [], $timeout = 10, $method = 'GET')
    {
        $curl = curl_init();
        if (!empty($headers)) {
            $headers = array(
                'Content-type: application/json',
                'Authorization: '.$headers['Authorization'].'',
            );
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_TIMEOUT, $timeout);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);

        if (!empty($data) && 'GET' == $method) $method = 'POST';


        switch ($method) {
            case 'POST':
                curl_setopt($curl, CURLOPT_POST, 1);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case 'PUT':
                curl_setopt($curl, CURLOPT_PUT, 1);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "DELETE":
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'DELETE');
                break;
        }
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        if (curl_errno($curl)) {
            return 'Curl error: ' . curl_error($curl);
        }
        curl_close($curl);

        return $output;
    }
